/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.ui.FrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

public class ClickMeFrame
extends JFrame
implements ActionListener,
ComponentListener,
MouseListener,
MouseMotionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private static final String SUCCESS_MESSAGE = "Successful clicks = ";
    private int successCount = 0;
    private JPanel clickMeContentPane = null;
    private JLabel clickMeLabel = null;
    private JButton quitButton = null;
    private JLabel successLabel = null;
    private static final int MAX_MOVE = 500;
    private double oldDist = Double.MAX_VALUE;
    private JPanel scorePanel;
    private JLabel scoreLabel;
    private JPanel buttonPanel;
    private JPanel chasePanel;
    private JButton replayButton;

    public ClickMeFrame(String title) {
        super(title);
        this.initialize();
    }

    public ClickMeFrame() {
        this("ClickMe");
    }

    private void initialize() {
        try {
            this.setName("ClickMe");
            this.setDefaultCloseOperation(2);
            this.setSize(616, 404);
            this.setVisible(true);
            this.setTitle("Click Me If You Can");
            this.setContentPane(this.getClickMeContentPane());
            this.initConnections();
            FrameUtilities.centerFrame(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getClickMeContentPane() {
        if (this.clickMeContentPane == null) {
            try {
                this.clickMeContentPane = new JPanel();
                this.clickMeContentPane.setName("ClickMeContentPane");
                this.clickMeContentPane.setBorder(new EtchedBorder());
                this.clickMeContentPane.setLayout(new BorderLayout(0, 0));
                this.clickMeContentPane.add((Component)this.getScorePanel(), "North");
                this.clickMeContentPane.add((Component)this.getChasePanel(), "Center");
                this.clickMeContentPane.add((Component)this.getButtonPanel(), "South");
                this.clickMeContentPane.setMinimumSize(new Dimension(200, 200));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.clickMeContentPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getQuitButton()) {
            this.quitButtonActionPerformed();
        }
    }

    public void clickMeChasePanelMouseDragged(MouseEvent mouseEvent) {
        this.moveIt(mouseEvent);
    }

    public void clickMeChasePanelMouseMoved(MouseEvent mouseEvent) {
        this.moveIt(mouseEvent);
    }

    public void clickMeDlgComponentResized(ComponentEvent componentEvent) {
        int midX = this.getChasePanel().getWidth() / 2;
        int midY = this.getChasePanel().getHeight() / 2;
        this.getClickMeLabel().setLocation(midX, midY);
    }

    public void clickMeWindowClosing() {
        this.quitButtonActionPerformed();
    }

    public void clickMeLabelMouseClicked(MouseEvent e) {
        this.getClickMeLabel().setVisible(false);
        this.getSuccessLabel().setVisible(true);
        ++this.successCount;
        this.getScoreLabel().setText(SUCCESS_MESSAGE + this.successCount);
        this.repaint();
    }

    public void quitButtonActionPerformed() {
        int result = JOptionPane.showConfirmDialog(this, "Awww... Are you sure you want to give up?", "Nice Try...", 0, 3);
        if (result == 0) {
            this.dispose();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this) {
            this.clickMeDlgComponentResized(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        System.out.println("ComponentShown event fired...");
    }

    private JLabel getClickMeLabel() {
        if (this.clickMeLabel == null) {
            try {
                this.clickMeLabel = new JLabel();
                this.clickMeLabel.setName("ClickMeLabel");
                this.clickMeLabel.setPreferredSize(new Dimension(58, 30));
                this.clickMeLabel.setBorder(new EtchedBorder());
                this.clickMeLabel.setText("CLICK ME");
                this.clickMeLabel.setMinimumSize(new Dimension(58, 30));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.clickMeLabel;
    }

    public Point getClickMeLabelMidpoint() {
        int labelX = this.getClickMeLabel().getX();
        int labelY = this.getClickMeLabel().getY();
        int labelWidth = this.getClickMeLabel().getWidth();
        int labelHeight = this.getClickMeLabel().getHeight();
        int labelMidX = labelX + labelWidth / 2;
        int labelMidY = labelY + labelHeight / 2;
        return new Point(labelMidX, labelMidY);
    }

    private JButton getQuitButton() {
        if (this.quitButton == null) {
            try {
                this.quitButton = new JButton();
                this.quitButton.setName("ClickMeQuitButton");
                this.quitButton.setText("I Give Up");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.quitButton;
    }

    public double getDistance(int inX, int inY) {
        Point midPoint = this.getClickMeLabelMidpoint();
        int labelMidX = midPoint.x;
        int labelMidY = midPoint.y;
        return Math.sqrt(Math.pow(labelMidX - inX, 2.0) + Math.pow(labelMidY - inY, 2.0));
    }

    private JLabel getSuccessLabel() {
        if (this.successLabel == null) {
            this.successLabel = new JLabel();
            this.successLabel.setName("SuccessLabel");
            this.successLabel.setText("CONGRATULATIONS!!");
            this.successLabel.setVisible(false);
            this.successLabel.setForeground(new Color(255, 0, 0));
            this.successLabel.setFont(new Font("dialog", 1, 18));
            this.successLabel.setHorizontalAlignment(0);
        }
        return this.successLabel;
    }

    private void initConnections() throws Exception {
        this.getQuitButton().addActionListener(this);
        this.getChasePanel().addMouseMotionListener(this);
        this.getClickMeLabel().addMouseListener(this);
        this.addComponentListener(this);
        this.addWindowListener(this);
    }

    private void handleException(Throwable t) {
        System.err.println("Exception in ClickMe frame: " + t);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.getClickMeLabel()) {
            this.clickMeLabelMouseClicked(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.getChasePanel()) {
            this.clickMeChasePanelMouseDragged(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.getChasePanel()) {
            this.clickMeChasePanelMouseMoved(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void moveIt(MouseEvent mouseEvent) {
        Point newLoc = null;
        double curDist = this.getDistance(mouseEvent.getX(), mouseEvent.getY());
        int panelHeight = this.getChasePanel().getHeight();
        int panelWidth = this.getChasePanel().getWidth();
        double maxDist = Math.sqrt(Math.pow(panelHeight, 2.0) + Math.pow(panelWidth, 2.0));
        if (curDist < maxDist / 2.0 && curDist < this.oldDist || this.getClickMeLabel().contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (curDist == 0.0) {
                curDist = 1.0;
            }
            int moveAmount = (int)(1.0 / curDist * 500.0);
            int mouseX = mouseEvent.getX();
            int mouseY = mouseEvent.getY();
            Point midPoint = this.getClickMeLabelMidpoint();
            int labelMidX = midPoint.x;
            int labelMidY = midPoint.y;
            int labelXloc = this.getClickMeLabel().getX();
            int labelYloc = this.getClickMeLabel().getY();
            newLoc = mouseX <= labelMidX && mouseY <= labelMidY ? new Point(labelXloc + moveAmount, labelYloc + moveAmount) : (mouseX <= labelMidX && mouseY > labelMidY ? new Point(labelXloc + moveAmount, labelYloc - moveAmount) : (mouseX > labelMidX && mouseY <= labelMidY ? new Point(labelXloc - moveAmount, labelYloc + moveAmount) : new Point(labelXloc - moveAmount, labelYloc - moveAmount)));
            if (newLoc.x < 15 || newLoc.x > panelWidth - this.getClickMeLabel().getWidth() - 15 || newLoc.y < 15 || newLoc.y > panelHeight - this.getClickMeLabel().getHeight() - 15) {
                if (curDist < (double)(this.getClickMeLabel().getWidth() + 10)) {
                    double rx = Math.random();
                    double ry = Math.random();
                    newLoc.x = (int)((double)(panelWidth - this.getClickMeLabel().getWidth()) * rx);
                    newLoc.y = (int)((double)(panelHeight - this.getClickMeLabel().getHeight()) * ry);
                    this.getClickMeLabel().setLocation(newLoc);
                    curDist = this.getDistance(mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                this.getClickMeLabel().setLocation(newLoc);
                curDist = this.getDistance(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        this.oldDist = curDist;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.clickMeWindowActivated(e);
    }

    private void clickMeWindowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.clickMeWindowClosing();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            ClickMeFrame frame = new ClickMeFrame();
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() while creating a new ClickMe frame");
            exception.printStackTrace(System.out);
        }
    }

    private JPanel getScorePanel() {
        if (this.scorePanel == null) {
            this.scorePanel = new JPanel();
            this.scorePanel.setBorder(new EtchedBorder());
            this.scorePanel.add(this.getScoreLabel());
            this.scorePanel.setMinimumSize(new Dimension(100, 100));
        }
        return this.scorePanel;
    }

    private JLabel getScoreLabel() {
        if (this.scoreLabel == null) {
            this.scoreLabel = new JLabel(SUCCESS_MESSAGE + this.successCount);
        }
        return this.scoreLabel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new EtchedBorder());
            this.buttonPanel.add(this.getQuitButton());
            this.buttonPanel.add(this.getReplayButton());
        }
        return this.buttonPanel;
    }

    private JPanel getChasePanel() {
        if (this.chasePanel == null) {
            this.chasePanel = new JPanel();
            this.chasePanel.setBorder(new LineBorder(Color.blue, 2, true));
            this.chasePanel.add(this.getClickMeLabel());
            this.chasePanel.add(this.getSuccessLabel());
            this.chasePanel.setMinimumSize(new Dimension(100, 100));
        }
        return this.chasePanel;
    }

    private JButton getReplayButton() {
        if (this.replayButton == null) {
            try {
                this.replayButton = new JButton();
                this.replayButton.setName("ReplayButton");
                this.replayButton.setText("Replay");
                this.replayButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClickMeFrame.this.getSuccessLabel().setVisible(false);
                        ClickMeFrame.this.getClickMeLabel().setVisible(true);
                    }
                });
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
        return this.replayButton;
    }
}

