/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.event.ListboxEvent;
import com.ibm.webrunner.j2mclb.event.ListboxListener;
import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.CategoryEvent;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.ICategoryListener;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.AnswerClarificationFrame;
import edu.csus.ecs.pc2.ui.EditFilterFrame;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ClarificationsPane
extends JPanePlugin {
    private static final long serialVersionUID = 5354454906850587233L;
    private JPanel clarificationButtonPane = null;
    private MCLB clarificationListBox = null;
    private JButton giveButton = null;
    private JButton takeButton = null;
    private JButton editButton = null;
    private JButton filterButton = null;
    private JButton requestButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private AnswerClarificationFrame answerClarificationFrame;
    private JPanel centerPane = null;
    private JSplitPane clarificationSplitPane = null;
    private JPanel clarificationPane = null;
    private JTextArea questionTextArea = null;
    private JPanel answerPane = null;
    private JTextArea answerTextArea = null;
    private boolean showNewClarificationsOnly = false;
    private Filter requiredFilter = new Filter();
    private Filter filter = new Filter();
    private DisplayTeamName displayTeamName = null;
    private JScrollPane jQuestionScrollPane = null;
    private JScrollPane jAnswerScrollPane = null;
    private EditFilterFrame editFilterFrame = null;
    private String filterFrameTitle = "Clarification filter";

    public ClarificationsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(622, 327));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getClarificationButtonPane(), "South");
        this.answerClarificationFrame = new AnswerClarificationFrame();
    }

    @Override
    public String getPluginTitle() {
        return "Clarifications Pane";
    }

    private JPanel getClarificationButtonPane() {
        if (this.clarificationButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.clarificationButtonPane = new JPanel();
            this.clarificationButtonPane.setLayout(flowLayout);
            this.clarificationButtonPane.setPreferredSize(new Dimension(35, 35));
            this.clarificationButtonPane.add((Component)this.getRequestButton(), null);
            this.clarificationButtonPane.add((Component)this.getGiveButton(), null);
            this.clarificationButtonPane.add((Component)this.getTakeButton(), null);
            this.clarificationButtonPane.add((Component)this.getFilterButton(), null);
            this.clarificationButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.clarificationButtonPane;
    }

    private MCLB getClarificationListBox() {
        if (this.clarificationListBox == null) {
            this.clarificationListBox = new MCLB();
            this.clarificationListBox.addListboxListener(new ListboxListener(){

                public void rowSelected(ListboxEvent e) {
                    if (ClarificationsPane.this.isAllowed(Permission.Type.ANSWER_CLARIFICATION) && e.getClickCount() >= 2) {
                        ClarificationsPane.this.requestSelectedClarification();
                    } else {
                        ClarificationsPane.this.showSelectedClarification();
                    }
                }

                public void rowDeselected(ListboxEvent e) {
                    ClarificationsPane.this.showSelectedClarification();
                }
            });
        }
        return this.clarificationListBox;
    }

    private void resetClarsListBoxColumns() {
        this.clarificationListBox.removeAllRows();
        this.clarificationListBox.removeAllColumns();
        Object[] fullColumns = new Object[]{"Site", "Team", "Clar Id", "Time", "Status", "Judge", "Sent to", "Problem", "Question", "Answer"};
        Object[] teamColumns = new Object[]{"Site", "Team", "Clar Id", "Time", "Status", "Problem", "Question", "Answer"};
        Object[] newColumns = new Object[]{"Site", "Team", "Clar Id", "Time", "Status", "Problem", "Question"};
        Object[] teamColumnsNewOnly = new Object[]{"Site", "Team", "Clar Id", "Time", "Status", "Problem", "Question"};
        Object[] columns = this.isTeam(this.getContest().getClientId()) ? (this.isShowNewClarificationsOnly() ? teamColumnsNewOnly : teamColumns) : (this.isShowNewClarificationsOnly() ? newColumns : fullColumns);
        this.clarificationListBox.addColumns(columns);
        HeapSorter sorter = new HeapSorter();
        HeapSorter numericStringSorter = new HeapSorter();
        numericStringSorter.setComparator((Comparator)new NumericStringComparator());
        HeapSorter accountNameSorter = new HeapSorter();
        accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
        int idx = 0;
        if (!this.isTeam(this.getContest().getClientId())) {
            this.clarificationListBox.setColumnSorter(idx++, sorter, 1);
            this.clarificationListBox.setColumnSorter(idx++, accountNameSorter, 2);
            this.clarificationListBox.setColumnSorter(idx++, numericStringSorter, 3);
            this.clarificationListBox.setColumnSorter(idx++, numericStringSorter, 4);
            this.clarificationListBox.setColumnSorter(idx++, sorter, 5);
            if (!this.isShowNewClarificationsOnly()) {
                this.clarificationListBox.setColumnSorter(idx++, accountNameSorter, 6);
                this.clarificationListBox.setColumnSorter(idx++, accountNameSorter, 7);
            }
            this.clarificationListBox.setColumnSorter(idx++, sorter, 8);
            this.clarificationListBox.setColumnSorter(idx++, sorter, 9);
            if (!this.isShowNewClarificationsOnly()) {
                this.clarificationListBox.setColumnSorter(idx++, sorter, 10);
            }
        } else {
            this.clarificationListBox.setColumnSorter(idx++, sorter, 1);
            this.clarificationListBox.setColumnSorter(idx++, accountNameSorter, 2);
            this.clarificationListBox.setColumnSorter(idx++, numericStringSorter, 3);
            this.clarificationListBox.setColumnSorter(idx++, numericStringSorter, 4);
            this.clarificationListBox.setColumnSorter(idx++, sorter, 5);
            this.clarificationListBox.setColumnSorter(idx++, sorter, 8);
            this.clarificationListBox.setColumnSorter(idx++, sorter, 9);
            if (!this.isShowNewClarificationsOnly()) {
                this.clarificationListBox.setColumnSorter(idx++, sorter, 10);
            }
        }
        this.clarificationListBox.autoSizeAllColumns();
    }

    protected void showSelectedClarification() {
        int selectedClarificationIndex = this.getClarificationListBox().getSelectedIndex();
        if (selectedClarificationIndex == -1) {
            this.getAnswerPane().setVisible(false);
            this.getAnswerTextArea().setText("");
            this.getQuestionTextArea().setText("");
            String clarificationTitle = "Clarification ";
            this.clarificationPane.setBorder(BorderFactory.createTitledBorder(null, clarificationTitle, 0, 0, null, null));
            return;
        }
        ElementId clarificationId = (ElementId)this.getClarificationListBox().getKeys()[selectedClarificationIndex];
        Clarification clarification = this.getContest().getClarification(clarificationId);
        if (clarification != null) {
            String clarificationTitle = "Clarification " + clarification.getNumber() + "  from " + this.getTeamDisplayName(clarification.getSubmitter()) + " (Site " + clarification.getSiteNumber() + ")";
            this.clarificationPane.setBorder(BorderFactory.createTitledBorder(null, clarificationTitle, 0, 0, null, null));
            this.getQuestionTextArea().setText(clarification.getQuestion());
            this.getQuestionTextArea().setCaretPosition(0);
            if (clarification.getAnswer() != null) {
                this.getAnswerPane().setVisible(true);
                this.getAnswerTextArea().setText(clarification.getAnswer());
            } else {
                this.getAnswerTextArea().setText("Not answered, yet.");
                this.getAnswerPane().setVisible(!this.isShowNewClarificationsOnly());
            }
            this.getAnswerTextArea().setCaretPosition(0);
        }
        this.getClarificationSplitPane().setVisible(true);
    }

    private void showClarificationAnswer(Clarification clarification) {
        if (clarification.isDeleted()) {
            return;
        }
        String problemName = this.getProblemTitle(clarification.getProblemId());
        String displayString = "<HTML><FONT SIZE=+1>Judge's Response<BR><BR>Problem: <FONT COLOR=BLUE>" + Utilities.forHTML(problemName) + "</FONT><BR><BR>" + "Clar Id: <FONT COLOR=BLUE>" + clarification.getNumber() + "</FONT><BR><BR><BR>" + "Question: <FONT COLOR=BLUE> " + Utilities.forHTML(clarification.getQuestion()) + "</FONT><BR><BR><BR>" + "Answer: <FONT COLOR=BLUE>" + Utilities.forHTML(clarification.getAnswer()) + "</FONT><BR><BR><BR>";
        if (clarification.isSendToAll()) {
            displayString = String.valueOf(displayString) + "* For All Teams *" + "\n";
        }
        FrameUtilities.showMessage(this.getParentFrame(), "Clarification " + clarification.getNumber(), displayString);
    }

    private void removeClarificationRow(final Clarification clarification) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowNumber = ClarificationsPane.this.clarificationListBox.getIndexByKey(clarification.getElementId());
                if (rowNumber != -1) {
                    ClarificationsPane.this.clarificationListBox.removeRow(rowNumber);
                }
            }
        });
    }

    public void updateClarificationRow(final Clarification clarification, final ClientId whoChangedId) {
        if (this.filter != null && !this.filter.matches(clarification)) {
            this.removeClarificationRow(clarification);
            return;
        }
        if (this.requiredFilter != null && !this.requiredFilter.matches(clarification)) {
            this.removeClarificationRow(clarification);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = ClarificationsPane.this.buildClarificationRow(clarification, whoChangedId);
                int rowNumber = ClarificationsPane.this.clarificationListBox.getIndexByKey(clarification.getElementId());
                if (rowNumber == -1) {
                    ClarificationsPane.this.clarificationListBox.addRow(objects, clarification.getElementId());
                } else {
                    ClarificationsPane.this.clarificationListBox.replaceRow(objects, rowNumber);
                    if (ClarificationsPane.this.clarificationListBox.isRowSelected(rowNumber)) {
                        ClarificationsPane.this.showSelectedClarification();
                    }
                }
                ClarificationsPane.this.clarificationListBox.autoSizeAllColumns();
                ClarificationsPane.this.clarificationListBox.sort();
            }
        });
    }

    private Object[] buildClarificationRow(Clarification clar, ClientId clientId) {
        int cols = this.clarificationListBox.getColumnCount();
        Object[] obj = new Object[cols];
        int idx = 0;
        obj[idx++] = this.getSiteTitle(clar.getSubmitter().getSiteNumber());
        obj[idx++] = this.getTeamDisplayName(clar.getSubmitter());
        obj[idx++] = clar.getNumber();
        obj[idx++] = clar.getElapsedMins();
        boolean isTeam = this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.TEAM);
        obj[idx++] = isTeam ? (clar.isAnswered() ? (clar.isSendToAll() ? "Broadcast" : "Answered") : "New") : clar.getState();
        if (!this.isShowNewClarificationsOnly() && !isTeam) {
            obj[idx++] = clar.isAnswered() ? (clar.getWhoJudgedItId() == null || isTeam ? "" : clar.getWhoJudgedItId().getName()) : (clientId == null ? "" : clientId.getName());
            obj[idx++] = clar.isSendToAll() ? "All Teams" : this.getTeamDisplayName(clar.getSubmitter());
        }
        obj[idx++] = this.getProblemTitle(clar.getProblemId());
        obj[idx++] = clar.getQuestion();
        if (!this.isShowNewClarificationsOnly()) {
            obj[idx++] = clar.getAnswer();
        }
        return obj;
    }

    void reloadListBox() {
        Clarification[] clarifications;
        if (this.isJudge()) {
            ContestInformation contestInformation = this.getContest().getContestInformation();
            this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
        }
        if (this.filter.isFilterOn()) {
            this.getFilterButton().setForeground(Color.BLUE);
            this.getFilterButton().setToolTipText("Edit filter - filter ON");
        } else {
            this.getFilterButton().setForeground(Color.BLACK);
            this.getFilterButton().setToolTipText("Edit filter");
        }
        this.clarificationListBox.removeAllRows();
        Clarification[] clarificationArray = clarifications = this.getContest().getClarifications();
        int n = clarifications.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if ((this.requiredFilter == null || this.requiredFilter.matches(clarification)) && (this.filter == null || this.filter.matches(clarification))) {
                this.addClarificationRow(clarification, false);
            }
            ++n2;
        }
        this.clarificationListBox.autoSizeAllColumns();
        this.clarificationListBox.sort();
    }

    private void addClarificationRow(Clarification clarification, boolean autoSizeAndSort) {
        Object[] objects = this.buildClarificationRow(clarification, null);
        this.clarificationListBox.addRow(objects, clarification.getElementId());
        if (autoSizeAndSort) {
            this.clarificationListBox.autoSizeAllColumns();
            this.clarificationListBox.sort();
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.displayTeamName = new DisplayTeamName();
        this.displayTeamName.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.getContest().addClarificationListener(new ClarificationListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addLanguageListener(new LanguageListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addCategoryListener(new CategoryListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClarificationsPane.this.getEditFilterFrame().setContestAndController(ClarificationsPane.this.getContest(), ClarificationsPane.this.getController());
                ClarificationsPane.this.answerClarificationFrame.setContestAndController(ClarificationsPane.this.getContest(), ClarificationsPane.this.getController());
                ClarificationsPane.this.updateGUIperPermissions();
                ClarificationsPane.this.resetClarsListBoxColumns();
                ClarificationsPane.this.reloadListBox();
            }
        });
    }

    private String getProblemTitle(ElementId problemId) {
        Problem problem = this.getContest().getProblem(problemId);
        if (problem != null) {
            return problem.toString();
        }
        return "Problem ?";
    }

    private String getSiteTitle(int siteNumber) {
        return "Site " + siteNumber;
    }

    private String getTeamDisplayName(ClientId clientId) {
        if (this.isJudge() && this.isTeam(clientId)) {
            return this.displayTeamName.getDisplayName(clientId);
        }
        return clientId.getName();
    }

    private JButton getGiveButton() {
        if (this.giveButton == null) {
            this.giveButton = new JButton();
            this.giveButton.setText("Give");
            this.giveButton.setToolTipText("Give the selected Clarification back to Judges");
            this.giveButton.setMnemonic(71);
            this.giveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClarificationsPane.this.showMessage("Give not implemented");
                }
            });
        }
        return this.giveButton;
    }

    private JButton getTakeButton() {
        if (this.takeButton == null) {
            this.takeButton = new JButton();
            this.takeButton.setText("Take");
            this.takeButton.setToolTipText("Take the selected Clarification back from the Judges");
            this.takeButton.setMnemonic(84);
            this.takeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClarificationsPane.this.showMessage("Take not implemented");
                }
            });
        }
        return this.takeButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit the selected Clarification");
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClarificationsPane.this.showMessage("Edit not implemented");
                }
            });
        }
        return this.editButton;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setText("Filter");
            this.filterButton.setToolTipText("Edit Filter");
            this.filterButton.setVisible(true);
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClarificationsPane.this.showFilterClarificationsFrame();
                }
            });
        }
        return this.filterButton;
    }

    protected void showFilterClarificationsFrame() {
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.PROBLEMS);
        if (!this.isTeam(this.getContest().getClientId())) {
            this.getEditFilterFrame().addList(EditFilterPane.ListNames.CLARIFICATION_STATES);
            this.getEditFilterFrame().addList(EditFilterPane.ListNames.TEAM_ACCOUNTS);
            this.getEditFilterFrame().addList(EditFilterPane.ListNames.SITES);
        }
        this.getEditFilterFrame().setFilter(this.filter);
        this.getEditFilterFrame().doLayout();
        this.getEditFilterFrame().setVisible(true);
    }

    public EditFilterFrame getEditFilterFrame() {
        if (this.editFilterFrame == null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            };
            this.editFilterFrame = new EditFilterFrame(this.filter, this.filterFrameTitle, callback);
            this.editFilterFrame.setFilteringClarifications(true);
            if (this.displayTeamName != null) {
                this.editFilterFrame.setDisplayTeamName(this.displayTeamName);
            }
        }
        return this.editFilterFrame;
    }

    private boolean isTeam(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isJudge() {
        return this.isJudge(this.getContest().getClientId());
    }

    private void updateGUIperPermissions() {
        if (this.showNewClarificationsOnly) {
            this.requestButton.setVisible(this.isAllowed(Permission.Type.ANSWER_CLARIFICATION));
            this.editButton.setVisible(false);
            this.giveButton.setVisible(false);
            this.takeButton.setVisible(false);
        } else {
            this.requestButton.setVisible(this.isAllowed(Permission.Type.ANSWER_CLARIFICATION));
            this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_CLARIFICATION));
            this.giveButton.setVisible(this.isAllowed(Permission.Type.GIVE_CLARIFICATION));
            this.takeButton.setVisible(this.isAllowed(Permission.Type.TAKE_CLARIFICATION));
        }
    }

    private JButton getRequestButton() {
        if (this.requestButton == null) {
            this.requestButton = new JButton();
            this.requestButton.setText("Answer");
            this.requestButton.setToolTipText("Answer the selected Clarification");
            this.requestButton.setMnemonic(65);
            this.requestButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClarificationsPane.this.requestSelectedClarification();
                }
            });
        }
        return this.requestButton;
    }

    protected void requestSelectedClarification() {
        int[] selectedIndexes = this.clarificationListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a clarification ");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.clarificationListBox.getKeys()[selectedIndexes[0]];
            Clarification clarificationToAnswer = this.getContest().getClarification(elementId);
            if (!clarificationToAnswer.getState().equals((Object)Clarification.ClarificationStates.NEW) || clarificationToAnswer.isDeleted()) {
                this.showMessage("Not allowed to request clarification, already answered");
                return;
            }
            this.answerClarificationFrame.setClarification(clarificationToAnswer);
            this.answerClarificationFrame.setVisible(true);
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to answer clarification, check log");
        }
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(32, 32));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ClarificationsPane.this.getParentFrame(), string, "Warning", 2);
            }
        });
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            this.centerPane = new JPanel();
            this.centerPane.setPreferredSize(new Dimension(200, 400));
            this.centerPane.setLayout(gridLayout);
            this.centerPane.add((Component)((Object)this.getClarificationListBox()), null);
            this.centerPane.add((Component)this.getClarificationSplitPane(), null);
        }
        return this.centerPane;
    }

    private JSplitPane getClarificationSplitPane() {
        if (this.clarificationSplitPane == null) {
            this.clarificationSplitPane = new JSplitPane();
            this.clarificationSplitPane.setPreferredSize(new Dimension(200, 200));
            this.clarificationSplitPane.setDividerLocation(70);
            this.clarificationSplitPane.setTopComponent(this.getClarificationPane());
            this.clarificationSplitPane.setBottomComponent(this.getAnswerPane());
            this.clarificationSplitPane.setOrientation(0);
            this.clarificationSplitPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ClarificationsPane.this.clarificationSplitPane.setDividerLocation(ClarificationsPane.this.clarificationSplitPane.getHeight() / 2);
                }
            });
        }
        return this.clarificationSplitPane;
    }

    private JPanel getClarificationPane() {
        if (this.clarificationPane == null) {
            this.clarificationPane = new JPanel();
            this.clarificationPane.setLayout(new BorderLayout());
            this.clarificationPane.setPreferredSize(new Dimension(10, 40));
            this.clarificationPane.setBorder(BorderFactory.createTitledBorder(null, "Clarification", 0, 0, null, null));
            this.clarificationPane.add((Component)this.getJQuestionScrollPane(), "Center");
        }
        return this.clarificationPane;
    }

    private JTextArea getQuestionTextArea() {
        if (this.questionTextArea == null) {
            this.questionTextArea = new JTextArea();
            this.questionTextArea.setLayout(new BorderLayout());
            this.questionTextArea.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
            this.questionTextArea.add((Component)this.getAnswerTextArea(), "Center");
            this.questionTextArea.setEditable(false);
        }
        return this.questionTextArea;
    }

    private JPanel getAnswerPane() {
        if (this.answerPane == null) {
            this.answerPane = new JPanel();
            this.answerPane.setLayout(new BorderLayout());
            this.answerPane.setBorder(BorderFactory.createTitledBorder(null, "Answer", 0, 0, null, null));
            this.answerPane.add((Component)this.getJAnswerScrollPane(), "Center");
        }
        return this.answerPane;
    }

    private JTextArea getAnswerTextArea() {
        if (this.answerTextArea == null) {
            this.answerTextArea = new JTextArea();
            this.answerTextArea.setEditable(false);
        }
        return this.answerTextArea;
    }

    public boolean isShowNewClarificationsOnly() {
        return this.showNewClarificationsOnly;
    }

    public void setShowNewClarificationsOnly(boolean showNewClarificationsOnly) {
        this.showNewClarificationsOnly = showNewClarificationsOnly;
        if (showNewClarificationsOnly) {
            if (this.requiredFilter == null) {
                this.requiredFilter = new Filter();
            }
            this.requiredFilter.addClarificationState(Clarification.ClarificationStates.NEW);
        } else {
            this.requiredFilter = new Filter();
        }
        this.getAnswerPane().setVisible(!showNewClarificationsOnly);
    }

    private JScrollPane getJQuestionScrollPane() {
        if (this.jQuestionScrollPane == null) {
            this.jQuestionScrollPane = new JScrollPane();
            this.jQuestionScrollPane.setViewportView(this.getQuestionTextArea());
        }
        return this.jQuestionScrollPane;
    }

    private JScrollPane getJAnswerScrollPane() {
        if (this.jAnswerScrollPane == null) {
            this.jAnswerScrollPane = new JScrollPane();
            this.jAnswerScrollPane.setViewportView(this.getAnswerTextArea());
        }
        return this.jAnswerScrollPane;
    }

    public void setFilterFrameTitle(String title) {
        this.filterFrameTitle = title;
        if (this.editFilterFrame != null) {
            this.editFilterFrame.setTitle(title);
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (ClarificationsPane.this.getContest().getClientId().equals(account.getClientId())) {
                ClarificationsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClarificationsPane.this.updateGUIperPermissions();
                        ClarificationsPane.this.reloadListBox();
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClarificationsPane.this.reloadListBox();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            boolean theyModifiedUs = false;
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ClarificationsPane.this.getContest().getClientId().equals(account.getClientId())) {
                    theyModifiedUs = true;
                    ClarificationsPane.this.initializePermissions();
                }
                ++n2;
            }
            final boolean finalTheyModifiedUs = theyModifiedUs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (finalTheyModifiedUs) {
                        ClarificationsPane.this.updateGUIperPermissions();
                    }
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.updateGUIperPermissions();
                    ClarificationsPane.this.resetClarsListBoxColumns();
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }
    }

    private class CategoryListenerImplementation
    implements ICategoryListener {
        private CategoryListenerImplementation() {
        }

        @Override
        public void categoryAdded(CategoryEvent event) {
        }

        @Override
        public void categoryChanged(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void categoryRemoved(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void categoryRefreshAll(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }
    }

    public class ClarificationListenerImplementation
    implements IClarificationListener {
        @Override
        public void clarificationAdded(ClarificationEvent event) {
            ClarificationsPane.this.updateClarificationRow(event.getClarification(), event.getWhoModifiedClarification());
            if (event.getClarification().isAnswered() && ClarificationsPane.this.getContest().getClientId().getClientType() == ClientType.Type.TEAM) {
                ClarificationsPane.this.showClarificationAnswer(event.getClarification());
            }
        }

        @Override
        public void refreshClarfications(ClarificationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.updateGUIperPermissions();
                    ClarificationsPane.this.resetClarsListBoxColumns();
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void clarificationChanged(ClarificationEvent event) {
            ClarificationsPane.this.updateClarificationRow(event.getClarification(), event.getWhoModifiedClarification());
            if (event.getClarification().isAnswered() && ClarificationsPane.this.getContest().getClientId().getClientType() == ClientType.Type.TEAM) {
                ClarificationsPane.this.showClarificationAnswer(event.getClarification());
            }
        }

        @Override
        public void clarificationRemoved(ClarificationEvent event) {
        }
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }

    public class LanguageListenerImplementation
    implements ILanguageListener {
        @Override
        public void languageAdded(LanguageEvent event) {
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void languageRemoved(LanguageEvent event) {
        }

        @Override
        public void languageRefreshAll(LanguageEvent event) {
            this.languageChanged(event);
        }

        @Override
        public void languagesAdded(LanguageEvent event) {
        }

        @Override
        public void languagesChanged(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        @Override
        public void problemAdded(ProblemEvent event) {
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClarificationsPane.this.reloadListBox();
                }
            });
        }
    }
}

