/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.ListboxColumn;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IMessageListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AutoRegistrationPane
extends JPanePlugin {
    private static final long serialVersionUID = 3571201525487468354L;
    private JPanel centerFrame = null;
    private JPanel buttonPane = null;
    private JPanel titlePane = null;
    private JLabel titleLabel = null;
    private JButton registerButton = null;
    private JButton cancelButton = null;
    private JTextField teamNameJTextField = null;
    private JPanel memberNamesPanel = null;
    private JPanel teamMemberTitle = null;
    private MCLB teamNameMCLB = null;
    private JPanel southPane;
    private JPanel buttonPaneTwo;
    private JButton btnRemoveMember;
    private JButton btnAddMember;

    public AutoRegistrationPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(451, 281));
        this.add((Component)this.getCenterFrame(), "Center");
        this.add((Component)this.getTitlePane(), "North");
        this.add((Component)this.getSouthPane(), "South");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        inContest.addMessageListener(new MessageListenerImplementation());
        inContest.addLoginListener(new LoginListenerImplementation());
    }

    @Override
    public String getPluginTitle() {
        return "Auto Registration Pane";
    }

    private JPanel getCenterFrame() {
        if (this.centerFrame == null) {
            this.centerFrame = new JPanel();
            this.centerFrame.setLayout(new BorderLayout());
            this.centerFrame.add((Component)this.getMemberNamesPanel(), "Center");
            this.centerFrame.add((Component)this.getTeamMemberTitle(), "North");
        }
        return this.centerFrame;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getRegisterButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getTitlePane() {
        if (this.titlePane == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("Registration ");
            this.titleLabel.setFont(new Font("Dialog", 1, 18));
            this.titleLabel.setHorizontalAlignment(0);
            this.titlePane = new JPanel();
            this.titlePane.setLayout(new BorderLayout());
            this.titlePane.setPreferredSize(new Dimension(45, 45));
            this.titlePane.add((Component)this.titleLabel, "Center");
        }
        return this.titlePane;
    }

    private JButton getRegisterButton() {
        if (this.registerButton == null) {
            this.registerButton = new JButton();
            this.registerButton.setText("Register");
            this.registerButton.setMnemonic('R');
            this.registerButton.setMnemonic(82);
            this.registerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoRegistrationPane.this.sendRegistrationRequest();
                }
            });
        }
        return this.registerButton;
    }

    protected void sendRegistrationRequest() {
        if (this.getAccountNameTitle().getText().trim().length() == 0) {
            this.showMessage(this.getParentFrame(), "Enter missing information", "Enter a Team Name/title");
            return;
        }
        String teamName = this.getAccountNameTitle().getText().trim();
        String[] teamMemberNames = this.getTeamNamesFromFields();
        if (teamMemberNames.length == 0) {
            this.showMessage(this.getParentFrame(), "Enter missing information", "Enter a Team Member Name");
            return;
        }
        String delimit = ":;";
        String names = StringUtilities.join(delimit, teamMemberNames);
        try {
            String autoRegisterInformation = String.valueOf(teamName) + delimit + names;
            this.getController().autoRegister(autoRegisterInformation);
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Unable to send auto registration ", e);
            this.showMessage(this.getParent(), "Unable to send auto registration", "Internal error " + e.getMessage());
        }
    }

    private String[] getTeamNamesFromFields() {
        MCLB mclb = this.getTeamNameMCLB();
        if (mclb.getRowCount() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int row = 0;
        while (row < mclb.getRowCount()) {
            JTextField jTextField = (JTextField)mclb.getRow(row)[0];
            String name = jTextField.getText();
            if (name != null && name.trim().length() > 0) {
                list.add(name);
            }
            ++row;
        }
        return list.toArray(new String[list.size()]);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoRegistrationPane.this.returnToParent();
                }
            });
        }
        return this.cancelButton;
    }

    protected void returnToParent() {
        this.getParentFrame().setVisible(false);
    }

    private JTextField getAccountNameTitle() {
        if (this.teamNameJTextField == null) {
            this.teamNameJTextField = new JTextField();
        }
        return this.teamNameJTextField;
    }

    private JPanel getMemberNamesPanel() {
        if (this.memberNamesPanel == null) {
            this.memberNamesPanel = new JPanel();
            this.memberNamesPanel.setLayout(new BorderLayout());
            this.memberNamesPanel.setBorder(BorderFactory.createTitledBorder(null, "Team Member Names", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.memberNamesPanel.add((Component)((Object)this.getTeamNameMCLB()), "Center");
        }
        return this.memberNamesPanel;
    }

    private JPanel getTeamMemberTitle() {
        if (this.teamMemberTitle == null) {
            this.teamMemberTitle = new JPanel();
            this.teamMemberTitle.setLayout(new BorderLayout());
            this.teamMemberTitle.setBorder(BorderFactory.createTitledBorder(null, "Team Name", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.teamMemberTitle.add((Component)this.getAccountNameTitle(), "Center");
        }
        return this.teamMemberTitle;
    }

    private MCLB getTeamNameMCLB() {
        if (this.teamNameMCLB == null) {
            this.teamNameMCLB = new MCLB();
            Object[] cols = new Object[]{"Name"};
            this.teamNameMCLB.addColumns(cols);
            this.teamNameMCLB.addRow(this.buildRow());
            int width = 500;
            ListboxColumn column = this.teamNameMCLB.getColumnInfo(0);
            column.setWidth(width);
        }
        return this.teamNameMCLB;
    }

    private Object[] buildRow() {
        Object[] objects = new Object[this.teamNameMCLB.getColumnCount()];
        objects[0] = this.createJTextField();
        return objects;
    }

    private Object createJTextField() {
        JTextField textField = new JTextField();
        textField.setText("");
        textField.setEditable(true);
        textField.requestFocus();
        return textField;
    }

    public void showAccountMessage(String accountMessage) {
        String[] loginInfo = accountMessage.split(":;");
        String teamName = loginInfo[0];
        String login = loginInfo[1];
        String password = loginInfo[2];
        StringBuffer buffer = new StringBuffer().append("<HTML><FONT SIZE=+1> ").append("Automantic Registration Information<BR>").append("for team ").append(teamName).append("<BR><BR>").append("Login: ").append(login).append("<BR><BR>").append("Password: ").append(password).append("<BR><BR>").append("</FONT></HTML>");
        FrameUtilities.showMessage(this.getParentFrame(), "Automatic Registration Information", buffer.toString());
        this.returnToParent();
    }

    private JPanel getSouthPane() {
        if (this.southPane == null) {
            this.southPane = new JPanel();
            this.southPane.setName("southPane");
            this.southPane.setLayout(new BorderLayout(0, 0));
            this.southPane.add(this.getButtonPaneTwo());
            this.southPane.add((Component)this.getButtonPane(), "South");
        }
        return this.southPane;
    }

    private JPanel getButtonPaneTwo() {
        if (this.buttonPaneTwo == null) {
            this.buttonPaneTwo = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.buttonPaneTwo.getLayout();
            flowLayout.setHgap(100);
            this.buttonPaneTwo.setPreferredSize(new Dimension(35, 35));
            this.buttonPaneTwo.add(this.getBtnAddMember());
            this.buttonPaneTwo.add(this.getBtnRemoveMember());
        }
        return this.buttonPaneTwo;
    }

    private JButton getBtnRemoveMember() {
        if (this.btnRemoveMember == null) {
            this.btnRemoveMember = new JButton("Remove Member");
            this.btnRemoveMember.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int lastRow = AutoRegistrationPane.this.teamNameMCLB.getRowCount();
                    if (lastRow > 1) {
                        AutoRegistrationPane.this.teamNameMCLB.removeRow(lastRow - 1);
                    } else {
                        AutoRegistrationPane.this.teamNameMCLB.removeRow(lastRow - 1);
                        AutoRegistrationPane.this.teamNameMCLB.addRow(AutoRegistrationPane.this.buildRow());
                    }
                }
            });
            this.btnRemoveMember.setMnemonic(69);
        }
        return this.btnRemoveMember;
    }

    private JButton getBtnAddMember() {
        if (this.btnAddMember == null) {
            this.btnAddMember = new JButton("Add Member");
            this.btnAddMember.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoRegistrationPane.this.teamNameMCLB.addRow(AutoRegistrationPane.this.buildRow());
                }
            });
            this.btnAddMember.setMnemonic(65);
        }
        return this.btnAddMember;
    }

    public void resetFields() {
        this.teamNameMCLB.removeAllRows();
        this.teamNameMCLB.addRow(this.buildRow());
        this.teamNameJTextField.setText("");
    }

    class LoginListenerImplementation
    implements ILoginListener {
        LoginListenerImplementation() {
        }

        @Override
        public void loginAdded(LoginEvent event) {
        }

        @Override
        public void loginRemoved(LoginEvent event) {
        }

        @Override
        public void loginDenied(LoginEvent event) {
            String message = event.getMessage();
            AutoRegistrationPane.this.showMessage(AutoRegistrationPane.this.getParent(), "Not Allowed", message);
            AutoRegistrationPane.this.returnToParent();
        }

        @Override
        public void loginRefreshAll(LoginEvent event) {
        }
    }

    class MessageListenerImplementation
    implements IMessageListener {
        MessageListenerImplementation() {
        }

        @Override
        public void messageAdded(MessageEvent event) {
            if (MessageEvent.Area.AUTOREG.equals((Object)event.getArea())) {
                String accountMessage = event.getMessage();
                AutoRegistrationPane.this.showAccountMessage(accountMessage);
            }
        }

        @Override
        public void messageRemoved(MessageEvent event) {
        }
    }
}

