/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTransformer {
    public static void main(String[] args) {
        if (args.length == 3) {
            XSLTransformer me = new XSLTransformer();
            try {
                me.transform(args[0], args[1], new FileOutputStream(args[2]));
            }
            catch (Exception e) {
                System.err.println("Error doing transform: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: xslFile xmlFile outFile");
        }
    }

    public void transform(String xslFile, String xmlFile, FileOutputStream outFile) throws Exception {
        StreamSource inputXSL = new StreamSource(new File(xslFile));
        StreamSource inputXML = new StreamSource(new File(xmlFile));
        this.transform(inputXSL, inputXML, outFile);
    }

    public void transform(String xslFile, InputStream xmlStream, FileOutputStream outFile) throws Exception {
        if (xmlStream == null) {
            throw new IllegalArgumentException("transform() Invalid xmlStream, cannot be null");
        }
        StreamSource inputXSL = new StreamSource(new File(xslFile));
        StreamSource inputXML = new StreamSource(xmlStream);
        this.transform(inputXSL, inputXML, outFile);
    }

    public void transform(Source inputXSL, Source inputXML, FileOutputStream outFile) throws Exception {
        if (outFile == null) {
            throw new IllegalArgumentException("transform() Invalid outFile, cannot be null");
        }
        StreamResult output = new StreamResult(outFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(inputXSL);
        transformer.transform(inputXML, output);
    }

    public String transformToString(File xslFile, String xmlString) throws Exception {
        StreamSource inputXML = new StreamSource(new StringReader(xmlString));
        StreamSource inputXSL = new StreamSource(xslFile);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(inputXSL);
        transformer.transform(inputXML, result);
        return stringWriter.toString();
    }
}

