/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.util.Arrays;
import java.util.Vector;

public class QuickLoad
implements UIPlugin {
    private static final long serialVersionUID = -4248229783309059230L;
    private IInternalContest contest;
    private IInternalController controller;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.loadContest();
    }

    public void loadContest() {
        if (this.contest.getLanguages().length == 0) {
            Language language = this.createLanguage("Java");
            if (language != null) {
                this.controller.addNewLanguage(language);
            }
            System.out.println("quickLoad: add " + language);
            language = this.createLanguage("GNU C++ (Unix / Windows)");
            if (language != null) {
                this.controller.addNewLanguage(language);
            }
            System.out.println("quickLoad: add " + language);
            language = this.createLanguage("Perl");
            if (language != null) {
                this.controller.addNewLanguage(language);
            }
            System.out.println("quickLoad: add " + language);
        }
        if (this.contest.getProblems().length == 0) {
            Problem problem = new Problem("Sumit");
            Problem problem2 = new Problem("Hello");
            ProblemDataFiles files = new ProblemDataFiles(problem);
            this.controller.addNewProblem(problem, files);
            System.out.println("quickLoad: add " + problem);
            files = new ProblemDataFiles(problem2);
            this.controller.addNewProblem(problem2, files);
            System.out.println("quickLoad: add " + problem);
        }
        if (this.siteLoggedIn(1)) {
            this.generateAccounts(1, ClientType.Type.TEAM, 22);
            this.generateAccounts(1, ClientType.Type.JUDGE, 12);
            this.generateAccounts(1, ClientType.Type.SCOREBOARD, 12);
        }
        if (this.siteLoggedIn(2)) {
            this.generateAccounts(2, ClientType.Type.TEAM, 22);
            this.generateAccounts(2, ClientType.Type.JUDGE, 2);
        }
        if (this.siteLoggedIn(3)) {
            this.generateAccounts(3, ClientType.Type.TEAM, 33);
        }
        this.assignGroupAndExternalIds();
    }

    private void assignGroupAndExternalIds() {
        Account[] accounts = null;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            accounts = null;
        }
        Account[] accountArray = accounts = this.getTeamAccounts(this.contest);
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            account.setCountryCode("UK");
            String externalId = String.valueOf(account.getSiteNumber()) + "00" + account.getClientId().getClientNumber();
            account.setExternalId(externalId);
            ++n2;
        }
        this.controller.updateAccounts(accounts);
    }

    public Account[] getTeamAccounts(IInternalContest inContest) {
        Vector<Account> accountVector = inContest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        return accounts;
    }

    private Language createLanguage(String languageName) {
        String[] stringArray = LanguageAutoFill.getLanguageList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String langName = stringArray[n2];
            if (langName.equals(languageName)) {
                String[] values = LanguageAutoFill.getAutoFillValues(langName);
                Language language = new Language(langName);
                this.fillLanguage(language, values, langName);
                return language;
            }
            ++n2;
        }
        return null;
    }

    private void fillLanguage(Language language, String[] values, String fullLanguageName) {
        language.setCompileCommandLine(values[1]);
        language.setExecutableIdentifierMask(values[2]);
        language.setProgramExecuteCommandLine(values[3]);
        boolean isScript = LanguageAutoFill.isInterpretedLanguage(fullLanguageName);
        language.setInterpreted(isScript);
    }

    private boolean siteLoggedIn(int siteNumber) {
        if (siteNumber == this.contest.getSiteNumber()) {
            return true;
        }
        ClientId remoteServerId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        return this.contest.isLocalLoggedIn(remoteServerId) || this.contest.isRemoteLoggedIn(remoteServerId);
    }

    private void generateAccounts(int siteNumber, ClientType.Type type, int count) {
        Vector<Account> accounts = this.contest.getAccounts(type, siteNumber);
        int numToGenerate = count - accounts.size();
        if (numToGenerate > 0) {
            System.out.println("quickLoad: added " + numToGenerate + " " + type.toString() + " at site " + siteNumber);
            this.controller.generateNewAccounts(type.toString(), siteNumber, numToGenerate, 1, true);
        }
    }

    @Override
    public String getPluginTitle() {
        return "Quick Load Contest";
    }
}

