/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FileStorage
implements IStorage {
    private String directoryName = ".";

    public FileStorage() {
    }

    public FileStorage(String directoryName) {
        this.directoryName = directoryName;
    }

    @Override
    public String getDirectoryName() {
        return this.directoryName;
    }

    @Override
    public Serializable load(String fileName) throws IOException, ClassNotFoundException, FileSecurityException {
        return (Serializable)this.readObjectFromFile(fileName);
    }

    @Override
    public boolean store(String fileName, Serializable serializable) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.writeObjectToFile(fileName, serializable);
    }

    public boolean writeObjectToFile(String filename, Serializable serializable) throws IOException {
        FileOutputStream f = new FileOutputStream(filename);
        ObjectOutputStream s = new ObjectOutputStream(f);
        s.writeObject(serializable);
        s.flush();
        s.close();
        s = null;
        return true;
    }

    private Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(filename);
        ObjectInputStream s = new ObjectInputStream(in);
        Object object = s.readObject();
        in.close();
        s.close();
        return object;
    }
}

