/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.exports.ccs.ScoreboardFile;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class ScoreboardTSVReport
implements IReportFile {
    private static final long serialVersionUID = 5168385483863061398L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "scoreboard.tsv";
    }

    @Override
    public void createReportFile(String filename, Filter aFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter aFilter) {
        try {
            ScoreboardFile scoreboardFile = new ScoreboardFile();
            String[] lines = scoreboardFile.createTSVFileLines(this.contest);
            return lines;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            return new String[]{"Exception writing report " + e.getMessage()};
        }
    }

    @Override
    public String createReportXML(Filter aFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        String[] lines;
        ScoreboardFile scoreboardFile = new ScoreboardFile();
        String[] stringArray = lines = scoreboardFile.createTSVFileLines(this.contest);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            printWriter.println(string);
            ++n2;
        }
    }

    @Override
    public String getReportTitle() {
        return "scoreboard.tsv";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

