/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeamProblem;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class RunsByTeamReport
implements IReport {
    private static final long serialVersionUID = 1672921503320671214L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void writeReport(PrintWriter printWriter) {
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparatorByTeamProblem());
        int count = this.filter.countRuns(runs);
        if (this.filter.isThisSiteOnly()) {
            printWriter.print(" for site " + this.filter.getSiteNumber());
        }
        ClientId currentTeam = null;
        Vector<Run> teamsRuns = new Vector<Run>();
        printWriter.println();
        if (count > 0) {
            Run[] runArray = runs;
            int n = runs.length;
            int n2 = 0;
            while (n2 < n) {
                Run run = runArray[n2];
                if (this.filter.matches(run)) {
                    if (run.getSubmitter().equals(currentTeam)) {
                        teamsRuns.add(run);
                    } else {
                        if (teamsRuns.size() > 0) {
                            this.printTeamsRuns(printWriter, currentTeam, teamsRuns);
                        }
                        currentTeam = run.getSubmitter();
                        teamsRuns = new Vector();
                        teamsRuns.add(run);
                    }
                }
                ++n2;
            }
            if (teamsRuns.size() > 0) {
                this.printTeamsRuns(printWriter, currentTeam, teamsRuns);
            }
        }
    }

    private String getClientName(ClientId clientId) {
        Account account = this.contest.getAccount(clientId);
        if (account != null) {
            return account.getDisplayName();
        }
        return clientId.getName();
    }

    private String getLanguageTitle(ElementId languageId) {
        Language language = this.contest.getLanguage(languageId);
        if (language != null) {
            return language.getDisplayName();
        }
        return "UndefLang";
    }

    private String getProblemTitle(ElementId problemId) {
        Problem problem = this.contest.getProblem(problemId);
        if (problem != null) {
            return problem.toString();
        }
        return "UndefProb";
    }

    private String getSiteTitle(String string) {
        return "Site " + string;
    }

    private Run[] getRunsForProblem(Vector<Run> runs, ElementId problemElementId) {
        Vector<Run> listOfRuns = new Vector<Run>();
        int i = 0;
        while (i < runs.size()) {
            Run run = runs.elementAt(i);
            if (this.filter.matches(run) && run.getProblemId().equals(problemElementId)) {
                listOfRuns.add(runs.elementAt(i));
            }
            ++i;
        }
        return listOfRuns.toArray(new Run[listOfRuns.size()]);
    }

    private void printTeamsRuns(PrintWriter printWriter, ClientId currentTeam, Vector<Run> teamsRuns) {
        printWriter.println(String.valueOf(currentTeam.getName()) + " Site " + currentTeam.getSiteNumber() + " - '" + this.getClientName(currentTeam) + "'");
        long firstSolveTime = 0L;
        int solved = 0;
        int attempts = 0;
        int deleteCount = 0;
        Problem[] problems = this.contest.getProblems();
        if (problems.length == 0) {
            printWriter.println("-- No problems defined -- ");
        }
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            Run[] runs = this.getRunsForProblem(teamsRuns, problem.getElementId());
            solved = 0;
            attempts = 0;
            firstSolveTime = 0L;
            deleteCount = 0;
            printWriter.println("   Problem " + this.getProblemTitle(problem.getElementId()));
            Run[] runArray = runs;
            int n3 = runs.length;
            int n4 = 0;
            while (n4 < n3) {
                Run run = runArray[n4];
                printWriter.format("     %3d %3d", run.getNumber(), run.getElapsedMins());
                if (run.isDeleted()) {
                    printWriter.print(" DELETED");
                    ++deleteCount;
                }
                printWriter.print(" " + (Object)((Object)run.getStatus()));
                ++attempts;
                if (run.isJudged()) {
                    JudgementRecord judgementRecord = run.getJudgementRecord();
                    Judgement judgement = this.contest.getJudgement(judgementRecord.getJudgementId());
                    printWriter.print(" " + judgement.toString().substring(0, 3));
                    if (run.isSolved() && !run.isDeleted()) {
                        if (firstSolveTime == 0L) {
                            firstSolveTime = run.getElapsedMins();
                        }
                        ++solved;
                    }
                }
                printWriter.print(" " + this.getLanguageTitle(run.getLanguageId()));
                printWriter.println();
                ++n4;
            }
            if (solved > 0 || attempts > 0) {
                printWriter.print("             " + attempts + " submissions. ");
                if (deleteCount > 0) {
                    printWriter.print(" " + deleteCount + " deleted");
                }
                if (solved > 0) {
                    printWriter.print(" SOLVED @ " + firstSolveTime + " mins.");
                } else {
                    printWriter.print(" NOT solved");
                }
                printWriter.println();
            } else {
                printWriter.println("             No submissions.");
            }
            printWriter.println();
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        String filterInfo;
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
        if (this.filter != null && !(filterInfo = this.filter.toString()).equals("")) {
            printWriter.println("Filter: " + filterInfo);
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Runs grouped by team";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Runs grouped by team Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

