/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.api.exceptions.LoginFailureException;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.report.AccountsTSVReportTeamAndJudges;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.JSONReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.core.report.SubmissionsTSVReport;
import edu.csus.ecs.pc2.exports.ccs.ResultsFile;
import edu.csus.ecs.pc2.exports.ccs.ScoreboardFile;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Extractor {
    private static final String LOGIN_OPTION_STRING = "--login";
    private static final String PASSWORD_OPTION_STRING = "--password";
    public static final String RUNS_OPTION = "runs";
    public static final String SCOREBOARD_OPTION = "scoreboard";
    public static final String RESULTS_OPTION = "results";
    public static final String SUBMISSION_OPTION = "submission";
    public static final String ACCOUNTS_OPTION = "accounts";
    public static final String JSON_OPTION = "standings.json";

    public void run(String[] args) {
        try {
            String[] requireArguementArgs = new String[]{LOGIN_OPTION_STRING, PASSWORD_OPTION_STRING, "-w", "-u"};
            ParseArguments arguments = new ParseArguments(args, requireArguementArgs);
            if (args.length == 0) {
                Extractor.usage();
                System.exit(2);
            }
            if (arguments.isOptPresent("--help")) {
                Extractor.usage();
                System.exit(0);
            }
            if (arguments.getArgCount() == 0) {
                System.err.println("Missing CCS filename");
                System.exit(2);
            }
            String loginName = "";
            if (arguments.isOptPresent(LOGIN_OPTION_STRING)) {
                loginName = arguments.getOptValue(LOGIN_OPTION_STRING);
            }
            if (arguments.isOptPresent("-u")) {
                loginName = arguments.getOptValue("-u");
            }
            String password = "";
            if (arguments.isOptPresent(PASSWORD_OPTION_STRING)) {
                password = arguments.getOptValue(PASSWORD_OPTION_STRING);
            }
            if (arguments.isOptPresent("-w")) {
                password = arguments.getOptValue("-w");
            }
            if (loginName == null || "".equals(loginName)) {
                throw new LoginFailureException("No login specified");
            }
            String[] argList = arguments.getArgList();
            String cccFilename = argList[0];
            String outputFilename = null;
            if (argList.length > 1) {
                outputFilename = argList[1];
            }
            Plugin plugin = this.logInToContest(loginName, password);
            String[] lines = this.getReportLines(cccFilename, plugin.getContest(), plugin.getController());
            if (outputFilename == null || outputFilename.trim().length() == 0) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    System.out.println(string);
                    ++n2;
                }
            } else {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(outputFilename, false), true);
                String[] stringArray = lines;
                int n = lines.length;
                int n3 = 0;
                while (n3 < n) {
                    String string = stringArray[n3];
                    printWriter.println(string);
                    ++n3;
                }
                printWriter.close();
                printWriter = null;
            }
            System.exit(0);
        }
        catch (LoginFailureException e) {
            if (e.getMessage() == null) {
                e.printStackTrace(System.err);
            }
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                e.printStackTrace(System.err);
            }
            System.err.println(e.getMessage());
        }
        System.exit(2);
    }

    protected String[] getReportLines(String cccFilename, IInternalContest inContest, IInternalController inController) throws Exception {
        IReport report = this.getReportForFilename(cccFilename);
        if (report == null) {
            throw new Exception("No such report for " + cccFilename);
        }
        report.setContestAndController(inContest, inController);
        return report.createReport(null);
    }

    private IReport getReportForFilename(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (SUBMISSION_OPTION.equals(name) || RUNS_OPTION.equals(name)) {
            return new SubmissionsTSVReport();
        }
        if (SCOREBOARD_OPTION.equals(name)) {
            return new ScoreboardTSVReport();
        }
        if (ACCOUNTS_OPTION.equals(name)) {
            return new AccountsTSVReportTeamAndJudges();
        }
        if (RESULTS_OPTION.equals(name)) {
            return new ResultsTSVReport();
        }
        if (JSON_OPTION.equals(name)) {
            return new JSONReport();
        }
        return null;
    }

    private Plugin logInToContest(String login, String password) throws LoginFailureException {
        IInternalContest internalContest = new InternalContest();
        InternalController controller = new InternalController(internalContest);
        controller.setUsingGUI(false);
        controller.setUsingMainUI(false);
        controller.setClientAutoShutdown(false);
        try {
            controller.start(new String[0]);
            internalContest = controller.clientLogin(internalContest, login, password);
            Plugin plugin = new Plugin();
            plugin.setContestAndController(internalContest, controller);
            return plugin;
        }
        catch (Exception e) {
            throw new LoginFailureException(e.getMessage());
        }
    }

    public static void usage() {
        String[] lines;
        String[] stringArray = lines = new String[]{"Usage: [options] CCS_reportname [outfilename]", "", "--login loginName - login name (or use -u)", "--password password - login password (or use -w) ", "", "CCS_reportname - one of the following submission, scoreboard, results, accounts, standings.json", "", "Example: Extractor --login scoreboard1 --password scoreboard1 scoreboard", "", ""};
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
        VersionInfo info = new VersionInfo();
        System.out.println(info.getSystemVersionInfo());
    }

    public static void main(String[] args) {
        new Extractor().run(args);
    }

    class EmptyReport
    implements IReport {
        private static final long serialVersionUID = -7612441954778315221L;
        private IInternalContest contest = null;

        EmptyReport() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            this.contest = inContest;
        }

        @Override
        public String getPluginTitle() {
            return null;
        }

        @Override
        public void writeReport(PrintWriter printWriter) throws Exception {
        }

        @Override
        public void setFilter(Filter filter) {
        }

        @Override
        public void printHeader(PrintWriter printWriter) {
        }

        @Override
        public void printFooter(PrintWriter printWriter) {
        }

        @Override
        public String getReportTitle() {
            return "Empty report";
        }

        @Override
        public Filter getFilter() {
            return null;
        }

        @Override
        public String createReportXML(Filter filter) throws IOException {
            return Reports.notImplementedXML(this);
        }

        @Override
        public void createReportFile(String filename, Filter filter) throws IOException {
        }

        @Override
        public String[] createReport(Filter filter) {
            return null;
        }

        public IInternalContest getContest() {
            return this.contest;
        }
    }

    protected class Plugin
    implements UIPlugin {
        private static final long serialVersionUID = -6457070609026348869L;
        private IInternalController controller;
        private IInternalContest contest;

        protected Plugin() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            this.controller = inController;
            this.contest = inContest;
        }

        public IInternalController getController() {
            return this.controller;
        }

        public IInternalContest getContest() {
            return this.contest;
        }

        @Override
        public String getPluginTitle() {
            return "Stub Plugin";
        }
    }

    protected class ResultsTSVReport
    extends EmptyReport {
        private static final long serialVersionUID = -994643840065683641L;
        private ResultsFile resultsFile = new ResultsFile();

        protected ResultsTSVReport() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            super.setContestAndController(inContest, inController);
        }

        @Override
        public String getReportTitle() {
            return "results.tsv report";
        }

        @Override
        public String[] createReport(Filter filter) {
            try {
                return this.resultsFile.createTSVFileLines(this.getContest());
            }
            catch (IllegalContestState e) {
                e.printStackTrace();
                return new String[0];
            }
        }
    }

    protected class ScoreboardTSVReport
    extends EmptyReport {
        private static final long serialVersionUID = -994643840065683641L;
        private ScoreboardFile scoreboardFile = new ScoreboardFile();

        protected ScoreboardTSVReport() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            super.setContestAndController(inContest, inController);
        }

        @Override
        public String getReportTitle() {
            return "results.tsv report";
        }

        @Override
        public String[] createReport(Filter filter) {
            try {
                return this.scoreboardFile.createTSVFileLines(this.getContest());
            }
            catch (IllegalContestState e) {
                e.printStackTrace();
                return new String[0];
            }
        }
    }
}

