/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ReportNameByComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.AccountPermissionReport;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReportTeamAndJudges;
import edu.csus.ecs.pc2.core.report.BalloonDeliveryReport;
import edu.csus.ecs.pc2.core.report.BalloonSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.CategoryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ClientSettingsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.ContestReport;
import edu.csus.ecs.pc2.core.report.ContestSettingsReport;
import edu.csus.ecs.pc2.core.report.EvaluationReport;
import edu.csus.ecs.pc2.core.report.EventFeed2013Report;
import edu.csus.ecs.pc2.core.report.ExportYamlReport;
import edu.csus.ecs.pc2.core.report.ExtractPlaybackLoadFilesReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedSummaryReport;
import edu.csus.ecs.pc2.core.report.FinalizeReport;
import edu.csus.ecs.pc2.core.report.GroupsReport;
import edu.csus.ecs.pc2.core.report.GroupsTSVReport;
import edu.csus.ecs.pc2.core.report.HTMLReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.InternalDumpReport;
import edu.csus.ecs.pc2.core.report.JSONReport;
import edu.csus.ecs.pc2.core.report.JudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.JudgementReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.LoginReport;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.PlaybackDumpReport;
import edu.csus.ecs.pc2.core.report.PluginsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.ProfileCloneSettingsReport;
import edu.csus.ecs.pc2.core.report.ProfilesReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.core.report.RunJudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.RunStatisticsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.RunsReport5;
import edu.csus.ecs.pc2.core.report.ScoreboardTSVReport;
import edu.csus.ecs.pc2.core.report.SitesReport;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import edu.csus.ecs.pc2.core.report.StandingsReport;
import edu.csus.ecs.pc2.core.report.SubmissionsTSVReport;
import edu.csus.ecs.pc2.core.report.TeamsTSVReport;
import edu.csus.ecs.pc2.core.report.UserdataTSVReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class AllReports
implements IReport {
    private static final long serialVersionUID = 7194244117875846407L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    public IReport[] getAllReports() {
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new AccountsReport());
        reports.add(new BalloonSummaryReport());
        reports.add(new ContestSettingsReport());
        reports.add(new ContestReport());
        reports.add(new ContestAnalysisReport());
        reports.add(new SolutionsByProblemReport());
        reports.add(new ListRunLanguages());
        reports.add(new FastestSolvedSummaryReport());
        reports.add(new FastestSolvedReport());
        reports.add(new StandingsReport());
        reports.add(new LoginReport());
        reports.add(new ProfilesReport());
        reports.add(new PluginsReport());
        reports.add(new RunsReport());
        reports.add(new ClarificationsReport());
        reports.add(new ProblemsReport());
        reports.add(new LanguagesReport());
        reports.add(new JudgementReport());
        reports.add(new RunsByTeamReport());
        reports.add(new BalloonSettingsReport());
        reports.add(new ClientSettingsReport());
        reports.add(new GroupsReport());
        reports.add(new EvaluationReport());
        reports.add(new OldRunsReport());
        reports.add(new RunsReport5());
        reports.add(new AccountPermissionReport());
        reports.add(new BalloonDeliveryReport());
        reports.add(new ExtractPlaybackLoadFilesReport());
        reports.add(new RunJudgementNotificationsReport());
        reports.add(new JudgementNotificationsReport());
        reports.add(new ProfileCloneSettingsReport());
        reports.add(new SitesReport());
        reports.add(new FinalizeReport());
        reports.add(new ExportYamlReport());
        reports.add(new InternalDumpReport());
        reports.add(new HTMLReport());
        reports.add(new CategoryReport());
        reports.add(new RunStatisticsReport());
        reports.add(new PlaybackDumpReport());
        reports.add(new AccountsTSVReportTeamAndJudges());
        reports.add(new AccountsTSVReport());
        reports.add(new SubmissionsTSVReport());
        reports.add(new JSONReport());
        reports.add(new EventFeed2013Report());
        reports.add(new UserdataTSVReport());
        reports.add(new GroupsTSVReport());
        reports.add(new TeamsTSVReport());
        reports.add(new ScoreboardTSVReport());
        IReport[] listOfReports = reports.toArray(new IReport[reports.size()]);
        Arrays.sort(listOfReports, new ReportNameByComparator());
        return listOfReports;
    }

    private IReport[] getXMLReports() {
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new ContestReport());
        reports.add(new StandingsReport());
        IReport[] listOfReports = reports.toArray(new IReport[reports.size()]);
        Arrays.sort(listOfReports, new ReportNameByComparator());
        return listOfReports;
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        IReport report;
        IReport[] reports;
        IReport[] iReportArray = reports = this.getAllReports();
        int n = reports.length;
        int n2 = 0;
        while (n2 < n) {
            report = iReportArray[n2];
            try {
                if (report != null) {
                    report.setContestAndController(this.contest, this.controller);
                    printWriter.println("**** " + report.getReportTitle() + " Report");
                    report.writeReport(printWriter);
                    printWriter.println();
                }
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            ++n2;
        }
        iReportArray = reports = this.getXMLReports();
        n = reports.length;
        n2 = 0;
        while (n2 < n) {
            report = iReportArray[n2];
            try {
                if (report != null) {
                    report.setContestAndController(this.contest, this.controller);
                    printWriter.println("**** " + report.getReportTitle() + " Report");
                    printWriter.println();
                    String xmlString = report.createReportXML(this.filter);
                    printWriter.println("-- Start XML --");
                    printWriter.println(xmlString);
                    printWriter.println();
                    printWriter.println("-- End XML --");
                    printWriter.println();
                }
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println("On: " + Utilities.getL10nDateTime());
        printWriter.println();
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end " + this.getReportTitle() + " report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "All Reports";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "All Reports Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

