/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.Submission;
import edu.csus.ecs.pc2.core.model.playback.EventStatus;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;

public class PlaybackRecord
implements IElementObject {
    private static final long serialVersionUID = -63147005376962233L;
    private ElementId elementId = null;
    private int sequenceNumber = 0;
    private ReplayEvent replayEvent;
    private EventStatus eventStatus = EventStatus.INVALID;

    public PlaybackRecord(ReplayEvent replayEvent, int sequenceNumber) {
        this.replayEvent = replayEvent;
        this.sequenceNumber = sequenceNumber;
        this.reset();
    }

    public void setEventStatus(EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ReplayEvent getReplayEvent() {
        return this.replayEvent;
    }

    public EventStatus getEventStatus() {
        return this.eventStatus;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public ReplayEvent.EventType getEventType() {
        return this.replayEvent.getEventType();
    }

    public int getId() {
        Submission submission = this.replayEvent.getEventDetails().getSubmission();
        if (submission != null) {
            return submission.getNumber();
        }
        return 0;
    }

    public void reset() {
        if (this.replayEvent != null) {
            this.eventStatus = EventStatus.PENDING;
        }
    }
}

