/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IGetDate;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import java.util.Date;

public class RunTestCase
implements IElementObject,
IGetDate {
    private static final long serialVersionUID = -9160568142729051113L;
    private boolean active = true;
    public static final String TESTCASE_RECORD_ID = "TestCase";
    private ElementId elementId = new ElementId("TestCase");
    private ElementId runElementId;
    private ElementId judgementId;
    private int testNumber;
    private boolean passed = false;
    private long elapsedMS;
    private long time = new Date().getTime();

    public RunTestCase(Run run, JudgementRecord record, int testNumber, boolean passed) {
        this.runElementId = run.getElementId();
        this.judgementId = record.getJudgementId();
        this.testNumber = testNumber;
        this.passed = passed;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public boolean matchesJudgement(JudgementRecord judgementRecord) {
        if (judgementRecord == null) {
            return false;
        }
        return this.judgementId.equals(judgementRecord.getJudgementId());
    }

    public boolean isPassed() {
        return this.passed;
    }

    public ElementId getRunElementId() {
        return this.runElementId;
    }

    public long getElapsedMins() {
        return this.elapsedMS / 60000L;
    }

    public void setElapsedMS(long elapsedMS) {
        this.elapsedMS = elapsedMS;
    }

    public long getElapsedMS() {
        return this.elapsedMS;
    }

    @Override
    public Date getDate() {
        return new Date(this.time);
    }

    @Override
    public void setDate(Date date) {
        this.time = 0L;
        if (date != null) {
            this.time = date.getTime();
        }
    }

    public ElementId getJudgementId() {
        return this.judgementId;
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "[Test Case: ";
        ret = String.valueOf(ret) + "num=" + this.testNumber + ", ";
        ret = String.valueOf(ret) + "passed=" + this.passed + ", ";
        ret = String.valueOf(ret) + "time(ms)=" + this.elapsedMS + "]";
        return ret;
    }
}

