/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;

public class Profile
implements IElementObject,
Serializable {
    private String name;
    private String description = "";
    private Date createDate = new Date();
    private ElementId elementId = null;
    private String profilePath = null;
    private String contestId = null;
    private Properties properties = new Properties();
    private static final long serialVersionUID = -8261748390647739218L;
    private boolean active = true;

    private Profile() {
    }

    public Profile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Profile name must not be null");
        }
        this.elementId = new ElementId(new String(name));
        this.setProfilePath(this.createProfilePath(""));
        this.name = name;
        this.setContestId(this.toString());
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String getContestId() {
        return this.contestId;
    }

    public void setContestId(String contestId) {
        this.contestId = contestId;
    }

    public String toString() {
        return this.elementId.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean matchesIdentifier(String identifier) {
        return this.toString().equals(identifier);
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    private String createProfilePath(String basepath, Profile newProfile) {
        if (basepath == null || basepath.trim().length() == 0) {
            basepath = "";
        } else if (basepath.substring(basepath.length() - 1).equals(File.separator)) {
            basepath = String.valueOf(basepath) + File.separator;
        }
        return String.valueOf(basepath) + "profiles" + File.separator + "P" + UUID.randomUUID().toString();
    }

    public String createProfilePath(String basepath) {
        return this.createProfilePath(basepath, this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ElementId) {
            ElementId otherId = (ElementId)obj;
            return otherId.equals(this.elementId);
        }
        if (obj instanceof Profile) {
            Profile otherProfile = (Profile)obj;
            return this.elementId.equals(otherProfile.getElementId());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean isSameAs(Profile profile) {
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (profile != null) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    if (this.stringSame(this.name, profile.getName())) break block7;
                    return false;
                }
                if (this.stringSame(this.description, profile.getDescription())) break block8;
                return false;
            }
            if (this.stringSame(this.profilePath, profile.getProfilePath())) break block9;
            return false;
        }
        return profile.isActive() == this.active;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }
}

