/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.TestCaseFileNameCollection;
import edu.csus.ecs.pc2.core.model.TestCaseFileNameSet;

public class ProblemNew
extends Problem {
    private static final long serialVersionUID = 1L;
    private TestCaseFileNameCollection testCases = new TestCaseFileNameCollection();

    public ProblemNew(String displayName) {
        super(displayName);
    }

    @Override
    public ProblemNew copy(String newDisplayName) {
        ProblemNew clone = new ProblemNew(newDisplayName);
        clone.setAnswerFileName(StringUtilities.cloneString(super.getAnswerFileName()));
        clone.setColorName(StringUtilities.cloneString(super.getColorName()));
        clone.setColorRGB(StringUtilities.cloneString(super.getColorRGB()));
        clone.setDataFileName(StringUtilities.cloneString(super.getDataFileName()));
        clone.setDisplayName(StringUtilities.cloneString(super.getDisplayName()));
        clone.setExecutionPrepCommand(StringUtilities.cloneString(super.getExecutionPrepCommand()));
        clone.setExternalDataFileLocation(super.getExternalDataFileLocation());
        clone.setLetter(StringUtilities.cloneString(super.getLetter()));
        clone.setNumber(super.getNumber());
        clone.setShortName(StringUtilities.cloneString(super.getShortName()));
        clone.setSiteNumber(super.getSiteNumber());
        clone.setState(super.getState());
        clone.setTimeOutInSeconds(super.getTimeOutInSeconds());
        clone.setValidatorCommandLine(StringUtilities.cloneString(super.getValidatorCommandLine()));
        clone.setValidatorProgramName(StringUtilities.cloneString(super.getValidatorProgramName()));
        clone.setWhichPC2Validator(super.getWhichPC2Validator());
        clone.setActive(super.isActive());
        clone.setCcsMode(super.isCcsMode());
        clone.setComputerJudged(super.isComputerJudged());
        clone.setHideOutputWindow(super.isHideOutputWindow());
        clone.setIgnoreSpacesOnValidation(super.isIgnoreSpacesOnValidation());
        clone.setInternationalJudgementReadMethod(super.isInternationalJudgementReadMethod());
        clone.setManualReview(super.isManualReview());
        clone.setPrelimaryNotification(super.isPrelimaryNotification());
        clone.setReadInputDataFromSTDIN(super.isReadInputDataFromSTDIN());
        clone.setShowCompareWindow(super.isShowCompareWindow());
        clone.setShowValidationToJudges(super.isShowValidationToJudges());
        clone.setUsingExternalDataFiles(super.isUsingExternalDataFiles());
        clone.setUsingPC2Validator(super.isUsingPC2Validator());
        clone.setValidatedProblem(super.isValidatedProblem());
        clone.setTestCaseFiles(this.testCases.clone());
        clone.setInternationalJudgementReadMethod(this.isInternationalJudgementReadMethod());
        return clone;
    }

    private void setTestCaseFiles(TestCaseFileNameCollection theTestCases) {
        this.testCases = theTestCases;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProblemNew) {
            ProblemNew otherProblem = (ProblemNew)obj;
            return this.getElementId().equals(otherProblem.getElementId());
        }
        throw new ClassCastException("expected a Problem found: " + obj.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.getElementId().toString().hashCode();
    }

    @Override
    public String getAnswerFileName(int testCaseNumber) {
        if (testCaseNumber < 1) {
            StaticLog.getLog().log(Log.WARNING, "Problem.getAnswerFileName(): illegal test case number: " + testCaseNumber + " (must be >= 1)");
            return null;
        }
        for (TestCaseFileNameSet tc : this.testCases) {
            if (tc.getTestCaseNum() != testCaseNumber) continue;
            return tc.getAnswerFileName();
        }
        return null;
    }

    @Override
    public String getDataFileName(int testCaseNumber) {
        if (testCaseNumber < 1) {
            StaticLog.getLog().log(Log.WARNING, "Problem.getDataFileName(): illegal test case number: " + testCaseNumber + " (must be >= 1)");
            return null;
        }
        for (TestCaseFileNameSet tc : this.testCases) {
            if (tc.getTestCaseNum() != testCaseNumber) continue;
            return tc.getDataFileName();
        }
        return null;
    }

    @Override
    public boolean isSameAs(Problem problem) {
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                block33: {
                                                                    block32: {
                                                                        block31: {
                                                                            block30: {
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                block25: {
                                                                                                    try {
                                                                                                        if (problem != null) break block25;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        StaticLog.getLog().log(Log.WARNING, "Exception comparing Problem " + e.getMessage(), e);
                                                                                                        e.printStackTrace(System.err);
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (problem instanceof ProblemNew) break block26;
                                                                                                return false;
                                                                                            }
                                                                                            if (StringUtilities.stringSame(this.getDisplayName(), problem.getDisplayName())) break block27;
                                                                                            return false;
                                                                                        }
                                                                                        if (this.isActive() == problem.isActive()) break block28;
                                                                                        return false;
                                                                                    }
                                                                                    if (this.getTimeOutInSeconds() == problem.getTimeOutInSeconds()) break block29;
                                                                                    return false;
                                                                                }
                                                                                if (StringUtilities.stringSame(this.getDataFileName(), problem.getDataFileName())) break block30;
                                                                                return false;
                                                                            }
                                                                            if (StringUtilities.stringSame(this.getAnswerFileName(), problem.getAnswerFileName())) break block31;
                                                                            return false;
                                                                        }
                                                                        if (this.isReadInputDataFromSTDIN() == problem.isReadInputDataFromSTDIN()) break block32;
                                                                        return false;
                                                                    }
                                                                    if (this.isValidatedProblem() == problem.isValidatedProblem()) break block33;
                                                                    return false;
                                                                }
                                                                if (this.isUsingPC2Validator() == problem.isUsingPC2Validator()) break block34;
                                                                return false;
                                                            }
                                                            if (this.getWhichPC2Validator() == problem.getWhichPC2Validator()) break block35;
                                                            return false;
                                                        }
                                                        if (StringUtilities.stringSame(this.getValidatorProgramName(), problem.getValidatorProgramName())) break block36;
                                                        return false;
                                                    }
                                                    if (StringUtilities.stringSame(this.getValidatorCommandLine(), problem.getValidatorCommandLine())) break block37;
                                                    return false;
                                                }
                                                if (this.isIgnoreSpacesOnValidation() == problem.isIgnoreSpacesOnValidation()) break block38;
                                                return false;
                                            }
                                            if (this.isShowValidationToJudges() == problem.isShowValidationToJudges()) break block39;
                                            return false;
                                        }
                                        if (this.isHideOutputWindow() == problem.isHideOutputWindow()) break block40;
                                        return false;
                                    }
                                    if (this.isShowCompareWindow() == problem.isShowCompareWindow()) break block41;
                                    return false;
                                }
                                if (this.isComputerJudged() == problem.isComputerJudged()) break block42;
                                return false;
                            }
                            if (this.isManualReview() == problem.isManualReview()) break block43;
                            return false;
                        }
                        if (this.isPrelimaryNotification() == problem.isPrelimaryNotification()) break block44;
                        return false;
                    }
                    if (this.getSiteNumber() == problem.getSiteNumber()) break block45;
                    return false;
                }
                if (StringUtilities.stringSame(this.getShortName(), problem.getShortName())) break block46;
                return false;
            }
            if (StringUtilities.stringSame(this.getExternalDataFileLocation(), problem.getExternalDataFileLocation())) break block47;
            return false;
        }
        return this.isUsingExternalDataFiles() == problem.isUsingExternalDataFiles();
    }

    public boolean addTestCaseFileNames(int testCaseNum, String datafile, String answerfile) {
        TestCaseFileNameSet tc2;
        if (testCaseNum < 1) {
            return false;
        }
        for (TestCaseFileNameSet tc2 : this.testCases) {
            if (tc2.getTestCaseNum() != testCaseNum) continue;
            StaticLog.getLog().log(Log.WARNING, "Problem.addTestCaseFileNames(): illegal attempt to add existing test case number: " + testCaseNum);
            return false;
        }
        tc2 = new TestCaseFileNameSet();
        tc2.setTestCaseNum(testCaseNum);
        tc2.setDataFileName(StringUtilities.cloneString(datafile));
        tc2.setAnswerFileName(StringUtilities.cloneString(answerfile));
        return this.testCases.add(tc2);
    }

    public void removeAllTestCaseFileNames() {
        this.testCases = new TestCaseFileNameCollection();
    }

    @Override
    public int getNumberTestCases() {
        return this.testCases.size();
    }
}

