/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Vector;

public final class DataLoader {
    private DataLoader() {
    }

    public static void loadDataSets(ProblemDataFiles files, String directoryName, boolean externalFiles) throws FileNotFoundException {
        DataLoader.loadDataSets(files, directoryName, externalFiles, "in", "ans");
    }

    public static void loadDataSets(ProblemDataFiles files, String directoryName, boolean externalFiles, String dataExtension, String answerFileExtension) throws FileNotFoundException {
        String[] datafiles = DataLoader.getFileNames(directoryName, dataExtension);
        if (datafiles.length == 0) {
            throw new FileNotFoundException("No files found " + directoryName + " ext = " + dataExtension);
        }
        String[] stringArray = datafiles;
        int n = datafiles.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String fullName = String.valueOf(directoryName) + File.separator + name;
            String fullAnsName = DataLoader.replaceExtension(fullName, dataExtension, answerFileExtension);
            if (!new File(fullAnsName).isFile()) {
                throw new FileNotFoundException("Expecting - ans file " + fullAnsName);
            }
            ++n2;
        }
        SerializedFile[] dataFilelist = new SerializedFile[datafiles.length];
        SerializedFile[] answerFilelist = new SerializedFile[datafiles.length];
        int idx = 0;
        String[] stringArray2 = datafiles;
        int n3 = datafiles.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            String fullName = String.valueOf(directoryName) + File.separator + name;
            String fullAnsName = DataLoader.replaceExtension(fullName, dataExtension, answerFileExtension);
            SerializedFile dataFile = new SerializedFile(fullName, externalFiles);
            SerializedFile ansFile = new SerializedFile(fullAnsName, externalFiles);
            dataFilelist[idx] = dataFile;
            answerFilelist[idx] = ansFile;
            ++idx;
            ++n4;
        }
        files.setJudgesDataFiles(dataFilelist);
        files.setJudgesAnswerFiles(answerFilelist);
    }

    private static String replaceExtension(String fullName, String dataExtension, String answerFileExtension) {
        return fullName.replaceFirst(String.valueOf(dataExtension) + "$", answerFileExtension);
    }

    public static String[] getFileNames(String directoryName, String extension) {
        Vector<Object> list = new Vector<Object>();
        File dir = new File(directoryName);
        Object[] entries = dir.list();
        if (entries == null) {
            return new String[0];
        }
        Arrays.sort(entries);
        Object[] objectArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            if (((String)name).endsWith(extension)) {
                list.addElement(name);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }
}

