/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ContestTime
implements IElementObject {
    public static final long serialVersionUID = 6967329985187819728L;
    public static final long MS_PER_SECONDS = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long DEFAULT_CONTEST_LENGTH_SECONDS = 18000L;
    private GregorianCalendar resumeTime = null;
    private GregorianCalendar contestStartTime = null;
    private GregorianCalendar serverTransmitTime = null;
    private long localClockOffset = 0L;
    private boolean haltContestAtTimeZero = false;
    private long elapsedSecs = 0L;
    private long elapsedMS = 0L;
    private long contestLengthSecs = 18000L;
    private boolean contestRunning = false;
    private int siteNumber;
    private ElementId elementId;

    public ContestTime() {
        this("Contest Time");
    }

    public ContestTime(int siteNumber) {
        this("Contest Time Site " + siteNumber);
        this.siteNumber = siteNumber;
    }

    private ContestTime(String idString) {
        this.elementId = new ElementId(idString);
    }

    public long getConestLengthMins() {
        return this.contestLengthSecs / 60L;
    }

    public String getContestLengthStr() {
        return ContestTime.formatTime(this.contestLengthSecs);
    }

    public boolean isContestRunning() {
        return this.contestRunning;
    }

    public String getElapsedTimeStr() {
        return ContestTime.formatTime(this.getElapsedSecs());
    }

    public String getRemainingTimeStr() {
        return ContestTime.formatTime(this.getRemainingSecs());
    }

    public String getRemainingMinStr() {
        String timeStr = ContestTime.formatTime(this.getRemainingSecs());
        int lastIndex = timeStr.lastIndexOf(":");
        if (lastIndex != -1) {
            return timeStr.substring(0, lastIndex);
        }
        return timeStr;
    }

    public static String formatTime(long seconds) {
        boolean negative;
        boolean bl = negative = seconds < 0L;
        if (negative) {
            seconds *= -1L;
        }
        long hours = seconds / 3600L;
        long mins = seconds / 60L % 60L;
        long secs = seconds % 60L;
        String hourStr = new Long(hours).toString();
        String minStr = new Long(mins).toString();
        if (mins < 10L) {
            minStr = String.valueOf('0') + minStr;
        }
        String secStr = new Long(secs).toString();
        if (secs < 10L) {
            secStr = String.valueOf('0') + secStr;
        }
        if (negative) {
            hourStr = "-" + hourStr;
        }
        return String.valueOf(hourStr) + ':' + minStr + ':' + secStr;
    }

    public long getContestLengthSecs() {
        return this.contestLengthSecs;
    }

    public long getContestLengthMS() {
        return this.contestLengthSecs * 1000L;
    }

    public long getElapsedMins() {
        return this.getElapsedSecs() / 60L;
    }

    public long getElapsedSecs() {
        return this.elapsedSecs + this.secsSinceContestStart();
    }

    public long getElapsedMS() {
        return this.elapsedMS + this.msSinceContestStart();
    }

    public long getElapsedTime() {
        return this.getElapsedMins();
    }

    public long getRemainingSecs() {
        return this.contestLengthSecs - (this.elapsedSecs + this.secsSinceContestStart());
    }

    public boolean isHaltContestAtTimeZero() {
        return this.haltContestAtTimeZero;
    }

    public boolean isPastEndOfContest() {
        return this.getRemainingSecs() <= 0L;
    }

    public String remTimeStr() {
        long secsLeft = this.getRemainingSecs();
        return ContestTime.formatTime(secsLeft);
    }

    private long secsSinceContestStart() {
        if (this.contestRunning) {
            long milliDiff = this.msSinceContestStart();
            long totalSeconds = milliDiff / 1000L;
            return totalSeconds;
        }
        return 0L;
    }

    private long msSinceContestStart() {
        if (this.contestRunning) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            GregorianCalendar cal = new GregorianCalendar(tz);
            long milliDiff = cal.getTime().getTime() - this.resumeTime.getTime().getTime();
            return milliDiff;
        }
        return 0L;
    }

    public void setContestLengthSecs(long newSecs) {
        this.contestLengthSecs = newSecs;
    }

    public void setElapsedMins(long minutes) {
        this.setElapsedSecs(minutes * 60L);
    }

    public void setElapsedSecs(long eSecs) {
        this.elapsedSecs = eSecs;
        this.elapsedMS = eSecs * 1000L;
    }

    public void setHaltContestAtTimeZero(boolean newHaltContestAtTimeZero) {
        this.haltContestAtTimeZero = newHaltContestAtTimeZero;
    }

    public void setRemainingSecs(long remSecs) {
        this.setElapsedSecs(this.contestLengthSecs - remSecs);
    }

    public void forceContestStartTimeResync() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.resumeTime = new GregorianCalendar(tz);
    }

    public void startContestClock() {
        if (this.contestStartTime == null) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            this.contestStartTime = new GregorianCalendar(tz);
        }
        if (!this.contestRunning) {
            this.forceContestStartTimeResync();
            this.contestRunning = true;
        }
    }

    public void stopContestClock() {
        if (this.contestRunning) {
            this.elapsedSecs += this.secsSinceContestStart();
            this.elapsedMS += this.msSinceContestStart();
            this.contestRunning = false;
        }
    }

    public GregorianCalendar getResumeTime() {
        return this.resumeTime;
    }

    public void setResumeTime(GregorianCalendar startTime) {
        this.resumeTime = startTime;
    }

    public long convertStringToLong(String intTime) {
        StringTokenizer stringTokenizer = new StringTokenizer(intTime, ":");
        String s1 = stringTokenizer.nextToken();
        String s2 = stringTokenizer.nextToken();
        String s3 = stringTokenizer.nextToken();
        long hh = Long.parseLong(s1);
        long mm = Long.parseLong(s2);
        long ss = Long.parseLong(s3);
        long totalSeconds = 0L;
        if (hh != -1L) {
            totalSeconds = hh;
        }
        if (mm != -1L) {
            totalSeconds = totalSeconds * 60L + mm;
        }
        if (ss != -1L) {
            totalSeconds = totalSeconds * 60L + ss;
        }
        if (hh == -1L || mm == -1L || ss == -1L) {
            return -1L;
        }
        return totalSeconds;
    }

    public long getLocalClockOffset() {
        return this.localClockOffset;
    }

    public void setLocalClockOffset(long localClockOffset) {
        this.localClockOffset = localClockOffset;
    }

    public GregorianCalendar getServerTransmitTime() {
        return this.serverTransmitTime;
    }

    public void setServerTransmitTime() {
        GregorianCalendar gregorianCalendar;
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.serverTransmitTime = gregorianCalendar = new GregorianCalendar(timeZone);
    }

    public void calculateLocalClockOffset() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.calculateLocalClockOffset(gregorianCalendar);
    }

    public void calculateLocalClockOffset(GregorianCalendar localClock) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        long milliDiff = gregorianCalendar.getTime().getTime() - localClock.getTime().getTime();
        this.localClockOffset = milliDiff / 1000L;
        if (this.resumeTime != null) {
            this.resumeTime.setTimeInMillis(this.resumeTime.getTimeInMillis() + milliDiff);
        }
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    public void resetClock() {
        this.resumeTime = null;
        this.serverTransmitTime = null;
        this.localClockOffset = 0L;
        this.setElapsedSecs(0L);
        this.contestRunning = false;
    }

    public Calendar getContestStartTime() {
        return this.contestStartTime;
    }

    public long getRemainingMS() {
        return this.getContestLengthMS() - this.getElapsedMS();
    }
}

