/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Site;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class BalloonSettings
implements IElementObject {
    public static final String MAIL_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_HOST = "mail.host";
    private static final String DEFAULT_MAIL_FROM = "nobody@ecs.csus.edu";
    private Hashtable<ElementId, String> colorList = new Hashtable();
    private Hashtable<ElementId, String> colorListRGB = new Hashtable();
    private static final long serialVersionUID = 4208771943370594478L;
    private static final int DEFAULT_PORT_SMTPS = 465;
    private static final int DEFAULT_PORT_SMTP = 25;
    public static final String MAIL_USER = "mail.user";
    public static final String MAIL_PASSWORD = "mail.user.password";
    public static final Object MAIL_FROM = "mail.from";
    private ElementId elementId;
    private String emailContact = "";
    private String printDevice = "";
    private boolean postscriptCapable = false;
    private String mailServer = "";
    private boolean includeNos = false;
    private boolean emailBalloons = false;
    private boolean printBalloons = false;
    private boolean balloonsEnabled = false;
    private int linesPerPage = 66;
    private ClientId balloonClient = null;
    private Properties mailProperties = null;

    public BalloonSettings(String displayName, int siteNumber) {
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(siteNumber);
        this.mailProperties = BalloonSettings.getDefaultMailProperties();
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public boolean isEmailBalloons() {
        return this.emailBalloons;
    }

    public void setEmailBalloons(boolean emailBalloons) {
        this.emailBalloons = emailBalloons;
        this.setBalloonsEnabled(this.isEmailBalloons() | this.isPrintBalloons());
    }

    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String emailContact) {
        this.emailContact = emailContact;
    }

    public boolean isIncludeNos() {
        return this.includeNos;
    }

    public void setIncludeNos(boolean includeNos) {
        this.includeNos = includeNos;
    }

    public static Properties getDefaultMailProperties() {
        Properties defaultProperties = new Properties();
        defaultProperties.put("mail.debug", Boolean.toString(false));
        defaultProperties.put(MAIL_HOST, "");
        defaultProperties.put(MAIL_USER, "");
        defaultProperties.put(MAIL_PASSWORD, "");
        defaultProperties.put(MAIL_PROTOCOL, "smtp");
        defaultProperties.put("mail.smtp.auth", Boolean.toString(false));
        defaultProperties.put("mail.smtp.port", Integer.toString(25));
        defaultProperties.put("mail.smtp.starttls.enable", Boolean.toString(false));
        defaultProperties.put("mail.smtps.auth", Boolean.toString(false));
        defaultProperties.put("mail.smtps.port", Integer.toString(465));
        defaultProperties.put(MAIL_FROM, DEFAULT_MAIL_FROM);
        defaultProperties.put("mail.smtp.ssl.trust", "*");
        defaultProperties.put("mail.smtps.ssl.trust", "*");
        return defaultProperties;
    }

    public Properties getMailProperties() {
        if (this.mailProperties == null) {
            this.mailProperties = BalloonSettings.getDefaultMailProperties();
        }
        return this.mailProperties;
    }

    public String getMailServer() {
        return (String)this.getMailProperties().get(MAIL_HOST);
    }

    public void setMailServer(String mailServer) {
        this.getMailProperties().put(MAIL_HOST, mailServer);
    }

    public boolean isPostscriptCapable() {
        return this.postscriptCapable;
    }

    public void setPostscriptCapable(boolean postscriptCapable) {
        this.postscriptCapable = postscriptCapable;
    }

    public boolean isPrintBalloons() {
        return this.printBalloons;
    }

    public void setPrintBalloons(boolean printBalloons) {
        this.printBalloons = printBalloons;
        this.setBalloonsEnabled(this.isEmailBalloons() | this.isPrintBalloons());
    }

    public String getPrintDevice() {
        return this.printDevice;
    }

    public void setPrintDevice(String printDevice) {
        this.printDevice = printDevice;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public void setLinesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
    }

    public String getColor(Problem problem) {
        return this.getColor(problem.getElementId());
    }

    public void addColorList(Problem[] problemList, String[] colors) {
        this.clearList();
        int i = 0;
        while (i < problemList.length) {
            this.addColor(problemList[i].getElementId(), colors[i]);
            ++i;
        }
    }

    private void clearList() {
        this.colorList = new Hashtable();
        this.colorListRGB = new Hashtable();
    }

    public void addColor(Problem problem, String colorName) {
        this.addColor(problem.getElementId(), colorName);
    }

    public void addColor(Problem problem, String colorName, String rgbColor) {
        this.addColor(problem.getElementId(), colorName, rgbColor);
    }

    private void addColor(ElementId id, String colorName) {
        this.colorList.put(id, colorName);
    }

    private void addColor(ElementId id, String colorName, String rgbColor) {
        this.colorList.put(id, colorName);
        this.colorListRGB.put(id, rgbColor);
    }

    public void updateColor(Problem problem, String colorName) {
        this.colorList.put(problem.getElementId(), colorName);
    }

    public String getColor(ElementId id) {
        return this.colorList.get(id);
    }

    protected ElementId[] getProblemIDList() {
        return this.colorList.keySet().toArray(new ElementId[this.colorList.keySet().size()]);
    }

    private boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameAs(BalloonSettings balloonSettings) {
        try {
            if (balloonSettings == null) {
                return false;
            }
            if (this.getSiteNumber() != balloonSettings.getSiteNumber()) {
                return false;
            }
            if (this.isEmailBalloons() != balloonSettings.isEmailBalloons()) {
                return false;
            }
            if (this.isPrintBalloons() != balloonSettings.isPrintBalloons()) {
                return false;
            }
            if (!this.stringSame(this.getPrintDevice(), balloonSettings.getPrintDevice())) {
                return false;
            }
            if (this.isPostscriptCapable() != balloonSettings.isPostscriptCapable()) {
                return false;
            }
            if (!this.stringSame(this.getEmailContact(), balloonSettings.getEmailContact())) {
                return false;
            }
            if (this.getLinesPerPage() != balloonSettings.getLinesPerPage()) {
                return false;
            }
            if (!this.mailProperties.equals(balloonSettings.getMailProperties())) {
                return false;
            }
            if (this.balloonClient == null) {
                if (balloonSettings.getBalloonClient() != null) {
                    return false;
                }
            } else {
                if (balloonSettings.getBalloonClient() == null) {
                    return false;
                }
                if (!this.balloonClient.equals(balloonSettings.getBalloonClient())) {
                    return false;
                }
            }
            if (balloonSettings.getProblemIDList().length != this.getProblemIDList().length) {
                return false;
            }
            ElementId[] elementIdArray = this.getProblemIDList();
            int n = elementIdArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                ElementId problemId = elementIdArray[n2];
                String colorName = this.getColor(problemId);
                if (colorName == null) {
                    return false;
                }
                if (!colorName.equals(balloonSettings.getColor(problemId))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isBalloonsEnabled() {
        return this.balloonsEnabled;
    }

    private void setBalloonsEnabled(boolean balloonsEnabled) {
        this.balloonsEnabled = balloonsEnabled;
    }

    public ClientId getBalloonClient() {
        return this.balloonClient;
    }

    public void setBalloonClient(ClientId balloonClient) {
        this.balloonClient = balloonClient;
    }

    public boolean isMatchesBalloonClient(ClientId clientId) {
        if (this.balloonClient == null) {
            return clientId == null;
        }
        if (clientId == null) {
            return false;
        }
        return this.balloonClient.equals(clientId);
    }

    public Object clone() throws CloneNotSupportedException {
        String[] keys;
        BalloonSettings clone = new BalloonSettings("foo", this.getSiteNumber());
        clone.elementId = this.elementId;
        clone.colorList = this.cloneColorList();
        clone.colorListRGB = this.cloneColorRGBList();
        clone.setBalloonClient(this.getBalloonClient());
        clone.setEmailBalloons(this.isEmailBalloons());
        clone.setEmailContact(new String(this.emailContact));
        clone.setIncludeNos(this.isIncludeNos());
        clone.setLinesPerPage(this.getLinesPerPage());
        clone.setMailServer(new String(this.mailServer));
        clone.setPostscriptCapable(this.isPostscriptCapable());
        clone.setPrintBalloons(this.isPrintBalloons());
        clone.setPrintDevice(new String(this.printDevice));
        Properties newMailProperties = new Properties();
        String[] stringArray = keys = this.mailProperties.keySet().toArray(new String[this.mailProperties.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            newMailProperties.put(key, new String((String)this.mailProperties.get(key)));
            ++n2;
        }
        clone.setMailProperties(newMailProperties);
        return clone;
    }

    private Hashtable<ElementId, String> cloneColorRGBList() {
        Hashtable<ElementId, String> newHash = new Hashtable<ElementId, String>();
        Enumeration<ElementId> elementList = this.colorListRGB.keys();
        while (elementList.hasMoreElements()) {
            ElementId key = elementList.nextElement();
            newHash.put(key, this.colorListRGB.get(key));
        }
        return newHash;
    }

    private Hashtable<ElementId, String> cloneColorList() {
        Hashtable<ElementId, String> newHash = new Hashtable<ElementId, String>();
        Enumeration<ElementId> elementList = this.colorList.keys();
        while (elementList.hasMoreElements()) {
            ElementId key = elementList.nextElement();
            newHash.put(key, this.colorList.get(key));
        }
        return newHash;
    }

    public BalloonSettings copy(Site newSite) {
        String[] keys;
        BalloonSettings clone = new BalloonSettings(newSite.getDisplayName(), newSite.getSiteNumber());
        clone.colorList = this.cloneColorList();
        clone.setBalloonClient(this.getBalloonClient());
        clone.setEmailBalloons(this.isEmailBalloons());
        clone.setEmailContact(new String(this.emailContact));
        clone.setIncludeNos(this.isIncludeNos());
        clone.setLinesPerPage(this.getLinesPerPage());
        clone.setMailServer(new String(this.mailServer));
        clone.setPostscriptCapable(this.isPostscriptCapable());
        clone.setPrintBalloons(this.isPrintBalloons());
        clone.setPrintDevice(new String(this.printDevice));
        Properties newMailProperties = new Properties();
        String[] stringArray = keys = this.mailProperties.keySet().toArray(new String[this.mailProperties.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            newMailProperties.put(key, new String((String)this.mailProperties.get(key)));
            ++n2;
        }
        clone.setMailProperties(newMailProperties);
        return clone;
    }

    public void setMailProperties(Properties newMailProperties) {
        this.mailProperties = newMailProperties;
        this.setMailServer((String)newMailProperties.get(MAIL_HOST));
    }

    public String getColorRGB(Problem problem) {
        return this.getColorRGB(problem.getElementId());
    }

    public String getColorRGB(ElementId id) {
        return this.colorListRGB.get(id);
    }
}

