/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.log.LogFormatter;
import edu.csus.ecs.pc2.core.log.LogStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log
extends Logger {
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level DEBUG = Level.FINEST;
    public static final Level FINEST = Level.FINEST;
    public static final String LOG_DIRECTORY_NAME = "logs";
    private LogStreamHandler streamHandler = null;
    private Handler consoleHandler = null;
    private Handler fileHandler = null;
    private String logfilename = null;

    public Log(String logFileName) {
        this("edu.ecs.csus.pc2", null, LOG_DIRECTORY_NAME, logFileName);
    }

    public Log(String directoryName, String logFileName) {
        this("edu.ecs.csus.pc2", null, directoryName, logFileName);
    }

    public Log(String name, String resourceBundleName, String logDirectory, String logFilename) {
        super(name, resourceBundleName);
        this.setLevel(Level.ALL);
        this.setFileHandlers(logDirectory, logFilename);
    }

    public void setFileHandlers(String logDirBase, String baseFileName) {
        if (baseFileName.endsWith(".log")) {
            baseFileName = baseFileName.substring(0, baseFileName.length() - 4);
        }
        Handler[] existingHandlers = this.getHandlers();
        try {
            File file = new File(logDirBase);
            if (!file.exists()) {
                file.mkdir();
            }
            this.logfilename = String.valueOf(logDirBase) + File.separator + baseFileName + "-%u.log";
            this.fileHandler = new FileHandler(this.logfilename, true);
            this.fileHandler.setLevel(Level.ALL);
            this.fileHandler.setFormatter(new LogFormatter(true));
            this.addHandler(this.fileHandler);
            if (this.streamHandler == null) {
                this.streamHandler = new LogStreamHandler();
                this.streamHandler.setFormatter(new LogFormatter(false));
                this.streamHandler.setLevel(Level.ALL);
                this.addHandler(this.streamHandler);
            }
        }
        catch (IOException e) {
            System.err.println("IOexception in setFileHandlers " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("exception in setFileHandlers " + e.getMessage());
            e.printStackTrace();
        }
        Handler[] handlerArray = existingHandlers;
        int n = existingHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof FileHandler) {
                handler.close();
                this.removeHandler(handler);
            }
            ++n2;
        }
        String location = logDirBase;
        try {
            location = new File(logDirBase).getCanonicalPath();
        }
        catch (IOException e) {
            this.info("Unable to getCanonicalPath of " + logDirBase + ":" + e.getMessage());
        }
        this.config("Now logging to " + location + " directory.");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws Throwable {
        Handler[] handlers = this.getHandlers();
        this.closeHandlers(handlers);
    }

    private void closeHandlers(Handler[] existingHandlers) {
        if (existingHandlers != null) {
            int i = 0;
            while (i < existingHandlers.length) {
                if (existingHandlers[i] != null) {
                    this.removeHandler(existingHandlers[i]);
                    existingHandlers[i].close();
                }
                ++i;
            }
        }
    }

    public LogStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    public void startConsoleLogger() {
        if (this.consoleHandler == null) {
            this.consoleHandler = new ConsoleHandler();
        }
        this.addHandler(this.consoleHandler);
    }

    public void stopConsoleLogger() {
        if (this.consoleHandler != null) {
            this.removeHandler(this.consoleHandler);
            this.consoleHandler.close();
            this.consoleHandler = null;
        }
    }

    public Logger getLogger() {
        return this;
    }

    public String getLogfilename() {
        return this.logfilename;
    }
}

