/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.export;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class ExportYAML {
    public static final String CONTEST_FILENAME = "contest.yaml";
    public static final String PROBLEM_SET_FILENAME = "problemset.yaml";
    public static final String PROBLEM_FILENAME = "problem.yaml";
    private static final String PAD4 = "    ";
    private static final String PAD2 = "  ";
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss z";
    private SimpleDateFormat formatter = new SimpleDateFormat(this.dateTimeFormat);

    public void exportFiles(String directoryName, IInternalContest contest) throws IOException {
        String contestFileName = CONTEST_FILENAME;
        if (directoryName != null && directoryName.length() != 0) {
            contestFileName = String.valueOf(directoryName) + File.separator + contestFileName;
        }
        this.writeContestYAMLFiles(contest, directoryName, contestFileName);
    }

    private String getDateTimeString() {
        return this.formatter.format(new Date());
    }

    public void writeContestYAMLFiles(IInternalContest contest, String directoryName, String contestFileName) throws IOException {
        PlaybackInfo[] clientSettings2;
        Object shortName2;
        Object runnerArguments;
        Language[] languages;
        int n;
        PrintWriter contestWriter = new PrintWriter(new FileOutputStream(contestFileName, false), true);
        contestWriter.println("# Contest Configuration, version 1.0 ");
        contestWriter.println("# PC^2 Version: " + new VersionInfo().getSystemVersionInfo());
        contestWriter.println("# Created: " + this.getDateTimeString());
        contestWriter.println("--- ");
        contestWriter.println();
        ContestInformation info = contest.getContestInformation();
        contestWriter.println("name: " + this.quote(info.getContestTitle()));
        contestWriter.println("short-name: " + this.quote(info.getContestShortName()));
        ContestTime contestTime = contest.getContestTime();
        if (contestTime == null) {
            contestTime = new ContestTime();
            contest.addContestTime(contestTime);
        }
        contestWriter.println("elapsed: " + contestTime.getElapsedTimeStr());
        contestWriter.println("remaining: " + contestTime.getRemainingTimeStr());
        contestWriter.println("running: " + contestTime.isContestRunning());
        if (info.getStartDate() == null) {
            info.setStartDate(new Date());
        }
        contestWriter.println("start-time: " + this.formatDate(info.getStartDate()));
        contestWriter.println("elapsed: " + contestTime.getContestLengthStr());
        contestWriter.println("scoreboard-freeze: " + info.getFreezeTime());
        contestWriter.println("# load-data-files: false");
        String judgeCDPBasePath = info.getJudgeCDPBasePath();
        if (!StringUtilities.isEmpty(judgeCDPBasePath)) {
            contestWriter.println("judge-config-path: " + judgeCDPBasePath);
        }
        contestWriter.println();
        contestWriter.println("default-clars:");
        contestWriter.println("  - " + info.getJudgesDefaultAnswer());
        contestWriter.println();
        Category[] categories = contest.getCategories();
        if (categories.length > 0) {
            contestWriter.println("clar-categories:");
            Category[] categoryArray = categories;
            n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                Category category = categoryArray[n2];
                contestWriter.println("  - " + category.getDisplayName());
                ++n2;
            }
            contestWriter.println();
        }
        if ((languages = contest.getLanguages()).length > 0) {
            contestWriter.println("languages:");
        }
        Language[] languageArray = languages;
        int n3 = languages.length;
        n = 0;
        while (n < n3) {
            Language language = languageArray[n];
            contestWriter.println("  - name: " + this.quote(language.getDisplayName()));
            contestWriter.println("    active: " + language.isActive());
            contestWriter.println("    compilerCmd: " + this.quote(language.getCompileCommandLine()));
            contestWriter.println("    exemask: " + this.quote(language.getExecutableIdentifierMask()));
            contestWriter.println("    execCmd: " + this.quote(language.getProgramExecuteCommandLine()));
            String runner = this.getRunner(language.getProgramExecuteCommandLine());
            runnerArguments = this.getRunnerArguments(language.getProgramExecuteCommandLine());
            if (runner != null) {
                contestWriter.println("    runner: " + this.quote(runner));
                contestWriter.println("    runner-args: " + this.quote((String)runnerArguments));
            }
            contestWriter.println("    interpreted: " + language.isInterpreted());
            contestWriter.println("    use-judge-cmd: " + language.isUsingJudgeProgramExecuteCommandLine());
            contestWriter.println("    judge-exec-cmd: " + this.quote(language.getJudgeProgramExecuteCommandLine()));
            contestWriter.println();
            ++n;
        }
        Problem[] problems = contest.getProblems();
        if (problems.length > 0) {
            contestWriter.println("problemset:");
        }
        int id = 1;
        runnerArguments = problems;
        int runner = problems.length;
        int n4 = 0;
        while (n4 < runner) {
            Problem problem = runnerArguments[n4];
            String name = problem.getDisplayName();
            String letter = this.getProblemLetter(id);
            if (problem.getLetter() != null) {
                letter = problem.getLetter();
            }
            contestWriter.println("  - letter: " + letter);
            shortName2 = this.createProblemShortName(name);
            if (problem.getShortName() != null && problem.getShortName().trim().length() > 0) {
                shortName2 = problem.getShortName();
            }
            contestWriter.println("    short-name: " + (String)shortName2);
            contestWriter.println("    name: " + this.quote(name));
            String colorName = this.getProblemBalloonColor(contest, problem);
            if (colorName != null) {
                contestWriter.println("    color: " + colorName);
            }
            contestWriter.println("    load-data-files: " + !problem.isUsingExternalDataFiles());
            String[] filesWritten = this.writeProblemYAML(contest, directoryName, problem, (String)shortName2);
            if (filesWritten.length > 0) {
                contestWriter.println("#     " + filesWritten.length + " data files written");
                String[] stringArray = filesWritten;
                int n5 = filesWritten.length;
                int n6 = 0;
                while (n6 < n5) {
                    String filename = stringArray[n6];
                    contestWriter.println("#     wrote " + filename);
                    ++n6;
                }
            }
            ++id;
            contestWriter.println();
            ++n4;
        }
        Vector<Account> accountVector = contest.getAccounts(ClientType.Type.JUDGE);
        Account[] judgeAccounts = accountVector.toArray(new Account[accountVector.size()]);
        Arrays.sort(judgeAccounts, new AccountComparator());
        int ajCount = 0;
        shortName2 = judgeAccounts;
        int letter = judgeAccounts.length;
        int name = 0;
        while (name < letter) {
            Account account = shortName2[name];
            clientSettings2 = contest.getClientSettings(account.getClientId());
            if (clientSettings2 != null && (clientSettings2.isAutoJudging() || clientSettings2.getAutoJudgeFilter() != null)) {
                if (++ajCount == 1) {
                    contestWriter.println("auto-judging:");
                }
                ClientId clientId = account.getClientId();
                contestWriter.println("  - account: " + (Object)((Object)clientId.getClientType()));
                contestWriter.println("    site: " + clientId.getSiteNumber());
                contestWriter.println("    number: " + clientId.getClientNumber());
                contestWriter.println("    letters: " + this.getProblemLetters(contest, clientSettings2.getAutoJudgeFilter()));
                contestWriter.println("    enabled: " + Utilities.yesNoString(clientSettings2.isAutoJudging()).toLowerCase());
                contestWriter.println();
            }
            ++name;
        }
        PlaybackInfo[] playbackInfos = contest.getPlaybackInfos();
        if (playbackInfos.length > 0) {
            contestWriter.println("replay:");
            clientSettings2 = playbackInfos;
            int shortName2 = playbackInfos.length;
            letter = 0;
            while (letter < shortName2) {
                PlaybackInfo playbackInfo = clientSettings2[letter];
                contestWriter.println("  - title: " + playbackInfo.getDisplayName());
                contestWriter.println("        file: " + playbackInfo.getFilename());
                contestWriter.println("      auto_start: " + Utilities.yesNoString(playbackInfo.isStarted()).toLowerCase());
                contestWriter.println("       minevents: " + playbackInfo.getMinimumPlaybackRecords());
                contestWriter.println("    pacingMS: " + playbackInfo.getWaitBetweenEventsMS());
                contestWriter.println("        site: " + playbackInfo.getSiteNumber());
                contestWriter.println();
                ++letter;
            }
        }
        Site[] sites = contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        contestWriter.println("sites:");
        Site[] siteArray = sites;
        int clientSettings2 = sites.length;
        int shortName2 = 0;
        while (shortName2 < clientSettings2) {
            Site site = siteArray[shortName2];
            contestWriter.println("  - number: " + site.getSiteNumber());
            contestWriter.println("    name: " + this.quote(site.getDisplayName()));
            contestWriter.println("    password: " + site.getPassword());
            String hostName = site.getConnectionInfo().getProperty("IP_KEY");
            String portStr = site.getConnectionInfo().getProperty("PORT_KEY");
            contestWriter.println("    IP: " + hostName);
            contestWriter.println("    port: " + portStr);
            contestWriter.println();
            ++shortName2;
        }
        contestWriter.println();
        ClientType.Type[] types = new ClientType.Type[]{ClientType.Type.TEAM, ClientType.Type.JUDGE, ClientType.Type.SCOREBOARD};
        boolean accountHeader = false;
        Site[] siteArray2 = sites;
        int n7 = sites.length;
        int n8 = 0;
        while (n8 < n7) {
            Site site = siteArray2[n8];
            ClientType.Type[] typeArray = types;
            int n9 = types.length;
            int n10 = 0;
            while (n10 < n9) {
                ClientType.Type type = typeArray[n10];
                Vector<Account> accounts = contest.getAccounts(type, site.getSiteNumber());
                if (accounts.size() > 0) {
                    if (!accountHeader) {
                        contestWriter.println("accounts:");
                        accountHeader = true;
                    }
                    contestWriter.println("  - account: " + type.toString());
                    contestWriter.println("    site: " + site.getSiteNumber());
                    contestWriter.println("    count: " + accounts.size());
                    contestWriter.println();
                }
                ++n10;
            }
            ++n8;
        }
        if (accountHeader) {
            contestWriter.println();
        }
        contestWriter.println("# EOF Contest Configuration");
        contestWriter.flush();
        contestWriter.close();
        contestWriter = null;
    }

    private String quote(String string) {
        return "'" + string + "'";
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return this.formatter.format(date);
    }

    private String getProblemLetters(IInternalContest contest, Filter filter) {
        ArrayList<String> list = new ArrayList<String>();
        Problem[] problems = contest.getProblems();
        int id = 1;
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (filter.matches(problem)) {
                list.add(this.getProblemLetter(id));
            }
            ++id;
            ++n2;
        }
        StringBuffer buffer = ExportYAML.join(", ", list);
        return buffer.toString();
    }

    protected static StringBuffer join(String delimiter, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size() - 1) {
            buffer.append(list.get(i));
            buffer.append(delimiter);
            ++i;
        }
        if (list.size() > 0) {
            buffer.append(list.get(list.size() - 1));
        }
        return buffer;
    }

    boolean createFile(SerializedFile file, String outputFileName) throws IOException {
        if (file != null && outputFileName != null && !file.isExternalFile()) {
            file.writeFile(outputFileName);
            return new File(outputFileName).isFile();
        }
        return false;
    }

    public String[] writeProblemYAML(IInternalContest contest, String directoryName, Problem problem, String shortName) throws IOException {
        String targetDirectoryName = String.valueOf(directoryName) + File.separator + shortName;
        String problemFileName = String.valueOf(targetDirectoryName) + File.separator + PROBLEM_FILENAME;
        ProblemDataFiles problemDataFiles = contest.getProblemDataFile(problem);
        return this.writeProblemYAML(contest, problem, problemFileName, problemDataFiles);
    }

    public String[] writeProblemYAML(IInternalContest contest, Problem problem, String filename, ProblemDataFiles problemDataFiles) throws IOException {
        Vector<String> filesWritten = new Vector<String>();
        String parentDirectoryName = new File(filename).getParent();
        new File(parentDirectoryName).mkdirs();
        PrintWriter problemWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        problemWriter.println("# Problem configuration, version 1.0 ");
        problemWriter.println("# PC^2 Version: " + new VersionInfo().getSystemVersionInfo());
        problemWriter.println("# Created: " + this.getDateTimeString());
        problemWriter.println("--- ");
        problemWriter.println();
        problemWriter.println("name: " + this.quote(problem.getDisplayName()));
        problemWriter.println("source: ");
        problemWriter.println("author: ");
        problemWriter.println("license: ");
        problemWriter.println("rights_owner: ");
        problemWriter.println();
        problemWriter.println("load-data-files: " + !this.isExternalFiles(problemDataFiles));
        problemWriter.println();
        String dataFile = problem.getDataFileName();
        if (dataFile != null) {
            problemWriter.println("datafile: " + dataFile);
        }
        String answerFileName = problem.getAnswerFileName();
        if (dataFile != null) {
            problemWriter.println("datafile: " + answerFileName);
        }
        problemWriter.println();
        problemWriter.println("limits:");
        problemWriter.println("    timeout: " + problem.getTimeOutInSeconds());
        problemWriter.println();
        if (problem.isValidatedProblem()) {
            problemWriter.println("validator: ");
            problemWriter.println("    validatorProg: " + this.quote(problem.getValidatorProgramName()));
            problemWriter.println("    validatorCmd: " + this.quote(problem.getValidatorCommandLine()));
            problemWriter.println("    usingInternal: " + problem.isUsingPC2Validator());
            problemWriter.println("    validatorOption: " + problem.getWhichPC2Validator());
            problemWriter.println();
            problemWriter.println("    use-internal-validator: " + problem.isUsingPC2Validator());
            problemWriter.println();
        }
        problemWriter.println("judging-type:");
        problemWriter.println("    computer-judged: " + problem.isComputerJudged());
        if (problem.isComputerJudged()) {
            problemWriter.println("    manual-review: " + problem.isManualReview());
        } else {
            problemWriter.println("    manual-review: true");
        }
        problemWriter.println("    send-prelim-judgement: " + problem.isPrelimaryNotification());
        problemWriter.println();
        problemWriter.println("input:");
        problemWriter.println("    readFromSTDIN: " + problem.isReadInputDataFromSTDIN());
        problemWriter.println();
        String problemLaTexFilename = String.valueOf(parentDirectoryName) + File.separator + "problem_statement" + File.separator + "problem.tex";
        this.writeProblemTitleToFile(problemLaTexFilename, problem.getDisplayName());
        String dataFileDirectoryName = String.valueOf(parentDirectoryName) + File.separator + "data" + File.separator + "secret";
        new File(dataFileDirectoryName).mkdirs();
        boolean foundProblemFiles = false;
        if (problemDataFiles != null) {
            String outputFileName;
            SerializedFile serializedFile;
            SerializedFile[] serializedFileArray = problemDataFiles.getJudgesDataFiles();
            int n = serializedFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                serializedFile = serializedFileArray[n2];
                outputFileName = String.valueOf(dataFileDirectoryName) + File.separator + serializedFile.getName();
                this.createFile(serializedFile, outputFileName);
                problemWriter.println("#     wrote (D)" + outputFileName);
                filesWritten.addElement(outputFileName);
                ++n2;
            }
            serializedFileArray = problemDataFiles.getJudgesAnswerFiles();
            n = serializedFileArray.length;
            n2 = 0;
            while (n2 < n) {
                serializedFile = serializedFileArray[n2];
                outputFileName = String.valueOf(dataFileDirectoryName) + File.separator + serializedFile.getName();
                this.createFile(serializedFile, outputFileName);
                problemWriter.println("#     wrote (A)" + outputFileName);
                filesWritten.addElement(outputFileName);
                ++n2;
            }
            boolean bl = foundProblemFiles = filesWritten.size() > 0;
        }
        if (!foundProblemFiles) {
            problemWriter.println("# No data files to write (present/defined)  ");
        }
        problemWriter.println();
        problemWriter.flush();
        problemWriter.close();
        problemWriter = null;
        return filesWritten.toArray(new String[filesWritten.size()]);
    }

    private boolean isExternalFiles(ProblemDataFiles problemDataFiles) {
        boolean result = false;
        if (problemDataFiles != null) {
            SerializedFile file = problemDataFiles.getJudgesDataFile();
            if (file != null) {
                result = file.isExternalFile();
            }
            if ((file = problemDataFiles.getJudgesAnswerFile()) != null) {
                result = file.isExternalFile();
            }
        }
        return result;
    }

    protected void writeProblemTitleToFile(String filename, String title) throws FileNotFoundException {
        String parentDirectoryName = new File(filename).getParent();
        new File(parentDirectoryName).mkdirs();
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        String titlePattern2 = "\\problemname{";
        String commentPattern = "%% plainproblemtitle:";
        writer.println(String.valueOf(titlePattern2) + title + "}");
        writer.println(String.valueOf(commentPattern) + title);
        writer.close();
        writer = null;
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    private String createProblemShortName(String name) {
        String newName = name.trim().split(" ")[0].trim().toLowerCase();
        return newName;
    }

    private String getProblemBalloonColor(IInternalContest contest, Problem problem) {
        BalloonSettings balloonSettings = contest.getBalloonSettings(contest.getSiteNumber());
        String name = null;
        if (balloonSettings != null) {
            name = balloonSettings.getColor(problem);
        }
        return name;
    }

    protected String getRunner(String programExecuteCommandLine) {
        if (programExecuteCommandLine.startsWith("{:")) {
            return null;
        }
        String firstArg = programExecuteCommandLine.trim().split(" ")[0];
        return firstArg;
    }

    protected String getRunnerArguments(String programExecuteCommandLine) {
        if (programExecuteCommandLine.startsWith("{:")) {
            return null;
        }
        return programExecuteCommandLine.trim().substring(this.getRunner(programExecuteCommandLine).length()).trim();
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }
}

