/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.IResultsParser;
import edu.csus.ecs.pc2.core.log.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLResultsParser
implements IResultsParser {
    private Exception exception = null;
    private Log log = null;
    private Hashtable<String, String> results = new Hashtable();

    private void processAttributes(NamedNodeMap nodeMap) {
        int i = 0;
        while (i < nodeMap.getLength()) {
            String item;
            Node node = nodeMap.item(i);
            if (node != null && (item = node.getNodeName()) != null) {
                this.results.put(item, node.getNodeValue());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parseValidatorResultsFile(String resultsFileName) {
        if (!new File(resultsFileName).exists()) {
            this.log.config("WARNING - results file " + resultsFileName + " not found");
            this.exception = new FileNotFoundException(resultsFileName);
        }
        String content = "";
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuildFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(resultsFileName));
            doc.getDocumentElement().normalize();
            String rootNode = doc.getDocumentElement().getNodeName();
            if (!rootNode.equals("result")) {
                this.log.info("Parse error expecting result rootNode, but found node: " + rootNode + " in " + resultsFileName);
                return false;
            }
            content = doc.getDocumentElement().getTextContent();
            if (content != null) {
                this.results.put("CONTENT", content);
            }
            NamedNodeMap attr = doc.getDocumentElement().getAttributes();
            this.processAttributes(attr);
            if (this.results.containsKey("outcome")) {
                return true;
            }
            this.log.info("Parse error - could not find 'outcome' attribute in " + resultsFileName);
            return false;
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "Error parsing results XML file " + resultsFileName, ex);
            this.exception = ex;
        }
        return false;
    }

    @Override
    public Hashtable<String, String> getResults() {
        return this.results;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("Usage: java edu.csus.ecs.pc2.core.execute.XMLResultsParser filename");
            System.exit(1);
        }
        Log log = new Log("edu.csus.ecs.pc2", null, "logs", "parser");
        XMLResultsParser parser = new XMLResultsParser();
        parser.setLog(log);
        if (parser.parseValidatorResultsFile(argv[0])) {
            Enumeration<String> enumeration = parser.getResults().keys();
            while (enumeration.hasMoreElements()) {
                String element = enumeration.nextElement();
                System.out.println("found attribute " + element + " value=" + parser.getResults().get(element));
            }
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

