/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Plugin;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecuteTimer;
import edu.csus.ecs.pc2.core.execute.ExecuteUtilities;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.execute.IExecutable;
import edu.csus.ecs.pc2.core.execute.IOCollector;
import edu.csus.ecs.pc2.core.execute.XMLResultsParser;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.NullViewer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JFileChooser;

public class ExecutablePlugin
extends Plugin
implements IExecutable {
    private static final long serialVersionUID = 1408367949659070087L;
    private static final String NL = System.getProperty("line.separator");
    private Run run = null;
    private Language language = null;
    private Problem problem = null;
    private ProblemDataFiles problemDataFiles = null;
    private ClientId executorId = null;
    private ExecuteUtilities executeUtilities = null;
    private String mainFileDirectory;
    private ExecutionData executionData;
    private ExecuteTimer executionTimer;
    private IFileViewer fileViewer = null;
    private static final int ERRORLENGTH = 50;
    public static final String COMPILER_STDOUT_FILENAME = "cstdout.pc2";
    public static final String COMPILER_STDERR_FILENAME = "cstderr.pc2";
    public static final String EXECUTE_STDOUT_FILENAME = "estdout.pc2";
    public static final String EXECUTE_STDERR_FILENAME = "estderr.pc2";
    public static final String VALIDATOR_STDOUT_FILENAME = "vstdout.pc2";
    public static final String VALIDATOR_STDERR_FILENAME = "vstderr.pc2";
    private RunFiles runFiles;
    private String errorString;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private String executeDirectoryName = null;
    private String executeDirectoryNameSuffix = "";
    private boolean overwriteJudgesDataFiles = true;
    private boolean testRunOnly = false;
    private boolean showMessageToUser = true;
    private boolean usingGUI = true;
    private String validatorResultsFileName;
    private String testingSummaryFilename;

    public ExecutablePlugin(IInternalContest inContest, IInternalController inController, Run run, RunFiles runFiles) {
        this.contest = inContest;
        this.controller = inController;
        this.runFiles = runFiles;
        this.run = run;
        this.language = inContest.getLanguage(run.getLanguageId());
        this.problem = inContest.getProblem(run.getProblemId());
        super.setContestAndController(this.contest, this.controller);
        this.initialize();
    }

    private void initialize() {
        this.executorId = this.contest.getClientId();
        this.mainFileDirectory = this.getDirName(this.runFiles.getMainFile());
        this.executeDirectoryName = this.getExecuteDirectoryName();
        this.log = this.controller.getLog();
        this.executeUtilities = new ExecuteUtilities(this.contest, this.controller, this.run, this.runFiles, this.problem, this.language);
        if (this.executorId.getClientType() != ClientType.Type.TEAM) {
            this.problemDataFiles = this.contest.getProblemDataFile(this.problem);
            this.executeUtilities.setProblemDataFiles(this.problemDataFiles);
        }
        String secs = new Long(new Date().getTime() % 100L).toString();
        this.validatorResultsFileName = String.valueOf(this.run.getNumber()) + secs + "XRSAM.txt";
        this.testingSummaryFilename = String.valueOf(this.run.getNumber()) + secs + "XRSAM.results.txt";
    }

    @Override
    public IFileViewer execute() {
        return this.execute(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IFileViewer execute(boolean clearDirFirst) {
        summaryLines = new ArrayList<String>();
        this.fileViewer = this.usingGUI != false ? new MultipleFileViewer(this.log) : new NullViewer();
        try {
            block49: {
                this.executionData = new ExecutionData();
                this.executeUtilities.setExecutionData(this.executionData);
                this.executeDirectoryName = this.getExecuteDirectoryName();
                dirThere = this.insureDir(this.executeDirectoryName);
                if (!dirThere) {
                    this.log.config("Directory could not be created: " + this.executeDirectoryName);
                    this.showDialogToUser("Unable to create directory " + this.executeDirectoryName);
                    this.setException(this.executionData, "Unable to create directory " + this.executeDirectoryName);
                    return this.fileViewer;
                }
                if (clearDirFirst && this.overwriteJudgesDataFiles && !(cleared = ExecuteUtilities.clearDirectory(this.executeDirectoryName))) {
                    this.log.config("Directory could not be cleared, other process running? ");
                    this.showDialogToUser("Unable to remove all files from directory " + this.executeDirectoryName);
                    this.setException(this.executionData, "Unable to remove all files from directory " + this.executeDirectoryName);
                    return this.fileViewer;
                }
                if (this.runFiles.getMainFile() != null) {
                    this.createFile(this.runFiles.getMainFile(), this.prefixExecuteDirname(this.runFiles.getMainFile().getName()));
                }
                if (this.runFiles.getOtherFiles() != null) {
                    var7_8 = this.runFiles.getOtherFiles();
                    var6_11 = var7_8.length;
                    var5_15 = 0;
                    while (var5_15 < var6_11) {
                        file = var7_8[var5_15];
                        if (file != null) {
                            this.createFile(file, this.prefixExecuteDirname(file.getName()));
                        }
                        ++var5_15;
                    }
                }
                judgeSummaryLine = "run=" + this.run.getNumber() + ",site=" + this.run.getSiteNumber() + ",team=" + this.run.getSubmitter() + ",judge=" + this.getContest().getClientId() + ",runstatus=" + (Object)this.run.getStatus() + ",problem=" + this.run.getProblemId();
                summaryLines.add(judgeSummaryLine);
                if (this.isTestRunOnly()) {
                    if (this.compileProgram()) {
                        this.executeProgram(0);
                    } else if (!this.executionData.isCompileSuccess()) {
                        errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                        if (this.executionData.getExecutionException() != null) {
                            errorMessage = String.valueOf(errorMessage) + ExecutablePlugin.NL + this.executionData.getExecutionException().getMessage();
                        }
                        this.showDialogToUser(errorMessage);
                        this.fileViewer.addTextPane("Error executing compiler", errorMessage);
                    } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                        errnoIndex = this.errorString.indexOf(61) + 1;
                        errorMessage = this.errorString.substring(errnoIndex).equals("2") != false ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                        this.showDialogToUser(errorMessage);
                        this.setException(this.executionData, errorMessage);
                        this.fileViewer.addTextPane("Error during compile", errorMessage);
                    }
                } else {
                    if (this.compileProgram()) {
                        dataFiles = null;
                        if (this.problemDataFiles != null) {
                            dataFiles = this.problemDataFiles.getJudgesDataFiles();
                        }
                        dataSetNumber = 0;
                        passed = false;
                        if (dataFiles == null || dataFiles.length <= 1) {
                            this.log.info("SINGLE run test case for un " + this.run.getNumber() + " site " + this.run.getSiteNumber());
                            if (this.executeProgram(dataSetNumber) && this.isValidated()) {
                                this.validateProgram(dataSetNumber);
                                passed = ExecuteUtilities.didTeamSolveProblem(this.executionData);
                                this.createOutputDataset(1, this.validatorResultsFileName);
                                summaryLine = this.createTestSummaryLine(dataSetNumber + 1, this.executionData);
                                summaryLines.add(summaryLine);
                            }
                        } else {
                            passed = true;
                            while (passed && dataSetNumber < dataFiles.length) {
                                testCaseNumber = dataSetNumber + 1;
                                this.log.info("Run test case " + testCaseNumber + " for run " + this.run.getNumber() + " site " + this.run.getSiteNumber());
                                if (this.executeProgram(dataSetNumber)) {
                                    if (this.isValidated()) {
                                        this.validateProgram(dataSetNumber);
                                        passed = ExecuteUtilities.didTeamSolveProblem(this.executionData);
                                        if (passed) {
                                            this.log.info("Run test case " + testCaseNumber + " for run " + this.run.getNumber() + " site " + this.run.getSiteNumber() + " passed validation ");
                                        } else {
                                            this.log.info("Run test case " + testCaseNumber + " for run " + this.run.getNumber() + " site " + this.run.getSiteNumber() + " failed validation ");
                                        }
                                        this.createOutputDataset(testCaseNumber, this.validatorResultsFileName);
                                        summaryLine = this.createTestSummaryLine(dataSetNumber + 1, this.executionData);
                                        summaryLines.add(summaryLine);
                                    }
                                } else {
                                    this.log.info("Run test case " + testCaseNumber + " for run " + this.run.getNumber() + " site " + this.run.getSiteNumber() + ", program did not run/execute ");
                                }
                                ++dataSetNumber;
                            }
                        }
                        summaryLines.add("results=" + passed);
                        fullResultsFilename = this.prefixExecuteDirname(this.testingSummaryFilename);
                        try {
                            ExecuteUtilities.writeFileContents(fullResultsFilename, summaryLines);
                            break block49;
                        }
                        catch (Exception e) {
                            this.log.info("Could not write results to file: " + fullResultsFilename + ", exception=" + e);
                            ** for (sumLine : summaryLines)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.log.info("summary: " + sumLine);
                            continue;
lbl105:
                            // 1 sources

                            break block49;
                        }
                    }
                    if (!this.executionData.isCompileSuccess()) {
                        errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                        if (this.executionData.getExecutionException() != null) {
                            errorMessage = String.valueOf(errorMessage) + ExecutablePlugin.NL + this.executionData.getExecutionException().getMessage();
                        }
                        this.showDialogToUser(errorMessage);
                        this.fileViewer.addTextPane("Error executing compiler", errorMessage);
                    } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                        errnoIndex = this.errorString.indexOf(61) + 1;
                        errorMessage = this.errorString.substring(errnoIndex).equals("2") != false ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                        this.showDialogToUser(errorMessage);
                        this.setException(this.executionData, errorMessage);
                        this.fileViewer.addTextPane("Error during compile", errorMessage);
                    }
                }
            }
            this.fileViewer.setTitle("Executable");
            outputFile = this.prefixExecuteDirname("vstdout.pc2");
            file = new File(outputFile);
            if (file.isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Validator output", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname("vstderr.pc2"))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Validator stderr", outputFile);
            }
            outputFile = this.prefixExecuteDirname("estdout.pc2");
            file = new File(outputFile);
            programGeneratedOutput = false;
            if (file.isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program output", outputFile);
                programGeneratedOutput = true;
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname("estderr.pc2"))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program stderr", outputFile);
                programGeneratedOutput = true;
            }
            if (!programGeneratedOutput) {
                message = "PC2: execution of program did not generate any output";
                if (!this.executionData.isCompileSuccess()) {
                    errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                    if (this.executionData.getExecutionException() != null) {
                        errorMessage = String.valueOf(errorMessage) + ExecutablePlugin.NL + this.executionData.getExecutionException().getMessage();
                    }
                    message = String.valueOf(message) + ExecutablePlugin.NL + errorMessage;
                }
                this.fileViewer.addTextPane("Program output", message);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname("cstdout.pc2"))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stdout", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname("cstderr.pc2"))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stderr", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(this.testingSummaryFilename))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Testing Results", outputFile);
                programGeneratedOutput = true;
            }
            if (this.executionData.getExecuteExitValue() != 0) {
                returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                this.fileViewer.setInformationLabelText("<html><font size='+1' color='red'>Team program exit code = 0x" + Long.toHexString(returnValue).toUpperCase() + "</font>");
            } else {
                this.fileViewer.setInformationLabelText("");
            }
            if (!this.isTestRunOnly() && this.problem.isShowCompareWindow()) {
                teamsOutputFileName = this.prefixExecuteDirname("estdout.pc2");
                if (this.problem.getAnswerFileName() != null && this.problem.getAnswerFileName().length() > 0) {
                    answerFileName = this.prefixExecuteDirname(this.problem.getAnswerFileName());
                    if (!new File(answerFileName).isFile()) {
                        dataSetNumber = 0;
                        this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, answerFileName);
                    }
                    this.fileViewer.setCompareFileNames(answerFileName, teamsOutputFileName);
                    this.fileViewer.enableCompareButton(true);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception during execute() ", e);
            this.fileViewer.addTextPane("Error during execute", "Exception during execute, check log " + e.getMessage());
        }
        return this.fileViewer;
    }

    private String createTestSummaryLine(int dataSetNumber, ExecutionData data) {
        boolean passed = ExecuteUtilities.didTeamSolveProblem(this.executionData);
        return "testnumber=" + dataSetNumber + ",accepted=" + passed + ",exeMS=" + data.getExecuteTimeMS() + ",valMS=" + data.getvalidateTimeMS() + ",exeRC=" + data.getExecuteExitValue() + ",valRC=" + data.getValidationReturnCode() + "\ntestnumber=" + dataSetNumber + ",exeExc=" + data.getExecutionException() + ",addInfo=" + data.getAdditionalInformation();
    }

    private void createOutputDataset(int testCaseNumber, String resultsFileName) {
        String[] filenames;
        String fileSuffix = ".set" + testCaseNumber;
        String[] stringArray = filenames = new String[]{VALIDATOR_STDOUT_FILENAME, VALIDATOR_STDERR_FILENAME, EXECUTE_STDOUT_FILENAME, EXECUTE_STDERR_FILENAME, resultsFileName};
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String sourceName = this.prefixExecuteDirname(name);
            String targ = String.valueOf(sourceName) + fileSuffix;
            if (new File(sourceName).isFile() && !ExecuteUtilities.copyFile(sourceName, targ, this.log)) {
                this.log.warning("Unnable to copy file " + sourceName + " to " + targ);
            }
            ++n2;
        }
    }

    public boolean createFile(SerializedFile[] fileList, int setNumber, String outputFileName) {
        if (fileList != null && setNumber < fileList.length) {
            return this.createFile(fileList[setNumber], outputFileName);
        }
        return false;
    }

    protected boolean createFile(SerializedFile file, String filename) {
        try {
            Utilities.createFile(file, filename);
            return true;
        }
        catch (IOException e) {
            this.log.log(Log.INFO, "Could not create " + filename, e);
            return false;
        }
    }

    protected void showDialogToUser(String string) {
        if (this.showMessageToUser) {
            if (this.usingGUI) {
                this.fileViewer.showMessage(string);
            }
            this.log.info(string);
        }
    }

    public boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            this.log.log(Log.CONFIG, "Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
            this.setException(this.executionData, "Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    protected boolean validateProgram(int dataSetNumber) {
        Process process;
        long startSecs;
        BufferedOutputStream stderrlog;
        BufferedOutputStream stdoutlog;
        block28: {
            this.executionData.setValidationReturnCode(-1L);
            this.executionData.setValidationSuccess(false);
            if (this.isJudge()) {
                this.controller.sendValidatingMessage(this.run);
            }
            if (this.problemDataFiles.getValidatorFile() != null) {
                String validatorFileName = this.problemDataFiles.getValidatorFile().getName();
                String validatorUnpackName = this.prefixExecuteDirname(validatorFileName);
                if (!this.createFile(this.problemDataFiles.getValidatorFile(), validatorUnpackName)) {
                    this.log.info("Unable to create validator program " + validatorUnpackName);
                    this.setException(this.executionData, "Unable to create validator program " + validatorUnpackName);
                    throw new SecurityException("Unable to create validator, check logs");
                }
                if (!validatorFileName.endsWith(".jar")) {
                    this.setExecuteBit(this.prefixExecuteDirname(validatorFileName));
                }
            }
            if (this.overwriteJudgesDataFiles && !this.problem.isUsingExternalDataFiles()) {
                this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getDataFileName()));
                this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getAnswerFileName()));
            }
            SerializedFile userOutputFile = this.executionData.getExecuteProgramOutput();
            this.createFile(userOutputFile, this.prefixExecuteDirname(userOutputFile.getName()));
            String commandPattern = this.problem.getValidatorCommandLine();
            boolean pc2JarUseDirectory = false;
            if (this.problem.isUsingPC2Validator()) {
                String pathToPC2Jar = this.findPC2JarPath();
                if (!new File(String.valueOf(pathToPC2Jar) + "pc2.jar").exists()) {
                    pc2JarUseDirectory = true;
                }
                commandPattern = "java -cp " + pathToPC2Jar + this.problem.getValidatorCommandLine();
            }
            this.log.log(Log.DEBUG, "before substitution: " + commandPattern);
            String cmdLine = this.executeUtilities.substituteAllStrings(commandPattern);
            cmdLine = ExecuteUtilities.replaceString(cmdLine, "{:resfile}", this.validatorResultsFileName);
            this.log.log(Log.DEBUG, "after  substitution: " + cmdLine);
            if (File.separator.equals("\\") && this.problem.isUsingPC2Validator()) {
                cmdLine = cmdLine.replaceFirst("-cp ", "-cp \"");
                cmdLine = cmdLine.replaceFirst("jar ", "jar\" ");
                this.log.log(Log.DEBUG, "after replaceFirst: " + cmdLine);
            }
            if (pc2JarUseDirectory) {
                cmdLine = ExecuteUtilities.replaceString(cmdLine, "pc2.jar", "");
            }
            this.log.log(Log.DEBUG, "after  substitution: " + cmdLine);
            try {
                String actFilename = new String(cmdLine);
                int i = actFilename.trim().indexOf(" ");
                actFilename = i > -1 ? String.valueOf(this.executeDirectoryName) + actFilename.trim().substring(0, i) : String.valueOf(this.executeDirectoryName) + actFilename.trim();
                File f = new File(actFilename);
                if (f.exists()) {
                    cmdLine = this.prefixExecuteDirname(cmdLine.trim());
                }
            }
            catch (Exception e) {
                this.setException(this.executionData, "Exception in validatorCall " + e.getMessage());
                this.log.log(Log.INFO, "Exception in validatorCall ", e);
                throw new SecurityException(e);
            }
            stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME), false));
            stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME), false));
            String msg = "Working...";
            if (this.problem.isShowValidationToJudges()) {
                msg = "Validating...";
            }
            startSecs = System.currentTimeMillis();
            process = this.runProgram(cmdLine, msg, false);
            if (process != null) break block28;
            this.executionTimer.stopTimer();
            stderrlog.close();
            stdoutlog.close();
            return false;
        }
        try {
            BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
            BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
            IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
            IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
            this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
            this.executionTimer.setProc(process);
            stdoutCollector.start();
            stderrCollector.start();
            stdoutCollector.join();
            stderrCollector.join();
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            } else {
                this.log.config("validatorCall() executionTimer == null");
            }
            if (process != null) {
                process.destroy();
            }
            stdoutlog.close();
            stderrlog.close();
            this.executionData.setvalidateTimeMS(System.currentTimeMillis() - startSecs);
            this.executionData.setValidationStdout(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME)));
            this.executionData.setValidationStderr(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME)));
        }
        catch (Exception ex) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.CONFIG, "Exception in validator ", ex);
        }
        boolean fileThere = new File(this.prefixExecuteDirname(this.validatorResultsFileName)).exists();
        try {
            try {
                if (fileThere) {
                    this.storeValidatorResults(this.validatorResultsFileName, this.log);
                } else {
                    this.log.config("validationCall - Did not produce output results file " + this.validatorResultsFileName);
                }
            }
            catch (Exception ex) {
                this.log.log(Log.INFO, "Exception in validation  ", ex);
                throw new SecurityException(ex);
            }
        }
        finally {
            if (this.executionData.isRunTimeLimitExceeded()) {
                this.executionData.setValidationResults("No - Time Limit Exceeded");
                this.executionData.setValidationSuccess(true);
            }
        }
        return this.executionData.isValidationSuccess();
    }

    protected void storeValidatorResults(String resultsFileName, Log logger) {
        XMLResultsParser parser = new XMLResultsParser();
        parser.setLog(this.log);
        boolean done = parser.parseValidatorResultsFile(this.prefixExecuteDirname(resultsFileName));
        Hashtable<String, String> results = parser.getResults();
        if (done && results != null && results.containsKey("outcome")) {
            if (!this.problem.isInternationalJudgementReadMethod() || results.containsKey("security") && resultsFileName.equals(results.get("security"))) {
                this.executionData.setValidationResults(results.get("outcome"));
                this.executionData.setValidationSuccess(true);
            } else {
                this.setException(this.executionData, "validationCall - results file did not contain security");
                logger.config("validationCall - results file did not contain security");
                logger.config(String.valueOf(resultsFileName) + " != " + results.get("security"));
            }
        } else if (!done) {
            this.setException(this.executionData, "Error parsing/reading results file, check log");
            logger.config("Error parsing/reading results file, check log");
        } else if (results != null && !results.containsKey("outcome")) {
            this.setException(this.executionData, "Error parsing/reading results file, check log");
            logger.config("Error could not find 'outcome' in results file, check log");
        } else {
            logger.config("Error parsing results file, check log");
        }
    }

    private void setException(ExecutionData inExecutionData, String string) {
        inExecutionData.setExecutionException(new Exception(string));
    }

    protected String findPC2JarPath() {
        return ExecuteUtilities.findPC2JarPath();
    }

    public boolean isValidated() {
        return this.problem.isValidatedProblem() && !this.isTestRunOnly();
    }

    public String getFileNameFromUser() {
        String outFileName = null;
        JFileChooser chooser = new JFileChooser(this.mainFileDirectory);
        try {
            chooser.setDialogTitle("Open Test Input File");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                this.mainFileDirectory = chooser.getCurrentDirectory().getAbsolutePath();
                outFileName = chooser.getSelectedFile().getCanonicalFile().toString();
            }
        }
        catch (Exception e) {
            this.log.log(Log.CONFIG, "Error getting selected file, try again.", e);
        }
        chooser = null;
        return outFileName;
    }

    protected void selectAndCopyDataFile(String inputFileName) throws Exception {
        String pickedFileName = this.getFileNameFromUser();
        if (pickedFileName != null) {
            SerializedFile data = new SerializedFile(pickedFileName);
            if (data.getBuffer() == null) {
                throw new Exception("datafile does not exist/can not be read " + pickedFileName);
            }
            this.createFile(data, inputFileName);
            Object var3_3 = null;
        }
    }

    protected boolean executeProgram(int dataSetNumber) {
        Process process;
        long startSecs;
        BufferedOutputStream stderrlog;
        BufferedOutputStream stdoutlog;
        String inputDataFileName;
        boolean passed;
        block36: {
            passed = false;
            inputDataFileName = null;
            int testSetNumber = dataSetNumber + 1;
            if (this.isJudge()) {
                this.controller.sendExecutingMessage(this.run);
            }
            if (!this.isTestRunOnly()) {
                this.log.log(Log.INFO, "Executing run " + this.run.getNumber() + " from " + this.run.getSubmitter().getTripletKey() + " test set " + testSetNumber);
            }
            this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId, this.isUsingGUI());
            this.executionTimer.startTimer();
            if (this.problem.getDataFileName() != null) {
                inputDataFileName = this.prefixExecuteDirname(this.problem.getDataFileName());
            }
            if (this.problem.isReadInputDataFromSTDIN()) {
                File output = File.createTempFile("__t", ".in", new File(this.getExecuteDirectoryName()));
                inputDataFileName = this.prefixExecuteDirname(output.getName());
                output.delete();
            }
            if (this.isTestRunOnly()) {
                if (this.problem.isReadInputDataFromSTDIN()) {
                    this.selectAndCopyDataFile(inputDataFileName);
                } else if (inputDataFileName != null) {
                    String sourceFileName = String.valueOf(this.getDirName(this.runFiles.getMainFile())) + File.separator + this.problem.getDataFileName();
                    SerializedFile dataFile = new SerializedFile(sourceFileName);
                    if (dataFile != null) {
                        this.createFile(dataFile, inputDataFileName);
                    }
                    dataFile = null;
                }
                if (inputDataFileName != null && !new File(inputDataFileName).isFile()) {
                    if (this.executionTimer != null) {
                        this.executionTimer.stopTimer();
                    }
                    throw new SecurityException("Expected data file, was not created, file name is " + this.problem.getDataFileName());
                }
            } else if (!this.problem.isUsingExternalDataFiles()) {
                if (inputDataFileName != null && this.problemDataFiles.getJudgesDataFiles() != null && this.overwriteJudgesDataFiles && !this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, inputDataFileName)) {
                    throw new SecurityException("Unable to create data file " + inputDataFileName);
                }
            } else {
                File dataFile = this.problem.locateJudgesDataFile(testSetNumber);
                if (dataFile == null) {
                    String name = this.problem.getDataFileName(testSetNumber);
                    this.log.log(Log.DEBUG, "For problem " + this.problem + " test number " + testSetNumber + " expecting file " + name + " in dir " + this.problem.getCCSfileDirectory());
                    throw new SecurityException("Unable to find/extract data file " + name + " for data set " + dataSetNumber + " check log");
                }
                inputDataFileName = dataFile.getCanonicalPath();
            }
            stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME), false));
            stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME), false));
            String cmdline = this.language.getProgramExecuteCommandLine();
            this.log.log(Log.DEBUG, "before substitution: " + cmdline);
            cmdline = this.executeUtilities.substituteAllStrings(cmdline);
            this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
            String actFilename = new String(cmdline);
            int i = actFilename.trim().indexOf(" ");
            actFilename = i > -1 ? this.prefixExecuteDirname(actFilename.trim().substring(0, i)) : this.prefixExecuteDirname(actFilename.trim());
            File f = new File(actFilename);
            if (f.exists()) {
                cmdline = f.getCanonicalPath();
            }
            boolean autoStop = false;
            if (!this.isTestRunOnly()) {
                autoStop = true;
            }
            startSecs = System.currentTimeMillis();
            process = this.runProgram(cmdline, "Executing...", autoStop);
            if (process != null) break block36;
            this.executionTimer.stopTimer();
            stderrlog.close();
            stdoutlog.close();
            this.executionData.setExecuteSucess(false);
            return false;
        }
        try {
            block38: {
                BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
                BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
                IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
                IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
                this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
                this.executionTimer.setProc(process);
                stdoutCollector.start();
                stderrCollector.start();
                if (this.isValidDataFile(this.problem) && this.problem.isReadInputDataFromSTDIN()) {
                    this.log.info("Submission is reading from stdin");
                    BufferedOutputStream out = new BufferedOutputStream(process.getOutputStream());
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputDataFileName));
                    byte[] buf = new byte[32768];
                    try {
                        int c;
                        while ((c = in.read(buf)) != -1) {
                            out.write(buf, 0, c);
                        }
                    }
                    catch (IOException e) {
                        this.log.info("Caught a " + e.getMessage() + " do not be alarmed.");
                    }
                    in.close();
                    out.close();
                }
                stdoutCollector.join();
                stderrCollector.join();
                if (this.executionTimer != null) {
                    this.executionTimer.stopTimer();
                    this.executionData.setRunTimeLimitExceeded(this.executionTimer.isRunTimeLimitExceeded());
                }
                if (process != null) {
                    int returnValue = process.waitFor();
                    this.executionData.setExecuteExitValue(returnValue);
                    process.destroy();
                }
                stdoutlog.close();
                stderrlog.close();
                this.executionData.setExecuteSucess(true);
                this.executionData.setExecuteTimeMS(System.currentTimeMillis() - startSecs);
                this.executionData.setExecuteProgramOutput(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME)));
                this.executionData.setExecuteStderr(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME)));
                if (this.executionData.getExecuteExitValue() != 0) {
                    long returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                    PrintWriter exitCodeFile = null;
                    try {
                        try {
                            exitCodeFile = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname("EXITCODE.TXT"), false), true);
                            exitCodeFile.write("0x" + Long.toHexString(returnValue).toUpperCase());
                        }
                        catch (FileNotFoundException e) {
                            StaticLog.log("Unable to open file EXITCODE.TXT", e);
                            exitCodeFile = null;
                            if (exitCodeFile != null) {
                                exitCodeFile.close();
                            }
                            break block38;
                        }
                    }
                    catch (Throwable throwable) {
                        if (exitCodeFile != null) {
                            exitCodeFile.close();
                        }
                        throw throwable;
                    }
                    if (exitCodeFile != null) {
                        exitCodeFile.close();
                    }
                }
            }
            passed = true;
        }
        catch (Exception e) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.INFO, "executeProgram() Exception ", e);
            throw new SecurityException(e);
        }
        return passed;
    }

    private boolean isValidDataFile(Problem inProblem) {
        boolean result = false;
        if (inProblem.getDataFileName() != null && inProblem.getDataFileName().trim().length() > 0) {
            result = true;
        }
        return result;
    }

    private boolean isJudge() {
        return this.contest.getClientId().getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    protected boolean compileProgram() {
        block13: {
            block12: {
                Process process;
                long startSecs;
                BufferedOutputStream stderrlog;
                BufferedOutputStream stdoutlog;
                String programName;
                File program;
                block11: {
                    try {
                        if (this.isJudge()) {
                            this.controller.sendCompilingMessage(this.run);
                        }
                        if ((program = new File(this.prefixExecuteDirname(programName = ExecuteUtilities.replaceString(this.language.getExecutableIdentifierMask(), "{:basename}", ExecuteUtilities.removeExtension(this.runFiles.getMainFile().getName()))))).exists()) {
                            this.log.config("Team submitted an executable " + programName);
                            program.delete();
                        }
                        this.log.log(Log.DEBUG, "before substitution: " + this.language.getCompileCommandLine());
                        String cmdline = this.executeUtilities.substituteAllStrings(this.language.getCompileCommandLine());
                        this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
                        stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME), false));
                        stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME), false));
                        this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId, this.isUsingGUI());
                        this.executionTimer.startTimer();
                        startSecs = System.currentTimeMillis();
                        process = this.runProgram(cmdline, "Compiling...", false);
                        if (process != null) break block11;
                        this.executionTimer.stopTimer();
                        stderrlog.close();
                        stdoutlog.close();
                        this.executionData.setCompileExeFileName("");
                        this.executionData.setCompileSuccess(false);
                        this.executionData.setCompileResultCode(1L);
                        return false;
                    }
                    catch (Exception e) {
                        if (this.executionTimer != null) {
                            this.executionTimer.stopTimer();
                        }
                        this.log.log(Log.INFO, "Exception ", e);
                        throw new SecurityException(e);
                    }
                }
                BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
                BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
                IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
                IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
                this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
                this.executionTimer.setProc(process);
                stdoutCollector.start();
                stderrCollector.start();
                stdoutCollector.join();
                stderrCollector.join();
                if (this.executionTimer != null) {
                    this.executionTimer.stopTimer();
                } else {
                    this.log.config("compileCall() executionTimer == null");
                }
                if (process != null) {
                    process.destroy();
                }
                stdoutlog.close();
                stderrlog.close();
                this.executionData.setCompileTimeMS(System.currentTimeMillis() - startSecs);
                this.executionData.setCompileStdout(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME)));
                this.executionData.setCompileStderr(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME)));
                program = new File(this.prefixExecuteDirname(programName));
                if (!program.exists()) break block12;
                this.executionData.setCompileExeFileName(programName);
                this.executionData.setCompileSuccess(true);
                this.executionData.setCompileResultCode(0L);
                return true;
            }
            if (!this.language.isInterpreted()) break block13;
            this.executionData.setCompileExeFileName(this.runFiles.getMainFile().getName());
            this.executionData.setCompileSuccess(true);
            this.executionData.setCompileResultCode(0L);
            return true;
        }
        this.executionData.setCompileExeFileName("");
        this.executionData.setCompileSuccess(false);
        this.executionData.setCompileResultCode(2L);
        return false;
    }

    private long getMaxFileSize() {
        return this.contest.getContestInformation().getMaxFileSize();
    }

    protected String getDirName(SerializedFile file) {
        String absPath = file.getAbsolutePath();
        return absPath.substring(0, absPath.length() - 1 - file.getName().length());
    }

    public Process runProgram(String cmdline, String msg, boolean autoStopExecution) {
        Process process = null;
        this.errorString = "";
        this.executeDirectoryName = this.getExecuteDirectoryName();
        try {
            File runDir = new File(this.executeDirectoryName);
            if (runDir.isDirectory()) {
                this.log.config("executing: '" + cmdline + "'");
                String[] env = null;
                if (this.executionTimer != null) {
                    this.executionTimer.setDoAutoStop(autoStopExecution);
                    this.executionTimer.setTitle(msg);
                }
                process = Runtime.getRuntime().exec(cmdline, env, runDir);
                if (this.executionTimer != null) {
                    this.executionTimer.setProc(process);
                    this.executionTimer.startTimer();
                }
            } else {
                this.errorString = "Execute Directory does not exist";
                this.log.config("Execute Directory does not exist");
            }
        }
        catch (IOException e) {
            this.errorString = e.getMessage();
            this.log.config("Note: exec failed in RunProgram " + this.errorString);
            this.executionData.setExecutionException(e);
            return null;
        }
        catch (Exception e) {
            this.errorString = e.getMessage();
            this.log.log(Log.CONFIG, "Note: exec failed in RunProgram " + this.errorString, e);
            this.executionData.setExecutionException(e);
            return null;
        }
        return process;
    }

    private void setExecuteBit(String filename) {
        this.log.config("setExecuteBit for " + filename);
        try {
            File chmodFile = new File("/bin/chmod");
            if (chmodFile.exists()) {
                String cmdline = "/bin/chmod +x " + filename;
                this.log.config("executing chmod: '" + cmdline + "'");
                Process process = Runtime.getRuntime().exec(cmdline);
                process.waitFor();
            }
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "Exception in setExecuteBit()  ", ex);
        }
    }

    public String getValidationResults() {
        return this.executionData.getValidationResults();
    }

    public ExecutionData getExecutionData() {
        return this.executionData;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public String getExecuteDirectoryName() {
        return "executesite" + this.contest.getClientId().getSiteNumber() + this.contest.getClientId().getName() + this.getExecuteDirectoryNameSuffix();
    }

    public String prefixExecuteDirname(String filename) {
        return String.valueOf(this.getExecuteDirectoryName()) + File.separator + filename;
    }

    public boolean isOverwriteJudgesDataFiles() {
        return this.overwriteJudgesDataFiles;
    }

    public void setOverwriteJudgesDataFiles(boolean overwriteDataFiles) {
        this.overwriteJudgesDataFiles = overwriteDataFiles;
    }

    public boolean isTestRunOnly() {
        return this.testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public void setTestRunOnly(boolean testRunOnly) {
        this.testRunOnly = testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public boolean isValidationSuccess() {
        return this.executionData.isValidationSuccess();
    }

    public boolean isShowMessageToUser() {
        return this.showMessageToUser;
    }

    public void setShowMessageToUser(boolean showMessageToUser) {
        this.showMessageToUser = showMessageToUser;
    }

    public String getExecuteDirectoryNameSuffix() {
        return this.executeDirectoryNameSuffix;
    }

    public void setExecuteDirectoryName(String executeDirectoryName) {
        this.executeDirectoryName = executeDirectoryName;
    }

    public void setExecuteBaseDirectoryName(String baseDirectoryName) throws Exception {
        this.insureDir(baseDirectoryName);
        if (!this.isDirectory(baseDirectoryName)) {
            throw new IOException("Could not create directory " + baseDirectoryName);
        }
        String dirname = String.valueOf(baseDirectoryName) + File.separator + this.executeDirectoryName;
        this.insureDir(baseDirectoryName);
        if (!this.isDirectory(dirname)) {
            throw new IOException("Could not create directory " + dirname);
        }
        this.executeDirectoryName = dirname;
    }

    private boolean isDirectory(String dirname) {
        return new File(dirname).isDirectory();
    }

    public void setExecuteDirectoryNameSuffix(String executeDirectoryNameSuffix) {
        this.executeDirectoryNameSuffix = executeDirectoryNameSuffix;
    }

    public void setUsingGUI(boolean usingGUI) {
        this.usingGUI = usingGUI;
    }

    public boolean isUsingGUI() {
        return this.usingGUI;
    }

    @Override
    public IFileViewer execute(IInternalContest inContest, IInternalController inController, Run aRun, RunFiles aRunFiles, boolean clearDirFirst) {
        this.contest = inContest;
        this.controller = inController;
        this.runFiles = aRunFiles;
        this.run = aRun;
        this.language = inContest.getLanguage(aRun.getLanguageId());
        this.problem = inContest.getProblem(aRun.getProblemId());
        this.initialize();
        return this.execute(clearDirFirst);
    }

    @Override
    public String getPluginTitle() {
        return "Executeable";
    }

    @Override
    public void dispose() {
        this.executionData = null;
        this.executionTimer = null;
        this.fileViewer = null;
    }

    public String getValidatorResultsFileName() {
        return this.validatorResultsFileName;
    }

    public String getTestingSummaryFilename() {
        return this.testingSummaryFilename;
    }
}

