/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Plugin;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecuteTimer;
import edu.csus.ecs.pc2.core.execute.ExecuteUtilities;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.execute.IExecutable;
import edu.csus.ecs.pc2.core.execute.IOCollector;
import edu.csus.ecs.pc2.core.execute.JudgementUtilites;
import edu.csus.ecs.pc2.core.execute.XMLResultsParser;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.NullViewer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;

public class Executable
extends Plugin
implements IExecutable {
    private static final long serialVersionUID = 1408367949659070087L;
    private static final String NL = System.getProperty("line.separator");
    private Run run = null;
    private Language language = null;
    private Problem problem = null;
    private ProblemDataFiles problemDataFiles = null;
    private ClientId executorId = null;
    private String mainFileDirectory;
    private ExecutionData executionData = new ExecutionData();
    private ExecuteTimer executionTimer;
    private IFileViewer fileViewer = null;
    private static final int ERRORLENGTH = 50;
    public static final String COMPILER_STDOUT_FILENAME = "cstdout.pc2";
    public static final String COMPILER_STDERR_FILENAME = "cstderr.pc2";
    public static final String EXECUTE_STDOUT_FILENAME = "estdout.pc2";
    public static final String EXECUTE_STDERR_FILENAME = "estderr.pc2";
    public static final String VALIDATOR_STDOUT_FILENAME = "vstdout.pc2";
    public static final String VALIDATOR_STDERR_FILENAME = "vstderr.pc2";
    private static final String EXIT_CODE_FILENAME = "EXITCODE.TXT";
    private RunFiles runFiles;
    private String errorString;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private String executeDirectoryName = null;
    private String executeDirectoryNameSuffix = "";
    private boolean overwriteJudgesDataFiles = true;
    private boolean testRunOnly = false;
    private boolean showMessageToUser = true;
    private boolean usingGUI = true;
    private ArrayList<String> teamsOutputFilenames = new ArrayList();
    private ArrayList<String> validatorOutputFilenames = new ArrayList();
    private ArrayList<String> validatorStderrFilesnames = new ArrayList();

    public Executable(IInternalContest inContest, IInternalController inController, Run run, RunFiles runFiles) {
        super.setContestAndController(inContest, inController);
        this.contest = inContest;
        this.controller = inController;
        this.runFiles = runFiles;
        this.run = run;
        this.language = inContest.getLanguage(run.getLanguageId());
        this.problem = inContest.getProblem(run.getProblemId());
        this.initialize();
    }

    private void initialize() {
        this.executorId = this.contest.getClientId();
        if (this.runFiles != null) {
            this.mainFileDirectory = this.getDirName(this.runFiles.getMainFile());
        }
        this.executeDirectoryName = this.getExecuteDirectoryName();
        this.log = this.controller.getLog();
        if (this.executorId.getClientType() != ClientType.Type.TEAM) {
            this.problemDataFiles = this.contest.getProblemDataFile(this.problem);
        }
    }

    public boolean clearDirectory(String dirName) {
        File dir = null;
        boolean result = true;
        dir = new File(dirName);
        String[] filesToRemove = dir.list();
        int i = 0;
        while (i < filesToRemove.length) {
            File fn1 = new File(String.valueOf(dirName) + File.separator + filesToRemove[i]);
            if (fn1.isDirectory()) {
                result &= this.clearDirectory(String.valueOf(dirName) + File.separator + filesToRemove[i]);
            }
            result &= fn1.delete();
            ++i;
        }
        return result;
    }

    @Override
    public IFileViewer execute() {
        return this.execute(true);
    }

    @Override
    public IFileViewer execute(boolean clearDirFirst) {
        this.teamsOutputFilenames = new ArrayList();
        this.fileViewer = this.usingGUI ? new MultipleFileViewer(this.log) : new NullViewer();
        try {
            int errnoIndex;
            boolean cleared;
            this.executionData = new ExecutionData();
            this.executeDirectoryName = this.getExecuteDirectoryName();
            boolean dirThere = this.insureDir(this.executeDirectoryName);
            if (!dirThere) {
                this.log.config("Directory could not be created: " + this.executeDirectoryName);
                this.showDialogToUser("Unable to create directory " + this.executeDirectoryName);
                this.setException("Unable to create directory " + this.executeDirectoryName);
                return this.fileViewer;
            }
            if (clearDirFirst && this.overwriteJudgesDataFiles && !(cleared = this.clearDirectory(this.executeDirectoryName))) {
                this.log.config("Directory could not be cleared, other process running? ");
                this.showDialogToUser("Unable to remove all files from directory " + this.executeDirectoryName);
                this.setException("Unable to remove all files from directory " + this.executeDirectoryName);
                return this.fileViewer;
            }
            if (this.runFiles.getMainFile() != null) {
                this.createFile(this.runFiles.getMainFile(), this.prefixExecuteDirname(this.runFiles.getMainFile().getName()));
            }
            if (this.runFiles.getOtherFiles() != null) {
                SerializedFile[] serializedFileArray = this.runFiles.getOtherFiles();
                int n = serializedFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializedFile file = serializedFileArray[n2];
                    if (file != null) {
                        this.createFile(file, this.prefixExecuteDirname(file.getName()));
                    }
                    ++n2;
                }
            }
            if (this.isTestRunOnly()) {
                if (this.compileProgram()) {
                    this.executeProgram(0);
                } else if (!this.executionData.isCompileSuccess()) {
                    String errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                    if (this.executionData.getExecutionException() != null) {
                        errorMessage = String.valueOf(errorMessage) + NL + this.executionData.getExecutionException().getMessage();
                    }
                    this.showDialogToUser(errorMessage);
                    this.fileViewer.addTextPane("Error executing compiler", errorMessage);
                } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                    errnoIndex = this.errorString.indexOf(61) + 1;
                    String errorMessage = this.errorString.substring(errnoIndex).equals("2") ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                    this.showDialogToUser(errorMessage);
                    this.setException(errorMessage);
                    this.fileViewer.addTextPane("Error during compile", errorMessage);
                }
            } else if (this.compileProgram()) {
                SerializedFile[] dataFiles = null;
                if (this.problemDataFiles != null) {
                    dataFiles = this.problemDataFiles.getJudgesDataFiles();
                }
                int dataSetNumber = 0;
                boolean passed = true;
                boolean oneTestFailed = false;
                String failedResults = "";
                if (dataFiles == null || dataFiles.length <= 1) {
                    this.log.info("Test cases: 1 for run " + this.run.getNumber());
                    passed = this.executeAndValidateDataSet(dataSetNumber);
                    if (!passed) {
                        oneTestFailed = true;
                        failedResults = this.executionData.getValidationResults();
                    }
                } else {
                    this.log.info("Test cases: " + dataFiles.length + " for run " + this.run.getNumber());
                    while (dataSetNumber < dataFiles.length) {
                        passed = this.executeAndValidateDataSet(dataSetNumber);
                        ++dataSetNumber;
                        if (passed) continue;
                        this.log.info("FAILED test case " + dataSetNumber + " for run " + this.run.getNumber() + " reason " + this.getFailureReason());
                        oneTestFailed = true;
                        if (!"".equals(failedResults)) continue;
                        failedResults = this.executionData.getValidationResults();
                    }
                    if (!this.problem.isUsingExternalDataFiles()) {
                        this.createFile(this.problemDataFiles.getJudgesDataFiles(), 0, this.prefixExecuteDirname(this.problem.getDataFileName()));
                        this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), 0, this.prefixExecuteDirname(this.problem.getAnswerFileName()));
                    }
                }
                if (oneTestFailed) {
                    this.executionData.setValidationResults(failedResults);
                    this.log.info("Test results: test failed " + this.run + " reason = " + this.getFailureReason());
                } else {
                    this.log.info("Test results: ALL passed for run " + this.run);
                }
            } else if (!this.executionData.isCompileSuccess()) {
                String errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                if (this.executionData.getExecutionException() != null) {
                    errorMessage = String.valueOf(errorMessage) + NL + this.executionData.getExecutionException().getMessage();
                }
                this.showDialogToUser(errorMessage);
                this.fileViewer.addTextPane("Error executing compiler", errorMessage);
            } else if (this.executionData.getCompileStderr() == null && this.executionData.getCompileStdout() == null) {
                errnoIndex = this.errorString.indexOf(61) + 1;
                String errorMessage = this.errorString.substring(errnoIndex).equals("2") ? "Compiler not found, contact staff." : "Problem executing compiler, contact staff.";
                this.showDialogToUser(errorMessage);
                this.setException(errorMessage);
                this.fileViewer.addTextPane("Error during compile", errorMessage);
            }
            this.fileViewer.setTitle("Executable");
            String outputFile = this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME);
            File file = new File(outputFile);
            if (file.isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Validator output", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Validator stderr", outputFile);
            }
            outputFile = this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME);
            file = new File(outputFile);
            boolean programGeneratedOutput = false;
            if (file.isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program output", outputFile);
                programGeneratedOutput = true;
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Program stderr", outputFile);
                programGeneratedOutput = true;
            }
            if (!programGeneratedOutput) {
                String message = "PC2: execution of program did not generate any output";
                if (!this.executionData.isCompileSuccess()) {
                    String errorMessage = "Unable to find/execute compiler using command: " + this.language.getCompileCommandLine();
                    if (this.executionData.getExecutionException() != null) {
                        errorMessage = String.valueOf(errorMessage) + NL + this.executionData.getExecutionException().getMessage();
                    }
                    message = String.valueOf(message) + NL + errorMessage;
                }
                this.fileViewer.addTextPane("Program output", message);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stdout", outputFile);
            }
            if ((file = new File(outputFile = this.prefixExecuteDirname(COMPILER_STDERR_FILENAME))).isFile() && file.length() > 0L) {
                this.fileViewer.addFilePane("Compiler stderr", outputFile);
            }
            if (this.executionData.getExecuteExitValue() != 0) {
                long returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                this.fileViewer.setInformationLabelText("<html><font size='+1' color='red'>Team program exit code = 0x" + Long.toHexString(returnValue).toUpperCase() + "</font>");
            } else {
                this.fileViewer.setInformationLabelText("");
            }
            if (!this.isTestRunOnly() && this.problem.isShowCompareWindow()) {
                String teamsOutputFileName = this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME);
                if (this.problem.getAnswerFileName() != null && this.problem.getAnswerFileName().length() > 0) {
                    String answerFileName = this.prefixExecuteDirname(this.problem.getAnswerFileName());
                    if (!new File(answerFileName).isFile()) {
                        int dataSetNumber = 0;
                        this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, answerFileName);
                    }
                    this.fileViewer.setCompareFileNames(answerFileName, teamsOutputFileName);
                    this.fileViewer.enableCompareButton(true);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception during execute() ", e);
            this.fileViewer.addTextPane("Error during execute", "Exception during execute, check log " + e.getMessage());
        }
        return this.fileViewer;
    }

    public String getFailureReason() {
        if (this.executionData.getExecutionException() != null) {
            return this.executionData.getExecutionException().getMessage();
        }
        if (this.executionData.getValidationResults() != null) {
            return this.executionData.getValidationResults();
        }
        return "Undetermined, developer note need another condition in getFailureReason()";
    }

    private boolean executeAndValidateDataSet(int dataSetNumber) {
        String reason;
        boolean passed = false;
        int testNumber = dataSetNumber + 1;
        this.log.info("  Test case " + testNumber + " execute, run " + this.run.getNumber());
        if (this.executeProgram(dataSetNumber) && this.isValidated()) {
            this.log.info("  Test case " + testNumber + " validate, run " + this.run.getNumber());
            passed = this.validateProgram(dataSetNumber);
            if (!ExecuteUtilities.didTeamSolveProblem(this.executionData)) {
                passed = false;
            }
        } else {
            passed = false;
        }
        reason = (reason = this.getFailureReason()) == null ? "" : "; validator returns: " + reason;
        this.log.info("  Test case " + testNumber + " passed = " + Utilities.yesNoString(passed) + " " + reason);
        JudgementRecord record = JudgementUtilites.createJudgementRecord(this.contest, this.run, this.executionData, this.executionData.getValidationResults());
        RunTestCase runTestCase = new RunTestCase(this.run, record, testNumber, passed);
        runTestCase.setElapsedMS(this.executionData.getExecuteTimeMS());
        this.run.addTestCase(runTestCase);
        return passed;
    }

    public boolean createFile(SerializedFile[] fileList, int setNumber, String outputFileName) {
        if (fileList != null && setNumber < fileList.length) {
            return this.createFile(fileList[setNumber], outputFileName);
        }
        return false;
    }

    protected boolean createFile(SerializedFile file, String filename) {
        try {
            return Utilities.createFile(file, filename);
        }
        catch (IOException e) {
            this.log.log(Log.INFO, "Could not create " + filename, e);
            return false;
        }
    }

    protected void showDialogToUser(String string) {
        if (this.showMessageToUser) {
            if (this.usingGUI) {
                this.fileViewer.showMessage(string);
            }
            this.log.info(string);
        }
    }

    public boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            this.log.log(Log.CONFIG, "Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
            this.setException("Executable.execute(RunData): Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    protected boolean validateProgram(int dataSetNumber) {
        Process process;
        long startSecs;
        BufferedOutputStream stderrlog;
        BufferedOutputStream stdoutlog;
        String resultsFileName;
        block31: {
            this.executionData.setValidationReturnCode(-1L);
            this.executionData.setValidationSuccess(false);
            if (this.isJudge()) {
                this.controller.sendValidatingMessage(this.run);
            }
            if (this.problemDataFiles != null && this.problemDataFiles.getValidatorFile() != null) {
                String validatorFileName = this.problemDataFiles.getValidatorFile().getName();
                String validatorUnpackName = this.prefixExecuteDirname(validatorFileName);
                if (!this.createFile(this.problemDataFiles.getValidatorFile(), validatorUnpackName)) {
                    this.log.info("Unable to create validator program " + validatorUnpackName);
                    this.setException("Unable to create validator program " + validatorUnpackName);
                    throw new SecurityException("Unable to create validator, check logs");
                }
                if (!validatorFileName.endsWith(".jar")) {
                    this.setExecuteBit(this.prefixExecuteDirname(validatorFileName));
                }
            }
            String judgeDataFilename = this.problem.getDataFileName();
            String judgeAnswerFilename = this.problem.getAnswerFileName();
            if (this.overwriteJudgesDataFiles) {
                if (this.problem.isUsingExternalDataFiles()) {
                    SerializedFile serializedFile = this.problemDataFiles.getJudgesDataFiles()[dataSetNumber];
                    judgeDataFilename = Utilities.locateJudgesDataFile(this.problem, serializedFile, this.getContestInformation().getJudgeCDPBasePath(), Utilities.DataFileType.JUDGE_DATA_FILE);
                    serializedFile = this.problemDataFiles.getJudgesAnswerFiles()[dataSetNumber];
                    judgeAnswerFilename = Utilities.locateJudgesDataFile(this.problem, serializedFile, this.getContestInformation().getJudgeCDPBasePath(), Utilities.DataFileType.JUDGE_DATA_FILE);
                } else {
                    if (this.problemDataFiles == null) {
                        throw new NullPointerException("Internal error - no data files present for problem " + this.problem);
                    }
                    this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getDataFileName()));
                    this.createFile(this.problemDataFiles.getJudgesAnswerFiles(), dataSetNumber, this.prefixExecuteDirname(this.problem.getAnswerFileName()));
                }
            }
            String secs = Long.toString(new Date().getTime() % 100L);
            int testSetNumber = dataSetNumber + 1;
            resultsFileName = String.valueOf(this.run.getNumber()) + secs + "XRSAM." + testSetNumber + ".txt";
            String commandPattern = this.problem.getValidatorCommandLine();
            boolean pc2JarUseDirectory = false;
            if (this.problem.isUsingPC2Validator()) {
                String pathToPC2Jar = this.findPC2JarPath();
                if (!new File(String.valueOf(pathToPC2Jar) + "pc2.jar").exists()) {
                    pc2JarUseDirectory = true;
                }
                commandPattern = "java -cp " + pathToPC2Jar + this.problem.getValidatorCommandLine();
            }
            this.log.log(Log.DEBUG, "before substitution: " + commandPattern);
            String cmdLine = this.replaceString(commandPattern, "{:infile}", judgeDataFilename);
            cmdLine = this.replaceString(cmdLine, "{:ansfile}", judgeAnswerFilename);
            cmdLine = this.substituteAllStrings(this.run, cmdLine);
            cmdLine = this.replaceString(cmdLine, "{:resfile}", resultsFileName);
            if (File.separator.equals("\\") && this.problem.isUsingPC2Validator()) {
                cmdLine = cmdLine.replaceFirst("-cp ", "-cp \"");
                cmdLine = cmdLine.replaceFirst("jar ", "jar\" ");
                this.log.log(Log.DEBUG, "after replaceFirst: " + cmdLine);
            }
            if (pc2JarUseDirectory) {
                cmdLine = ExecuteUtilities.replaceString(cmdLine, "pc2.jar", "");
            }
            this.log.log(Log.DEBUG, "after  substitution: " + cmdLine);
            try {
                String actFilename = new String(cmdLine);
                int i = actFilename.trim().indexOf(" ");
                actFilename = i > -1 ? String.valueOf(this.executeDirectoryName) + actFilename.trim().substring(0, i) : String.valueOf(this.executeDirectoryName) + actFilename.trim();
                File f = new File(actFilename);
                if (f.exists()) {
                    cmdLine = this.prefixExecuteDirname(cmdLine.trim());
                }
            }
            catch (Exception e) {
                this.log.log(Log.INFO, "Exception while constructing validator command line ", e);
                this.executionData.setExecutionException(e);
                throw new SecurityException(e);
            }
            stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME), false));
            stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME), false));
            String msg = "Working...";
            if (this.problem.isShowValidationToJudges()) {
                msg = "Validating...";
            }
            startSecs = System.currentTimeMillis();
            process = this.runProgram(cmdLine, msg, false);
            if (process != null) break block31;
            this.executionTimer.stopTimer();
            stderrlog.close();
            stdoutlog.close();
            return false;
        }
        try {
            BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
            BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
            IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
            IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
            this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
            this.executionTimer.setProc(process);
            stdoutCollector.start();
            stderrCollector.start();
            stdoutCollector.join();
            stderrCollector.join();
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            } else {
                this.log.config("validatorCall() executionTimer == null");
            }
            if (process != null) {
                process.destroy();
            }
            stdoutlog.close();
            stderrlog.close();
            this.executionData.setvalidateTimeMS(System.currentTimeMillis() - startSecs);
            this.executionData.setValidationStdout(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDOUT_FILENAME)));
            this.executionData.setValidationStderr(new SerializedFile(this.prefixExecuteDirname(VALIDATOR_STDERR_FILENAME)));
        }
        catch (Exception ex) {
            this.executionData.setExecutionException(ex);
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.CONFIG, "Exception in validator ", ex);
        }
        String validatorOutputFilename = this.prefixExecuteDirname("valout." + dataSetNumber + ".txt");
        this.createFile(this.executionData.getValidationStdout(), validatorOutputFilename);
        this.validatorOutputFilenames.add(validatorOutputFilename);
        String validatorStderrFilename = this.prefixExecuteDirname("valerr." + dataSetNumber + ".txt");
        this.createFile(this.executionData.getValidationStderr(), validatorStderrFilename);
        this.validatorStderrFilesnames.add(validatorStderrFilename);
        boolean fileThere = new File(this.prefixExecuteDirname(resultsFileName)).exists();
        try {
            try {
                if (fileThere) {
                    this.storeValidatorResults(resultsFileName, this.log);
                } else {
                    this.log.config("validationCall - Did not produce output results file " + resultsFileName);
                }
            }
            catch (Exception ex) {
                this.executionData.setExecutionException(ex);
                this.log.log(Log.INFO, "Exception while reading results file " + resultsFileName, ex);
                throw new SecurityException(ex);
            }
        }
        finally {
            if (this.executionData.isRunTimeLimitExceeded()) {
                this.executionData.setValidationResults("No - Time Limit Exceeded");
                this.executionData.setValidationSuccess(true);
            }
        }
        return this.executionData.isValidationSuccess();
    }

    private String getTeamOutputFilename(int dataSetNumber) {
        return this.prefixExecuteDirname("teamoutput." + dataSetNumber + ".txt");
    }

    protected void storeValidatorResults(String resultsFileName, Log logger) {
        XMLResultsParser parser = new XMLResultsParser();
        parser.setLog(this.log);
        boolean done = parser.parseValidatorResultsFile(this.prefixExecuteDirname(resultsFileName));
        Hashtable<String, String> results = parser.getResults();
        if (parser.getException() != null) {
            logger.log(Log.WARNING, "Exception parsing XML in file " + resultsFileName, parser.getException());
        } else if (done && results != null && results.containsKey("outcome")) {
            if (!this.problem.isInternationalJudgementReadMethod() || results.containsKey("security") && resultsFileName.equals(results.get("security"))) {
                this.executionData.setValidationResults(results.get("outcome"));
                this.executionData.setValidationSuccess(true);
            } else {
                this.setException("validationCall - results file did not contain security");
                logger.config("validationCall - results file did not contain security");
                logger.config(String.valueOf(resultsFileName) + " != " + results.get("security"));
            }
        } else if (!done) {
            this.setException("Error parsing/reading results file, check log");
            logger.config("Error parsing/reading results file, check log");
        } else if (results != null && !results.containsKey("outcome")) {
            this.setException("Error parsing/reading results file, check log");
            logger.config("Error could not find 'outcome' in results file, check log");
        } else {
            logger.config("Error parsing results file, check log");
        }
    }

    private void setException(String string) {
        this.executionData.setExecutionException(new Exception(string));
    }

    protected String findPC2JarPath() {
        String jarDir = ".";
        try {
            File dir;
            String defaultPath = new File("./build/prod").getCanonicalPath();
            if (!new File(defaultPath).exists()) {
                defaultPath = "/software/pc2/cc/projects/pc2-9.3/build/prod";
            }
            jarDir = defaultPath;
            String cp = System.getProperty("java.class.path");
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                File dir2 = new File(token);
                if (!dir2.exists() || !dir2.isFile() || !dir2.toString().endsWith("pc2.jar")) continue;
                jarDir = String.valueOf(new File(dir2.getParent()).getCanonicalPath()) + File.separator;
                break;
            }
            if (defaultPath.equals(jarDir) && (dir = new File("dist/pc2.jar")).isFile()) {
                jarDir = String.valueOf(new File(dir.getParent()).getCanonicalPath()) + File.separator;
            }
        }
        catch (IOException e) {
            this.log.log(Log.WARNING, "Trouble locating pc2home: " + e.getMessage(), e);
        }
        return jarDir;
    }

    public boolean isValidated() {
        return this.problem.isValidatedProblem() && !this.isTestRunOnly();
    }

    public String getFileNameFromUser() {
        String outFileName = null;
        JFileChooser chooser = new JFileChooser(this.mainFileDirectory);
        try {
            chooser.setDialogTitle("Open Test Input File");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                this.mainFileDirectory = chooser.getCurrentDirectory().getAbsolutePath();
                outFileName = chooser.getSelectedFile().getCanonicalFile().toString();
            }
        }
        catch (Exception e) {
            this.log.log(Log.CONFIG, "Error getting selected file, try again.", e);
        }
        chooser = null;
        return outFileName;
    }

    protected void selectAndCopyDataFile(String inputFileName) throws Exception {
        String pickedFileName = this.getFileNameFromUser();
        if (pickedFileName != null) {
            SerializedFile data = new SerializedFile(pickedFileName);
            if (data.getBuffer() == null) {
                throw new Exception("datafile does not exist/can not be read " + pickedFileName);
            }
            this.createFile(data, inputFileName);
            Object var3_3 = null;
        }
    }

    protected boolean executeProgram(int dataSetNumber) {
        Process process;
        long startSecs;
        BufferedOutputStream stderrlog;
        BufferedOutputStream stdoutlog;
        String inputDataFileName;
        boolean passed;
        block46: {
            passed = false;
            inputDataFileName = null;
            int testSetNumber = dataSetNumber + 1;
            if (this.isJudge()) {
                this.controller.sendExecutingMessage(this.run);
            }
            if (!this.isTestRunOnly()) {
                this.log.log(Log.INFO, "Executing run " + this.run.getNumber() + " from " + this.run.getSubmitter().getTripletKey() + " test set " + testSetNumber);
            }
            this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId, this.isUsingGUI());
            this.executionTimer.startTimer();
            if (this.problem.getDataFileName() != null) {
                if (this.problem.isReadInputDataFromSTDIN()) {
                    File output = File.createTempFile("__t", ".in", new File(this.getExecuteDirectoryName()));
                    inputDataFileName = this.prefixExecuteDirname(output.getName());
                    output.delete();
                } else {
                    inputDataFileName = this.prefixExecuteDirname(this.problem.getDataFileName());
                }
            }
            if (this.isTestRunOnly()) {
                if (inputDataFileName != null && this.problem.isReadInputDataFromSTDIN()) {
                    this.selectAndCopyDataFile(inputDataFileName);
                } else if (inputDataFileName != null) {
                    String sourceFileName = String.valueOf(this.getDirName(this.runFiles.getMainFile())) + File.separator + this.problem.getDataFileName();
                    SerializedFile dataFile = new SerializedFile(sourceFileName);
                    if (dataFile != null) {
                        this.createFile(dataFile, inputDataFileName);
                    }
                    dataFile = null;
                }
                if (inputDataFileName != null && !new File(inputDataFileName).isFile()) {
                    if (this.executionTimer != null) {
                        this.executionTimer.stopTimer();
                    }
                    throw new SecurityException("Expected data file, was not created, file name is " + this.problem.getDataFileName());
                }
            } else if (!this.problem.isUsingExternalDataFiles()) {
                if (inputDataFileName != null && this.problemDataFiles.getJudgesDataFiles() != null && this.overwriteJudgesDataFiles) {
                    if (!this.createFile(this.problemDataFiles.getJudgesDataFiles(), dataSetNumber, inputDataFileName)) {
                        throw new SecurityException("Unable to create data file " + inputDataFileName);
                    }
                    String actualDataFile = null;
                    try {
                        actualDataFile = this.problemDataFiles.getJudgesDataFiles()[dataSetNumber].getName();
                    }
                    catch (Exception e) {
                        actualDataFile = "Problem getting judge data file name for set " + dataSetNumber + " " + e.getMessage();
                        this.log.log(Log.DEBUG, e.toString(), e);
                    }
                    this.log.info("(Internal) Input data file: " + actualDataFile);
                }
            } else {
                SerializedFile serializedFile = this.problemDataFiles.getJudgesDataFiles()[dataSetNumber];
                String dataFileName = Utilities.locateJudgesDataFile(this.problem, serializedFile, this.getContestInformation().getJudgeCDPBasePath(), Utilities.DataFileType.JUDGE_DATA_FILE);
                if (dataFileName != null) {
                    File dataFile = new File(dataFileName);
                    inputDataFileName = dataFile.getCanonicalPath();
                    this.log.info("(External) Input data file: " + inputDataFileName);
                } else {
                    String expectedFileName = serializedFile.getName();
                    this.log.log(Log.DEBUG, "For problem " + this.problem + " test case " + testSetNumber + " expecting file " + expectedFileName + " in dir " + this.problem.getCCSfileDirectory());
                    FileNotFoundException notFound = new FileNotFoundException(String.valueOf(expectedFileName) + " for test case " + testSetNumber);
                    this.executionData.setExecutionException(notFound);
                    this.log.info("(External) Input data file: NOT FOUND ");
                }
            }
            stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME), false));
            stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME), false));
            String cmdline = this.language.getProgramExecuteCommandLine();
            if (!this.isTestRunOnly() && this.language.isUsingJudgeProgramExecuteCommandLine()) {
                cmdline = this.language.getJudgeProgramExecuteCommandLine();
                this.log.info("Using judge command line " + cmdline);
            }
            this.log.log(Log.DEBUG, "before substitution: " + cmdline);
            cmdline = this.substituteAllStrings(this.run, cmdline);
            this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
            String actFilename = new String(cmdline);
            int i = actFilename.trim().indexOf(" ");
            actFilename = i > -1 ? this.prefixExecuteDirname(actFilename.trim().substring(0, i)) : this.prefixExecuteDirname(actFilename.trim());
            File f = new File(actFilename);
            if (f.exists()) {
                cmdline = f.getCanonicalPath();
            }
            boolean autoStop = false;
            if (!this.isTestRunOnly()) {
                autoStop = true;
            }
            startSecs = System.currentTimeMillis();
            process = this.runProgram(cmdline, "Executing...", autoStop);
            if (process != null) break block46;
            this.executionTimer.stopTimer();
            stderrlog.close();
            stdoutlog.close();
            this.executionData.setExecuteSucess(false);
            return false;
        }
        try {
            String teamsOutputFilename;
            block48: {
                BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
                BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
                IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
                IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
                this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
                this.executionTimer.setProc(process);
                stdoutCollector.start();
                stderrCollector.start();
                if (inputDataFileName != null && this.problem.isReadInputDataFromSTDIN()) {
                    this.log.info("Using STDIN from file " + inputDataFileName);
                    BufferedOutputStream out = new BufferedOutputStream(process.getOutputStream());
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputDataFileName));
                    byte[] buf = new byte[32768];
                    try {
                        int c;
                        while ((c = in.read(buf)) != -1) {
                            out.write(buf, 0, c);
                        }
                    }
                    catch (IOException e) {
                        this.log.info("Caught a " + e.getMessage() + " do not be alarmed.");
                    }
                    in.close();
                    out.close();
                }
                stdoutCollector.join();
                stderrCollector.join();
                if (this.executionTimer != null) {
                    this.executionTimer.stopTimer();
                    this.executionData.setRunTimeLimitExceeded(this.executionTimer.isRunTimeLimitExceeded());
                    this.log.info("Run exceeded time limit " + this.problem.getTimeOutInSeconds() + " secs, Run = " + this.run);
                }
                if (process != null) {
                    int returnValue = process.waitFor();
                    this.executionData.setExecuteExitValue(returnValue);
                    process.destroy();
                }
                stdoutlog.close();
                stderrlog.close();
                this.executionData.setExecuteSucess(true);
                this.executionData.setExecuteTimeMS(System.currentTimeMillis() - startSecs);
                this.executionData.setExecuteProgramOutput(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDOUT_FILENAME)));
                this.executionData.setExecuteStderr(new SerializedFile(this.prefixExecuteDirname(EXECUTE_STDERR_FILENAME)));
                SerializedFile userOutputFile = this.executionData.getExecuteProgramOutput();
                this.createFile(userOutputFile, this.prefixExecuteDirname(userOutputFile.getName()));
                teamsOutputFilename = this.getTeamOutputFilename(dataSetNumber);
                this.createFile(userOutputFile, teamsOutputFilename);
                this.teamsOutputFilenames.add(teamsOutputFilename);
                if (this.executionData.getExecuteExitValue() != 0) {
                    long returnValue = (long)this.executionData.getExecuteExitValue() << 32 >>> 32;
                    PrintWriter exitCodeFile = null;
                    try {
                        try {
                            exitCodeFile = new PrintWriter(new FileOutputStream(this.prefixExecuteDirname(EXIT_CODE_FILENAME), false), true);
                            exitCodeFile.write("0x" + Long.toHexString(returnValue).toUpperCase());
                        }
                        catch (FileNotFoundException e) {
                            this.log.log(Log.WARNING, "Unable to open/write file EXITCODE.TXT", e);
                            exitCodeFile = null;
                            if (exitCodeFile != null) {
                                exitCodeFile.close();
                            }
                            break block48;
                        }
                    }
                    catch (Throwable throwable) {
                        if (exitCodeFile != null) {
                            exitCodeFile.close();
                        }
                        throw throwable;
                    }
                    if (exitCodeFile != null) {
                        exitCodeFile.close();
                    }
                }
            }
            if (this.executionData.getExecuteStderr() != null) {
                byte[] errBuff = this.executionData.getExecuteStderr().getBuffer();
                FileOutputStream outputStream = null;
                try {
                    if (errBuff != null && errBuff.length > 0) {
                        outputStream = new FileOutputStream(teamsOutputFilename, true);
                        outputStream.write(("*** Team STDERR Follows:" + NL).getBytes());
                        outputStream.write(errBuff, 0, errBuff.length);
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log.log(Log.WARNING, "Unable to append to file " + teamsOutputFilename, e);
                }
            }
            passed = true;
        }
        catch (Exception e) {
            if (this.executionTimer != null) {
                this.executionTimer.stopTimer();
            }
            this.log.log(Log.INFO, "Exception in executeProgram()", e);
            this.executionData.setExecutionException(e);
            throw new SecurityException(e);
        }
        return passed;
    }

    protected boolean isValidDataFile(Problem inProblem) {
        boolean result = false;
        if (inProblem.getDataFileName() != null && inProblem.getDataFileName().trim().length() > 0) {
            result = true;
        }
        if (inProblem.isUsingExternalDataFiles()) {
            return true;
        }
        return result;
    }

    private boolean isJudge() {
        return this.contest.getClientId().getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    protected boolean compileProgram() {
        block13: {
            block12: {
                Process process;
                long startSecs;
                BufferedOutputStream stderrlog;
                BufferedOutputStream stdoutlog;
                String programName;
                File program;
                block11: {
                    try {
                        if (this.isJudge()) {
                            this.controller.sendCompilingMessage(this.run);
                        }
                        if ((program = new File(this.prefixExecuteDirname(programName = this.replaceString(this.language.getExecutableIdentifierMask(), "{:basename}", this.removeExtension(this.runFiles.getMainFile().getName()))))).exists()) {
                            this.log.config("Team submitted an executable " + programName);
                            program.delete();
                        }
                        this.log.log(Log.DEBUG, "before substitution: " + this.language.getCompileCommandLine());
                        String cmdline = this.substituteAllStrings(this.run, this.language.getCompileCommandLine());
                        this.log.log(Log.DEBUG, "after  substitution: " + cmdline);
                        stdoutlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME), false));
                        stderrlog = new BufferedOutputStream(new FileOutputStream(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME), false));
                        this.executionTimer = new ExecuteTimer(this.log, this.problem.getTimeOutInSeconds(), this.executorId, this.isUsingGUI());
                        this.executionTimer.startTimer();
                        startSecs = System.currentTimeMillis();
                        process = this.runProgram(cmdline, "Compiling...", false);
                        if (process != null) break block11;
                        this.executionTimer.stopTimer();
                        stderrlog.close();
                        stdoutlog.close();
                        this.executionData.setCompileExeFileName("");
                        this.executionData.setCompileSuccess(false);
                        this.executionData.setCompileResultCode(1L);
                        return false;
                    }
                    catch (Exception e) {
                        if (this.executionTimer != null) {
                            this.executionTimer.stopTimer();
                        }
                        this.log.log(Log.INFO, "Exception ", e);
                        throw new SecurityException(e);
                    }
                }
                BufferedInputStream childOutput = new BufferedInputStream(process.getInputStream());
                BufferedInputStream childError = new BufferedInputStream(process.getErrorStream());
                IOCollector stdoutCollector = new IOCollector(this.log, childOutput, stdoutlog, this.executionTimer, this.getMaxFileSize() + 50L);
                IOCollector stderrCollector = new IOCollector(this.log, childError, stderrlog, this.executionTimer, this.getMaxFileSize() + 50L);
                this.executionTimer.setIOCollectors(stdoutCollector, stderrCollector);
                this.executionTimer.setProc(process);
                stdoutCollector.start();
                stderrCollector.start();
                stdoutCollector.join();
                stderrCollector.join();
                if (this.executionTimer != null) {
                    this.executionTimer.stopTimer();
                } else {
                    this.log.config("compileCall() executionTimer == null");
                }
                if (process != null) {
                    process.destroy();
                }
                stdoutlog.close();
                stderrlog.close();
                this.executionData.setCompileTimeMS(System.currentTimeMillis() - startSecs);
                this.executionData.setCompileStdout(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDOUT_FILENAME)));
                this.executionData.setCompileStderr(new SerializedFile(this.prefixExecuteDirname(COMPILER_STDERR_FILENAME)));
                program = new File(this.prefixExecuteDirname(programName));
                if (!program.exists()) break block12;
                this.executionData.setCompileExeFileName(programName);
                this.executionData.setCompileSuccess(true);
                this.executionData.setCompileResultCode(0L);
                return true;
            }
            if (!this.language.isInterpreted()) break block13;
            this.executionData.setCompileExeFileName(this.runFiles.getMainFile().getName());
            this.executionData.setCompileSuccess(true);
            this.executionData.setCompileResultCode(0L);
            return true;
        }
        this.executionData.setCompileExeFileName("");
        this.executionData.setCompileSuccess(false);
        this.executionData.setCompileResultCode(2L);
        return false;
    }

    private long getMaxFileSize() {
        return this.contest.getContestInformation().getMaxFileSize();
    }

    public String replaceString(String origString, String beforeString, String afterString) {
        if (origString == null || afterString == null) {
            return origString;
        }
        int startIdx = origString.lastIndexOf(beforeString);
        if (startIdx == -1) {
            return origString;
        }
        StringBuffer buf = new StringBuffer(origString);
        while (startIdx != -1) {
            buf.replace(startIdx, startIdx + beforeString.length(), afterString);
            startIdx = origString.lastIndexOf(beforeString, startIdx - 1);
        }
        return buf.toString();
    }

    public String replaceString(String origString, String beforeString, int afterInt) {
        String afterString = new Integer(afterInt).toString();
        return this.replaceString(origString, beforeString, afterString);
    }

    public String substituteAllStrings(Run inRun, String origString) {
        String newString = "";
        String nullArgument = "-";
        try {
            String pc2home;
            int index;
            SerializedFile validatorFile;
            if (inRun == null) {
                throw new IllegalArgumentException("Run is null");
            }
            if (this.runFiles.getMainFile() == null) {
                this.log.config("substituteAllStrings() main file is null (no contents)");
                return origString;
            }
            newString = this.replaceString(origString, "{:mainfile}", this.runFiles.getMainFile().getName());
            newString = this.replaceString(newString, "{:basename}", this.removeExtension(this.runFiles.getMainFile().getName()));
            String validatorCommand = null;
            if (this.problem.getValidatorProgramName() != null) {
                validatorCommand = this.problem.getValidatorProgramName();
            }
            if (this.problemDataFiles != null && (validatorFile = this.problemDataFiles.getValidatorFile()) != null) {
                validatorCommand = validatorFile.getName();
            }
            if (validatorCommand != null) {
                newString = this.replaceString(newString, "{:validator}", validatorCommand);
            }
            if (inRun.getLanguageId() != null) {
                Language[] langs = this.contest.getLanguages();
                index = 0;
                String displayName = "";
                int i = 0;
                while (i < langs.length) {
                    if (langs[i] != null && langs[i].getElementId().equals(inRun.getLanguageId())) {
                        displayName = langs[i].getDisplayName().toLowerCase().replaceAll(" ", "_");
                        index = i + 1;
                        break;
                    }
                    ++i;
                }
                if (index > 0) {
                    newString = this.replaceString(newString, "{:language}", index);
                    newString = this.replaceString(newString, "{:languageletter}", Utilities.convertNumber(index));
                    newString = this.replaceString(newString, "{:languagename}", displayName);
                }
            }
            if (inRun.getProblemId() != null) {
                Problem[] problems = this.contest.getProblems();
                index = 0;
                int i = 0;
                while (i < problems.length) {
                    if (problems[i] != null && problems[i].getElementId().equals(inRun.getProblemId())) {
                        index = i + 1;
                        break;
                    }
                    ++i;
                }
                if (index > 0) {
                    newString = this.replaceString(newString, "{:problem}", index);
                    newString = this.replaceString(newString, "{:problemletter}", Utilities.convertNumber(index));
                }
            }
            if (inRun.getSubmitter() != null) {
                newString = this.replaceString(newString, "{:teamid}", inRun.getSubmitter().getClientNumber());
                newString = this.replaceString(newString, "{:siteid}", inRun.getSubmitter().getSiteNumber());
            }
            if (this.problem != null) {
                newString = this.problem.getDataFileName() != null && !this.problem.getDataFileName().equals("") ? this.replaceString(newString, "{:infile}", this.problem.getDataFileName()) : this.replaceString(newString, "{:infile}", nullArgument);
                newString = this.problem.getAnswerFileName() != null && !this.problem.getAnswerFileName().equals("") ? this.replaceString(newString, "{:ansfile}", this.problem.getAnswerFileName()) : this.replaceString(newString, "{:ansfile}", nullArgument);
                newString = this.replaceString(newString, "{:timelimit}", Long.toString(this.problem.getTimeOutInSeconds()));
            } else {
                this.log.config("substituteAllStrings() problem is undefined (null)");
            }
            if (this.executionData != null) {
                if (this.executionData.getExecuteProgramOutput() != null) {
                    newString = this.executionData.getExecuteProgramOutput().getName() != null ? this.replaceString(newString, "{:outfile}", this.executionData.getExecuteProgramOutput().getName()) : this.replaceString(newString, "{:outfile}", nullArgument);
                }
                newString = this.replaceString(newString, "{:exitvalue}", Integer.toString(this.executionData.getExecuteExitValue()));
                newString = this.replaceString(newString, "{:executetime}", Long.toString(this.executionData.getExecuteTimeMS()));
            }
            if ((pc2home = new VersionInfo().locateHome()) != null && pc2home.length() > 0) {
                newString = this.replaceString(newString, "{:pc2home}", pc2home);
            }
        }
        catch (Exception e) {
            this.log.log(Log.CONFIG, "Exception substituting strings ", e);
        }
        return newString;
    }

    public String removeExtension(String original) {
        String outString = new String(original);
        int dotIndex = outString.lastIndexOf(46, outString.length() - 1);
        if (dotIndex != -1) {
            outString = outString.substring(0, dotIndex);
        }
        return outString;
    }

    protected String getDirName(SerializedFile file) {
        String absPath = file.getAbsolutePath();
        return absPath.substring(0, absPath.length() - 1 - file.getName().length());
    }

    public Process runProgram(String cmdline, String msg, boolean autoStopExecution) {
        Process process = null;
        this.errorString = "";
        this.executeDirectoryName = this.getExecuteDirectoryName();
        try {
            File runDir = new File(this.executeDirectoryName);
            if (runDir.isDirectory()) {
                this.log.config("executing: '" + cmdline + "'");
                String[] env = null;
                if (this.executionTimer != null) {
                    this.executionTimer.setDoAutoStop(autoStopExecution);
                    this.executionTimer.setTitle(msg);
                }
                process = Runtime.getRuntime().exec(cmdline, env, runDir);
                if (this.executionTimer != null) {
                    this.executionTimer.setProc(process);
                    this.executionTimer.startTimer();
                }
            } else {
                this.errorString = "Execute Directory does not exist";
                this.log.config("Execute Directory does not exist");
            }
        }
        catch (IOException e) {
            this.errorString = e.getMessage();
            this.log.config("Note: exec failed in RunProgram " + this.errorString);
            this.executionData.setExecutionException(e);
            return null;
        }
        catch (Exception e) {
            this.errorString = e.getMessage();
            this.log.log(Log.CONFIG, "Note: exec failed in RunProgram " + this.errorString, e);
            this.executionData.setExecutionException(e);
            return null;
        }
        return process;
    }

    private void setExecuteBit(String filename) {
        this.log.config("setExecuteBit for " + filename);
        try {
            File chmodFile = new File("/bin/chmod");
            if (chmodFile.exists()) {
                String cmdline = "/bin/chmod +x " + filename;
                this.log.config("executing chmod: '" + cmdline + "'");
                Process process = Runtime.getRuntime().exec(cmdline);
                process.waitFor();
            }
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "Exception in setExecuteBit()  ", ex);
        }
    }

    public String getValidationResults() {
        return this.executionData.getValidationResults();
    }

    public ExecutionData getExecutionData() {
        return this.executionData;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public String getExecuteDirectoryName() {
        return "executesite" + this.contest.getClientId().getSiteNumber() + this.contest.getClientId().getName() + this.getExecuteDirectoryNameSuffix();
    }

    public String prefixExecuteDirname(String filename) {
        return String.valueOf(this.getExecuteDirectoryName()) + File.separator + filename;
    }

    public boolean isOverwriteJudgesDataFiles() {
        return this.overwriteJudgesDataFiles;
    }

    public void setOverwriteJudgesDataFiles(boolean overwriteDataFiles) {
        this.overwriteJudgesDataFiles = overwriteDataFiles;
    }

    public boolean isTestRunOnly() {
        return this.testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public void setTestRunOnly(boolean testRunOnly) {
        this.testRunOnly = testRunOnly || this.executorId.getClientType() == ClientType.Type.TEAM;
    }

    public boolean isValidationSuccess() {
        return this.executionData.isValidationSuccess();
    }

    public boolean isShowMessageToUser() {
        return this.showMessageToUser;
    }

    public void setShowMessageToUser(boolean showMessageToUser) {
        this.showMessageToUser = showMessageToUser;
    }

    public String getExecuteDirectoryNameSuffix() {
        return this.executeDirectoryNameSuffix;
    }

    public void setExecuteDirectoryName(String executeDirectoryName) {
        this.executeDirectoryName = executeDirectoryName;
    }

    public void setExecuteBaseDirectoryName(String baseDirectoryName) throws Exception {
        this.insureDir(baseDirectoryName);
        if (!this.isDirectory(baseDirectoryName)) {
            throw new IOException("Could not create directory " + baseDirectoryName);
        }
        String dirname = String.valueOf(baseDirectoryName) + File.separator + this.executeDirectoryName;
        this.insureDir(baseDirectoryName);
        if (!this.isDirectory(dirname)) {
            throw new IOException("Could not create directory " + dirname);
        }
        this.executeDirectoryName = dirname;
    }

    private boolean isDirectory(String dirname) {
        return new File(dirname).isDirectory();
    }

    public void setExecuteDirectoryNameSuffix(String executeDirectoryNameSuffix) {
        this.executeDirectoryNameSuffix = executeDirectoryNameSuffix;
    }

    public void setUsingGUI(boolean usingGUI) {
        this.usingGUI = usingGUI;
    }

    public boolean isUsingGUI() {
        return this.usingGUI;
    }

    @Override
    public IFileViewer execute(IInternalContest inContest, IInternalController inController, Run aRun, RunFiles aRunFiles, boolean clearDirFirst) {
        this.contest = inContest;
        this.controller = inController;
        this.runFiles = aRunFiles;
        this.run = aRun;
        this.language = inContest.getLanguage(aRun.getLanguageId());
        this.problem = inContest.getProblem(aRun.getProblemId());
        this.initialize();
        return this.execute(clearDirFirst);
    }

    @Override
    public String getPluginTitle() {
        return "Executeable";
    }

    @Override
    public void dispose() {
        this.executionData = null;
        this.executionTimer = null;
        this.fileViewer = null;
    }

    public ContestInformation getContestInformation() {
        return this.contest.getContestInformation();
    }

    public List<String> getTeamsOutputFilenames() {
        return this.teamsOutputFilenames;
    }

    public List<String> getValidatorOutputFilenames() {
        return this.validatorOutputFilenames;
    }

    public List<String> getValidatorErrFilenames() {
        return this.validatorStderrFilesnames;
    }
}

