/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.ui.FrameUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RetryDialog
extends JDialog {
    private Runnable reconnectRunnable = null;
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private JButton retryButton = null;
    private JButton exitButton = null;

    public RetryDialog() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(496, 209));
        this.setContentPane(this.getMainPanel());
        this.setDefaultCloseOperation(0);
        this.setTitle("Disconnected");
        FrameUtilities.centerFrame(this);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getButtonPanel(), "South");
            this.mainPanel.add((Component)this.getMessagePanel(), "Center");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(60);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getRetryButton(), null);
            this.buttonPanel.add((Component)this.getExitButton(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("Disconnected from server");
            this.messageLabel.setHorizontalTextPosition(0);
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private JButton getRetryButton() {
        if (this.retryButton == null) {
            this.retryButton = new JButton();
            this.retryButton.setText("Retry");
            this.retryButton.setMnemonic(82);
            this.retryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RetryDialog.this.setTitle("Retrying... ");
                    if (RetryDialog.this.reconnectRunnable != null) {
                        RetryDialog.this.reconnectRunnable.run();
                    }
                }
            });
        }
        return this.retryButton;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit / Abort");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RetryDialog.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    public void setMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RetryDialog.this.messageLabel.setText(message);
            }
        });
    }

    public Runnable getReconnectRunnable() {
        return this.reconnectRunnable;
    }

    public void setReconnectRunnable(Runnable reconnectRunnable) {
        this.reconnectRunnable = reconnectRunnable;
    }
}

