/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.RetryDialog;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.packet.Packet;
import java.util.Random;

public class Reconnector
implements Runnable {
    private RetryDialog retryDialog = null;
    private IInternalContest contest = null;
    private int maxConnectionRetries = 3;
    private Random r = new Random();
    private boolean connected = true;
    private String loginName = null;
    private String password = null;
    private int retryCount = 0;

    public Reconnector(String loginName, String password) {
        this.loginName = loginName;
        this.password = password;
        this.r.setSeed(System.nanoTime());
    }

    void setContestAndController(IInternalContest inContest, IInternalController inController) {
    }

    public void handleDisconnection(Packet packet) {
        this.addPacketToList(packet);
        this.connected = false;
        this.attemptReconnection(this.loginName, this.password);
        this.showRetryDialog();
    }

    private void attemptReconnection(String loginName2, String password2) {
        this.connected = false;
        this.maxConnectionRetries = this.contest.getMaxConnectionRetries();
        this.retryCount = 0;
        while (!this.connected && this.retryCount < this.maxConnectionRetries) {
            this.retryConnection();
        }
    }

    private void showRetryDialog() {
        if (this.retryDialog == null) {
            this.retryDialog = new RetryDialog();
            this.retryDialog.setReconnectRunnable(this);
        }
        this.retryDialog.setTitle("Disconnected from server");
        this.retryDialog.setMessage("Disconnected from server");
        this.retryDialog.setVisible(true);
    }

    private void addPacketToList(Packet packet) {
    }

    private void retryConnection() {
        int maxMSecs = this.contest.getMaxRetryMSecs();
        try {
            int msec = this.r.nextInt(maxMSecs);
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ++this.retryCount;
    }

    @Override
    public void run() {
        this.retryDialog.setTitle("Attempting to reconnect...");
        this.retryDialog.setMessage("Attempting to reconnect to server");
        this.attemptReconnection(this.loginName, this.password);
    }

    public static void main(String[] args) {
        Reconnector reconnector = new Reconnector("login", "password");
        reconnector.handleDisconnection(null);
    }
}

