/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.NoteMessage;
import java.util.ArrayList;
import java.util.Vector;

public class NoteList {
    public static final String NO_FILENAME = "<no filename>";
    private ArrayList<NoteMessage> notes = new ArrayList();

    public NoteList() {
    }

    public NoteList(NoteMessage[] list) {
        NoteMessage[] noteMessageArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            NoteMessage noteMessage = noteMessageArray[n2];
            this.notes.add(noteMessage);
            ++n2;
        }
    }

    public NoteMessage[] get(NoteMessage.Type type) {
        Vector<NoteMessage> outVector = new Vector<NoteMessage>();
        int i = 0;
        while (i < this.notes.size()) {
            NoteMessage noteMessage = this.notes.get(i);
            if (noteMessage.getType().equals((Object)type)) {
                outVector.add(noteMessage);
            }
            ++i;
        }
        return outVector.toArray(new NoteMessage[outVector.size()]);
    }

    public NoteMessage[] getAll() {
        return this.notes.toArray(new NoteMessage[this.notes.size()]);
    }

    public int size() {
        return this.notes.size();
    }

    public int getCount(NoteMessage.Type type) {
        if (this.notes.size() == 0) {
            return 0;
        }
        return this.get(type).length;
    }

    public void log(NoteMessage message) {
        this.notes.add(message);
    }

    public void log(NoteMessage.Type type, String filename, int lineNumber, String comment) {
        NoteMessage noteMessage = new NoteMessage(type, filename, lineNumber, comment);
        this.notes.add(noteMessage);
    }

    public void log(NoteMessage.Type type, String filename, int lineNumber, String comment, Exception exception) {
        NoteMessage noteMessage = new NoteMessage(type, filename, lineNumber, comment, exception);
        this.notes.add(noteMessage);
    }

    public void logError(String filename, int lineNumber, String comment) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.ERROR, filename, lineNumber, comment);
        this.notes.add(noteMessage);
    }

    public void logError(String filename, int lineNumber, String comment, Exception exception) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.ERROR, filename, lineNumber, comment, exception);
        this.notes.add(noteMessage);
    }

    public void logInfo(String filename, int lineNumber, String comment) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.INFORMATION, filename, lineNumber, comment);
        this.notes.add(noteMessage);
    }

    public void logInfo(String filename, int lineNumber, String comment, Exception exception) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.INFORMATION, filename, lineNumber, comment, exception);
        this.notes.add(noteMessage);
    }

    public void logWarning(String filename, int lineNumber, String comment) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.WARNING, filename, lineNumber, comment);
        this.notes.add(noteMessage);
    }

    public void logWarning(String filename, int lineNumber, String comment, Exception exception) {
        NoteMessage noteMessage = new NoteMessage(NoteMessage.Type.WARNING, filename, lineNumber, comment, exception);
        this.notes.add(noteMessage);
    }

    public void removeAll() {
        this.notes = new ArrayList();
    }

    public void logError(String string, Exception e) {
        this.logError(NO_FILENAME, 0, string, e);
    }

    public void logWarning(String string, Exception e) {
        this.logWarning(NO_FILENAME, 0, string, e);
    }

    public void logInfo(String string, Exception e) {
        this.logInfo(NO_FILENAME, 0, string, e);
    }
}

