/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import java.io.Serializable;
import java.util.ArrayList;

public class InternalControllerSpecial
extends InternalController {
    private PacketConnectionManager manager = new PacketConnectionManager();

    public InternalControllerSpecial(IInternalContest contest) {
        super(contest);
        this.setConnectionManager(this.manager);
        Log logger = new Log("InternalControllerSpecial.log");
        this.setLog(logger);
    }

    public Packet[] getPacketList() {
        return this.manager.getPacketList();
    }

    public Packet getLastPacket() {
        Packet[] list = this.getPacketList();
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public void clearPacketList() {
        this.manager.clearPacketList();
    }

    protected class PacketConnectionManager
    implements ITransportManager {
        private ArrayList<Packet> packetList = new ArrayList();

        protected PacketConnectionManager() {
        }

        public Packet[] getPacketList() {
            return this.packetList.toArray(new Packet[this.packetList.size()]);
        }

        public void clearPacketList() {
            this.packetList = new ArrayList();
        }

        @Override
        public void connectToMyServer() throws TransportException {
        }

        @Override
        public void send(Serializable serializable) throws TransportException {
            this.packetList.add((Packet)serializable);
        }

        @Override
        public void send(Serializable serializable, ConnectionHandlerID connectionHandlerID) throws TransportException {
            this.packetList.add((Packet)serializable);
        }

        @Override
        public ConnectionHandlerID connectToServer(String serverIP, int port) throws TransportException {
            return null;
        }

        @Override
        public void startClientTransport(String serverIP, int port, IBtoA appCallBack) {
        }

        @Override
        public void shutdownTransport() {
        }

        @Override
        public void setLog(Log log) {
        }

        @Override
        public void accecptConnections(int listeningPort) throws TransportException {
        }

        @Override
        public void unregisterConnection(ConnectionHandlerID myConnectionID) {
        }

        @Override
        public void startServerTransport(ITwoToOne appCallBack) {
        }
    }
}

