/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.ccs.RunSubmitterInterfaceManager;
import edu.csus.ecs.pc2.core.ContestLoader;
import edu.csus.ecs.pc2.core.ICountDownMessage;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Ini;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.PacketHandler;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.archive.PacketArchiver;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.ProfileException;
import edu.csus.ecs.pc2.core.exception.ServerProcessException;
import edu.csus.ecs.pc2.core.log.EvaluationLog;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IPacketListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.core.model.PacketEvent;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.packet.PacketType;
import edu.csus.ecs.pc2.core.report.ContestSummaryReports;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.connection.ConnectionManager;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import edu.csus.ecs.pc2.profile.ProfileManager;
import edu.csus.ecs.pc2.ui.ILogWindow;
import edu.csus.ecs.pc2.ui.ILoginUI;
import edu.csus.ecs.pc2.ui.IStartupContestDialog;
import edu.csus.ecs.pc2.ui.LoadUIClass;
import edu.csus.ecs.pc2.ui.TextCountDownMessage;
import edu.csus.ecs.pc2.ui.UIPlugin;
import edu.csus.ecs.pc2.ui.UIPluginList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;

public class InternalController
implements IInternalController,
ITwoToOne,
IBtoA {
    private static final String INI_FILENAME_OPTION_STRING = "--ini";
    private static final String PROFILE_OPTION_STRING = "--profile";
    private static final String FILE_OPTION_STRING = "-F";
    private static final String NO_GUI_OPTION_STRING = "--nogui";
    private boolean haltOnFatalError = true;
    private IInternalContest contest;
    private ITransportManager connectionManager;
    private Vector<IPacketListener> packetListenerList = new Vector();
    private UIPlugin uiPlugin = null;
    private boolean usingGUI = true;
    private Log log;
    private Ini ini = new Ini();
    private static final String DEBUG_OPTION_STRING = "--debug";
    private static final String LOGIN_OPTION_STRING = "--login";
    private static final String PASSWORD_OPTION_STRING = "--password";
    private static int port;
    private String remoteHostName = "127.0.0.1";
    private int remoteHostPort;
    private static final String SERVER_PORT_KEY = "server.port";
    private static final String REMOTE_SERVER_KEY = "server.remoteServer";
    private static final String CLIENT_SERVER_KEY = "client.server";
    private static final String CLIENT_PORT_KEY = "client.port";
    private static ConnectionHandlerID remoteServerConnectionHandlerID;
    private ParseArguments parseArguments = new ParseArguments();
    private boolean contactingRemoteServer = true;
    private boolean usingMainUI = true;
    private PacketArchiver packetArchiver = null;
    private ILoginUI loginUI;
    private boolean isStarted = false;
    private PacketHandler packetHandler = null;
    private boolean serverModule = false;
    private boolean saveCofigurationToDisk = true;
    private EvaluationLog evaluationLog;
    public static final int SECURITY_HIGH_LEVEL = 10;
    public static final int SECURITY_NONE_LEVEL = 0;
    private static final String CONTEST_PASSWORD_OPTION = "--contestpassword";
    private static final String MAIN_UI_OPTION = "--ui";
    private static final String LOG_WINDOW_GUI_CLASS = "edu.csus.ecs.pc2.ui.LogWindow";
    private String logWindowClassName = "edu.csus.ecs.pc2.ui.LogWindow";
    private static final String STARTUP_DIALOG_GUI_CLASS = "edu.csus.ecs.pc2.ui.server.StartupContestDialog";
    private static final String LOGIN_UI_GUI_CLASSNAME = "edu.csus.ecs.pc2.ui.LoginFrame";
    private static final String COUNTDOWN_UI_CLASSNAME = "edu.csus.ecs.pc2.ui.CountDownMessage";
    private String loginClassName = "edu.csus.ecs.pc2.ui.LoginFrame";
    private String startupDialogClassName = "edu.csus.ecs.pc2.ui.server.StartupContestDialog";
    private String countdownClassName = "edu.csus.ecs.pc2.ui.CountDownMessage";
    private IStartupContestDialog startDialog;
    private int securityLevel = 10;
    private boolean clientAutoShutdown = true;
    private String overRideUIName = null;
    private UIPluginList pluginList = new UIPluginList();
    private Profile theProfile = null;
    private ILogWindow logWindow = null;
    private RunSubmitterInterfaceManager runSubmitterInterfaceManager = new RunSubmitterInterfaceManager();

    static {
        remoteServerConnectionHandlerID = null;
    }

    public InternalController(IInternalContest contest) {
        this.setContest(contest);
    }

    @Override
    public void sendToLocalServer(Packet packet) {
        if (this.isThisServer(packet.getSourceId()) && this.isServer()) {
            ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(this.contest.getClientId());
            this.processPacket(packet, connectionHandlerID);
            this.log.info("Loopback send packet to server " + packet);
            return;
        }
        try {
            this.log.info("Sending packet to server " + packet);
            if (this.contest.getProfile() != null) {
                packet.setContestIdentifier(this.contest.getContestIdentifier().toString());
            }
            this.connectionManager.send(packet);
            this.outgoingPacket(packet);
        }
        catch (TransportException e) {
            this.info("Unable to send to Server  " + packet);
            e.printStackTrace();
        }
        this.log.info("Sent    packet to server " + packet);
    }

    private boolean isThisServer(ClientId sourceId) {
        if (this.isServer(sourceId)) {
            return sourceId.getSiteNumber() == this.contest.getSiteNumber();
        }
        return false;
    }

    private void sendToClient(ConnectionHandlerID connectionHandlerID, Packet packet) {
        this.info("sendToClient (send) " + packet.getDestinationId() + " " + packet + " " + connectionHandlerID);
        try {
            packet.setContestIdentifier(this.contest.getContestIdentifier().toString());
            this.connectionManager.send(packet, connectionHandlerID);
            this.outgoingPacket(packet);
        }
        catch (TransportException e) {
            this.info("Unable to send to " + connectionHandlerID + " packet " + packet);
            e.printStackTrace();
        }
    }

    @Override
    public void sendToRemoteServer(int siteNumber, Packet packet) {
        ClientId clientId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
        this.info("sendToRemoteServer " + clientId + " " + packet + " " + connectionHandlerID);
        ClientType.Type type = packet.getSourceId().getClientType();
        if (!type.equals((Object)ClientType.Type.ADMINISTRATOR) && !type.equals((Object)ClientType.Type.SERVER)) {
            this.log.log(Log.WARNING, "Unexpected User sent packet to other (" + siteNumber + ") site.  " + packet);
        }
        if (connectionHandlerID != null) {
            try {
                packet.setContestIdentifier(this.contest.getContestIdentifier().toString());
                this.connectionManager.send(packet, connectionHandlerID);
                this.outgoingPacket(packet);
            }
            catch (TransportException e) {
                this.log.log(Log.SEVERE, "Exception sending packet to site " + siteNumber + " " + packet, e);
            }
        } else {
            this.log.log(Log.SEVERE, "Unable to send packet to site " + siteNumber + " (" + clientId + ")" + packet);
        }
    }

    @Override
    public void sendToClient(Packet packet) {
        this.info("sendToClient b4 to " + packet.getDestinationId() + " " + packet);
        ClientId toClientId = packet.getDestinationId();
        if (this.isThisSite(toClientId.getSiteNumber())) {
            if (this.contest.isLocalLoggedIn(toClientId)) {
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(toClientId);
                this.info("sendToClient " + packet.getSourceId() + " " + connectionHandlerID);
                this.sendToClient(connectionHandlerID, packet);
            } else {
                try {
                    this.packetArchiver.writeNextPacket(packet);
                    this.logWarning("Unable to send packet to " + toClientId + " not logged in.  Packet saved in: " + this.packetArchiver.getLastArchiveFilename());
                    this.sendMessage(MessageEvent.Area.OTHER, "Unable to send packet to " + toClientId + " not logged in. " + packet);
                }
                catch (Exception e) {
                    this.logWarning("Unable to send packet to " + toClientId + " could not save packet", e);
                    this.sendMessage(MessageEvent.Area.OTHER, "Unable to send packet to " + toClientId + " not logged in. " + packet, e);
                }
            }
        } else {
            this.sendToRemoteServer(toClientId.getSiteNumber(), packet);
        }
        this.info("sendToClient af to " + packet.getDestinationId() + " " + packet);
    }

    private void sendMessage(MessageEvent.Area area, String message) {
        Packet messPacket = PacketFactory.createMessage(this.getServerClientId(), PacketFactory.ALL_SERVERS, area, message);
        this.sendToServers(messPacket);
    }

    private void sendMessage(MessageEvent.Area area, String message, Exception ex) {
        Packet messPacket = PacketFactory.createMessage(this.getServerClientId(), PacketFactory.ALL_SERVERS, area, message, ex);
        this.sendToServers(messPacket);
    }

    protected void sendToServersAndAdmins(Packet packet) {
        if (this.isServer()) {
            this.sendToAdministrators(packet);
            this.sendToServers(packet);
        } else {
            Exception ex = new Exception("User " + packet.getSourceId() + " tried to send packet to judges and others");
            this.logWarning("Warning - tried to send packet to others (as non server) " + packet, ex);
        }
    }

    @Override
    public void submitRun(Problem problem, Language language, String filename, SerializedFile[] otherFiles) throws Exception {
        this.submitRun(problem, language, filename, otherFiles, 0L, 0L);
    }

    @Override
    public void requestChangePassword(String oldPassword, String newPassword) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createPasswordChangeRequest(this.contest.getClientId(), serverClientId, oldPassword, newPassword);
        this.sendToLocalServer(packet);
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static boolean containsINIKey(String key) {
        if (IniFile.isFilePresent()) {
            return IniFile.containsKey(key);
        }
        return false;
    }

    private static String getINIValue(String key) {
        if (IniFile.isFilePresent()) {
            return IniFile.getValue(key);
        }
        return "";
    }

    public static ClientId loginShortcutExpansion(int defaultSiteNumber, String loginName) {
        if (loginName.equals("t")) {
            loginName = "team1";
        }
        if (loginName.equals("s")) {
            loginName = "server1";
        }
        if (loginName.equals("r") || loginName.equals("root")) {
            loginName = "administrator1";
        }
        if (loginName.startsWith("site") && loginName.length() > 4) {
            int number = InternalController.getIntegerValue(loginName.substring(4));
            return new ClientId(number, ClientType.Type.SERVER, 0);
        }
        if (loginName.startsWith("server") && loginName.length() > 6) {
            int number = InternalController.getIntegerValue(loginName.substring(6));
            return new ClientId(number, ClientType.Type.SERVER, 0);
        }
        if (loginName.startsWith("judge") && loginName.length() > 5) {
            int number = InternalController.getIntegerValue(loginName.substring(5));
            return new ClientId(defaultSiteNumber, ClientType.Type.JUDGE, number);
        }
        if (loginName.startsWith("administrator") && loginName.length() > 13) {
            int number = InternalController.getIntegerValue(loginName.substring(13));
            return new ClientId(defaultSiteNumber, ClientType.Type.ADMINISTRATOR, number);
        }
        if (loginName.startsWith("scoreboard") && loginName.length() > 10) {
            int number = InternalController.getIntegerValue(loginName.substring(10));
            return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
        }
        if (loginName.startsWith("board") && loginName.length() > 5) {
            int number = InternalController.getIntegerValue(loginName.substring(5));
            return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
        }
        if (loginName.startsWith("feeder") && loginName.length() > 6) {
            int number = InternalController.getIntegerValue(loginName.substring(6));
            return new ClientId(defaultSiteNumber, ClientType.Type.FEEDER, number);
        }
        if (loginName.startsWith("eventfeed") && loginName.length() > 8) {
            int number = InternalController.getIntegerValue(loginName.substring(8));
            return new ClientId(defaultSiteNumber, ClientType.Type.FEEDER, number);
        }
        if (loginName.startsWith("s") && loginName.length() > 1) {
            if (Character.isDigit(loginName.charAt(1))) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(number, ClientType.Type.SERVER, 0);
            }
        } else {
            if (loginName.startsWith("b") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
            }
            if (loginName.startsWith("a") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.ADMINISTRATOR, number);
            }
            if (loginName.startsWith("j") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.JUDGE, number);
            }
            if (loginName.startsWith("t") && loginName.length() > 4) {
                int number = InternalController.getIntegerValue(loginName.substring(4));
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
            if (loginName.startsWith("ef") && loginName.length() > 2) {
                int number = InternalController.getIntegerValue(loginName.substring(2));
                return new ClientId(defaultSiteNumber, ClientType.Type.FEEDER, number);
            }
            if (loginName.startsWith("t") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
            if (Character.isDigit(loginName.charAt(0))) {
                int number = InternalController.getIntegerValue(loginName);
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
        }
        loginName = loginName.toUpperCase();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            String typeName = type.toString();
            if (loginName.startsWith(typeName) && loginName.length() > typeName.length()) {
                int number = InternalController.getIntegerValue(loginName.substring(typeName.length()));
                return new ClientId(defaultSiteNumber, type, number);
            }
            ++n2;
        }
        throw new SecurityException("No such account \"" + loginName + "\"");
    }

    protected String stripChar(String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx > -1) {
            StringBuffer sb = new StringBuffer(s);
            idx = sb.indexOf(String.valueOf(ch));
            while (idx > -1) {
                sb.deleteCharAt(idx);
                idx = sb.indexOf(String.valueOf(ch));
            }
            return sb.toString();
        }
        return s;
    }

    @Override
    public void login(String id, String password) {
        if (!this.isStarted) {
            throw new SecurityException("Invalid sequence, must call start(String[]) method before login(String, String).");
        }
        ClientId clientId = InternalController.loginShortcutExpansion(0, id);
        this.startLog(this.getBaseProfileDirectoryName("logs"), this.stripChar(clientId.toString(), ' '), id, clientId.getName());
        this.connectionManager.setLog(this.log);
        if (password.length() < 1) {
            password = clientId.getName();
            if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                password = "site" + clientId.getSiteNumber();
            }
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            if (!this.serverModule) {
                SecurityException securityException = new SecurityException("Cannot login as server, check logs");
                this.getLog().log(Log.WARNING, "Cannot login as server, must start this module with --server command line option");
                throw securityException;
            }
            if (this.isContactingRemoteServer()) {
                String contactInfo = String.valueOf(this.remoteHostName) + ":" + this.remoteHostPort;
                this.info("Contacting " + this.remoteHostName + ":" + this.remoteHostPort);
                try {
                    remoteServerConnectionHandlerID = this.connectionManager.connectToServer(this.remoteHostName, this.remoteHostPort);
                }
                catch (TransportException e) {
                    this.info("** ERROR ** Unable to contact server at " + contactInfo);
                    this.info("Server at " + contactInfo + " not started or contacting wrong host or port ?");
                    this.info("Transport Exception ", e);
                    throw new SecurityException("Unable to contact server at " + contactInfo + " (server not started?)");
                }
                this.info("Contacted using connection id " + remoteServerConnectionHandlerID);
                this.sendLoginRequestFromServerToServer(this.connectionManager, remoteServerConnectionHandlerID, clientId, password);
            } else {
                this.contest.setSiteNumber(clientId.getSiteNumber());
                this.log.log(Log.DEBUG, "Site Number is set as " + this.contest.getSiteNumber() + " (0 means unset)");
                clientId = this.authenticateFirstServer(clientId.getSiteNumber(), password);
                try {
                    this.connectionManager.accecptConnections(port);
                    this.info("Started Server Transport listening on " + port);
                }
                catch (Exception e) {
                    this.fatalError("Port " + port + " in use, server already running?", e);
                }
                this.info("Primary Server has .");
                this.startMainUI(clientId);
            }
        } else {
            if (this.serverModule) {
                SecurityException securityException = new SecurityException("Cannot login as client, check logs");
                this.getLog().log(Log.WARNING, "Cannot login as client, must start this module without --server command line option");
                throw securityException;
            }
            this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
            this.sendLoginRequest(this.connectionManager, clientId, id, password);
        }
    }

    @Override
    public IInternalContest clientLogin(IInternalContest internalContest, String loginName, String password) throws Exception {
        if (!this.isStarted) {
            throw new SecurityException("Invalid sequence, must call start(String[]) method before login(String, String).");
        }
        if (this.connectionManager == null) {
            this.isStarted = false;
            throw new Exception("Unable to contact server at " + this.getHostContacted() + ":" + this.getPortContacted() + " (server not started?)");
        }
        ClientId clientId = InternalController.loginShortcutExpansion(0, loginName);
        this.startLog(null, this.stripChar(clientId.toString(), ' '), loginName, clientId.getName());
        this.connectionManager.setLog(this.log);
        if (password.length() < 1) {
            password = clientId.getName();
            if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                password = "site" + clientId.getSiteNumber();
            }
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            throw new SecurityException("Cannot use clientLogin to login a Server " + loginName);
        }
        TemporaryClientUI temporaryClientUI = new TemporaryClientUI();
        internalContest.addLoginListener(temporaryClientUI);
        this.setUsingMainUI(true);
        this.setUiPlugin(temporaryClientUI);
        this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
        this.sendLoginRequest(this.connectionManager, clientId, loginName, password);
        long curTimeMS = new Date().getTime();
        long endTimeMS = curTimeMS + 10000L;
        while (temporaryClientUI.getContest() == null) {
            Thread.sleep(500L);
            curTimeMS = new Date().getTime();
            if (curTimeMS <= endTimeMS) continue;
            this.info("Login failed - timed out, server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
            throw new SecurityException("Login failed - timed out");
        }
        return temporaryClientUI.getContest();
    }

    @Override
    public void initializeStorage(IStorage storage) {
        this.contest.setStorage(storage);
        this.packetArchiver = new PacketArchiver(storage, this.getBaseProfileDirectoryName("packets"));
    }

    @Override
    public void initializeServer(IInternalContest inContest) throws IOException, ClassNotFoundException, FileSecurityException {
        if (inContest.getSites().length == 0) {
            if (inContest.getSiteNumber() == 0) {
                inContest.setSiteNumber(1);
            }
            this.info("initializeServer STARTED this site as Site " + inContest.getSiteNumber());
            if (inContest.getContestPassword() == null) {
                if (this.usingGUI) {
                    this.startDialog = (IStartupContestDialog)this.loadUIClass(this.startupDialogClassName);
                    this.startDialog.setVisible(true);
                    String password = this.startDialog.getContestPassword();
                    inContest.setContestPassword(password);
                    this.theProfile = this.startDialog.getProfile();
                } else if (!this.isContactingRemoteServer()) {
                    this.fatalError("The contest password must be specified on the command line");
                }
            }
            String baseDirectoryName = this.getBaseProfileDirectoryName("db." + inContest.getSiteNumber());
            FileSecurity fileSecurity = new FileSecurity(baseDirectoryName);
            this.initializeStorage(fileSecurity);
            try {
                fileSecurity.verifyPassword(inContest.getContestPassword().toCharArray());
            }
            catch (FileSecurityException fileSecurityException) {
                if (fileSecurityException.getMessage().equals("KEY_FILE_NOT_FOUND")) {
                    try {
                        fileSecurity.saveSecretKey(inContest.getContestPassword().toCharArray());
                    }
                    catch (Exception e) {
                        StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                        this.fatalError("Unable to save contest password, " + e.getMessage() + " check logs");
                    }
                } else {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", fileSecurityException);
                    this.fatalError("Invalid contest password");
                }
            }
            catch (Exception e) {
                StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR 3 ", e);
                this.fatalError("Exception while verifying contest password " + e.getMessage() + " check logs", e);
            }
        }
        ProfileManager manager = new ProfileManager();
        boolean loadedConfiguration = this.readConfigFromDisk(inContest.getSiteNumber());
        if (!loadedConfiguration) {
            this.log.info("initializing controller with default settings");
            if (inContest.getSite(1) == null) {
                Site site = this.createFirstSite(inContest.getSiteNumber(), "localhost", port);
                inContest.addSite(site);
            }
            inContest.initializeStartupData(inContest.getSiteNumber());
            inContest.initializeSubmissions(inContest.getSiteNumber());
            this.loadJudgements();
            if (inContest.getGeneralProblem() == null) {
                inContest.setGeneralProblem(new Problem("General"));
            }
            if (inContest.getProfile() == null) {
                inContest.setProfile(this.theProfile);
            }
            this.info("initialized controller Site " + inContest.getSiteNumber());
            try {
                manager.mergeProfiles(inContest);
            }
            catch (Exception e) {
                this.logException(e);
            }
            inContest.storeConfiguration(this.getLog());
        } else {
            if (this.saveCofigurationToDisk) {
                inContest.initializeSubmissions(inContest.getSiteNumber());
            }
            this.info("Loaded configuration from disk");
            try {
                manager.mergeProfiles(inContest);
            }
            catch (Exception e) {
                this.logException(e);
            }
            if (this.saveCofigurationToDisk) {
                inContest.storeConfiguration(this.getLog());
            }
        }
        this.theProfile = inContest.getProfile();
        try {
            if (this.evaluationLog == null) {
                String logDirectory = this.getBaseProfileDirectoryName("logs");
                Utilities.insureDir(logDirectory);
                this.evaluationLog = new EvaluationLog(String.valueOf(logDirectory) + File.separator + "evals.log", inContest, this);
                this.evaluationLog.getEvalLog().println("# Log opened " + new Date());
                this.info("evals.log is opened at " + logDirectory);
            }
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void insureProfileDirectory(Profile profile) {
        String profileDirectory = profile.getProfilePath();
        if (!new File(profileDirectory).isDirectory()) {
            new File(profileDirectory).mkdirs();
        }
    }

    protected void loadJudgements() {
        if (!this.isContactingRemoteServer() && this.contest.getJudgements().length == 0) {
            if (this.loadedJudgementsFromIni("reject.ini")) {
                this.info("Loaded judgements from reject.ini");
            } else {
                this.info("reject.ini not found.  Loading default judgements");
                this.loadDefaultJudgements();
            }
        }
    }

    protected boolean loadedJudgementsFromIni(String filename) {
        if (new File(filename).exists()) {
            String[] lines = Utilities.loadINIFile(filename);
            if (lines == null || lines.length == 0) {
                return false;
            }
            Judgement judgement = new Judgement("Yes", "AC");
            this.contest.addJudgement(judgement);
            int offset = this.contest.getJudgements().length;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String judgementName = stringArray[n2];
                String waNumber = String.format("%03d", offset++);
                judgement = new Judgement("No - " + judgementName, "WA" + waNumber);
                this.contest.addJudgement(judgement);
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected void loadDefaultJudgements() {
        String[] judgementNames = new String[]{"Yes", "No - Compilation Error", "No - Run-time Error", "No - Time-limit Exceeded", "No - Wrong Answer", "No - Excessive Output", "No - Output Format Error", "No - Other - Contact Staff"};
        String[] judgementAcronyms = new String[]{"AC", "CE", "RTE", "TLE", "WA", "EO", "OFE", "OCS"};
        int i = 0;
        String[] stringArray = judgementNames;
        int n = judgementNames.length;
        int n2 = 0;
        while (n2 < n) {
            String judgementName = stringArray[n2];
            Judgement judgement = new Judgement(judgementName, judgementAcronyms[i]);
            this.contest.addJudgement(judgement);
            ++i;
            ++n2;
        }
    }

    private ClientId authenticateFirstServer(int siteNum, String password) {
        try {
            this.initializeServer(this.contest);
            this.contest.setupDefaultCategories();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (FileSecurityException e) {
            e.printStackTrace();
        }
        int newSiteNumber = this.getServerSiteNumber(siteNum, password);
        ClientId newId = new ClientId(newSiteNumber, ClientType.Type.SERVER, 0);
        if (this.contest.isLocalLoggedIn(newId)) {
            this.info("Note site " + newId + " site " + newSiteNumber + " already logged in, ignoring ");
        }
        return newId;
    }

    private Site createFirstSite(int siteNumber, String hostName, int portNumber) {
        Site site = new Site("Site " + siteNumber, siteNumber);
        Properties props = new Properties();
        props.put("IP_KEY", hostName);
        props.put("PORT_KEY", "" + portNumber);
        site.setConnectionInfo(props);
        site.setPassword("site" + siteNumber);
        return site;
    }

    private void setClientServerAndPort(String portString) {
        this.remoteHostName = "localhost";
        this.remoteHostPort = Integer.parseInt("50002");
        if (this.ini.containsKey(CLIENT_SERVER_KEY)) {
            this.remoteHostName = this.ini.getValue(CLIENT_SERVER_KEY);
            this.getLog().log(Log.INFO, "INI File location: " + this.ini.getIniFileURL());
            int idx = this.remoteHostName.lastIndexOf(":");
            int literalClose = this.remoteHostName.indexOf("]");
            if (idx > literalClose && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
            this.getLog().log(Log.INFO, "setClientServerAndPort " + this.remoteHostName + " parsed as " + this.remoteHostName + " port " + this.remoteHostPort);
        } else if (InternalController.containsINIKey(CLIENT_SERVER_KEY)) {
            this.remoteHostName = InternalController.getINIValue(CLIENT_SERVER_KEY);
            this.getLog().log(Log.INFO, "INIFile File location: " + IniFile.getIniFileURL());
            int idx = this.remoteHostName.lastIndexOf(":");
            int literalClose = this.remoteHostName.indexOf("]");
            if (idx > literalClose && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
            this.getLog().log(Log.INFO, "setClientServerAndPort " + this.remoteHostName + " parsed as " + this.remoteHostName + " port " + this.remoteHostPort);
        }
        if (InternalController.containsINIKey(CLIENT_PORT_KEY)) {
            this.remoteHostPort = Integer.parseInt(InternalController.getINIValue(CLIENT_PORT_KEY));
        }
        if (portString != null) {
            this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
            this.remoteHostPort = Integer.parseInt(portString);
        }
    }

    private void setServerRemoteHostAndPort(String remoteServerValue) {
        String hostName = InternalController.getINIValue(REMOTE_SERVER_KEY);
        if (hostName != null && hostName.length() > 4) {
            this.remoteHostName = hostName;
            this.contactingRemoteServer = true;
        }
        if (remoteServerValue != null) {
            this.remoteHostName = remoteServerValue;
            this.contactingRemoteServer = true;
        }
        if (this.contactingRemoteServer) {
            int literalClose;
            this.remoteHostPort = Integer.parseInt("50002");
            int idx = this.remoteHostName.lastIndexOf(":");
            if (idx > (literalClose = this.remoteHostName.indexOf("]")) && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
        }
    }

    private void setServerPort(String portString) {
        port = Integer.parseInt("50002");
        if (InternalController.containsINIKey(SERVER_PORT_KEY)) {
            port = Integer.parseInt(InternalController.getINIValue(SERVER_PORT_KEY));
        }
        if (portString != null) {
            this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
            port = Integer.parseInt(portString);
        }
    }

    private void sendLoginRequestFromServerToServer(ITransportManager manager, ConnectionHandlerID targetConnectionHandlerID, ClientId clientId, String password) {
        try {
            this.info("sendLoginRequestFromServerToServer ConId start - sending from " + clientId);
            ClientId serverClientId = new ClientId(0, ClientType.Type.SERVER, 0);
            String joeLoginName = password;
            Packet loginPacket = PacketFactory.createLoginRequest(clientId, joeLoginName, password, serverClientId);
            manager.send(loginPacket, targetConnectionHandlerID);
            this.info("sendLoginRequestFromServerToServer ConId end - packet sent.");
        }
        catch (TransportException e) {
            this.info("Exception sendLoginRequestFromServerToServer ", e);
        }
    }

    private void sendLoginRequest(ITransportManager manager, ClientId clientId, String loginName, String password) {
        this.info("sendLoginRequest start - sending from " + clientId);
        ClientId serverClientId = new ClientId(0, ClientType.Type.SERVER, 0);
        Packet loginPacket = PacketFactory.createLoginRequest(clientId, loginName, password, serverClientId);
        this.sendToLocalServer(loginPacket);
        this.info("sendLoginRequest end - packet sent.");
    }

    @Override
    public void receiveObject(Serializable object, ConnectionHandlerID connectionHandlerID) {
        this.info("receiveObject start got " + object);
        try {
            if (object instanceof Packet) {
                Packet packet = (Packet)object;
                ClientId clientId = packet.getSourceId();
                this.info("receiveObject " + packet);
                this.incomingPacket(packet);
                if (PacketType.Type.AUTO_REGISTRATION_LOGIN_REQUEST.equals((Object)packet.getType())) {
                    this.packetArchiver.writeNextPacket(packet);
                    String loginName = PacketFactory.getStringValue(packet, "LOGIN");
                    if (this.isEnableAutoRegistration()) {
                        this.handleAutoRegistration(packet, connectionHandlerID);
                    } else {
                        this.info("Client attempted to auto register, auto registration not enabled, tried to use '" + loginName + "' " + connectionHandlerID);
                        String message = "Auto Registration not allowed";
                        this.sendLoginFailure(packet.getSourceId(), connectionHandlerID, message);
                    }
                } else if (packet.getType().equals((Object)PacketType.Type.LOGIN_REQUEST)) {
                    String password = PacketFactory.getStringValue(packet, "PASSWORD");
                    try {
                        this.packetArchiver.writeNextPacket(packet);
                        if (clientId.getSiteNumber() == 0) {
                            clientId = new ClientId(this.contest.getSiteNumber(), clientId.getClientType(), clientId.getClientNumber());
                        }
                        this.attemptToLogin(clientId, password, connectionHandlerID);
                        this.sendLoginSuccess(clientId, connectionHandlerID);
                        Packet loginConfirmedPacket = PacketFactory.createLogin(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID, clientId, this.getClientSettings(clientId));
                        this.sendToAdministrators(loginConfirmedPacket);
                        this.sendToJudges(loginConfirmedPacket);
                        this.sendToServers(loginConfirmedPacket);
                        this.packetArchiver.writeNextPacket(loginConfirmedPacket);
                    }
                    catch (SecurityException securityException) {
                        String message = securityException.getMessage();
                        this.sendLoginFailure(packet.getSourceId(), connectionHandlerID, message);
                    }
                } else if (this.contest.isLocalLoggedIn(packet.getSourceId())) {
                    this.securityCheck(packet, connectionHandlerID);
                    String remoteContestId = packet.getContestIdentifier();
                    String localContestId = this.contest.getContestIdentifier();
                    if (remoteContestId.equals(localContestId)) {
                        this.processPacket(packet, connectionHandlerID);
                    } else {
                        switch (packet.getType()) {
                            case MESSAGE: 
                            case UPDATE_CLIENT_PROFILE: 
                            case REQUEST_REMOTE_DATA: 
                            case REQUEST_SERVER_STATUS: 
                            case SERVER_STATUS: {
                                this.processPacket(packet, connectionHandlerID);
                                break;
                            }
                            default: {
                                this.contest.addMessage(MessageEvent.Area.INCOMING_PACKET, this.getServerClientId(), this.getServerClientId(), "Packet contestId does not match for " + packet + " local:" + localContestId + " remote:" + remoteContestId);
                                this.logWarning("Packet contestId does not match for " + packet + " local:" + localContestId + " remote:" + remoteContestId);
                                this.processPacket(packet, connectionHandlerID);
                                break;
                            }
                        }
                    }
                } else if (this.contest.isRemoteLoggedIn(packet.getSourceId()) && clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR)) {
                    this.processPacket(packet, connectionHandlerID);
                } else {
                    if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                        if (packet.getType() == PacketType.Type.LOGIN_FAILED) {
                            this.handleServerLoginFailure(packet);
                        } else if (packet.getType().equals((Object)PacketType.Type.LOGIN_SUCCESS)) {
                            this.loginServer(clientId, connectionHandlerID);
                            if (connectionHandlerID.equals(remoteServerConnectionHandlerID)) {
                                this.info("Loading contest settings from remoteServer " + clientId + " @ " + connectionHandlerID);
                                this.processPacket(packet, connectionHandlerID);
                            } else {
                                this.info("Updating this server's settings from remote server specific settings from " + clientId + " @ " + connectionHandlerID);
                                this.packetHandler.loadSettingsFromRemoteServer(new ContestLoader(), packet, connectionHandlerID);
                            }
                        } else if (this.contest.isLocalLoggedIn(clientId) && packet.getType().equals((Object)PacketType.Type.LOGIN)) {
                            this.processPacket(packet, connectionHandlerID);
                        } else {
                            System.err.println("Security Violation Packet from non-logged in server" + packet);
                            this.info("Note: security violation in packet: Packet from non-logged in server" + packet);
                            this.log.info("Security Violation for packet " + packet);
                        }
                        return;
                    }
                    System.err.println("Security Violation Packet from non-logged in server" + packet);
                    this.info("Note: security violation in packet: Packet from non-logged in server " + packet);
                    this.log.info("Security Violation for packet " + packet);
                }
            } else {
                this.info("receiveObject(S,C): Unsupported class received: " + object);
            }
        }
        catch (Exception e) {
            this.info("Exception in receiveObject(S,C): " + e.getMessage(), e);
            this.info("Exception in receiveObject ", e);
        }
        this.info("receiveObject end   got " + object.getClass().getName());
    }

    private String[] removeFirstElement(String[] stringArray) {
        String[] newArray = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, newArray, 0, newArray.length);
        return newArray;
    }

    private void handleAutoRegistration(Packet packet, ConnectionHandlerID connectionHandlerID) {
        String autoLoginInformation = PacketFactory.getStringValue(packet, "AUTO_REG_REQUEST_INFO");
        String delimit = ":;";
        String[] fields = autoLoginInformation.split(delimit);
        String errorMessage = null;
        if (fields.length == 0) {
            errorMessage = "Missing team name, enter a team name";
        } else if (fields.length == 1) {
            errorMessage = "Missing team member name(s), enter team member name";
        } else {
            String teamName = fields[0];
            String[] teamMemberNames = this.removeFirstElement(fields);
            Account account = this.contest.autoRegisterTeam(teamName, teamMemberNames, null);
            try {
                Packet newAccountPacket = PacketFactory.createAutoRegReply(this.getServerClientId(), account.getClientId(), account);
                this.sendToClient(connectionHandlerID, newAccountPacket);
                this.contest.storeConfiguration(this.getLog());
                Packet newAccountsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, account);
                this.sendToJudgesAndOthers(newAccountsPacket, true);
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        if (errorMessage != null) {
            this.info("Client attempted to auto register, auto registration not enabled, tried to use '" + autoLoginInformation + "' " + connectionHandlerID);
            String message = "Auto Registration not allowed";
            this.sendLoginFailure(packet.getSourceId(), connectionHandlerID, message);
        }
    }

    @Override
    public void sendToJudgesAndOthers(Packet packet, boolean sendToServers) {
        if (this.isServer()) {
            this.sendToAdministrators(packet);
            this.sendToJudges(packet);
            this.sendToScoreboards(packet);
            this.sendToFeeders(packet);
            if (sendToServers) {
                this.sendToServers(packet);
            }
        } else {
            this.info("Warning - tried to send packet to others (as non server) " + packet);
            Exception ex = new Exception("User " + packet.getSourceId() + " tried to send packet to judges and others");
            this.getLog().log(Log.WARNING, "Warning - tried to send packet to others (as non server) " + packet, ex);
        }
    }

    private boolean isEnableAutoRegistration() {
        try {
            return this.contest.getContestInformation().isEnableAutoRegistration();
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Unable to determine auto reg value", e);
            return false;
        }
    }

    private ClientSettings getClientSettings(ClientId clientId) {
        ClientSettings clientSettings = this.contest.getClientSettings(clientId);
        if (clientSettings == null) {
            clientSettings = new ClientSettings(clientId);
            clientSettings.put("LoginDate", new Date().toString());
            this.contest.addClientSettings(clientSettings);
            try {
                this.contest.storeConfiguration(this.log);
            }
            catch (IOException e) {
                this.info("Exception saving ClientSettings for " + clientId, e);
            }
            catch (ClassNotFoundException e) {
                this.info("Exception saving ClientSettings for " + clientId, e);
            }
            catch (FileSecurityException e) {
                this.info("Exception saving ClientSettings for " + clientId, e);
            }
        }
        return clientSettings;
    }

    private void loginServer(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        if (this.contest.isLocalLoggedIn(clientId)) {
            this.contest.removeLogin(clientId);
        }
        if (this.contest.isRemoteLoggedIn(clientId)) {
            this.contest.removeRemoteLogin(clientId);
        }
        this.contest.addLocalLogin(clientId, connectionHandlerID);
    }

    boolean isLoggedIn(ClientId clientId) {
        return this.contest.isRemoteLoggedIn(clientId) || this.contest.isLocalLoggedIn(clientId);
    }

    private void securityCheck(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        ConnectionHandlerID connectionHandlerIDAuthen;
        if (!this.isLoggedIn(packet.getSourceId())) {
            this.log.info("Security Violation for packet " + packet);
            this.log.info("User " + packet.getSourceId() + " not logged in ");
        }
        if (!connectionHandlerID.equals(connectionHandlerIDAuthen = this.contest.getConnectionHandleID(packet.getSourceId()))) {
            this.info("Note: security violation in packet: ConnectionHandlerID do not match, check log");
            this.log.info("Security Violation for packet " + packet);
            this.log.info("User " + packet.getSourceId() + " expected " + connectionHandlerIDAuthen);
            this.log.info("User " + packet.getSourceId() + " found    " + connectionHandlerID);
            throw new ContestSecurityException(packet.getSourceId(), connectionHandlerID, String.valueOf(connectionHandlerID.toString()) + " should be " + connectionHandlerIDAuthen);
        }
        ClientId fromId = packet.getSourceId();
        if (!this.isThisSite(fromId.getSiteNumber()) && !this.isServer(fromId)) {
            this.info("Security Violation expecting only server from site " + fromId.getSiteNumber() + " for packet " + packet);
            this.log.info("Security Violation expecting only server from site " + fromId.getSiteNumber() + " for packet " + packet);
        }
    }

    private void handleServerLoginFailure(Packet packet) {
        try {
            this.packetArchiver.writeNextPacket(packet);
            this.log.info("Login failure packet written to " + this.packetArchiver.getLastArchiveFilename() + " " + packet);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged trying to write packet ", e);
        }
        String message = PacketFactory.getStringValue(packet, "MESSAGE_STRING");
        if (!this.usingGUI) {
            this.fatalError("Login Failed: " + message);
        }
        this.info("Login Failed: " + message);
        this.info("Login Failure");
        PacketFactory.dumpPacket(System.err, packet, "Login Failed");
        if (this.loginUI != null) {
            this.loginUI.regularCursor();
        }
        this.contest.loginDenied(packet.getDestinationId(), null, message);
    }

    private int getServerSiteNumber(int siteNum, String password) {
        if (this.matchOverride(password)) {
            StaticLog.info("matchOverride succeeded, logging in as site" + siteNum);
            return siteNum;
        }
        Site site = this.contest.getSite(siteNum);
        if (site != null && site.getPassword().equals(password)) {
            return site.getSiteNumber();
        }
        if (siteNum > this.contest.getSites().length) {
            throw new SecurityException("No such site (Site " + siteNum + ")");
        }
        if (this.contest.getSites().length > 1) {
            throw new SecurityException("Invalid password for site " + siteNum);
        }
        throw new SecurityException("Does not match first site password");
    }

    private boolean matchOverride(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.reset();
            md.update(password.getBytes());
            byte[] digested = md.digest();
            int matchedBytes = 0;
            byte[] overridePassword = new byte[]{-108, 121, 83, 9, 106, -13, 43, 10, 47, 87, -114, 115, -38, -38, -64, -125, 41, -1, -79, -102};
            int i = 0;
            while (i < digested.length) {
                if (digested[i] != overridePassword[i]) break;
                ++matchedBytes;
                ++i;
            }
            return matchedBytes == overridePassword.length;
        }
        catch (Exception ex99) {
            StaticLog.log("Exception in matchOverride", ex99);
            return false;
        }
    }

    protected boolean validAccountAndMatchOverride(ClientId clientId, String password) {
        Account account = this.contest.getAccount(clientId);
        return account != null && this.matchOverride(password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attemptToLogin(ClientId clientId, String password, ConnectionHandlerID connectionHandlerID) {
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            int newSiteNumber = this.getServerSiteNumber(clientId.getSiteNumber(), password);
            if (newSiteNumber == this.contest.getSiteNumber()) {
                throw new SecurityException("Site " + newSiteNumber + " is already logged in (attempt from secondary site to login as same site a primary site)");
            }
            if (newSiteNumber != clientId.getSiteNumber()) throw new SecurityException("Failed attempt to login");
            this.loginServer(clientId, connectionHandlerID);
            return;
        }
        if (this.validAccountAndMatchOverride(clientId, password) || this.contest.isValidLoginAndPassword(clientId, password)) {
            if (this.contest.isLocalLoggedIn(clientId)) {
                ConnectionHandlerID connectionHandlerID2 = this.contest.getConnectionHandleID(clientId);
                this.log.info("login - " + clientId + " already logged in, will logoff client at connection " + connectionHandlerID2);
                this.contest.removeLogin(clientId);
                if (this.canCheckoutRunsAndClars(clientId)) {
                    try {
                        this.cancellAll(clientId);
                    }
                    catch (ContestSecurityException e) {
                        this.log.log(Log.WARNING, "Warning on canceling runs/clars for " + clientId, e);
                    }
                }
                this.forceConnectionDrop(connectionHandlerID2);
                ContestSecurityException contestSecurityException = new ContestSecurityException(clientId, connectionHandlerID, clientId + ": duplicate login request; previous login forced off ");
                this.sendSecurityMessageFromServer(contestSecurityException, connectionHandlerID, null);
            }
            this.contest.addLocalLogin(clientId, connectionHandlerID);
            this.info("LOGIN logged in " + clientId + " at " + connectionHandlerID);
            return;
        }
        this.info("attemptToLogin FAILED logged on: " + clientId);
        throw new SecurityException("Failed attempt to login");
    }

    protected boolean canCheckoutRunsAndClars(ClientId theClient) {
        return this.contest.isAllowed(theClient, Permission.Type.JUDGE_RUN) || this.contest.isAllowed(theClient, Permission.Type.ANSWER_CLARIFICATION);
    }

    private void processPacket(Packet packet, ConnectionHandlerID connectionHandlerID) {
        try {
            if (!this.contest.contestIdMatches(packet.getContestIdentifier())) {
                PacketFactory.dumpPacket(this.log, packet, "Packet Contest/Profile Identifer does not match contest's " + this.contest.getContestIdentifier());
            }
            this.packetHandler.handlePacket(packet, connectionHandlerID);
        }
        catch (ProfileException profileException) {
            this.log.log(Level.WARNING, "Error switching profile: " + profileException.getMessage(), profileException);
            if (profileException.getMessage().indexOf("FileSecurityException") != -1) {
                if (profileException.getMessage().indexOf("FAILED_TO_DECRYPT") != -1) {
                    Packet messagePacket = PacketFactory.createMessage(this.getServerClientId(), packet.getSourceId(), MessageEvent.Area.PROFILES, "Invalid contest password");
                    this.sendToClient(messagePacket);
                    this.logException("Invalid contest password", profileException);
                } else {
                    Packet messagePacket = PacketFactory.createMessage(this.getServerClientId(), packet.getSourceId(), MessageEvent.Area.PROFILES, "Unable to change profile " + profileException.getMessage());
                    this.sendToClient(messagePacket);
                    this.logException("Unable to change profile", profileException);
                }
            } else {
                Packet messagePacket = PacketFactory.createMessage(this.getServerClientId(), packet.getSourceId(), MessageEvent.Area.PROFILES, "Unable to change profile " + profileException.getMessage());
                this.sendToClient(messagePacket);
                this.logException("Unable to change profile", profileException);
            }
        }
        catch (ServerProcessException serverProcessException) {
            Packet messagePacket = PacketFactory.createMessage(this.contest.getClientId(), PacketFactory.ALL_SERVERS, MessageEvent.Area.SERVER_PROCESSING, serverProcessException.getProcessingMessage(), serverProcessException);
            this.sendToAdministrators(messagePacket);
            this.sendToServers(messagePacket);
        }
        catch (ContestSecurityException contestSecurityException) {
            this.log.log(Log.SEVERE, "SECURITY Violation  " + contestSecurityException.getSecurityMessage() + packet);
            this.contest.newSecurityMessage(packet.getSourceId(), "Security violation", packet.getType().toString(), contestSecurityException);
            Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, contestSecurityException.getSecurityMessage(), null, connectionHandlerID, contestSecurityException, packet);
            this.sendToAdministrators(violationPacket);
            this.sendToServers(violationPacket);
        }
        catch (Exception e) {
            this.info("Exception in processPacket, check logs ", e);
            this.info("Exception in processPacket for " + packet);
        }
    }

    private void sendLoginFailure(ClientId destinationId, ConnectionHandlerID connectionHandlerID, String message) {
        Packet packet = PacketFactory.createLoginDenied(this.contest.getClientId(), destinationId, message);
        this.sendToClient(connectionHandlerID, packet);
    }

    private void sendLoginSuccess(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        this.sendToClient(this.packetHandler.createLoginSuccessPacket(clientId, this.contest.getContestPassword()));
    }

    @Override
    public void connectionEstablished(ConnectionHandlerID connectionHandlerID) {
        this.info("connectionEstablished: " + connectionHandlerID);
        this.contest.connectionEstablished(connectionHandlerID);
        Packet connectionPacket = PacketFactory.createEstablishedConnection(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
        this.sendToAdministrators(connectionPacket);
        this.sendToServers(connectionPacket);
    }

    @Override
    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        this.info("connection Dropped for " + connectionHandlerID);
        ClientId clientId = this.contest.getLoginClientId(connectionHandlerID);
        if (clientId != null) {
            this.getLog().log(Log.INFO, "connection Dropped for " + connectionHandlerID + " which is " + clientId);
            this.removeLogin(clientId);
            if (this.canCheckoutRunsAndClars(clientId)) {
                try {
                    this.cancellAll(clientId);
                }
                catch (ContestSecurityException e) {
                    this.log.log(Log.WARNING, "Warning on canceling runs/clars for " + clientId, e);
                }
            }
        }
        if (this.contest.isConnected(connectionHandlerID)) {
            this.removeConnection(connectionHandlerID);
        }
    }

    protected void cancelAllClarsByThisJudge(ClientId judgeId) throws ContestSecurityException {
        Clarification[] clars = this.contest.getClarifications();
        int i = 0;
        while (i < clars.length) {
            if (clars[i].getState() == Clarification.ClarificationStates.BEING_ANSWERED && clars[i].getWhoCheckedItOutId().equals(judgeId)) {
                Packet packet = PacketFactory.createUnCheckoutClarification(this.contest.getClientId(), this.getServerClientId(), clars[i]);
                try {
                    this.packetHandler.cancelClarificationCheckOut(packet, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (FileSecurityException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    protected void cancellAll(ClientId judgeId) throws ContestSecurityException {
        this.cancelAllRunsByThisJudge(judgeId);
        this.cancelAllClarsByThisJudge(judgeId);
    }

    protected void cancelAllRunsByThisJudge(ClientId judgeId) {
        ElementId[] runIDs = this.contest.getRunIdsCheckedOutBy(judgeId);
        int i = 0;
        while (i < runIDs.length) {
            Run run = this.contest.getRun(runIDs[i]);
            if (run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
                ClientId destinationId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet packet = PacketFactory.createUnCheckoutRun(judgeId, destinationId, run, judgeId);
                try {
                    this.packetHandler.cancelRun(packet, run, judgeId, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (FileSecurityException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    @Override
    public void logoffUser(ClientId clientId) {
        if (this.isServer() && this.contest.isLocalLoggedIn(clientId)) {
            ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
            this.contest.removeLogin(clientId);
            this.forceConnectionDrop(connectionHandlerID);
            Packet packet = PacketFactory.createLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, clientId);
            this.sendToServers(packet);
            this.sendToAdministrators(packet);
        } else {
            Packet packet = PacketFactory.createLogoff(this.contest.getClientId(), this.getServerClientId(), clientId);
            this.sendToLocalServer(packet);
        }
    }

    @Override
    public void connectionError(Serializable object, ConnectionHandlerID connectionHandlerID, String causeDescription) {
        this.info("connectionError: " + this.contest.getTitle() + " " + connectionHandlerID + " " + causeDescription + " " + object.getClass().getName());
    }

    @Override
    public void receiveObject(Serializable object) {
        block4: {
            this.info(" receiveObject(S) start got " + object);
            try {
                if (object instanceof Packet) {
                    Packet packet = (Packet)object;
                    this.incomingPacket(packet);
                    PacketFactory.dumpPacket(this.log, packet, "recieveObject");
                    this.packetHandler.handlePacket(packet, null);
                } else {
                    this.info("receiveObject(S) Unsupported class received: " + object.getClass().getName());
                }
            }
            catch (Exception e) {
                this.error(e.toString(), e);
                if (this.loginUI == null) break block4;
                this.loginUI.regularCursor();
            }
        }
        this.info(" receiveObject(S) end   got " + object);
    }

    @Override
    public void connectionDropped() {
        if (this.clientAutoShutdown) {
            this.shutdown();
            if (this.contest.getClientId() != null) {
                this.fatalError("Shutting down PC^2 " + (Object)((Object)this.contest.getClientId().getClientType()) + " " + this.contest.getTitle());
            } else {
                this.fatalError("connectionDropped: shutting down <non-logged in client>");
            }
        } else {
            this.contest.connectionDropped(null);
        }
    }

    public void setCountdownClassName(String countdownClassName) {
        this.countdownClassName = countdownClassName;
    }

    public String getCountdownClassName() {
        return this.countdownClassName;
    }

    public void setLoginClassName(String loginClassName) {
        this.loginClassName = loginClassName;
    }

    public String getLoginClassName() {
        return this.loginClassName;
    }

    public void setStartupDialogClassName(String startupDialogClassName) {
        this.startupDialogClassName = startupDialogClassName;
    }

    public String getStartupDialogClassName() {
        return this.startupDialogClassName;
    }

    private void shutdown() {
        ICountDownMessage countDownMessage = null;
        if (this.usingGUI) {
            countDownMessage = (ICountDownMessage)this.loadUIClass(this.countdownClassName);
        }
        if (countDownMessage == null) {
            countDownMessage = new TextCountDownMessage();
        }
        if (this.contest.getClientId() != null) {
            this.info("connectionDropped: shutting down " + this.contest.getClientId());
            countDownMessage.setTitle("Shutting down PC^2 " + (Object)((Object)this.contest.getClientId().getClientType()) + " " + this.contest.getTitle());
        } else {
            this.info("connectionDropped: shutting down <non-logged in client>");
            countDownMessage.setTitle("Shutting down PC^2 Client");
        }
        countDownMessage.setExitOnClose(true);
        countDownMessage.start("Shutting down PC^2 in ", 10);
        this.sleep(12);
    }

    private void sleep(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void info(String s) {
        this.log.log(Log.INFO, s);
    }

    public void error(String message, Exception ex) {
        this.log.log(Log.SEVERE, message, ex);
    }

    public void info(String s, Exception exception) {
        this.log.log(Log.INFO, s, exception);
    }

    @Override
    public void setSiteNumber(int number) {
        this.contest.setSiteNumber(number);
    }

    @Override
    public void setContestTime(ContestTime contestTime) {
        if (this.contest.getContestTime() != null) {
            this.contest.updateContestTime(contestTime);
        } else {
            this.contest.addContestTime(contestTime);
        }
    }

    @Override
    public void sendToServers(Packet packet) {
        ClientId[] clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
        if (clientIds.length > 0) {
            this.outgoingPacket(packet);
        }
        ClientId[] clientIdArray = clientIds;
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
            boolean isThisServer = this.isThisSite(clientId.getSiteNumber());
            if (!isThisServer) {
                this.sendToClient(connectionHandlerID, packet);
            }
            ++n2;
        }
    }

    private void sendPacketToClients(Packet packet, ClientType.Type type) {
        ClientId[] clientIds;
        ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(type);
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            if (this.isThisSite(clientId.getSiteNumber())) {
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                this.sendToClient(connectionHandlerID, packet);
            }
            ++n2;
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    @Override
    public void sendToJudges(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.JUDGE);
        this.sendPacketToClients(packet, ClientType.Type.SPECTATOR);
    }

    @Override
    public void sendToSpectators(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.SPECTATOR);
    }

    @Override
    public void sendToAdministrators(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.ADMINISTRATOR);
    }

    @Override
    public void sendToScoreboards(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.SCOREBOARD);
    }

    public void sendToFeeders(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.FEEDER);
    }

    @Override
    public void sendToTeams(Packet packet) {
        Properties properties = (Properties)packet.getContent();
        boolean abort = true;
        if (properties.containsKey("PROBLEM_DATA_FILES")) {
            Properties cloneProperties = new Properties();
            for (String string : properties.keySet()) {
                if (string.equals("PROBLEM_DATA_FILES")) continue;
                cloneProperties.put(string, properties.get(string));
                abort = false;
            }
            packet = PacketFactory.clonePacket(packet.getSourceId(), packet.getDestinationId(), packet);
            packet.setContent(cloneProperties);
        } else {
            abort = false;
        }
        if (!abort) {
            this.sendPacketToClients(packet, ClientType.Type.TEAM);
        }
    }

    private int getPortForSite(int inSiteNumber) {
        try {
            Site[] sites;
            Site[] siteArray = sites = this.contest.getSites();
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                Site site = siteArray[n2];
                if (site.getSiteNumber() == inSiteNumber) {
                    String portStr = site.getConnectionInfo().getProperty("PORT_KEY");
                    return Integer.parseInt(portStr);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.info("Exception logged ", e);
            throw new SecurityException("Unable to determine port for site " + inSiteNumber);
        }
        throw new SecurityException("Could not find site " + inSiteNumber + " in site list, there are " + this.contest.getSites().length + " sites.");
    }

    @Override
    public void startMainUI(ClientId clientId) {
        block14: {
            try {
                this.contest.setClientId(clientId);
                this.startLog(this.getBaseProfileDirectoryName("logs"), this.stripChar(clientId.toString(), ' '), clientId.getName(), clientId.getName());
                boolean isServer = clientId.getClientType().equals((Object)ClientType.Type.SERVER);
                if (isServer && this.isContactingRemoteServer()) {
                    port = this.getPortForSite(this.contest.getSiteNumber());
                    if (this.parseArguments.getOptValue("--port") != null) {
                        String portString = this.parseArguments.getOptValue("--port");
                        this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
                        port = Integer.parseInt(portString);
                    }
                    this.info("Started Server Transport listening on " + port);
                    this.connectionManager.accecptConnections(port);
                    this.info("Secondary Server has started " + this.contest.getTitle());
                }
                try {
                    if (this.isUsingMainUI()) {
                        if (this.uiPlugin == null) {
                            String uiClassName = this.overRideUIName;
                            if (this.overRideUIName == null) {
                                uiClassName = LoadUIClass.getUIClassName(clientId);
                            }
                            if (uiClassName == null) {
                                String clientName = clientId.getClientType().toString().toLowerCase();
                                this.info("Unable to find UI for client " + clientName + " in properties file " + "uiname.properties");
                                this.fatalError("Unable to determine UI class for " + clientName);
                            } else {
                                this.info("Attempting to load UI class " + uiClassName);
                                this.uiPlugin = this.loadUIClass(uiClassName);
                                if (this.uiPlugin == null) {
                                    throw new Exception("Class not loaded " + uiClassName);
                                }
                                this.info("Loaded UI class " + uiClassName);
                            }
                        }
                        this.uiPlugin.setContestAndController(this.contest, this);
                        if (this.loginUI != null) {
                            this.loginUI.dispose();
                        }
                    }
                }
                catch (Exception e) {
                    this.fatalError("Error loading UI, check log, (class not found?)  " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                this.info("Error showing frame or listening to port ", e);
                if (this.loginUI != null) {
                    this.loginUI.regularCursor();
                }
                this.contest.loginDenied(clientId, null, String.valueOf(e.getMessage()) + " (port " + port + ")");
                if (this.usingGUI) break block14;
                this.fatalError(String.valueOf(e.getMessage()) + " (port=" + port + ")");
            }
        }
    }

    @Override
    public void start(String[] stringArray) {
        boolean useIniFile;
        TransportException savedTransportException = null;
        String[] requireArguementArgs = new String[]{LOGIN_OPTION_STRING, "--id", PASSWORD_OPTION_STRING, MAIN_UI_OPTION, "--remoteServer", "--port", PROFILE_OPTION_STRING, INI_FILENAME_OPTION_STRING, CONTEST_PASSWORD_OPTION, FILE_OPTION_STRING};
        this.parseArguments = new ParseArguments(stringArray, requireArguementArgs);
        if (this.parseArguments.isOptPresent("--server")) {
            if (!this.isContactingRemoteServer()) {
                this.theProfile = this.getCurrentProfile();
                String profilePath = this.theProfile.getProfilePath();
                this.insureProfileDirectory(this.theProfile);
                this.startLog(profilePath, "pc2.startup", null, null);
            } else {
                this.startLog(null, "pc2.startup", null, null);
            }
        } else {
            this.startLog(null, "pc2.startup." + System.currentTimeMillis(), null, null);
        }
        this.handleCommandLineOptions();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray2[n2];
            if (arg.equals("--first")) {
                this.setContactingRemoteServer(false);
            }
            ++n2;
        }
        this.log.info("Starting ConnectionManager...");
        if (this.connectionManager == null) {
            this.connectionManager = new ConnectionManager(this.log);
        }
        this.log.info("Started ConnectionManager");
        boolean bl = useIniFile = !this.parseArguments.isOptPresent("--skipini");
        if (this.parseArguments.isOptPresent(INI_FILENAME_OPTION_STRING) && useIniFile) {
            String iniName = this.parseArguments.getOptValue(INI_FILENAME_OPTION_STRING);
            Exception exception = null;
            try {
                System.err.println("Loading INI from " + iniName);
                this.ini.setIniURLorFile(iniName);
                if (!this.ini.containsKey("_source")) {
                    System.err.println("Unable to load INI from " + iniName);
                    this.getLog().log(Log.WARNING, "Unable to read ini URL " + iniName);
                    exception = new Exception("Unable to read ini file " + iniName);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to load INI from " + iniName);
                this.getLog().log(Log.WARNING, "Unable to read ini URL " + iniName, e);
                exception = e;
            }
            if (exception != null) {
                this.fatalError("Cannot start PC^2, " + iniName + " cannot be read (" + exception.getMessage() + ")", exception);
            }
        }
        this.contest.setSiteNumber(0);
        if (useIniFile && !this.parseArguments.isOptPresent(INI_FILENAME_OPTION_STRING)) {
            if (IniFile.isFilePresent()) {
                new IniFile();
            } else {
                String currentDirectory = Utilities.getCurrentDirectory();
                this.fatalError("Cannot start PC^2, " + IniFile.getINIFilename() + " file not found in " + currentDirectory);
            }
        }
        if (this.parseArguments.isOptPresent("--nosave")) {
            this.saveCofigurationToDisk = false;
        }
        if (this.parseArguments.isOptPresent("--server")) {
            this.info("Starting Server Transport...");
            this.connectionManager.startServerTransport(this);
            this.serverModule = true;
            this.contactingRemoteServer = false;
            this.setServerRemoteHostAndPort(this.parseArguments.getOptValue("--remoteServer"));
            if (!this.isContactingRemoteServer()) {
                this.theProfile = this.getCurrentProfile();
                String profilePath = this.theProfile.getProfilePath();
                this.insureProfileDirectory(this.theProfile);
                this.startLog(profilePath, "pc2.startup", null, null);
            }
            try {
                this.setServerPort(this.parseArguments.getOptValue("--port"));
            }
            catch (NumberFormatException numException) {
                savedTransportException = new TransportException("Unable to parse value after --port '" + this.parseArguments.getOptValue("--port") + "'");
                this.log.log(Log.WARNING, "Exception logged ", numException);
            }
        } else {
            try {
                this.setClientServerAndPort(this.parseArguments.getOptValue("--port"));
                this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort);
                this.connectionManager.startClientTransport(this.remoteHostName, this.remoteHostPort, this);
            }
            catch (NumberFormatException numException) {
                savedTransportException = new TransportException("Unable to parse value after --port '" + this.parseArguments.getOptValue("--port") + "'");
                this.log.log(Log.WARNING, "Exception logged ", numException);
            }
            try {
                this.connectionManager.connectToMyServer();
            }
            catch (TransportException transportException) {
                savedTransportException = transportException;
                this.log.log(Log.INFO, "Exception logged ", transportException);
                this.info("Unable to contact server at " + this.remoteHostName + ":" + port + " " + transportException.getMessage());
            }
        }
        this.isStarted = true;
        if (!this.parseArguments.isOptPresent(LOGIN_OPTION_STRING)) {
            if (this.usingGUI && this.isUsingMainUI()) {
                this.loginUI = this.createLoginFrame();
            }
        } else {
            String loginName = "";
            if (this.parseArguments.isOptPresent(LOGIN_OPTION_STRING)) {
                loginName = this.parseArguments.getOptValue(LOGIN_OPTION_STRING);
            }
            String password = "";
            if (this.parseArguments.isOptPresent(PASSWORD_OPTION_STRING)) {
                password = this.parseArguments.getOptValue(PASSWORD_OPTION_STRING);
            }
            if (this.usingGUI) {
                this.loginUI = this.createLoginFrame();
                this.loginUI.setContestAndController(this.contest, this);
            }
            try {
                if (savedTransportException == null) {
                    this.login(loginName, password);
                }
            }
            catch (Exception e) {
                this.log.log(Log.INFO, "Exception logged ", e);
                if (this.usingGUI) {
                    this.loginUI.setStatusMessage(e.getMessage());
                }
                this.fatalError(e.getMessage());
            }
        }
        String contactInfo = String.valueOf(this.getHostContacted()) + ":" + this.getPortContacted();
        if (this.usingGUI && savedTransportException != null && this.loginUI != null) {
            this.loginUI.disableLoginButton();
            this.loginUI.setStatusMessage("Unable to contact server, contact staff");
            this.showErrorMessage("Unable to contact server at: " + contactInfo, "Error contacting server");
        } else if (savedTransportException != null) {
            this.connectionManager = null;
            this.fatalError("Unable to contact server at: " + contactInfo + ", contact staff", savedTransportException);
        }
    }

    private ILoginUI createLoginFrame() {
        ILoginUI ui = (ILoginUI)this.loadUIClass(this.loginClassName);
        ui.setContestAndController(this.contest, this);
        return ui;
    }

    private UIPlugin loadUIClass(String className) {
        try {
            UIPlugin ui = LoadUIClass.loadUIClass(className);
            return ui;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.log.log(Log.WARNING, "Unable to load UI, class = " + className);
            this.getLog();
            return null;
        }
    }

    private Profile getCurrentProfile() {
        try {
            ProfileManager manager = new ProfileManager();
            if (manager.hasDefaultProfile()) {
                Profile defaultProfile = manager.getDefaultProfile();
                defaultProfile.setSiteNumber(1);
                return defaultProfile;
            }
            Profile newProfile = ProfileManager.createNewProfile();
            newProfile.setSiteNumber(1);
            manager.storeDefaultProfile(newProfile);
            return newProfile;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.fatalError("Unable to start pc2 unable to create initial Profile");
            return null;
        }
    }

    private void handleCommandLineOptions() {
        if (this.parseArguments.isOptPresent("--help")) {
            System.out.println("Usage: Starter [--help] [--server] [--first] [--login <login>] [--password <pass>] [] [--skipini] [--ini filename] [--contestpassword <pass>] [-F filename] [--nogui] [--ui classname]");
            System.exit(0);
        }
        if (this.parseArguments.isOptPresent(FILE_OPTION_STRING)) {
            String propertiesFileName = this.parseArguments.getOptValue(FILE_OPTION_STRING);
            if (!new File(propertiesFileName).exists()) {
                this.fatalError(String.valueOf(propertiesFileName) + " does not exist (pwd: " + Utilities.getCurrentDirectory() + ")", null);
            }
            try {
                this.parseArguments.overRideOptions(propertiesFileName);
            }
            catch (IOException e) {
                this.fatalError("Unable to read file " + propertiesFileName, e);
            }
        }
        if (this.parseArguments.isOptPresent(NO_GUI_OPTION_STRING)) {
            String loginName;
            this.usingGUI = false;
            if (!this.parseArguments.isOptPresent(LOGIN_OPTION_STRING)) {
                this.fatalError("Must specify --login option and login name when using --nogui");
            }
            if ((loginName = this.parseArguments.getOptValue(LOGIN_OPTION_STRING)) == null) {
                this.fatalError("Missing login name after --login");
            }
            ClientId client = null;
            try {
                client = InternalController.loginShortcutExpansion(0, loginName);
            }
            catch (SecurityException e) {
                this.fatalError(e.getLocalizedMessage());
            }
            if (this.overRideUIName == null) {
                if (this.isServer(client)) {
                    this.overRideUIName = "edu.csus.ecs.pc2.ui.server.ServerModule";
                } else if (this.isJudge(client)) {
                    this.overRideUIName = "edu.csus.ecs.pc2.ui.judge.AutoJudgeModule";
                } else if (this.isEventFeeder(client)) {
                    this.overRideUIName = "edu.csus.ecs.pc2.services.eventFeed.EventFeederModule";
                } else {
                    this.fatalError("--nogui can only be used with a judge or server login, login '" + loginName + "' is not a judge or server login.");
                }
            }
        }
        if (this.parseArguments.isOptPresent(DEBUG_OPTION_STRING)) {
            Utilities.setDebugMode(true);
            this.log.info("Debug mode ON");
            this.printDebug("Debug mode ON");
            this.printDebug(String.valueOf(new VersionInfo().getSystemName()) + " Build " + new VersionInfo().getBuildNumber());
            try {
                this.printDebug("Working directory is " + new File(".").getCanonicalPath());
            }
            catch (IOException e1) {
                System.err.println("debug: Could not determine working directory " + e1.getMessage());
                e1.printStackTrace(System.err);
            }
        }
        if (this.parseArguments.isOptPresent(CONTEST_PASSWORD_OPTION)) {
            String newContestPassword = this.parseArguments.getOptValue(CONTEST_PASSWORD_OPTION);
            if (newContestPassword == null) {
                this.fatalError("No contest password found after --contestpassword");
            }
            this.contest.setContestPassword(newContestPassword);
        }
        if (this.parseArguments.isOptPresent(MAIN_UI_OPTION)) {
            String overrideClassName = this.parseArguments.getOptValue(MAIN_UI_OPTION);
            if (overrideClassName == null) {
                this.fatalError("No UI name after --ui");
            }
            this.overRideUIName = overrideClassName;
        }
    }

    private boolean isEventFeeder(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.FEEDER);
    }

    protected void printDebug(String message) {
        System.out.println("debug: " + message);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private ClientId getServerClientId() {
        return new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
    }

    private String getBaseProfileDirectoryName(String dirname) {
        if (this.theProfile != null) {
            return String.valueOf(this.theProfile.getProfilePath()) + File.separator + dirname;
        }
        return dirname;
    }

    private void startLog(String directoryName, String logFileName, String loginName, String clientName) {
        if (directoryName == null) {
            directoryName = this.getBaseProfileDirectoryName("logs");
            Utilities.insureDir(directoryName);
        }
        this.log = new Log(directoryName, logFileName);
        StaticLog.setLog(this.log);
        this.info("");
        this.info(new VersionInfo().getSystemVersionInfo());
        if (loginName != null) {
            this.info("Login: " + loginName + " (aka " + clientName + ")");
        }
        try {
            this.log.info("Working directory is " + new File(".").getCanonicalPath());
        }
        catch (IOException e1) {
            this.log.info("Could not determine working directory " + e1.getMessage());
        }
        try {
            this.log.info("Process id is " + ManagementFactory.getRuntimeMXBean().getName());
        }
        catch (Exception e) {
            this.log.info("Could not determine process id " + e.getMessage());
        }
    }

    @Override
    public void checkOutRun(Run run, boolean readOnly, boolean computerJudge) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunRequest(clientId, this.getServerClientId(), run, clientId, readOnly, computerJudge);
        this.sendToLocalServer(packet);
    }

    @Override
    public void checkOutRejudgeRun(Run run) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunRejudgeRequest(clientId, this.getServerClientId(), run, clientId);
        this.sendToLocalServer(packet);
    }

    @Override
    public void submitRunJudgement(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunJudgement(clientId, this.getServerClientId(), run, judgementRecord, runResultFiles);
        this.sendToLocalServer(packet);
    }

    @Override
    public void cancelRun(Run run) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createUnCheckoutRun(clientId, this.getServerClientId(), run, clientId);
        this.sendToLocalServer(packet);
    }

    @Override
    public void addNewSite(Site site) {
        if (this.isServer()) {
            this.contest.addSite(site);
            try {
                this.contest.storeConfiguration(this.getLog());
                Packet packet = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, site);
                this.sendToServers(packet);
                this.sendToJudges(packet);
                this.sendToAdministrators(packet);
                this.sendToScoreboards(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (FileSecurityException e) {
                e.printStackTrace();
            }
        } else {
            Packet packet = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), site);
            this.sendToLocalServer(packet);
        }
    }

    public void modifySite(Site site) {
        this.contest.changeSite(site);
        Packet packet = PacketFactory.createUpdateSetting(this.getServerClientId(), PacketFactory.ALL_SERVERS, site);
        this.sendToServers(packet);
    }

    @Override
    public void sendServerLoginRequest(int inSiteNumber) throws Exception {
        if (this.isServer()) {
            if (this.isThisSite(inSiteNumber)) {
                System.err.println(" Tried to send login request to ourselves, login to " + inSiteNumber + ", ignored");
                this.log.log(Log.DEBUG, " Tried to send login request to ourselves, login to " + inSiteNumber + ", ignored");
                return;
            }
            Site remoteSite = this.contest.getSite(inSiteNumber);
            Site localSite = this.contest.getSite(this.contest.getSiteNumber());
            String localPassword = localSite.getPassword();
            String hostName = remoteSite.getConnectionInfo().getProperty("IP_KEY");
            String portStr = remoteSite.getConnectionInfo().getProperty("PORT_KEY");
            int portNumber = Integer.parseInt(portStr);
            this.info("Send login request to Site " + remoteSite.getSiteNumber() + " " + hostName + ":" + portStr);
            ConnectionHandlerID connectionHandlerID = this.connectionManager.connectToServer(hostName, portNumber);
            this.info("Contacted Site " + remoteSite.getSiteNumber() + " using connection id " + connectionHandlerID);
            this.sendLoginRequestFromServerToServer(this.connectionManager, connectionHandlerID, this.getServerClientId(), localPassword);
        } else if (this.contest.isAllowed(Permission.Type.ALLOWED_TO_RECONNECT_SERVER)) {
            Packet reconnectPacket = PacketFactory.createReconnectPacket(this.contest.getClientId(), this.getServerClientId(), inSiteNumber);
            this.sendToLocalServer(reconnectPacket);
        } else {
            System.err.println(" Non-admin Tried to send reconnection request " + inSiteNumber + ", ignored");
            this.log.log(Log.DEBUG, " Non-admin Tried to send reconnection request " + inSiteNumber + ", ignored");
            return;
        }
    }

    public boolean isContactingRemoteServer() {
        return this.contactingRemoteServer;
    }

    public void setContactingRemoteServer(boolean contactingRemoteServer) {
        this.contactingRemoteServer = contactingRemoteServer;
    }

    public boolean isUsingMainUI() {
        return this.usingMainUI;
    }

    public void setUsingMainUI(boolean usingMainUI) {
        this.usingMainUI = usingMainUI;
    }

    public UIPlugin getUiPlugin() {
        return this.uiPlugin;
    }

    public void setUiPlugin(UIPlugin uiPlugin) {
        this.uiPlugin = uiPlugin;
    }

    @Override
    public void updateSite(Site site) {
        if (this.isServer()) {
            this.contest.changeSite(site);
            try {
                this.contest.storeConfiguration(this.getLog());
                Packet packet = PacketFactory.createUpdateSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, site);
                this.sendToServers(packet);
                this.sendToJudges(packet);
                this.sendToAdministrators(packet);
                this.sendToScoreboards(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (FileSecurityException e) {
                e.printStackTrace();
            }
        } else {
            Packet packet = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), site);
            this.sendToLocalServer(packet);
        }
    }

    private boolean isServer() {
        return this.contest.getClientId() != null && this.isServer(this.contest.getClientId());
    }

    private boolean isServer(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    @Override
    public final Log getLog() {
        return this.log;
    }

    @Override
    public void generateNewAccounts(String clientTypeName, int siteNumber, int count, int startNumber, boolean active) {
        ClientType.Type type = ClientType.Type.valueOf(clientTypeName);
        Packet packet = PacketFactory.createGenerateAccounts(this.contest.getClientId(), this.getServerClientId(), siteNumber, type, count, startNumber, active);
        this.sendToLocalServer(packet);
    }

    @Override
    public void generateNewAccounts(String clientTypeName, int count, int startNumber, boolean active) {
        this.generateNewAccounts(clientTypeName, this.contest.getSiteNumber(), count, startNumber, active);
    }

    @Override
    public void submitClarification(Problem problem, String question) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Clarification clarification = new Clarification(this.contest.getClientId(), problem, question);
        Packet packet = PacketFactory.createClarificationSubmission(this.contest.getClientId(), serverClientId, clarification);
        this.sendToLocalServer(packet);
    }

    @Override
    public void checkOutClarification(Clarification clarification, boolean readOnly) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createClarificationRequest(this.contest.getClientId(), serverClientId, clarification.getElementId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void cancelClarification(Clarification clarification) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createUnCheckoutClarification(this.contest.getClientId(), serverClientId, clarification);
        this.sendToLocalServer(packet);
    }

    @Override
    public void submitClarificationAnswer(Clarification clarification) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createAnsweredClarification(this.contest.getClientId(), serverClientId, clarification, clarification.getAnswer());
        this.sendToLocalServer(packet);
    }

    @Override
    public void forceConnectionDrop(ConnectionHandlerID connectionHandlerID) {
        if (this.isServer()) {
            if (this.contest.isConnected(connectionHandlerID)) {
                this.log.log(Log.INFO, "forceConnectionDrop: " + connectionHandlerID);
                this.connectionManager.unregisterConnection(connectionHandlerID);
                this.contest.connectionDropped(connectionHandlerID);
            } else if (this.contest.isConnectedToRemoteSite(connectionHandlerID)) {
                Packet forceDiscoPacket = PacketFactory.createForceLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
                this.sendToServers(forceDiscoPacket);
            }
        } else {
            this.contest.connectionDropped(connectionHandlerID);
        }
    }

    @Override
    public void addNewProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        Packet updateProblemPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), problem, problemDataFiles);
        this.sendToLocalServer(updateProblemPacket);
    }

    @Override
    public void addNewProblem(Problem[] problem, ProblemDataFiles[] problemDataFiles) {
        Packet updateProblemPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), problem, problemDataFiles);
        this.sendToLocalServer(updateProblemPacket);
    }

    @Override
    public void updateRun(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles) {
        Packet updateRunPacket = PacketFactory.createRunUpdated(this.contest.getClientId(), this.getServerClientId(), run, judgementRecord, runResultFiles, this.contest.getClientId());
        this.sendToLocalServer(updateRunPacket);
    }

    @Override
    public void addProblem(Problem problem) {
        Packet updateProblemPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), problem, null);
        this.sendToLocalServer(updateProblemPacket);
    }

    @Override
    public void updateProblem(Problem problem) {
        Packet updateProblemPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), problem, null);
        this.sendToLocalServer(updateProblemPacket);
    }

    @Override
    public void updateProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        Packet updateProblemPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), problem, problemDataFiles);
        this.sendToLocalServer(updateProblemPacket);
    }

    @Override
    public ProblemDataFiles getProblemDataFiles(Problem problem) {
        return this.contest.getProblemDataFile(problem);
    }

    @Override
    public void shutdownTransport() {
        this.connectionManager.shutdownTransport();
    }

    @Override
    public void removeConnection(ConnectionHandlerID connectionHandlerID) {
        this.contest.connectionDropped(connectionHandlerID);
        Packet disconnectionPacket = PacketFactory.createDroppedConnection(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
        PacketFactory.dumpPacket(this.log, disconnectionPacket, "removeConnection");
        this.sendToAdministrators(disconnectionPacket);
        this.sendToServers(disconnectionPacket);
    }

    @Override
    public void removeLogin(ClientId clientId) {
        this.contest.removeLogin(clientId);
        try {
            Packet logoffPacket = PacketFactory.createLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, clientId);
            this.sendToAdministrators(logoffPacket);
            if (!this.isServer(clientId)) {
                this.sendToServers(logoffPacket);
            }
        }
        catch (Exception e) {
            this.log.log(Log.SEVERE, "Exception removeLogin ", e);
        }
    }

    @Override
    public void startContest(int inSiteNumber) {
        Packet packet = PacketFactory.createStartContestClock(this.contest.getClientId(), this.getServerClientId(), inSiteNumber, this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void stopContest(int inSiteNumber) {
        Packet packet = PacketFactory.createStopContestClock(this.contest.getClientId(), this.getServerClientId(), inSiteNumber, this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void startAllContestTimes() {
        Packet packet = PacketFactory.createStartAllClocks(this.contest.getClientId(), this.getServerClientId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void stopAllContestTimes() {
        Packet packet = PacketFactory.createStopAllClocks(this.contest.getClientId(), this.getServerClientId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void addNewLanguage(Language language) {
        Packet addLanguagePacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), language);
        this.sendToLocalServer(addLanguagePacket);
    }

    @Override
    public void addNewJudgement(Judgement judgement) {
        Packet addJudgementPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(addJudgementPacket);
    }

    @Override
    public void updateLanguage(Language language) {
        Packet updateLanguagePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), language);
        this.sendToLocalServer(updateLanguagePacket);
    }

    @Override
    public void updateJudgement(Judgement judgement) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void updateAccount(Account account) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), account);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void updateAccounts(Account[] accounts) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), accounts);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void updateCategories(Category[] categories) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), categories);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void addNewAccount(Account account) {
        Packet addAccountPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), account);
        this.sendToLocalServer(addAccountPacket);
    }

    @Override
    public void addNewAccounts(Account[] accounts) {
        Packet addAccountPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), accounts);
        this.sendToLocalServer(addAccountPacket);
    }

    public boolean readConfigFromDisk(int siteNum) {
        boolean loadedConfiguration = false;
        if (this.saveCofigurationToDisk) {
            try {
                loadedConfiguration = this.contest.readConfiguration(siteNum, this.getLog());
            }
            catch (FileNotFoundException fileNotFoundException) {
                loadedConfiguration = false;
            }
            catch (Exception e) {
                this.logException(e);
                this.fatalError("Halting server - configuration file corrupt", e);
                return false;
            }
        }
        return loadedConfiguration;
    }

    @Override
    public void addNewClientSettings(ClientSettings clientSettings) {
        Packet addClientSettingsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), clientSettings);
        this.sendToLocalServer(addClientSettingsPacket);
    }

    @Override
    public void updateClientSettings(ClientSettings clientSettings) {
        Packet updateClientSettingsPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), clientSettings);
        this.sendToLocalServer(updateClientSettingsPacket);
    }

    @Override
    public void updateContestInformation(ContestInformation contestInformation) {
        Packet addAccountPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), contestInformation);
        this.sendToLocalServer(addAccountPacket);
    }

    @Override
    public void setJudgementList(Judgement[] judgementList) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), judgementList);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void removeJudgement(Judgement judgement) {
        Packet deleteJudgmentPacket = PacketFactory.createDeleteSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(deleteJudgmentPacket);
    }

    @Override
    public void addNewBalloonSettings(BalloonSettings newBalloonSettings) {
        Packet newBalloonSettingsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), newBalloonSettings);
        this.sendToLocalServer(newBalloonSettingsPacket);
    }

    @Override
    public void updateBalloonSettings(BalloonSettings balloonSettings) {
        Packet balloonSettingsPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), balloonSettings);
        this.sendToLocalServer(balloonSettingsPacket);
    }

    public int getSiteNumber() {
        return this.contest.getSiteNumber();
    }

    @Override
    public void updateContestTime(ContestTime newContestTime) {
        Packet newContestTimePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), newContestTime);
        this.sendToLocalServer(newContestTimePacket);
    }

    @Override
    public void addNewGroup(Group group) {
        Packet newGroupPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), group);
        this.sendToLocalServer(newGroupPacket);
    }

    @Override
    public void updateGroup(Group group) {
        Packet groupPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), group);
        this.sendToLocalServer(groupPacket);
    }

    @Override
    public int getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void sendSecurityMessageFromServer(ContestSecurityException contestSecurityException, ConnectionHandlerID connectionHandlerID, Packet packet) {
        Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, contestSecurityException.getSecurityMessage(), null, connectionHandlerID, contestSecurityException, packet);
        this.sendToAdministrators(violationPacket);
        this.sendToServers(violationPacket);
        this.contest.newSecurityMessage(contestSecurityException.getClientId(), contestSecurityException.getSecurityMessage(), "", contestSecurityException);
    }

    @Override
    public void sendSecurityMessage(String event, String message, ContestSecurityException contestSecurityException) {
        Packet securityMessagePacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), this.getServerClientId(), event, contestSecurityException.getClientId(), contestSecurityException.getConnectionHandlerID(), contestSecurityException, null);
        this.sendToLocalServer(securityMessagePacket);
    }

    @Override
    public String getHostContacted() {
        return this.remoteHostName;
    }

    @Override
    public int getPortContacted() {
        return this.remoteHostPort;
    }

    @Override
    public void fetchRun(Run run) throws IOException, ClassNotFoundException, FileSecurityException {
        RunFiles runFiles = this.contest.getRunFiles(run);
        if (runFiles != null) {
            this.contest.updateRun(run, runFiles, null, null);
        } else {
            Packet fetchRunPacket = PacketFactory.createFetchRun(this.contest.getClientId(), this.getServerClientId(), run, this.contest.getClientId());
            this.sendToLocalServer(fetchRunPacket);
        }
    }

    private void sendStatusMessge(Run run, RunExecutionStatus status) {
        if (this.contest.isSendAdditionalRunStatusMessages()) {
            Packet sendPacket = PacketFactory.createRunStatusPacket(this.contest.getClientId(), this.getServerClientId(), run, this.contest.getClientId(), status);
            this.sendToLocalServer(sendPacket);
        }
    }

    @Override
    public void sendCompilingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.COMPILING);
    }

    @Override
    public void sendExecutingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.EXECUTING);
    }

    @Override
    public void sendValidatingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.VALIDATING);
    }

    @Override
    public boolean isClientAutoShutdown() {
        return this.clientAutoShutdown;
    }

    @Override
    public void setClientAutoShutdown(boolean clientAutoShutdown) {
        this.clientAutoShutdown = clientAutoShutdown;
    }

    @Override
    public void resetContest(ClientId clientResettingContest, boolean eraseProblems, boolean eraseLanguages) {
        Profile currentProfile = this.contest.getProfile();
        Packet sendPacket = PacketFactory.createResetAllSitesPacket(this.contest.getClientId(), this.getServerClientId(), clientResettingContest, currentProfile, eraseProblems, eraseLanguages);
        this.sendToLocalServer(sendPacket);
    }

    @Override
    public void cloneProfile(Profile profile, ProfileCloneSettings settings, boolean switchNow) {
        Packet sendPacket = PacketFactory.createCloneProfilePacket(this.contest.getClientId(), this.getServerClientId(), profile, settings, switchNow);
        this.sendToLocalServer(sendPacket);
    }

    @Override
    public void switchProfile(Profile currentProfile, Profile switchToProfile, String contestPassword) {
        Packet sendPacket = PacketFactory.createSwitchProfilePacket(this.contest.getClientId(), this.getServerClientId(), currentProfile, switchToProfile, contestPassword);
        this.sendToLocalServer(sendPacket);
    }

    @Override
    public void updateProfile(Profile profile) {
        Packet updateProfilePackert = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), profile);
        this.sendToLocalServer(updateProfilePackert);
    }

    protected void warning(String message, Exception ex) {
        if (this.log != null) {
            if (ex != null) {
                this.log.log(Log.WARNING, message, ex);
            } else {
                this.log.log(Log.WARNING, message);
            }
        }
        System.err.println(message);
        if (Utilities.isDebugMode() && ex != null) {
            ex.printStackTrace(System.err);
        }
    }

    private void showErrorMessage(String message, String title) {
        System.err.println(String.valueOf(title) + ": " + message);
    }

    protected void fatalError(String message, Exception ex) {
        if (this.log != null) {
            if (ex != null) {
                this.log.log(Log.SEVERE, message, ex);
            } else {
                this.log.log(Log.SEVERE, message);
            }
            if (this.haltOnFatalError) {
                this.log.log(Log.INFO, "PC^2 halted");
            }
        }
        if (this.usingGUI) {
            this.showErrorMessage(String.valueOf(message) + " check logs", "PC^2 Halted");
            if (Utilities.isDebugMode() && ex != null) {
                ex.printStackTrace(System.err);
            }
        } else {
            System.err.println(message);
            if (Utilities.isDebugMode() && ex != null) {
                ex.printStackTrace(System.err);
            }
            if (this.haltOnFatalError) {
                System.err.println("PC^2 Halted - check logs");
            }
        }
        if (this.haltOnFatalError) {
            System.exit(4);
        }
    }

    private void fatalError(String message) {
        this.fatalError(message, null);
    }

    @Override
    public void setContest(IInternalContest newContest) {
        this.contest = newContest;
        this.packetHandler = new PacketHandler(this, newContest);
        this.runSubmitterInterfaceManager.setContestAndController(newContest, this);
    }

    @Override
    public void register(UIPlugin plugin) {
        this.pluginList.register(plugin);
    }

    @Override
    public UIPlugin[] getPluginList() {
        return this.pluginList.getList();
    }

    private void firePacketListener(PacketEvent packetEvent) {
        int i = 0;
        while (i < this.packetListenerList.size()) {
            if (packetEvent.getAction() == PacketEvent.Action.RECEIVED) {
                this.packetListenerList.elementAt(i).packetReceived(packetEvent);
            } else {
                this.packetListenerList.elementAt(i).packetSent(packetEvent);
            }
            ++i;
        }
    }

    @Override
    public void updateContestController(IInternalContest inContest, IInternalController inController) {
        this.setContest(inContest);
        ClientId clientId = this.contest.getClientId();
        String id = clientId.getName();
        try {
            if (this.log != null) {
                this.log.close();
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        this.setTheProfile(inContest.getProfile());
        this.startLog(this.getBaseProfileDirectoryName("logs"), this.stripChar(clientId.toString(), ' '), id, clientId.getName());
        if (this.evaluationLog != null) {
            this.evaluationLog.closeEvalLog();
            this.evaluationLog = null;
        }
        if (this.evaluationLog == null) {
            String logDirectory = this.getBaseProfileDirectoryName("logs");
            Utilities.insureDir(logDirectory);
            this.evaluationLog = new EvaluationLog(String.valueOf(logDirectory) + File.separator + "evals.log", inContest, this);
            this.evaluationLog.getEvalLog().println("# Log opened " + new Date());
            this.info("evals.log is opened at " + logDirectory);
        }
        try {
            new ProfileManager().mergeProfiles(this.contest);
        }
        catch (Exception e) {
            this.logException(e);
        }
        UIPlugin[] uIPluginArray = this.getPluginList();
        int n = uIPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIPlugin plugin = uIPluginArray[n2];
            try {
                plugin.setContestAndController(this.contest, inController);
                inController.getLog().info("plugin.setContestAndController for " + plugin.getPluginTitle());
                if (Utilities.isDebugMode()) {
                    System.out.println("plugin.setContestAndController for " + plugin.getPluginTitle());
                }
            }
            catch (Exception e) {
                this.logException(e);
            }
            ++n2;
        }
        this.packetHandler = new PacketHandler(this, this.contest);
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
        } else {
            e.printStackTrace(System.err);
        }
    }

    private void logException(String message, Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception - " + message, e);
            if (Utilities.isDebugMode()) {
                System.err.println("Exception - " + message);
                e.printStackTrace(System.err);
            }
        } else {
            System.err.println("Exception - " + message);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void addPacketListener(IPacketListener packetListener) {
        this.packetListenerList.addElement(packetListener);
    }

    @Override
    public void removePacketListener(IPacketListener packetListener) {
        this.packetListenerList.removeElement(packetListener);
    }

    @Override
    public void incomingPacket(Packet packet) {
        PacketEvent event = new PacketEvent(PacketEvent.Action.RECEIVED, packet);
        this.firePacketListener(event);
    }

    @Override
    public void outgoingPacket(Packet packet) {
        PacketEvent event = new PacketEvent(PacketEvent.Action.SENT, packet);
        this.firePacketListener(event);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public boolean isUsingGUI() {
        return this.usingGUI;
    }

    @Override
    public ILogWindow startLogWindow(IInternalContest inContest) {
        if (!this.isUsingGUI()) {
            return null;
        }
        if (this.logWindow != null) {
            this.logWindow.dispose();
        }
        this.logWindow = null;
        this.logWindow = (ILogWindow)this.loadUIClass(this.logWindowClassName);
        this.logWindow.setContestAndController(inContest, this);
        this.logWindow.setTitle("Log " + inContest.getClientId().toString());
        return this.logWindow;
    }

    @Override
    public void showLogWindow(boolean showWindow) {
        if (this.isUsingGUI()) {
            this.logWindow.setVisible(showWindow);
        }
    }

    @Override
    public boolean isLogWindowVisible() {
        if (this.isUsingGUI()) {
            this.logWindow.isVisible();
        }
        return false;
    }

    public void logWarning(String string) {
        this.log.log(Log.WARNING, string);
        System.err.println("Warning: " + string);
    }

    @Override
    public void logWarning(String string, Exception e) {
        this.log.log(Log.WARNING, string, e);
        System.err.println("Warning: " + string);
        this.printStackTraceTop(e, System.err, 5);
    }

    public void logSevere(String string, Exception e) {
        this.log.log(Log.SEVERE, string, e);
        System.err.println("Severe Error: " + string);
        this.printStackTraceTop(e, System.err, 5);
    }

    private void printStackTraceTop(Throwable throwable, PrintStream printStream, int count) {
        printStream.println("Exception " + throwable.getClass().getName() + ": " + throwable.getMessage());
        StackTraceElement[] elements = throwable.getStackTrace();
        int i = 0;
        while (i < count) {
            StackTraceElement stackTraceElement = elements[i];
            String sourceName = "(Unknown Source)";
            if (stackTraceElement.getFileName() != null) {
                sourceName = "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
            }
            printStream.println("     at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " " + sourceName);
            ++i;
        }
    }

    @Override
    public void syncProfileSubmissions(Profile profile) {
        Packet packet = PacketFactory.createSwitchSynchronizePacket(this.contest.getClientId(), this.getServerClientId(), profile);
        this.sendToLocalServer(packet);
    }

    @Override
    public void sendShutdownAllSites() {
        Packet packet = PacketFactory.createShutdownAllServersPacket(this.contest.getClientId(), this.getServerClientId());
        this.sendToLocalServer(packet);
    }

    @Override
    public void sendShutdownSite(int siteNumber) {
        Packet packet = PacketFactory.createShutdownPacket(this.contest.getClientId(), this.getServerClientId(), siteNumber);
        this.sendToLocalServer(packet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdownServer(ClientId requestor) {
        if (!this.isServer()) throw new SecurityException("Attempted to shutdown non-server client");
        if (!this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_ALL_SERVERS)) {
            if (!this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_SERVER)) throw new SecurityException("User " + requestor + " not allowed to shutdown Server");
        }
        try {
            ContestSummaryReports contestReports = new ContestSummaryReports();
            contestReports.setContestAndController(this.contest, this);
            if (contestReports.isLateInContest()) {
                contestReports.generateReports();
                this.log.info("Reports Generated to " + contestReports.getReportDirectory());
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Unable to create reports ", e);
        }
        this.log.info("Server " + this.contest.getSiteNumber() + " halted by " + requestor);
        System.exit(0);
    }

    @Override
    public void shutdownRemoteServers(ClientId requestor) {
        if (this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_ALL_SERVERS)) {
            ClientId[] clientIds;
            ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                Packet shutdownPacket = PacketFactory.createShutdownPacket(requestor, clientId, clientId.getSiteNumber());
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                this.sendToClient(connectionHandlerID, shutdownPacket);
                ++n2;
            }
        } else {
            throw new SecurityException("User " + requestor + " not allowed to shutdown remote servers");
        }
    }

    @Override
    public void shutdownServer(ClientId requestor, int siteNumber) {
        if (this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_ALL_SERVERS) || this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_SERVER)) {
            if (siteNumber == this.contest.getSiteNumber()) {
                this.shutdownServer(requestor);
            } else {
                ClientId serverId = this.getServerClientId(siteNumber);
                Packet shutdownPacket = PacketFactory.createShutdownPacket(requestor, serverId, siteNumber);
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(serverId);
                this.sendToClient(connectionHandlerID, shutdownPacket);
            }
        } else {
            throw new SecurityException("User " + requestor + " not allowed to shutdown remote servers");
        }
    }

    protected ClientId getServerClientId(int siteNumber) {
        return new ClientId(siteNumber, ClientType.Type.SERVER, 0);
    }

    @Override
    public void updateFinalizeData(FinalizeData data) {
        Packet updateFinalizePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), data);
        this.sendToLocalServer(updateFinalizePacket);
    }

    @Override
    public void setUsingGUI(boolean usingGUI) {
        this.usingGUI = usingGUI;
    }

    @Override
    public void updateCategory(Category newCategory) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), newCategory);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void addNewCategory(Category newCategory) {
        Packet addNewCategory = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), newCategory);
        this.sendToLocalServer(addNewCategory);
    }

    @Override
    public void startPlayback(PlaybackInfo playbackInfo) {
        Packet startPacket = PacketFactory.createStartPlayback(this.contest.getClientId(), this.getServerClientId(), playbackInfo);
        this.sendToLocalServer(startPacket);
    }

    @Override
    public void submitRun(Problem problem, Language language, String filename, SerializedFile[] otherFiles, long overrideSubmissionTime, long overrideRunId) {
        SerializedFile serializedFile = new SerializedFile(filename);
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Run run = new Run(this.contest.getClientId(), language, problem);
        RunFiles runFiles = new RunFiles(run, serializedFile, otherFiles);
        Packet packet = PacketFactory.createSubmittedRun(this.contest.getClientId(), serverClientId, run, runFiles, overrideSubmissionTime, overrideRunId);
        this.sendToLocalServer(packet);
    }

    @Override
    public void sendRunToSubmissionInterface(Run run, RunFiles runFiles) {
        try {
            this.runSubmitterInterfaceManager.sendRun(run, runFiles);
        }
        catch (Exception e) {
            this.logException("Failure in RSI ", e);
            e.printStackTrace();
        }
    }

    public void addConsoleLogging() {
        if (this.log != null) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            this.log.addHandler(consoleHandler);
        } else {
            System.err.println("Unable to add console logging, log is null");
        }
    }

    public Profile getTheProfile() {
        return this.theProfile;
    }

    public void setTheProfile(Profile theProfile) {
        this.theProfile = theProfile;
    }

    @Override
    public void autoRegister(String loginName) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        ClientId fauxClientId = new ClientId(0, ClientType.Type.OTHER, 0);
        Packet packet = PacketFactory.createAutoRegisterRequest(fauxClientId, serverClientId, loginName);
        this.sendToLocalServer(packet);
    }

    @Override
    public void setConnectionManager(ITransportManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setHaltOnFatalError(boolean haltOnFatalError) {
        this.haltOnFatalError = haltOnFatalError;
    }

    public boolean isHaltOnFatalError() {
        return this.haltOnFatalError;
    }

    @Override
    public void addNewLanguages(Language[] languages) {
        Packet addPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), languages);
        this.sendToLocalServer(addPacket);
    }

    @Override
    public void updateLanguages(Language[] languages) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), languages);
        this.sendToLocalServer(updatePacket);
    }

    @Override
    public void addNewGroups(Group[] groups) {
        Packet addPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), groups);
        this.sendToLocalServer(addPacket);
    }

    @Override
    public void updateGroups(Group[] groups) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), groups);
        this.sendToLocalServer(updatePacket);
    }

    protected class TemporaryClientUI
    implements UIPlugin,
    ILoginListener {
        private IInternalContest contest = null;
        private IInternalController controller = null;
        private SecurityException securityException = null;
        private static final long serialVersionUID = 8735788359720905862L;

        protected TemporaryClientUI() {
        }

        @Override
        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            this.contest = inContest;
            this.controller = inController;
        }

        @Override
        public String getPluginTitle() {
            return "TemporaryClientUI";
        }

        public IInternalContest getContest() {
            if (this.securityException != null) {
                throw this.securityException;
            }
            return this.contest;
        }

        public void setContest(IInternalContest contest) {
            this.contest = contest;
        }

        public IInternalController getController() {
            return this.controller;
        }

        public void setController(IInternalController controller) {
            this.controller = controller;
        }

        @Override
        public void loginAdded(LoginEvent event) {
        }

        @Override
        public void loginRemoved(LoginEvent event) {
        }

        @Override
        public void loginDenied(LoginEvent event) {
            this.securityException = new SecurityException("Login denied " + event.getMessage());
        }

        @Override
        public void loginRefreshAll(LoginEvent event) {
        }
    }
}

