/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemDataFilesList;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.Submission;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ContestLoader {
    protected void addAllAccountsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                Object[] objectArray = accounts;
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Account account = objectArray[n2];
                    if (this.isServer(contest)) {
                        if (!this.isThisSite(contest, account)) {
                            contest.updateAccount(account);
                        }
                    } else {
                        contest.updateAccount(account);
                    }
                    ++n2;
                }
                objectArray = ClientType.Type.values();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Account type = objectArray[n2];
                    this.addMissingLocalAccounts(contest, accounts, (ClientType.Type)((Object)type));
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    private void addMissingLocalAccounts(IInternalContest contest, Account[] accounts, ClientType.Type type) {
        Vector<Account> vector;
        if (this.isServer(contest) && (vector = contest.getAccounts(type, contest.getSiteNumber())).size() == 0) {
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (this.isThisSite(contest, account) && account.getClientId().getClientType().equals((Object)type)) {
                    contest.updateAccount(account);
                }
                ++n2;
            }
        }
    }

    protected void addAllClarificationsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                Clarification[] clarificationArray = clarifications;
                int n = clarifications.length;
                int n2 = 0;
                while (n2 < n) {
                    Clarification clarification = clarificationArray[n2];
                    if (!this.isServer(contest) || !this.isThisSite(contest, clarification)) {
                        if (contest.getClarification(clarification.getElementId()) != null) {
                            contest.updateClarification(clarification, null);
                        } else {
                            contest.addClarification(clarification);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllClientSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                ClientSettings[] clientSettingsArray = clientSettings;
                int n = clientSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientSettings clientSettings2 = clientSettingsArray[n2];
                    ClientId clientId = clientSettings2.getClientId();
                    if (this.isServer(contest)) {
                        if (!this.isThisSite(contest, clientId)) {
                            contest.updateClientSettings(clientSettings2);
                        }
                    } else {
                        contest.updateClientSettings(clientSettings2);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllConnectionIdsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ConnectionHandlerID[] connectionHandlerIDs = (ConnectionHandlerID[])PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID_LIST");
            if (connectionHandlerIDs != null) {
                ConnectionHandlerID[] connectionHandlerIDArray = connectionHandlerIDs;
                int n = connectionHandlerIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionHandlerID connectionHandlerID = connectionHandlerIDArray[n2];
                    contest.connectionEstablished(connectionHandlerID);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllContestTimesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                ContestTime[] contestTimeArray = contestTimes;
                int n = contestTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    ContestTime contestTime = contestTimeArray[n2];
                    if (contest.getSiteNumber() != contestTime.getSiteNumber()) {
                        if (contest.getContestTime(contestTime.getSiteNumber()) != null) {
                            contest.updateContestTime(contestTime);
                        } else {
                            contest.addContestTime(contestTime);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllRunsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (!this.isServer(contest) || !this.isThisSite(contest, run)) {
                        contest.addRun(run);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addBalloonSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            BalloonSettings[] balloonSettings = (BalloonSettings[])PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS_LIST");
            if (balloonSettings != null) {
                BalloonSettings[] balloonSettingsArray = balloonSettings;
                int n = balloonSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    BalloonSettings balloonSettings2 = balloonSettingsArray[n2];
                    contest.updateBalloonSettings(balloonSettings2);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addContestInformationToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestInformation contestInformation = (ContestInformation)PacketFactory.getObjectValue(packet, "CONTEST_INFORMATION");
            if (contestInformation != null) {
                contest.updateContestInformation(contestInformation);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void setFinalizeData(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            FinalizeData finalizeData = (FinalizeData)PacketFactory.getObjectValue(packet, "FINALIZE_DATA");
            if (finalizeData != null) {
                contest.setFinalizeData(finalizeData);
                if (finalizeData.isCertified()) {
                    controller.getLog().log(Log.INFO, "Contest Certified by '" + finalizeData.getComment() + "'");
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged in load Finalize Data ", e);
        }
    }

    protected void addGeneralProblemToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Problem generalProblem = (Problem)PacketFactory.getObjectValue(packet, "GENERAL_PROBLEM");
            if (generalProblem != null) {
                contest.setGeneralProblem(generalProblem);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged in General Problem ", e);
        }
    }

    protected void addGroupsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Group[] groups = (Group[])PacketFactory.getObjectValue(packet, "GROUP_LIST");
            if (groups != null) {
                Group[] groupArray = groups;
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    Group group = groupArray[n2];
                    if (contest.getGroup(group.getElementId()) != null) {
                        contest.updateGroup(group);
                    } else {
                        contest.addGroup(group);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addJudgementsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Judgement[] judgements = (Judgement[])PacketFactory.getObjectValue(packet, "JUDGEMENT_LIST");
            if (judgements != null) {
                Judgement[] judgementArray = judgements;
                int n = judgements.length;
                int n2 = 0;
                while (n2 < n) {
                    Judgement judgement = judgementArray[n2];
                    if (contest.getJudgement(judgement.getElementId()) != null) {
                        contest.updateJudgement(judgement);
                    } else {
                        contest.addJudgement(judgement);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addCategoriesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Category[] categories = (Category[])PacketFactory.getObjectValue(packet, "CATEGORY_LIST");
            if (categories != null) {
                Category[] categoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    Category category = categoryArray[n2];
                    if (contest.getCategory(category.getElementId()) != null) {
                        contest.updateCategory(category);
                    } else {
                        contest.addCategory(category);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addLanguagesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Language[] languages = (Language[])PacketFactory.getObjectValue(packet, "LANGUAGE_LIST");
            if (languages != null) {
                Language[] languageArray = languages;
                int n = languages.length;
                int n2 = 0;
                while (n2 < n) {
                    Language language = languageArray[n2];
                    if (contest.getLanguage(language.getElementId()) != null) {
                        contest.updateLanguage(language);
                    } else {
                        contest.addLanguage(language);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addLoginsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        block15: {
            try {
                ConnectionHandlerID fakeId;
                ClientId clientId;
                int n;
                int n2;
                ClientId[] clientIdArray;
                ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "REMOTE_LOGGED_IN_USERS");
                if (clientIds != null) {
                    clientIdArray = clientIds;
                    n2 = clientIds.length;
                    n = 0;
                    while (n < n2) {
                        clientId = clientIdArray[n];
                        try {
                            if (this.isServer(contest)) {
                                if (!contest.isLocalLoggedIn(clientId) && !this.isThisSite(contest, clientId)) {
                                    fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                                    contest.addRemoteLogin(clientId, fakeId);
                                }
                            } else {
                                fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                                contest.addRemoteLogin(clientId, fakeId);
                            }
                        }
                        catch (Exception e) {
                            controller.logWarning("Exception in adding login to model ", e);
                        }
                        ++n;
                    }
                }
                if ((clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOCAL_LOGGED_IN_USERS")) == null) break block15;
                clientIdArray = clientIds;
                n2 = clientIds.length;
                n = 0;
                while (n < n2) {
                    clientId = clientIdArray[n];
                    try {
                        if (this.isServer(contest)) {
                            if (!contest.isLocalLoggedIn(clientId) && !this.isThisSite(contest, clientId)) {
                                fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                                contest.addRemoteLogin(clientId, fakeId);
                            }
                        } else {
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            contest.addLocalLogin(clientId, fakeId);
                        }
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception in adding login to model ", e);
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                controller.logWarning("Exception in adding logins to model ", e);
            }
        }
    }

    protected void addProblemsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        int n;
        int n2;
        IElementObject[] iElementObjectArray;
        ProblemDataFilesList problemDataFilesList = new ProblemDataFilesList();
        try {
            ProblemDataFiles[] problemDataFiles = (ProblemDataFiles[])PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
            if (problemDataFiles != null) {
                iElementObjectArray = problemDataFiles;
                n2 = problemDataFiles.length;
                n = 0;
                while (n < n2) {
                    IElementObject problemDataFile = iElementObjectArray[n];
                    problemDataFilesList.add(problemDataFile);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
        try {
            Problem[] problems = (Problem[])PacketFactory.getObjectValue(packet, "PROBLEM_LIST");
            if (problems != null) {
                iElementObjectArray = problems;
                n2 = problems.length;
                n = 0;
                while (n < n2) {
                    IElementObject problem = iElementObjectArray[n];
                    ProblemDataFiles problemDataFiles = (ProblemDataFiles)problemDataFilesList.get(problem);
                    if (contest.getProblem(((Problem)problem).getElementId()) != null) {
                        if (problemDataFiles == null) {
                            contest.updateProblem((Problem)problem);
                        } else {
                            contest.updateProblem((Problem)problem, problemDataFiles);
                        }
                    } else if (problemDataFiles == null) {
                        contest.addProblem((Problem)problem);
                    } else {
                        contest.addProblem((Problem)problem, problemDataFiles);
                    }
                    ++n;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addProfilesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Profile[] profiles = (Profile[])PacketFactory.getObjectValue(packet, "PROFILE_LIST");
            if (profiles != null) {
                Profile[] profileArray = profiles;
                int n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile = profileArray[n2];
                    contest.updateProfile(profile);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteAccountsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                Account[] accountArray = accounts;
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Account account = accountArray[n2];
                    if (remoteSiteNumber == account.getSiteNumber()) {
                        contest.updateAccount(account);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    public void loadIfMissingAccountToModel(IInternalContest contest, IInternalController controller, Packet packet, ClientType.Type type) {
        try {
            int siteNumber = contest.getSiteNumber();
            int count = contest.getAccounts(type, siteNumber).size();
            int numAdded = 0;
            if (count == 0) {
                Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
                if (accounts != null) {
                    Account[] accountArray = accounts;
                    int n = accounts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Account account = accountArray[n2];
                        if (siteNumber == account.getSiteNumber() && account.getClientId().getClientType().equals((Object)type) && contest.getAccount(account.getClientId()) == null) {
                            contest.updateAccount(account);
                            ++numAdded;
                        }
                        ++n2;
                    }
                }
                controller.getLog().log(Log.INFO, "Loaded " + numAdded + " " + (Object)((Object)type) + " Accounts for site " + siteNumber);
            } else {
                controller.getLog().log(Log.INFO, "No accounts loaded " + count + " accounts exists for site " + siteNumber);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteAllClientSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                ClientSettings[] clientSettingsArray = clientSettings;
                int n = clientSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientSettings clientSettings2 = clientSettingsArray[n2];
                    if (remoteSiteNumber == clientSettings2.getSiteNumber()) {
                        contest.updateClientSettings(clientSettings2);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteClarificationsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                Clarification[] clarificationArray = clarifications;
                int n = clarifications.length;
                int n2 = 0;
                while (n2 < n) {
                    Clarification clarification = clarificationArray[n2];
                    if (remoteSiteNumber == clarification.getSiteNumber()) {
                        contest.addClarification(clarification);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteContestTimesToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                ContestTime[] contestTimeArray = contestTimes;
                int n = contestTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    ContestTime contestTime = contestTimeArray[n2];
                    if (remoteSiteNumber == contestTime.getSiteNumber()) {
                        if (contest.getContestTime(contestTime.getSiteNumber()) != null) {
                            contest.updateContestTime(contestTime);
                        } else {
                            contest.addContestTime(contestTime);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteLoginsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        block17: {
            try {
                ConnectionHandlerID fakeId;
                ClientId clientId;
                int n;
                int n2;
                ClientId[] clientIdArray;
                ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOCAL_LOGGED_IN_USERS");
                if (clientIds != null) {
                    clientIdArray = clientIds;
                    n2 = clientIds.length;
                    n = 0;
                    while (n < n2) {
                        clientId = clientIdArray[n];
                        try {
                            if (this.isServer(clientId)) {
                                if (!contest.isLocalLoggedIn(clientId) && !this.isThisSite(contest, clientId)) {
                                    fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                                    contest.addRemoteLogin(clientId, fakeId);
                                }
                            } else if (remoteSiteNumber == clientId.getSiteNumber()) {
                                fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + "-" + clientId);
                                contest.addRemoteLogin(clientId, fakeId);
                            }
                        }
                        catch (Exception e) {
                            controller.logWarning("Exception while adding remote login ", e);
                        }
                        ++n;
                    }
                }
                if ((clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "REMOTE_LOGGED_IN_USERS")) == null) break block17;
                clientIdArray = clientIds;
                n2 = clientIds.length;
                n = 0;
                while (n < n2) {
                    clientId = clientIdArray[n];
                    try {
                        if (this.isServer(clientId)) {
                            if (!contest.isLocalLoggedIn(clientId) && !this.isThisSite(contest, clientId)) {
                                fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                                contest.addRemoteLogin(clientId, fakeId);
                            }
                        } else if (remoteSiteNumber == clientId.getSiteNumber()) {
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + "-" + clientId);
                            contest.addRemoteLogin(clientId, fakeId);
                        }
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception while adding remote login ", e);
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                controller.logWarning("Exception while adding remote logins ", e);
            }
        }
    }

    protected void addRemoteRunsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (!this.isThisSite(contest, run.getSiteNumber())) {
                        contest.updateRun(run, packet.getSourceId());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addSitesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Site[] sites = (Site[])PacketFactory.getObjectValue(packet, "SITE_LIST");
            if (sites != null) {
                Site[] siteArray = sites;
                int n = sites.length;
                int n2 = 0;
                while (n2 < n) {
                    Site site = siteArray[n2];
                    contest.updateSite(site);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void initializeContestTime(IInternalContest contest, IInternalController controller, Packet packet) {
        if (this.isServer(contest) && contest.getContestTime() == null) {
            ContestTime contestTime = new ContestTime(contest.getSiteNumber());
            contest.addContestTime(contestTime);
        }
    }

    private boolean isServer(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isServer(IInternalContest contest) {
        ClientId id = contest.getClientId();
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isThisSite(IInternalContest contest, Account account) {
        return account.getSiteNumber() == contest.getSiteNumber();
    }

    private boolean isThisSite(IInternalContest contest, ClientId id) {
        return this.isThisSite(contest, id.getSiteNumber());
    }

    private boolean isThisSite(IInternalContest contest, int siteNumber) {
        return siteNumber == contest.getSiteNumber();
    }

    private boolean isThisSite(IInternalContest contest, Submission submission) {
        return submission.getSiteNumber() == contest.getSiteNumber();
    }

    protected void updateContestTimeInModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestTime contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME");
            if (contestTime != null) {
                if (this.isServer(contest)) {
                    if (this.isThisSite(contest, contestTime.getSiteNumber())) {
                        controller.setContestTime(contestTime);
                    } else if (contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        contest.addContestTime(contestTime);
                    } else {
                        contest.updateContestTime(contestTime);
                    }
                } else {
                    GregorianCalendar serverTransmitTime = (GregorianCalendar)PacketFactory.getObjectValue(packet, "SERVER_CLOCK_OFFSET");
                    contestTime.calculateLocalClockOffset(serverTransmitTime);
                    if (contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        contest.addContestTime(contestTime);
                    } else {
                        contest.updateContestTime(contestTime);
                    }
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    public void loadDataIntoModel(IInternalContest contest, IInternalController controller, Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientId who = packet.getDestinationId();
        if (who != null) {
            contest.setClientId(who);
        }
        controller.setSiteNumber(who.getSiteNumber());
        this.setProfileIntoModel(contest, controller, packet);
        this.addSitesToModel(contest, controller, packet);
        if (this.isServer(contest)) {
            controller.initializeServer(contest);
        }
        this.addLanguagesToModel(contest, controller, packet);
        this.addProblemsToModel(contest, controller, packet);
        this.addCategoriesToModel(contest, controller, packet);
        this.addGroupsToModel(contest, controller, packet);
        this.addJudgementsToModel(contest, controller, packet);
        this.updateContestTimeInModel(contest, controller, packet);
        this.addContestInformationToModel(contest, controller, packet);
        this.addAllClientSettingsToModel(contest, controller, packet);
        this.initializeContestTime(contest, controller, packet);
        this.addAllContestTimesToModel(contest, controller, packet);
        this.addAllRunsToModel(contest, controller, packet);
        this.addAllClarificationsToModel(contest, controller, packet);
        this.addAllAccountsToModel(contest, controller, packet);
        this.addAllConnectionIdsToModel(contest, controller, packet);
        this.addLoginsToModel(contest, controller, packet);
        this.addBalloonSettingsToModel(contest, controller, packet);
        this.addProfilesToModel(contest, controller, packet);
        this.addGeneralProblemToModel(contest, controller, packet);
        this.setFinalizeData(contest, controller, packet);
    }

    protected void setProfileIntoModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            String contestId = (String)PacketFactory.getObjectValue(packet, "CONTEST_IDENTIFIER");
            contest.setContestIdentifier(contestId);
            Profile newProfile = (Profile)PacketFactory.getObjectValue(packet, "NEW_PROFILE");
            Profile profile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE");
            if (newProfile != null) {
                contest.setProfile(newProfile);
            } else if (profile != null) {
                contest.setProfile(profile);
            }
        }
        catch (Exception e) {
            controller.logWarning("Unable to load profile into model ", e);
        }
    }
}

