/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.api.exceptions.LoadContestDataException;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.NoteList;
import edu.csus.ecs.pc2.core.NoteMessage;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Site;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ContestImporter {
    private NoteList noteList = new NoteList();

    public void sendContestSettingsToServer(IInternalController theController, IInternalContest theContest, IInternalContest newContest) throws LoadContestDataException {
        Object existingSite22;
        int n;
        ContestInformation contestInformation = null;
        try {
            if (newContest.getContestInformation().getContestTitle() != null) {
                contestInformation = newContest.getContestInformation();
                contestInformation.setContestTitle(newContest.getContestInformation().getContestTitle());
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Contest Information", e);
        }
        try {
            Site[] siteArray = newContest.getSites();
            n = siteArray.length;
            int n2 = 0;
            while (n2 < n) {
                Site site = siteArray[n2];
                existingSite22 = theContest.getSite(site.getSiteNumber());
                if (existingSite22 != null) {
                    Site updatedSite = ((Site)existingSite22).clone();
                    if (!site.isSameAs(updatedSite)) {
                        updatedSite.setDisplayName(site.getDisplayName());
                        updatedSite.setPassword(site.getPassword());
                        updatedSite.setConnectionInfo(site.getConnectionInfo());
                        updatedSite.setConnectionDisplayInfo(site.getConnectionDisplayInfo());
                        theController.updateSite(updatedSite);
                    }
                } else {
                    theController.addNewSite(site);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Site Information", e);
        }
        try {
            HashMap<String, Object> langHash = new HashMap<String, Object>();
            existingSite22 = theContest.getLanguages();
            int n3 = ((Language[])existingSite22).length;
            n = 0;
            while (n < n3) {
                Object existingLanguage = existingSite22[n];
                if (((Language)existingLanguage).isActive()) {
                    langHash.put(((Language)existingLanguage).getDisplayName(), existingLanguage);
                }
                ++n;
            }
            ArrayList<Language> addLangList = new ArrayList<Language>();
            ArrayList<Language> updateLangList = new ArrayList<Language>();
            Language[] languageArray = newContest.getLanguages();
            int updatedSite = languageArray.length;
            int existingSite22 = 0;
            while (existingSite22 < updatedSite) {
                Language language = languageArray[existingSite22];
                if (langHash.containsKey(language.getDisplayName())) {
                    Language newLanguage = (Language)langHash.get(language.getDisplayName());
                    if (!newLanguage.isSameAs(language)) {
                        newLanguage.setCompileCommandLine(language.getCompileCommandLine());
                        newLanguage.setExecutableIdentifierMask(language.getExecutableIdentifierMask());
                        newLanguage.setProgramExecuteCommandLine(language.getProgramExecuteCommandLine());
                        updateLangList.add(newLanguage);
                    }
                } else {
                    addLangList.add(language);
                }
                ++existingSite22;
            }
            if (updateLangList.size() > 0) {
                theController.updateLanguages(updateLangList.toArray(new Language[updateLangList.size()]));
            }
            if (addLangList.size() > 0) {
                theController.addNewLanguages(addLangList.toArray(new Language[addLangList.size()]));
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Language Information", e);
        }
        Vector<Account> addAccountsVector = new Vector<Account>();
        try {
            HashMap<String, Account> accountHash = new HashMap<String, Account>();
            Account[] updatedSite = theContest.getAccounts();
            int existingSite22 = updatedSite.length;
            int language = 0;
            while (language < existingSite22) {
                Account existingAccount = updatedSite[language];
                accountHash.put(existingAccount.getClientId().toString(), existingAccount);
                ++language;
            }
            updatedSite = newContest.getAccounts();
            existingSite22 = updatedSite.length;
            language = 0;
            while (language < existingSite22) {
                Account account = updatedSite[language];
                if (!accountHash.containsKey(account.getClientId().toString())) {
                    addAccountsVector.add(account);
                }
                ++language;
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Account Information", e);
        }
        try {
            Category[] existingCategories = theContest.getCategories();
            HashMap<String, Category> cats = new HashMap<String, Category>();
            int i = 0;
            while (i < existingCategories.length) {
                Category category = existingCategories[i];
                cats.put(category.getDisplayName(), category);
                ++i;
            }
            Category[] categories = newContest.getCategories();
            Vector<Category> catAdds = new Vector<Category>();
            int i2 = 0;
            while (i2 < categories.length) {
                Category category = categories[i2];
                if (!cats.containsKey(category.getDisplayName())) {
                    catAdds.add(category);
                }
                ++i2;
            }
            theController.updateCategories(catAdds.toArray(new Category[catAdds.size()]));
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Category Information", e);
        }
        Problem[] problemList = new Problem[]{};
        ProblemDataFiles[] problemDataFiles = null;
        HashMap<String, Problem> probHash = new HashMap<String, Problem>();
        Problem[] problemArray = theContest.getProblems();
        int category = problemArray.length;
        int i2 = 0;
        while (i2 < category) {
            Problem existingProblem = problemArray[i2];
            if (existingProblem.isActive()) {
                probHash.put(existingProblem.getDisplayName(), existingProblem);
            }
            ++i2;
        }
        try {
            ArrayList<Problem> problemsToAddList = new ArrayList<Problem>();
            Problem[] problemArray2 = newContest.getProblems();
            int n4 = problemArray2.length;
            category = 0;
            while (category < n4) {
                Problem problem = problemArray2[category];
                if (probHash.containsKey(problem.getDisplayName())) {
                    try {
                        Problem newProblem = (Problem)probHash.get(problem.getDisplayName());
                        if (!newProblem.isSameAs(problem)) {
                            this.updateProblemFields(newProblem, problem);
                        }
                        theController.updateProblem(newProblem, theContest.getProblemDataFile(problem));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    problemsToAddList.add(problem);
                }
                ++category;
            }
            if (problemsToAddList.size() > 0) {
                problemList = new Problem[problemsToAddList.size()];
                problemsToAddList.toArray(problemList);
                problemDataFiles = new ProblemDataFiles[problemList.length];
                int idx = 0;
                Problem[] problemArray3 = problemList;
                int n5 = problemList.length;
                n4 = 0;
                while (n4 < n5) {
                    Problem problem = problemArray3[n4];
                    problemDataFiles[idx] = newContest.getProblemDataFile(problem);
                    ++idx;
                    ++n4;
                }
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error saving Problem Information", e);
        }
        PlaybackInfo[] infos = newContest.getPlaybackInfos();
        PlaybackInfo playbackInfo = null;
        if (infos.length > 0) {
            playbackInfo = infos[0];
        }
        if (this.noteList.size() > 0) {
            NoteMessage noteMessage = this.noteList.getAll()[0];
            throw new LoadContestDataException(String.valueOf(this.noteList.size()) + " errors in loading contest configuration data, " + noteMessage.getComment());
        }
        try {
            if (contestInformation != null) {
                theController.updateContestInformation(contestInformation);
            }
            if (problemList.length > 0) {
                theController.addNewProblem(problemList, problemDataFiles);
            }
            if (addAccountsVector.size() > 0) {
                theController.addNewAccounts(addAccountsVector.toArray(new Account[addAccountsVector.size()]));
            }
            if (playbackInfo != null) {
                Thread.sleep(2000L);
                theController.startPlayback(playbackInfo);
            }
            this.updateClientSettingsAJSettings(theContest, theController, newContest, probHash);
        }
        catch (Exception e) {
            this.noteList.logError("Error storing configuration Information", e);
            throw new LoadContestDataException(String.valueOf(this.noteList.size()) + " errors in sending contest configuration data");
        }
    }

    private void updateClientSettingsAJSettings(IInternalContest theContest, IInternalController theController, IInternalContest newContest, HashMap<String, Problem> probHash) throws LoadContestDataException {
        ClientSettings[] settings = newContest.getClientSettingsList();
        int i = 0;
        while (i < settings.length) {
            ElementId[] pList;
            ClientSettings clientSettings = settings[i];
            Filter ajFilter = clientSettings.getAutoJudgeFilter();
            if (ajFilter != null && (pList = ajFilter.getProblemIdList()) != null) {
                Vector<Problem> addToList = new Vector<Problem>();
                int j = 0;
                while (j < pList.length) {
                    ElementId elementId2 = pList[j];
                    if (probHash.containsKey(newContest.getProblem(elementId2).getDisplayName())) {
                        addToList.add(probHash.get(newContest.getProblem(elementId2).getDisplayName()));
                    } else {
                        addToList.add(newContest.getProblem(elementId2));
                    }
                    ++j;
                }
                ajFilter.clearProblemList();
                for (Problem problem2 : addToList) {
                    ajFilter.addProblem(problem2);
                }
                ajFilter.setUsingProblemFilter(true);
                clientSettings.setAutoJudgeFilter(ajFilter);
            }
            ++i;
        }
        try {
            if (settings.length > 0) {
                Thread.sleep(2000L);
                ClientSettings[] clientSettingsArray = settings;
                int n = settings.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientSettings setting = clientSettingsArray[n2];
                    ClientSettings clientSettings = theContest.getClientSettings(setting.getClientId());
                    if (clientSettings == null) {
                        theController.addNewClientSettings(setting);
                    } else {
                        theController.updateClientSettings(setting);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.noteList.logError("Error storing Client Information/Auto Judge settings", e);
            throw new LoadContestDataException(String.valueOf(this.noteList.size()) + " errors in sending Client Information/Auto Judge settings");
        }
    }

    private void updateProblemFields(Problem newProblem, Problem problem) throws Exception {
        newProblem.setAnswerFileName(problem.getAnswerFileName());
        newProblem.setComputerJudged(problem.isComputerJudged());
        newProblem.setDataFileName(problem.getDataFileName());
        newProblem.setHideOutputWindow(problem.isHideOutputWindow());
        newProblem.setIgnoreSpacesOnValidation(problem.isIgnoreSpacesOnValidation());
        newProblem.setInternationalJudgementReadMethod(problem.isInternationalJudgementReadMethod());
        newProblem.setManualReview(problem.isManualReview());
        newProblem.setPrelimaryNotification(problem.isPrelimaryNotification());
        newProblem.setReadInputDataFromSTDIN(problem.isReadInputDataFromSTDIN());
        newProblem.setShortName(problem.getShortName());
        newProblem.setShowCompareWindow(problem.isShowCompareWindow());
        newProblem.setShowValidationToJudges(problem.isShowValidationToJudges());
        newProblem.setTimeOutInSeconds(problem.getTimeOutInSeconds());
        newProblem.setUsingPC2Validator(problem.isUsingPC2Validator());
        newProblem.setValidatedProblem(problem.isValidatedProblem());
        newProblem.setValidatorCommandLine(problem.getValidatorCommandLine());
        newProblem.setValidatorProgramName(problem.getValidatorProgramName());
        newProblem.setWhichPC2Validator(problem.getWhichPC2Validator());
    }

    public NoteList getNoteList() {
        return this.noteList;
    }
}

