/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.IProblemDetails;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsComparator;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;
import java.util.Arrays;

public class PrintAllProblemDetails
extends APIAbstractTest {
    @Override
    public void printTest() {
        IProblem[] problems = this.getContest().getProblems();
        this.println("Standings - " + this.getContest().getStandings().length + " teams to rank");
        IStanding[] iStandingArray = this.getContest().getStandings();
        int n = iStandingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStanding standing = iStandingArray[n2];
            IClient client = standing.getClient();
            this.println("Rank " + standing.getRank() + " solved= " + standing.getNumProblemsSolved() + " pts= " + standing.getPenaltyPoints() + " " + "s" + client.getSiteNumber() + "t" + client.getAccountNumber() + " " + client.getDisplayName());
            IProblemDetails[] details = standing.getProblemDetails();
            Arrays.sort(details, new ProblemDetailsComparator());
            if (details.length == 0) {
                this.println("    No details found for team " + client.getLoginName());
            }
            int detailCounter = 0;
            IProblemDetails[] iProblemDetailsArray = details;
            int n3 = details.length;
            int n4 = 0;
            while (n4 < n3) {
                IProblemDetails det = iProblemDetailsArray[n4];
                boolean solved = det.getSolutionTime() != 0L;
                this.println("  " + ++detailCounter + " " + problems[det.getProblemId() - 1].getName() + " solved=" + solved + " solutionTime=" + det.getSolutionTime() + " points=" + det.getPenaltyPoints() + " attempts=" + det.getAttempts());
                ++n4;
            }
            ++n2;
        }
        this.println();
    }

    @Override
    public String getTitle() {
        return "getProblemDetails";
    }
}

