/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;

public class ProblemImplementation
implements IProblem {
    private String name;
    private String judgesDataFileName;
    private byte[] judgesDataFileContents;
    private String judgesAnswerFileName;
    private byte[] judgesAnswerFileContents;
    private String validatorCommandLine;
    private String validatorFileName;
    private ElementId elementId;
    private byte[] validatorFileContents;
    private boolean externalValidator = false;
    private boolean readsInputFromSTDIN = false;
    private String shortName;

    public ProblemImplementation(ElementId problemId, IInternalContest internalContest) {
        this(internalContest.getProblem(problemId), internalContest);
    }

    public ProblemImplementation(Problem problem, IInternalContest internalContest) {
        this.elementId = problem.getElementId();
        this.name = problem.getDisplayName();
        this.shortName = problem.getShortName();
        if (this.shortName == null || this.shortName.isEmpty()) {
            this.shortName = this.name.toLowerCase();
            int space = this.shortName.indexOf(" ");
            if (space > 0) {
                this.shortName = this.shortName.substring(0, space);
            }
        }
        this.judgesDataFileName = problem.getDataFileName();
        this.judgesAnswerFileName = problem.getAnswerFileName();
        this.validatorFileName = problem.getValidatorProgramName();
        if (problem.isValidatedProblem() && !problem.isUsingPC2Validator()) {
            this.externalValidator = true;
        }
        this.readsInputFromSTDIN = problem.isReadInputDataFromSTDIN();
        ProblemDataFiles problemDataFiles = internalContest.getProblemDataFile(problem);
        if (problemDataFiles != null) {
            SerializedFile serializedFile = problemDataFiles.getJudgesDataFile();
            if (serializedFile != null) {
                this.judgesDataFileContents = serializedFile.getBuffer();
            }
            if ((serializedFile = problemDataFiles.getJudgesAnswerFile()) != null) {
                this.judgesAnswerFileContents = serializedFile.getBuffer();
            }
            if ((serializedFile = problemDataFiles.getValidatorFile()) != null) {
                this.validatorFileContents = serializedFile.getBuffer();
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJudgesDataFileName() {
        return this.judgesDataFileName;
    }

    @Override
    public byte[] getJudgesDataFileContents() {
        return this.judgesDataFileContents;
    }

    @Override
    public String getJudgesAnswerFileName() {
        return this.judgesAnswerFileName;
    }

    @Override
    public byte[] getJudgesAnswerFileContents() {
        return this.judgesAnswerFileContents;
    }

    @Override
    public String getValidatorFileName() {
        return this.validatorFileName;
    }

    @Override
    public String getValidatorCommandLine() {
        return this.validatorCommandLine;
    }

    @Override
    public byte[] getValidatorFileContents() {
        return this.validatorFileContents;
    }

    @Override
    public boolean hasExternalValidator() {
        return this.externalValidator;
    }

    @Override
    public boolean readsInputFromFile() {
        if (this.hasDataFile()) {
            return !this.readsInputFromStdIn();
        }
        return false;
    }

    @Override
    public boolean readsInputFromStdIn() {
        if (this.hasDataFile()) {
            return this.readsInputFromSTDIN;
        }
        return false;
    }

    @Override
    public boolean hasDataFile() {
        return this.judgesDataFileContents != null;
    }

    @Override
    public boolean hasAnswerFile() {
        return this.judgesAnswerFileContents != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProblemImplementation) {
            ProblemImplementation problemImplementation = (ProblemImplementation)obj;
            return problemImplementation.elementId.equals(this.elementId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.elementId.toString().hashCode();
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }
}

