/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.IClarificationEventListener;
import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.IContestClock;
import edu.csus.ecs.pc2.api.IGroup;
import edu.csus.ecs.pc2.api.IJudgement;
import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.IProblemDetails;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.ISite;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.RunStates;
import edu.csus.ecs.pc2.api.implementation.ClarificationImplementation;
import edu.csus.ecs.pc2.api.implementation.ClarificationListenerList;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.ConfigurationListenerList;
import edu.csus.ecs.pc2.api.implementation.ConnectionEventListenerList;
import edu.csus.ecs.pc2.api.implementation.ContestTimeImplementation;
import edu.csus.ecs.pc2.api.implementation.GenerateStandings;
import edu.csus.ecs.pc2.api.implementation.GroupImplementation;
import edu.csus.ecs.pc2.api.implementation.JudgementImplementation;
import edu.csus.ecs.pc2.api.implementation.LanguageImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsComparator;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.RunImplementation;
import edu.csus.ecs.pc2.api.implementation.RunListenerList;
import edu.csus.ecs.pc2.api.implementation.SiteImplementation;
import edu.csus.ecs.pc2.api.implementation.TeamImplementation;
import edu.csus.ecs.pc2.api.listener.IConfigurationUpdateListener;
import edu.csus.ecs.pc2.api.listener.IConnectionEventListener;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Contest
implements IContest,
UIPlugin {
    private static final long serialVersionUID = 292457136351847397L;
    private VersionInfo versionInfo = new VersionInfo();
    private boolean loggedIn = true;
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private RunListenerList runListenerList = new RunListenerList();
    private ConnectionEventListenerList connectionEventListenerList = new ConnectionEventListenerList();
    private ClarificationListenerList clarificationListenerList = new ClarificationListenerList();
    private ConfigurationListenerList configurationListenerList = new ConfigurationListenerList();
    private GenerateStandings generateStandings = new GenerateStandings();
    private Log log = null;

    public Contest(IInternalContest contest, IInternalController controller, Log log) {
        this.log = log;
        this.setContestAndController(contest, controller);
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String getTitle() {
        Account account = this.contest.getAccount(this.contest.getClientId());
        return account.getDisplayName();
    }

    @Override
    public ITeam[] getTeams() {
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.TEAM);
        ITeam[] teamImplementations = new TeamImplementation[vector.size()];
        int i = 0;
        while (i < teamImplementations.length) {
            teamImplementations[i] = new TeamImplementation(vector.elementAt(i), this.contest);
            ++i;
        }
        return teamImplementations;
    }

    @Override
    public String getSiteName(int siteNumber) {
        Site site = this.contest.getSite(siteNumber);
        return site.getDisplayName();
    }

    @Override
    public String getContestTitle() {
        return this.contest.getContestInformation().getContestTitle();
    }

    @Override
    public String getSiteName() {
        return this.getSiteName(this.contest.getSiteNumber());
    }

    @Override
    public ILanguage[] getLanguages() {
        Language[] languages = this.contest.getLanguages();
        ILanguage[] implementations = new LanguageImplementation[languages.length];
        int i = 0;
        while (i < languages.length) {
            implementations[i] = new LanguageImplementation(languages[i]);
            ++i;
        }
        return implementations;
    }

    @Override
    public IProblem[] getProblems() {
        Problem[] problems = this.contest.getProblems();
        IProblem[] implementations = new ProblemImplementation[problems.length];
        int i = 0;
        while (i < problems.length) {
            implementations[i] = new ProblemImplementation(problems[i], this.contest);
            ++i;
        }
        return implementations;
    }

    @Override
    public IJudgement[] getJudgements() {
        Judgement[] judgements = this.contest.getJudgements();
        IJudgement[] implementations = new JudgementImplementation[judgements.length];
        int i = 0;
        while (i < judgements.length) {
            implementations[i] = new JudgementImplementation(judgements[i]);
            ++i;
        }
        return implementations;
    }

    @Override
    public IRun[] getRuns() {
        Run[] runs = this.contest.getRuns();
        IRun[] runImplementations = new RunImplementation[runs.length];
        int i = 0;
        while (i < runs.length) {
            runImplementations[i] = new RunImplementation(runs[i], this.contest, this.controller);
            ++i;
        }
        return runImplementations;
    }

    @Override
    public void addRunListener(IRunEventListener runEventListener) {
        this.runListenerList.addRunListener(runEventListener);
    }

    @Override
    public void removeRunListener(IRunEventListener runEventListener) {
        this.runListenerList.removeRunListener(runEventListener);
    }

    @Override
    public void addConnectionListener(IConnectionEventListener connectionEventListener) {
        this.connectionEventListenerList.addConnectionListener(connectionEventListener);
    }

    @Override
    public void removeConnectionListener(IConnectionEventListener connectionEventListener) {
        this.connectionEventListenerList.removeConnectionListener(connectionEventListener);
    }

    @Override
    public void addContestConfigurationUpdateListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.configurationListenerList.addContestUpdateConfigurationListener(contestUpdateConfigurationListener);
    }

    @Override
    public void removeContestConfigurationUpdateListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.configurationListenerList.removeContestUpdateConfigurationListener(contestUpdateConfigurationListener);
    }

    @Override
    public IContestClock getContestClock() {
        return new ContestTimeImplementation(this.contest.getContestTime());
    }

    @Override
    public IGroup[] getGroups() {
        Group[] groups = this.contest.getGroups();
        IGroup[] groupImplementations = new GroupImplementation[groups.length];
        int i = 0;
        while (i < groups.length) {
            groupImplementations[i] = new GroupImplementation(groups[i], this.contest);
            ++i;
        }
        return groupImplementations;
    }

    @Override
    public IClient getMyClient() {
        return new ClientImplementation(this.contest.getClientId(), this.contest);
    }

    @Override
    public boolean isContestClockRunning() {
        return this.contest.getContestTime().isContestRunning();
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Override
    public IStanding getStanding(ITeam team) {
        IStanding[] standings = this.generateStandings.getStandings(this.contest, this.log);
        if (standings == null) {
            return null;
        }
        IStanding[] iStandingArray = standings;
        int n = standings.length;
        int n2 = 0;
        while (n2 < n) {
            IStanding standing = iStandingArray[n2];
            if (team.getAccountNumber() == standing.getClient().getAccountNumber() && team.getSiteNumber() == standing.getClient().getSiteNumber()) {
                return standing;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IStanding[] getStandings() {
        return this.generateStandings.getStandings(this.contest, this.log);
    }

    @Override
    public ISite[] getSites() {
        Site[] sites = this.contest.getSites();
        ISite[] siteImplementations = new SiteImplementation[sites.length];
        int i = 0;
        while (i < sites.length) {
            siteImplementations[i] = new SiteImplementation(sites[i]);
            ++i;
        }
        return siteImplementations;
    }

    @Override
    public String getServerHostName() {
        return this.controller.getHostContacted();
    }

    @Override
    public int getServerPort() {
        return this.controller.getPortContacted();
    }

    @Override
    public IClarification[] getClarifications() {
        Clarification[] clarifications = this.contest.getClarifications();
        IClarification[] clarificationImplementations = new ClarificationImplementation[clarifications.length];
        int i = 0;
        while (i < clarifications.length) {
            clarificationImplementations[i] = new ClarificationImplementation(clarifications[i], this.contest, this.controller);
            ++i;
        }
        return clarificationImplementations;
    }

    @Override
    public void removeClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.clarificationListenerList.removeClarificationListener(clarificationEventListener);
    }

    @Override
    public void addClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.clarificationListenerList.addClarificationListener(clarificationEventListener);
    }

    @Override
    public String getPluginTitle() {
        return "API Contest class";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.runListenerList.setContestAndController(this.contest, this.controller);
        this.clarificationListenerList.setContestAndController(this.contest, this.controller);
        this.configurationListenerList.setContest(this.contest);
        this.connectionEventListenerList.setContestAndController(this.contest, this.controller, this);
    }

    @Override
    public IProblemDetails[] getProblemDetails() {
        IProblemDetails[] list = this.generateStandings.getProblemDetails(this.contest, this.log);
        Arrays.sort(list, new ProblemDetailsComparator());
        return list;
    }

    @Override
    public boolean isCCSTestMode() {
        return this.contest.getContestInformation().isCcsTestMode();
    }

    @Override
    public IProblem[] getClarificationCategories() {
        Problem problem = this.contest.getGeneralProblem();
        IProblem[] implementations = new ProblemImplementation[]{new ProblemImplementation(problem, this.contest)};
        return implementations;
    }

    @Override
    public IClient[] getClientsAllSites() {
        Vector<Account> accounts = this.contest.getAccounts(ClientType.Type.ALL);
        return this.createClientList(accounts);
    }

    @Override
    public IClient[] getClients() {
        Vector<Account> accounts = this.contest.getAccounts(ClientType.Type.ALL);
        ArrayList<Account> list = new ArrayList<Account>();
        for (Account account : accounts) {
            if (account.getSiteNumber() != this.contest.getSiteNumber()) continue;
            list.add(account);
        }
        return this.createClientList(list);
    }

    private IClient[] createClientList(List<Account> accounts) {
        ArrayList<ClientImplementation> list = new ArrayList<ClientImplementation>();
        for (Account account : accounts) {
            ClientImplementation client = new ClientImplementation(account.getClientId(), this.contest);
            list.add(client);
        }
        return list.toArray(new IClient[list.size()]);
    }

    @Override
    public RunStates getRunState(IRun run) {
        RunStates value = RunStates.UNKNOWN;
        if (run == null) {
            throw new IllegalArgumentException("run is null");
        }
        if (this.isAllowed(Permission.Type.JUDGE_RUN) || this.isAllowed(Permission.Type.EDIT_RUN)) {
            Run.RunStates state = this.getRunStateInternal(run);
            switch (state) {
                case NEW: {
                    value = RunStates.NEW;
                    break;
                }
                case BEING_JUDGED: 
                case BEING_COMPUTER_JUDGED: {
                    value = RunStates.BEING_JUDGED;
                    break;
                }
                case BEING_RE_JUDGED: {
                    value = RunStates.BEING_RE_JUDGED;
                    break;
                }
                case JUDGED: {
                    value = RunStates.JUDGED;
                    break;
                }
            }
        } else {
            throw new SecurityException("Not allowed to get run state");
        }
        return value;
    }

    private Run getInternalRun(IRun run) {
        Run[] runList;
        Run[] runArray = runList = this.contest.getRuns();
        int n = runList.length;
        int n2 = 0;
        while (n2 < n) {
            Run run2 = runArray[n2];
            if (run2.getNumber() == run.getNumber() && run2.getSiteNumber() == run.getSiteNumber()) {
                return run2;
            }
            ++n2;
        }
        return null;
    }

    private Run.RunStates getRunStateInternal(IRun run) {
        Run foundRun = this.getInternalRun(run);
        if (foundRun == null) {
            throw new IllegalArgumentException("No run found " + run);
        }
        return foundRun.getStatus();
    }

    private boolean isAllowed(Permission.Type type) {
        return this.contest.isAllowed(type);
    }

    @Override
    public String getMajorVersion() {
        String[] parts = this.getVersionParts(this.versionInfo.getVersionNumber());
        return parts[0];
    }

    protected String[] getVersionParts(String versionString) {
        Object[] output = new String[3];
        Arrays.fill(output, "");
        Pattern pattern = Pattern.compile("([0-9]+)[.]([0-9]+)(.*)");
        Matcher m = pattern.matcher(versionString);
        if (m.matches() && m.groupCount() == 3) {
            output[0] = m.group(1);
            output[1] = m.group(2);
            output[2] = m.group(3);
        } else {
            output[0] = versionString;
        }
        return output;
    }

    @Override
    public String getMinorVersion() {
        String[] parts = this.getVersionParts(this.versionInfo.getVersionNumber());
        return parts[1];
    }

    @Override
    public String getOtherVersionInfo() {
        String[] parts = this.getVersionParts(this.versionInfo.getVersionNumber());
        return parts[2];
    }

    @Override
    public String getBuildNumber() {
        return this.versionInfo.getBuildNumber();
    }

    @Override
    public String getFullVersionString() {
        return "Version " + this.versionInfo.getPC2Version() + " Build " + this.versionInfo.getBuildNumber();
    }

    @Override
    public IRun getRun(int siteNumber, int runNumber) {
        IRun[] runs;
        IRun[] iRunArray = runs = this.getRuns();
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            IRun iRun = iRunArray[n2];
            if (iRun.getNumber() == runNumber && iRun.getSiteNumber() == siteNumber) {
                return iRun;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IRun getRun(int runNumber) {
        return this.getRun(this.contest.getSiteNumber(), runNumber);
    }
}

