# -*- coding: utf-8 -*-

# Campos:
# D: dict()
class Amigos:
    def __init__(self, archivo):
        # Constructor: str -> Amigos()
        # Dado un nombre de archivo, crea una red social (objeto Amigos) con las relaciones
        # entre las personas especificadas en el archivo
        self.D = {}
        for linea in open(archivo, "r"):
            amigos = linea.split("/")
            persona = amigos[0]
            self.D[persona] = []
            for amigo in amigos[1:len(amigos)]:
                if amigo[-1] == "\n":
                    amigo = amigo[:-1]
                self.D[persona].append(amigo)

    # amigar: str str -> None
    # Dados dos nombres de personas, añade una relación de amistad RECÍPROCA entre ell@s
    def amigar(self, X, Y):
        if Y not in self.D[X]:
            self.D[X].append(Y)
        if X not in self.D[Y]:
            self.D[Y].append(X)

    # grabarAmigos: str -> None
    # Dado el nombre de un archivo, guarda allí las relaciones sociales existentes, donde
    # cada línea está en el formato:
    # nombrePersona/amig@1/amigo2/.../amig@N
    def grabarAmigos(self, nombreArchivo):
        archivo = open(nombreArchivo, "w")
        for persona in self.D:
            string = persona + "/"
            for amigo in self.D[persona]:
                string += amigo + "/"
            string = string[:-1] + "\n"
            archivo.write(string)
        archivo.close()


redSocial = Amigos("amigos.txt")
redSocial.amigar("pedro", "camila")
redSocial.grabarAmigos("amigos.txt")


# Diálogo para preguntar por amistad (eso suena muy triste :c)
nombre = raw_input("Hola, cuál es tu nombre? 1313  ")
archivoPersonas = open(nombre + ".txt", "r")
listaPersonas = archivoPersonas.readline().split("/")
for solicitante in listaPersonas:
    if solicitante[-1] == "\n":
        solicitante = solicitante[:-1]
    respuesta = raw_input(nombre + ", quieres ser amigo de " + solicitante + "(si/no)?  ")
    if respuesta == "si":
        redSocial.amigar(solicitante, nombre)

redSocial.grabarAmigos("amigos.txt")











