# -*- coding: utf-8 -*-
from Tkinter import *

# Campos:
# __xs: list(float)
# __ys: list(float)
# __minX: float
# __maxX: float
# __minY: float
# __maxY: float
class CoordenadasFuncion:
    # Constructor: str -> CoordenadasFuncion
    # Crea un objeto CoordenadasFuncion a partir de un nombre de archivo
    def __init__(self, nombreArchivo):
        self.__xs, self.__ys = self.leerArchivo(nombreArchivo)
        self.__minX = min(self.__xs)
        self.__maxX = max(self.__xs)
        self.__minY = min(self.__ys)
        self.__maxY = max(self.__ys)

    # getXs: None -> list(float)
    # Retorna la lista de puntos X
    def getXs(self):
        return self.__xs

    # getYs: None -> list(float)
    # Retorna la lista de puntos Y
    def getYs(self):
        return self.__ys

    # getMinX: None -> float
    # Retorna el mínimo X dentro de las coordenadas leídas
    def getMinX(self):
        return self.__minX
    # getMaxX: None -> float
    # Retorna el máximo X dentro de las coordenadas leídas
    def getMaxX(self):
        return self.__maxX

    # getMinY: None -> float
    # Retorna el mínimo Y dentro de las coordenadas leídas
    def getMinY(self):
        return self.__minY

    # getMinX: None -> float
    # Retorna el máximo Y dentro de las coordenadas leídas
    def getMaxY(self):
        return self.__maxY

    # leerArchivo: str -> list(float), list(float)
    # Lee el archivo y extrae las coordenadas, devolviendo una lista
    # con los puntos X y los puntos Y
    def leerArchivo(self, nombreArchivo):
        archivo = open(nombreArchivo)
        xs = []
        ys = []
        for linea in archivo:
            coordenadas = linea.split(" ")
            xs.append(float(coordenadas[0]))
            ys.append(float(coordenadas[1]))
        return xs, ys





# Campos:
# __canvas: Canvas()
# __height: int
# __width: int
# __minXVentana: int
# __maxXVentana: int
# __minYVentana: int
# __maxYVentana: int
class Graficador:
    # Constructor: canvas, int, int -> Graficador
    # Construye un elemento Graficador. marginX y marginY representan cuánto
    # espacio se quiere dejar en los bordes horizontales y verticales
    def __init__(self, canvas, marginX=10, marginY=10):
        self.__canvas = canvas
        self.__height = int((self.__canvas.cget("height")))
        self.__width = int((self.__canvas.cget("width")))

        self.__minXVentana = marginX
        self.__maxXVentana = self.__width - marginX

        self.__minYVentana = marginY
        self.__maxYVentana = self.__height - marginY

    # proyectarPunto: float, float, CoordenadasFuncion -> float, float
    # Proyecta los puntos desde el mundo real hacia la ventana
    def proyectarPunto(self, x, y, coordenadas):
        xVentana = self.__minXVentana + \
            (self.__maxXVentana - self.__minXVentana) * (x - coordenadas.getMinX()) / \
            (coordenadas.getMaxX() - coordenadas.getMinX())

        yVentana = self.__height - \
            (self.__minYVentana +
             (self.__maxYVentana - self.__minYVentana) * (y - coordenadas.getMinY()) /
                (coordenadas.getMaxY() - coordenadas.getMinY()))
        return xVentana, yVentana

    # dibujar: CoordenadasFuncion -> None
    # Dibuja en el canvas las coordenadas
    def dibujar(self, coordenadas):
        xs = coordenadas.getXs()
        ys = coordenadas.getYs()

        xInicial = xs[0]
        yInicial = ys[0]

        xVentanaInicial, yVentanaInicial = self.proyectarPunto(
            xInicial, yInicial, coordenadas)
        for i in range(1, len(xs)):
            xActual = xs[i]
            yActual = ys[i]
            xVentanaActual, yVentanaActual = self.proyectarPunto(
                xActual, yActual, coordenadas)
            self.__canvas.create_line(xVentanaInicial, yVentanaInicial,
                               xVentanaActual, yVentanaActual)
            xVentanaInicial = xVentanaActual
            yVentanaInicial = yVentanaActual


nombreArchivo = "puntos1.txt"
ventana = Tk()
canvas = Canvas(ventana, width=800, height=600, bg="white")
canvas.pack()

coordenadas = CoordenadasFuncion(nombreArchivo)
graficador = Graficador(canvas)
graficador.dibujar(coordenadas)
ventana.mainloop()
