# -*- coding: utf-8 -*-
import random
class Bolsa:
    # __init__: None -> Bolsa
    # Crea un objeto Bolsa, representado por una lista
    def __init__(self):
        self.__L = []

    # poner: any -> None
    # Agrega un elemento X en la bolsa, sólo si es que no estaba previamente
    def poner(self, X):
        if X not in self.__L:
            self.__L.append(X)

    # sacar: None -> any
    # Sacar un elemento de la lista de forma aleatoria, None en caso de no haber más elementos
    def sacar(self):
        if len(self.__L) == 0:
            return None
        else:
            index = random.randint(0, len(self.__L) - 1)
            # Opción 1: usando método pop
            # return self.__L.pop(index)

            # Opción 2: usando función del
            # value = self.__L[index]
            # del self.__L[index]
            # return value

            # Opción 3: cortando la lista en 2 partes
            value = self.__L[index]
            self.__L = self.__L[:index] + self.__L[index + 1:]
            return value


# Tests de clase Bolsa
B_test = Bolsa()

# Ponemos elementos
B_test.poner(1)
B_test.poner(2)
B_test.poner(3)
B_test.poner(3)

# Sacamos elementos
assert B_test.sacar() in [1,2,3]
assert B_test.sacar() in [1,2,3]
assert B_test.sacar() in [1,2,3]
assert B_test.sacar() is None

################################################ Pregunta 2 #####################################
# Poner 20 elementos en la Bolsa
B = Bolsa()
for i in range(20):
    n = random.randint(1, 90)
    B.poner(n)

# Sacar 20 elementos (usando for)
for i in range(20):
    x = B.sacar()
    if x == None:
        break
    else:
        print x

# Otra opción: sacar 20 elementos usando while
# while True:
#     x = B.sacar()
#     if x is None:
#         break
#     else:
#         print x











