# -*- coding: utf-8 -*-

# clase Polera
class Polera:
    # __init__: self, str, str -> Polera
    # Crea un objeto Polera
    def __init__(self, talla, color):
        self.__talla = talla
        self.__color = color

    # setTalla: self, str -> None
    # Actualiza la talla de la polera
    def setTalla(self, nuevaTalla):
        self.__talla = nuevaTalla

    # getTalla: self -> str
    # Retorna la talla de la polera
    def getTalla(self):
        return self.__talla

    # setColor: self, str -> None
    # Actualiza el color de la polera
    def setColor(self, nuevoColor):
        self.__color = nuevoColor

    # getColor: self -> str
    # Retorna el color de la polera
    def getColor(self):
        return self.__color


##############################################################

# Creamos poleras
p1 = Polera("M", "Rojo")
p2 = Polera("L", "Rojo")
p3 = Polera("M", "Azul")
p4 = Polera("L", "Azul")

# Creamos subdiccionarios
dictRojas = {"M": 10, "L": 5}
dictAzules = {"M": 20, "L": 15}
# Creamos inventario, utilizando los subdiccionarios
inventario = {"PolerasRojas": dictRojas, "PolerasAzules": dictAzules}


# agregarPolera : Polera, dict -> None
# Agrega una polera al inventario
def agregarPolera(polera, inventario):
    color = polera.getColor()
    talla = polera.getTalla()
    if color.lower() == "rojo":
        inventario["PolerasRojas"][talla] += 1
    elif color.lower() == "azul":
        inventario["PolerasAzules"][talla] += 1

agregarPolera(p1, inventario)
assert inventario["PolerasRojas"]["M"] == 11
agregarPolera(p4, inventario)
assert inventario["PolerasAzules"]["L"] == 16


# borrarPolera: Polera, dict -> None
# Elimina una polera del inventario
def borrarPolera(polera, inventario):
    color = polera.getColor()
    talla = polera.getTalla()
    if color.lower() == "rojo" and inventario["PolerasRojas"][talla] > 0:
        inventario["PolerasRojas"][talla] -= 1
    elif color.lower() == "azul" and inventario["PolerasAzules"][talla] > 0:
        inventario["PolerasAzules"][talla] -= 1

borrarPolera(p1, inventario)
assert inventario["PolerasRojas"]["M"] == 10
borrarPolera(p4, inventario)
assert inventario["PolerasAzules"]["L"] == 15

# borrarPolera_error: Polera, dict -> None
# Elimina una polera del inventario. Implementación usando assert (tirará error si es que no se puede eliminar la polera)
def borrarPolera_error(polera, inventario):
    talla = polera.getTalla()
    color = polera.getColor()
    if color.lower() == "rojo":
        assert inventario["PolerasRojas"][talla] > 0
        inventario["PolerasRojas"][talla] -= 1
    elif color.lower() == "azul":
        assert inventario["PolerasAzules"][talla] > 0
        inventario["PolerasAzules"][talla] -= 1

borrarPolera_error(p1, inventario)
assert inventario["PolerasRojas"]["M"] == 9
borrarPolera_error(p4, inventario)
assert inventario["PolerasAzules"]["L"] == 14

# contarPoleras : dict -> num
# Cuenta la cantidad de poleras que hay en el inventario
# Ejemplo: contarPoleras(inventario) entrega 48
def contarPoleras(inventario):
    total = 0
    for color in inventario:
        dictActual = inventario[color]
        for talla in dictActual:
            total += inventario[color][talla]
    return total

assert contarPoleras(inventario) == 48

# contarPoleras_while : dict -> num
# Cuenta la cantidad de poleras que hay en el inventario. Implementación usando while
# Ejemplo: contarPoleras_while(inventario) entrega 48
def contarPoleras_while(inventario):
    total = 0
    indiceColor = 0
    llavesColores = inventario.keys()
    while indiceColor < len(llavesColores):
        colorActual = llavesColores[indiceColor]
        dictActual = inventario[colorActual]
        indiceTalla = 0
        llavesTallas = dictActual.keys()
        while indiceTalla < len(llavesTallas):
            tallaActual = llavesTallas[indiceTalla]
            total += dictActual[tallaActual]
            indiceTalla += 1
        indiceColor += 1
    return total

assert contarPoleras(inventario) == contarPoleras_while(inventario)

# agregarNPoleras: dict, list[Poleras] -> None
# Agrega todas las poleras en la lista al inventario
def agregarNPoleras(inventario, listaPoleras):
    for polera in listaPoleras:
        agregarPolera(polera, inventario)

listaPoleras = [p1, p2, p3, p4]
agregarNPoleras(inventario, listaPoleras)
assert inventario["PolerasRojas"]["M"] == 10
assert inventario["PolerasRojas"]["L"] == 6
assert inventario["PolerasAzules"]["M"] == 21
assert inventario["PolerasAzules"]["L"] == 15




















