# -*- coding: utf-8 -*-

# Clase botella


class Botella:
    # __init__ : self, int, int, str, str -> Botella
    # Crea una nueva Botella
    def __init__(self, capacidadMax, contenidoActual, material, relleno):
        self.__capacidadMax = capacidadMax
        self.__contenidoActual = contenidoActual
        self.__material = material
        self.__tipoRelleno = relleno

    # setContenidoActual: self, int -> None
    # Actualiza el contenido actual
    def setContenidoActual(self, nuevoContenido):
        self.__contenidoActual = nuevoContenido

    # getContenidoActual: self -> int
    # Retorna el contenido actual
    def getContenidoActual(self):
        return self.__contenidoActual

    # setCapacidadMax: self, int -> None
    # Actualiza la capacidad máxima
    def setCapacidadMax(self, nuevaCapacidad):
        self.__capacidadMax = nuevaCapacidad

    # getCapacidadMax: self -> int
    # Retorna la capacidad máxima
    def getCapacidadMax(self):
        return self.__capacidadMax

    # setMaterial: self, str -> None
    # Actualiza el tipo de material
    def setMaterial(self, nuevoMaterial):
        self.__material = nuevoMaterial

    # getMaterial: self -> str
    # Retorna el tipo de material
    def getMaterial(self):
        return self.__material

    # setTipoRelleno: self, str -> None
    # Actualiza el tipo de relleno
    def setTipoRelleno(self, nuevoRelleno):
        self.__tipoRelleno = nuevoRelleno

    # getTipoRelleno: self -> str
    # Retorna el tipo de relleno
    def getTipoRelleno(self):
        return self.__tipoRelleno

    # llenar: self -> None
    # Llena la botella, actualizando el contenido actual a la capacidad máxima
    def llenar(self):
        self.__contenidoActual = self.__capacidadMax

    # llenar_alternativo: self -> None
    # Llena la botella, actualizando el contenido actual a la capacidad máxima
    # (implementación distinta)
    def llenar_alternativo(self):
        self.setContenidoActual(self.__capacidadMax)

    # darSorbo: self -> None
    # Da un sorbo de 20cc. Si el contenido actual es menor a 20cc, lanza un
    # error
    def darSorbo(self):
        assert self.__contenidoActual >= 20
        self.__contenidoActual -= 20

    # agregar: self, int -> None
    # Agrega cc a contenidoActual. Si es que se alcanzó la capacidad máxima,
    # no hace nada
    def agregar(self, cc):
        if self.__contenidoActual + cc <= self.__capacidadMax:
            self.__contenidoActual += cc
        else:
            self.llenar()

    # __str__: self -> str
    # Método para imprimir de fora bonita los objetos (ejemplo solamente)
    def __str__(self):
        return "Botella de tipo " + self.__tipoRelleno


# Creamos botellas
cocacola = Botella(1000, 0, "vidrio", "coca-cola")
jugo = Botella(500, 0, "plastico", "jugo")
pisco = Botella(750, 750, "vidrio", "pisco")
agua = Botella(1600, 800, "plastico", "agua")
cerveza = Botella(1000, 750, "vidrio", "cerveza")

# Llenamos las botellas de Coca Cola y jugo
cocacola.llenar()
jugo.llenar()

# Tomamos 10 sorbos de Coca Cola
for i in range(10):
    cocacola.darSorbo()

# Imprimimos en pantalla el contenido de las botellas
print "Contenido botella Coca Cola", cocacola.getContenidoActual()
print "Contenido botella Jugo", jugo.getContenidoActual()

# Creamos lista de botellas
botellas = [cocacola, jugo, pisco, agua, cerveza]

# contarBotellasCapacidadMaxima: list[Botella], int ->  int
# Retorna la cantidad de botellas que tienen capacidad máxima igual a
# capacidadMax
# Ejemplo: contarBotellasCapacidadMaxima(botellas, 1000) entrega 2


def contarBotellasCapacidadMaxima(listaBotellas, capacidadMax):
    contador = 0
    for botella in listaBotellas:
        if botella.getCapacidadMax() == capacidadMax:
            contador += 1
    return contador


assert contarBotellasCapacidadMaxima(botellas, 1000) == 2
assert contarBotellasCapacidadMaxima(botellas, 1600) == 1
assert contarBotellasCapacidadMaxima(botellas, 1469) == 0

# contarBotellasCapacidadMaxima_while: list[Botella], int ->  int
# Retorna la cantidad de botellas que tienen capacidad máxima igual a
# capacidadMax (implementación usando while)
# Ejemplo: contarBotellasCapacidadMaxima_while(botellas, 1000) entrega 2


def contarBotellasCapacidadMaxima_while(listaBotellas, capacidadMax):
    contador = 0
    largo = len(listaBotellas)
    i = 0
    while i < largo:
        botella = listaBotellas[i]
        if botella.getCapacidadMax() == capacidadMax:
            contador += 1
        i += 1
    return contador


assert contarBotellasCapacidadMaxima_while(botellas, 1000) == 2
assert contarBotellasCapacidadMaxima_while(botellas, 1600) == 1
assert contarBotellasCapacidadMaxima_while(botellas, 1469) == 0

# liquidoTotal: list[Botella] -> int
# Obtiene la cantidad total de líquido almacenado en las botellas
# Ejemplo: liquidoTotal(botellas) entrega 3600 (¡fíjese que hemos hecho
# cambios en algunas botellas al dar sorbos!)


def liquidoTotal(listaBotellas):
    total = 0
    for botella in listaBotellas:
        total += botella.getContenidoActual()
    return total


assert liquidoTotal(botellas) == 3600

# agregar100CC: list[Botella] -> None
# Agrega 100cc a cada botella. Note que si la botella está en su capacidad
# máxima, no ocurre nada


def agregar100CC(listaBotellas):
    for botella in listaBotellas:
        botella.agregar(100)


agregar100CC(botellas)
print liquidoTotal(botellas)
