# -*- coding: utf-8 -*-
votos1 = [2451, 3554, 4823, 4841, 4825, 3225, 3564, 3993, 4810, 2195, 1772, 4683, 1407, 1772, 3515]
votos2 = [4547, 4868, 2888, 4690, 2601, 4985, 3352, 4011, 1297, 3906, 4896, 4191, 4747, 4711, 3207]
delegados = [47, 22, 13, 5, 13, 6, 24, 11, 48, 13, 18, 38, 44, 25, 31]
estados = ["New York", "Washington", "Ohio", "California", "Florida", "Hawaii", "Iowa", "Texas", "Michigan", "Kansas", "New Jersey", "New Mexico", "Pennsylvania", "Alaska", "Delaware"]


# delegadosNecesarios: list[int] -> int
# Entrega la cantidad de delegados necesarios para ganar la elección
# Ejemplo: delegadosNecesarios([30, 40, 50]) entrega 61 (la mitad más uno)
def delegadosNecesarios(delegados):
    suma = 0
    for d in delegados:
        suma += d
    return (suma / 2) + 1

assert delegadosNecesarios([30, 40, 50]) == 61
assert delegadosNecesarios([30, 40, 51]) == 61
assert delegadosNecesarios(delegados) == 180


# ganadorVotoPopular: list[int], list[int] -> int
# Dados los votos del candidato 1 y del candidato 2 (v1 y v2, respectivamente), entrega el índice del candidato que obtuvo más votos
# Ejemplo: ganadorVotoPopular([40, 30], [25, 35]) entrega 1
def ganadorVotoPopular(v1, v2):
    assert len(v1) == len(v2)
    s1 = 0
    s2 = 0
    for i in range(len(v1)):
        s1 += v1[i]
        s2 += v2[i]

    if s1 > s2:
        return 1
    else:
        return 2

assert ganadorVotoPopular([40, 30], [25, 35]) == 1
assert ganadorVotoPopular(votos1, votos2) == 2

# ganador: list[int], list[int], list[int] -> int
# Entrega el índice del candidato que obtuvo mayor cantidad de votos de delegados, y por ende, obtuvo la victoria en este sistema antidemocrático
# Ejemlo: ganador(delegados, votos1, votos2) entrega 2
def ganador(delegados, v1, v2):
    assert len(v1) == len(v2) == len(delegados)
    d1 = 0
    d2 = 0
    for i in range(len(v1)):
        if v1[i] > v2[i]:
            d1 += delegados[i]
        else:
            d2 += delegados[i]
    if d1 > d2:
        return 1
    else:
        return 2

assert ganador(delegados, votos1, votos2) == 2


# sinEstadoMasDelegados: list[int], list[int], list[int] -> boolean
# Retorna True si es que al eliminar el estado con la mayor cantidad de delegados cambia el resultado de la elección, False en caso contrario
# Ejemplo: sinEstadoMasDelegados(delegados, votos1, votos2) entrega False
def sinEstadoMasDelegados(delegados, v1, v2):
    mayor = 0
    indiceMayor = 0
    for i in range(len(delegados)):
        if delegados[i] > mayor:
            mayor = delegados[i]
            indiceMayor = i

    ganadorActual = ganador(delegados, v1, v2)
    nuevosDelegados = delegados[:indiceMayor] + delegados[indiceMayor + 1:]
    nuevosV1 = v1[:indiceMayor] + v1[indiceMayor + 1:]
    nuevosV2 = v2[:indiceMayor] + v2[indiceMayor + 1:]

    nuevoGanador = ganador(nuevosDelegados, nuevosV1, nuevosV2)
    return ganadorActual != nuevoGanador

assert not sinEstadoMasDelegados(delegados, votos1, votos2)

# sacarEstadosDelFinal: list[int], list[int], list[int] -> int
# Retorna cuántos estados de "al final" de la lista es necesario sacar para cambiar el resultado de la votación. Si es que no se puede, entrega -1.
# Ejemplo: sacarEstadosDelFinal(delegados, votos1, votos2) entrega 3 (al sacar los últimos 3 estados de la lista, cambia el resultado de la votación)
def sacarEstadosDelFinal(delegados, v1, v2):
    ganadorActual = ganador(delegados, v1, v2)
    indice = 1
    while indice < len(votos1) + 1:
        nuevoGanador = ganador(delegados[:-indice], v1[:-indice], v2[:-indice])
        if nuevoGanador != ganadorActual:
            return indice
        indice += 1

    return -1

assert sacarEstadosDelFinal(delegados, votos1, votos2) == 3















