# -*- coding: utf-8 -*-
# Lista de días
dias = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

# Días del mes de julio
diasJulio = dias[6]

# totalDias: list[int] -> int
# Retorna la suma de la lista de días.
# Ejemplo: totalDias(dias) entrega 365.
def totalDias(dias):
    contador = 0
    suma = 0
    while contador < len(dias):
        suma += dias[contador]
        contador += 1
    return suma

assert totalDias(dias) == 365

# totalDias_for: list[int] -> int
# Retorna la suma de la lista de días (usa for en vez de while)
# Ejemplo: totalDias(dias) entrega 365.
def totalDias_for(dias):
    suma = 0
    for dia in dias:
        suma += dia
    return suma

assert totalDias_for(dias) == 365

# indiceMesMasCorto: list[int] -> int
# Entrega el índice que corresponde al mes con menos días.
# Ejemplo: indiceMesMasCorto(dias) entrega 1, que corresponde al mes de febrero.
def indiceMesMasCorto(dias):
    menor = 100
    indiceMenor = 0
    for i in range(len(dias)):
        if dias[i] < menor:
            menor = dias[i]
            indiceMenor = i
    return indiceMenor

assert indiceMesMasCorto(dias) == 1

# indicesMesesMasGrandes: list[int] -> list[int]
# Entrega una lista con los índices de los meses con más días.
# Ejemplo: indicesMesesMasGrandes(dias) entrega [0, 2, 4, 6, 7, 9, 11], que corresponden a los meses de enero, marzo, mayo, julio, agosto, octubre y diciembre, todos meses con 31 días.
def indicesMesesMasGrandes(dias):
    M = 0
    for dia in dias:
        if dia > M:
            M = dia

    mesesGrandes = []
    for i in range(len(dias)):
        if dias[i] == M:
            mesesGrandes.append(i)

    return mesesGrandes

assert indicesMesesMasGrandes(dias) == [0, 2, 4, 6, 7, 9, 11]

# Lista de nombre de meses
nombres = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]

# imprimirMeses: list[int], list[str] -> None
# Imprime en pantalla los nombres de los meses junto a la cantidad de días correspondientes
def imprimirMeses(dias, nombres):
    for i in range(len(dias)):
        print nombres[i], dias[i]

imprimirMeses(dias, nombres)


# nombreMesMasCorto: list[int], list[str] -> str
# Retorna el nombre del mes más corto
# Ejemplo: nombreMesMasCorto(dias, nombres) entrega "febrero"
def nombreMesMasCorto(dias, nombres):
    indice = indiceMesMasCorto(dias)
    return nombres[indice]

assert nombreMesMasCorto(dias, nombres) == "febrero"

# mesesNDias: list[int], list[str], int -> list[str]
# Entrega una lista con los nombres de los meses que tienen exactamente n días
# Ejemplo: mesesNDias(dias, nombres, 30) entrega ["abril", "junio", "septiembre","noviembre"]
def mesesNDias(dias, nombres, n):
    resultado = []
    for i in range(len(dias)):
        if dias[i] == n:
            resultado.append(nombres[i])
    return resultado

assert mesesNDias(dias, nombres, 28) == ["febrero"]
assert mesesNDias(dias, nombres, 30) == ["abril", "junio", "septiembre","noviembre"]
assert mesesNDias(dias, nombres, 0) == []
