# -*- coding: utf-8 -*-
from lista import *

###############################################################
# Variables a usar para tests y ejemplos
s1 = "casa"
s2 = "perro"
s3 = "manzana"
s4 = "gato"
s5 = "concierto"

l1 = lista(s1, lista(s3, lista(s4, None)))
l2 = lista(s2, lista(s4, lista(s5, lista(s1, None))))
l3 = lista(s4, lista(s1, lista(s3, None)))
l4 = lista(s2, lista(s1, None))

l1_mas_s2 = lista(s1, lista(s3, lista(s4, lista(s2, None))))
l1_union_l2 = lista(s1, lista(s3, lista(s4, lista(s2, lista(s5, None)))))
l1_interseccion_l2 = lista(s4, lista(s1, None))

################################################################
# Parte a)

# agregarSiEsQueNoEsta: lista, any -> lista
# Agrega valor a L1 sólo si es que no está
# Ejemplo: agregar(l1, s1) entrega l1
def agregarSiEsQueNoEsta(L1, valor):
    if L1 == None:
        return lista(valor, None)
    else:
        if cabeza(L1) == valor:
            return L1
        else:
            return lista(cabeza(L1), \
                         agregarSiEsQueNoEsta(cola(L1), valor))

assert agregarSiEsQueNoEsta(l1, s1) == l1
assert agregarSiEsQueNoEsta(l1, s2) == l1_mas_s2

# union: lista, lista -> lista
# Retorna la unión entre dos listas
# Ejemplo: union(l1, l2) entrega l1_union_l2
def union(L1, L2):
    if L2 == None:
        return L1
    else:
        L1 = agregarSiEsQueNoEsta(L1, cabeza(L2))
        return union(L1, cola(L2))


assert union(l1, l2) == l1_union_l2

###############################################################
# Parte b)

# esta: lista, any -> boolean
# Retorna True si es que valor está en L1, False en caso contrario
# Ejemplo: esta(l1, s1) entrega True
def esta(L1, valor):
    if L1 == None:
        return False
    else:
        if cabeza(L1) == valor:
            return True
        else:
            return esta(cola(L1), valor)

assert esta(l1, s1)
assert not esta(l2, s3)

# interseccion: lista, lista -> lista
# Retorna la intersección entre dos listas
# Ejemplo: interseccion(l1, l2) entrega l1_interseccion_l2

def interseccion(L1, L2):
    if L2 == None:
        return None
    else:
        actual = cabeza(L2)
        if esta(L1, actual):
            return lista(actual, \
                         interseccion(L1, cola(L2)))
        else:
            return interseccion(L1, cola(L2))

assert interseccion(l1, l2) == l1_interseccion_l2
# Notar que interseccion(l2, l1) entregará una lista con los mismos elementos,
# pero en distinto orden

#########################################################
# Parte c)

# esSubconjunto: lista, lista -> boolean
# Retorna True si es que L2 es subconjunto L1, False en caso contrario
# Ejemplo: esSubconjunto(l1, l2) entrega False
def esSubconjunto(L1, L2):
    if L2 == None:
        return True
    else:
        if esta(L1, cabeza(L2)):
            return esSubconjunto(L1, cola(L2))
        else:
            return False

assert esSubconjunto(l2, l4)
assert not esSubconjunto(l4, l2)
assert not esSubconjunto(l1, l2)

# igualdad: lista, lista -> boolean
# Retorna true si es que L1 y L2 contienen exactamente los mismos elementos,
# sin importar el orden
# Ejemplo: igualdad(l1, l3) entrega True
def igualdad(L1, L2):
    return esSubconjunto(L1, L2) and esSubconjunto(L2, L1)

assert igualdad(l1, l3)
assert igualdad(l1, l1)
assert not igualdad(l2, l4)


















