# -*- coding: utf-8 -*-
import estructura
from lista import *

# contador: valor (str) frecuencia (int)
estructura.crear("contador", "valor frecuencia")

c1 = contador("Breaking Bad", 15)
c2 = contador("Game of Thrones", 10)
c3 = contador("Sherlock", 12)

c4 = contador("Mr Robot", 15)
c5 = contador("Breaking Bad", 3)
c6 = contador("Sherlock", 7)
c7 = contador("House of Cards", 4)


L1 = lista(c1, lista(c2, lista(c3, None)))
L2 = lista(c4, lista(c5, lista(c6, lista(c7, None))))

L1_mas_c4 = lista(c1, lista(c2, lista(c3, lista(c4, None))))
L1_mas_c5 = lista(contador("Breaking Bad", 18), lista(c2, lista(c3, None)))
L1_mas_L2 = lista(contador('Breaking Bad', 18), lista(c2, lista(contador('Sherlock', 19), lista(c4, lista(c7, None)))))

# agregarOActualizar: lista, contador -> lista
# Agrega elemento a L1, si es que no está, y si es que está, simplemente lo actualiza
# Ej: agregarOActualizar(L1, c4) entrega L1_mas_c4

# Plantilla
# def agregarOActualizar(L1, elemento):
#     if L1 == None:
#         ...
#     else:
#         ...cabeza(L1)...
#         if cabeza(L1).valor == elemento.valor:
#               ...
#         else:
#             ...agregarOActualizar(...)...

def agregarOActualizar(L1, elemento):
    if L1 == None:
        return lista(elemento, None)
    else:
        actual = cabeza(L1)
        if actual.valor == elemento.valor:
            suma = actual.frecuencia + elemento.frecuencia
            nuevo = contador(actual.valor, suma)
            return lista(nuevo, cola(L1))
        else:
            return lista(actual, \
                         agregarOActualizar(cola(L1), elemento))

assert agregarOActualizar(L1, c4) == L1_mas_c4
assert agregarOActualizar(L1, c5) == L1_mas_c5



# incorporar: lista(contador), lista(contador) -> lista(contador)
# Dadas dos listas, retorna el resultado de juntar ambas listas en una
# Ej: incorporar(L1, L2) entrega L1_mas_L2
def incorporar(L1, L2):
    if L2 == None:
        return L1
    else:
        actual = cabeza(L2)
        L1 = agregarOActualizar(L1, actual)
        return incorporar(L1, cola(L2))

assert incorporar(L1, L2) == L1_mas_L2













