# -*- coding: utf-8 -*-
import estructura
from lista import *
# arbol: valor(any) izq(arbol) der(arbol)
estructura.crear("arbol", "valor izq der")


A=arbol(27, arbol(12, None, None), arbol(42, arbol(35, None, None), None))
B=arbol(12, arbol(6, None, None), arbol(35, None, None))
C=arbol(35, arbol(12, None, None), None)

# mayor: arbol -> num
# Retorna el mayor del árbol
# Ej: mayor(C) entrega 35

# Plantilla:
# if a == None:
#       ...
# else:
#       ... a.izq ...
#       ... a.der ...
#       ... mayor(...) ...
def mayor(a):
    # Caso arbol inicial vacío
    if a == None:
        return -1
    else:
        if a.der != None:
            return mayor(a.der)
        else:
            return a.valor

assert mayor(A) == 42
assert mayor(B) == 35
assert mayor(C) == 35

# cualTieneElMayor: lista(arbol), num, arbol > arbol
# Dada una lista recursiva de conjuntos (representados como árboles binarios),
# retorna el conjunto que tiene el mayor elemento
# Ejemplo: cualTieneElMayor(lista(A, lista(B, lista(C, None)))) entregará A
def cualTieneElMayor(conjuntos, mayorValor = -1, \
                     mayorConjunto = None):
    if conjuntos == None:
        return mayorConjunto
    else:
        a = cabeza(conjuntos)
        m = mayor(a)
        if m > mayorValor:
            mayorValor = m
            mayorConjunto = a
        return cualTieneElMayor(cola(conjuntos),
                                mayorValor, \
                                mayorConjunto)

conjuntos = lista(A, lista(B, lista(C, None)))

assert cualTieneElMayor(conjuntos) == A

# esta: arbol, num -> boolean
# Retorna True si es que valor está en el árbol a; False en caso contrario
# Ejemplo: esta(A, 35) entrega True
def esta(a, valor):
    if a == None:
        return False
    else:
        if a.valor == valor:
            return True
        elif a.valor < valor:
            return esta(a.der, valor)
        else:
            return esta(a.izq, valor)

assert esta(A, 35)
assert esta(A, 42)
assert esta(A, 12)
assert not esta(A, 15)
assert not esta(A, 37)

# esSubconjunto: arbol, arbol -> boolean
# Retorna True si es que el primer conjunto es subconjunto del segundo; False en caso contrario
# Ejemplo: esSubconjunto(C, B) entrega True
def esSubconjunto(a1, a2):
    if a1 == None:
        return True
    else:
        v = a1.valor
        return esta(a2, v) and esSubconjunto(a1.izq, a2) and esSubconjunto(a1.der, a2)

assert not esSubconjunto(A, B)
assert esSubconjunto(C, B)
assert not esSubconjunto(B, C)
assert esSubconjunto(A, A)

# sumarUno: arbol -> arbol
# Suma 1 a todos los elementos del árbol
# Ejemplo: sumarUno(A) entregará arbol(28,arbol(13,None,None),arbol(43,arbol(36, None, None),None))
def sumarUno(a):
    if a == None:
        return None
    else:
        return arbol(a.valor + 1, \
                     sumarUno(a.izq), \
                     sumarUno(a.der))

assert sumarUno(A) == arbol(28, arbol(13, None, None), arbol(43, arbol(36, None, None), None))
assert sumarUno(B) == arbol(13, arbol(7, None, None), arbol(36, None, None))
assert sumarUno(C) == arbol(36, arbol(13, None, None), None)











































