import estructura

#arbol: izq: arbol der: arbol valor: str
estructura.crear("Nodo","izq der valor")

#arbol que representa el codigo morse
#LETRAS EN MAYUSCULAS
morse=arbol(arbol(arbol(arbol(arbol(None,None,"H"),arbol(None,None,"V"),"S"),arbol(arbol(None,None,"F"),None,"U"),"I"),arbol(arbol(arbol(None,None,"L"),None,"R"),arbol(arbol(None,None,"P"),arbol(None,None,"J"),"W"),"A"),"E"),arbol(arbol(arbol(arbol(None,None,"B"),arbol(None,None,"X"),"D"),arbol(arbol(None,None,"C"),arbol(None,None,"Y"),"K"),"N"),arbol(arbol(arbol(None,None,"Z"),arbol(None,None,"Q"),"G"),arbol(None,None,"O"),"M"),"T"),"")

#codigoALetra: str arbol(str)
#recibe una serie de puntos y rayas y retorna la letra que representa en morse
#Ej: codigoALetra("....")="H"
def codigoALetra(codigo,arbol=morse):
    if len(codigo)==0:
        return arbol.valor
    if codigo[0]=="-":
        return codigoALetra(codigo[1:],arbol.der)
    if codigo[0]==".":
        return codigoALetra(codigo[1:],arbol.izq)
assert codigoALetra("....")=="H"

#codigoAPalabra: str arbol(str)
#recibe una serie de puntos, rayas y espacios y retorna la palabra en
#codigo morse
#Ej: codigoAPalabra('--.. .- .--. .- - .. .-.. .-.. .- ... ')="ZAPATILLAS"
def codigoAPalabra(codigo,arbol=morse,p=""):
    if len(codigo)==0:
        return codigoALetra(p)
    if codigo[0]==" ":
        return codigoALetra(p)+codigoAPalabra(codigo[1:])
    if codigo[0]=="-":
        return codigoAPalabra(codigo[1:],arbol,p+codigo[0])
    if codigo[0]==".":
        return codigoAPalabra(codigo[1:],arbol,p+codigo[0])
assert codigoAPalabra('--.. .- .--. .- - .. .-.. .-.. .- ... ')=="ZAPATILLAS"

#esta: str arbol(str)
#retorna verdadero si el valor esta en el arbol
#Ej: esta("S",morse)=True
def esta(valor,arbol):
    if arbol==None:
        return False
    if arbol.valor==valor:
        return True
    else: return esta(valor,arbol.izq) or esta(valor,arbol.der)
assert esta("S",morse)==True

#letraACodigo: str arbol(str)
#retorna el codigo morse asociado a una letra
#Ej: letraACodigo("A")=".-"
def letraACodigo(letra,arbol=morse):
    if arbol.valor==letra:
        return ""
    if esta(letra,arbol.izq):
        return "."+letraACodigo(letra,arbol.izq)
    if esta(letra,arbol.der):
        return "-"+letraACodigo(letra,arbol.der)
assert letraACodigo("A")==".-"

#palabraACodigo: str arbol(str)
#retorna el codigo morse asociado a una palabra
#palabraACodigo("ZAPATILLAS")='--.. .- .--. .- - .. .-.. .-.. .- ... '
def palabraACodigo(palabra,arbol=morse):
    if len(palabra)==0:
        return ""
    else:
        return letraACodigo(palabra[0])+" "+palabraACodigo(palabra[1:])
assert palabraACodigo("ZAPATILLAS")=='--.. .- .--. .- - .. .-.. .-.. .- ... '
