# -*- coding: utf-8 -*-
from lista import *
import estructura

# actor: nombre(str) sexo(Str) edad(int)
estructura.crear("actor", "nombre sexo edad")
# pelicula: nombre(str), fecha(int), rating(float)
estructura.crear("pelicula", "nombre fecha rating")
# actuaEn: pelicula(pelicula), actor(actor)
estructura.crear("actuaEn", "pelicula actor")


trumanShow = pelicula("The Truman Show", 1998, 8.1)
sunshine = pelicula("Eternal Sunshine of a Spotless Mind", 2004, 8.3)
titanic = pelicula("Titanic", 1997, 7.7)
devil = pelicula("The Devil Wears Prada", 2006, 6.8)
starWars = pelicula("Star Wars", 1977, 8.7)
rroad = pelicula("Revolutionary Road", 2008, 7.3)

jimCarrey = actor("Jim Carrey", "H", 54)
edHarris = actor("Ed Harris", "H", 66)
kateWinslet = actor("Kate Winslet", "M", 41)
dicaprio = actor("Leonardo DiCaprio", "H", 42)
anne = actor("Anne Hathaway", "M", 34)
meryl = actor("Meryl Streep", "M", 67)
markHamill = actor("Mark Hamill", "H", 65)
harrisonFord = actor("Harrison Ford", "H", 74)
carrieFisher = actor("Carrie Fisher", "M", 60)

r1 = actuaEn(trumanShow, jimCarrey)
r2 = actuaEn(trumanShow, edHarris)
r3 = actuaEn(sunshine, jimCarrey)
r4 = actuaEn(sunshine, kateWinslet)
r5 = actuaEn(titanic, kateWinslet)
r6 = actuaEn(titanic, dicaprio)
r7 = actuaEn(devil, anne)
r8 = actuaEn(devil, meryl)
r9 = actuaEn(starWars, markHamill)
r10 = actuaEn(starWars, harrisonFord)
r11 = actuaEn(rroad, kateWinslet)
r12 = actuaEn(rroad, dicaprio)
r13 = actuaEn(starWars, carrieFisher)

relaciones = None
relaciones = crearLista(r1, relaciones)
relaciones = crearLista(r2, relaciones)
relaciones = crearLista(r3, relaciones)
relaciones = crearLista(r4, relaciones)
relaciones = crearLista(r5, relaciones)
relaciones = crearLista(r6, relaciones)
relaciones = crearLista(r7, relaciones)
relaciones = crearLista(r8, relaciones)
relaciones = crearLista(r9, relaciones)
relaciones = crearLista(r10, relaciones)
relaciones = crearLista(r11, relaciones)
relaciones = crearLista(r12, relaciones)
relaciones = crearLista(r13, relaciones)


# xActuaEnY: lista(actuaEn), str, str -> booleano
# True si es que actor participó en película, False en caso contrario
# Ejemplo: xActuaEnY(relaciones, "Leonardo DiCaprio", "Titanic") entrea True

# Plantilla:
# def xActuaEnY(L, actor, pelicula):
#       if vacia(L):
#           ...
#       else:
#           ... cabeza(L).actor ...
#           ... cabeza(L).pelicula ...
#           ... xActuaEnY(cola(L), actorStr, peliculaStr)


def xActuaEnY(L, actorStr, peliculaStr):
    if vacia(L):
        return False
    else:
        peliculaActual = cabeza(L).pelicula
        actorActual = cabeza(L).actor
        if peliculaActual.nombre == peliculaStr and actorActual.nombre == actorStr:
            return True
        else:
            return xActuaEnY(cola(L), actorStr, peliculaStr)

assert xActuaEnY(relaciones, "Leonardo DiCaprio", "Titanic")
assert not xActuaEnY(relaciones, "Harrison Ford", "Titanic")


#########################################################################

# filmografia: lista(actuaEn) str -> lista(pelicula)
def filmografia(L, actorStr):
    if vacia(L):
        return None
    else:
        peliculaActual = cabeza(L).pelicula
        actorActual = cabeza(L).actor
        if actorActual.nombre == actorStr:
            return crearLista(peliculaActual, \
                              filmografia(cola(L), actorStr))
        else:
            return filmografia(cola(L), actorStr)

assert filmografia(relaciones, "Kate Winslet") == lista(valor=pelicula(nombre='Revolutionary Road', fecha=2008, rating=7.3), siguiente=lista(valor=pelicula(nombre='Titanic', fecha=1997, rating=7.7), siguiente=lista(valor=pelicula(nombre='Eternal Sunshine of a Spotless Mind', fecha=2004, rating=8.3), siguiente=None)))

#########################################################################

# elenco: lista(actuaEn) str -> lista(actor)
def elenco(L, peliculaStr):
    if vacia(L):
        return None
    else:
        peliculaActual = cabeza(L).pelicula
        actorActual = cabeza(L).actor
        if peliculaActual.nombre == peliculaStr:
            return crearLista(actorActual, \
                              elenco(cola(L), peliculaStr))
        else:
            return elenco(cola(L), peliculaStr)


assert elenco(relaciones, "Star Wars") == lista(valor=actor(nombre='Carrie Fisher', sexo='M', edad=60), siguiente=lista(valor=actor(nombre='Harrison Ford', sexo='H', edad=74), siguiente=lista(valor=actor(nombre='Mark Hamill', sexo='H', edad=65), siguiente=None)))


#########################################################################
# estaEn: lista(any) any -> boolean
def estaEn(L, elemento):
    if vacia(L):
        return False
    else:
        if cabeza(L) == elemento:
            return True
        else:
            return estaEn(cola(L), elemento)

# interseccion: lista(any) lista(any) -> lista(any)
def interseccion(L1, L2):
    if vacia(L1):
        return None
    else:
        actual = cabeza(L1)
        if estaEn(L2, actual):
            return crearLista(actual, \
                              interseccion(cola(L1), L2))
        else:
            return interseccion(cola(L1), L2)

# seEncontraronEn: lista(actuaEn), str, str -> list(pelicula)
def seEncontraronEn(L, actor1, actor2):
    f1 = filmografia(L, actor1)
    f2 = filmografia(L, actor2)
    return interseccion(f1, f2)

assert seEncontraronEn(relaciones, "Leonardo DiCaprio", "Kate Winslet") == lista(valor=pelicula(nombre='Revolutionary Road', fecha=2008, rating=7.3), siguiente=lista(valor=pelicula(nombre='Titanic', fecha=1997, rating=7.7), siguiente=None))



#########################################################################

# peliculaYActrices: pelicula (pelicula) nActrices (int)
estructura.crear("peliculaYActrices", "pelicula nActrices")

# contarActrices: lista(actuaEn), pelicula -> int
def contarActrices(L, p):
    if vacia(L):
        return 0
    else:
        if cabeza(L).pelicula == p and cabeza(L).actor.sexo == "M":
            return 1 + contarActrices(cola(L), p)
        else:
            return contarActrices(cola(L), p)



# peliculaConMasActrices_aux : lista(actuaEn) peliculaYActrices -> peliculaYActrices
def peliculaConMasActrices_aux(L, maximo):
    if vacia(L):
        return maximo
    else:
        peliculaActual = cabeza(L).pelicula
        n = contarActrices(L, peliculaActual)
        if n > maximo.nActrices:
            maximo = peliculaYActrices(peliculaActual, n)
        return peliculaConMasActrices_aux(cola(L), maximo)


# peliculaConMasActrices: lista(actuaEn) -> peliculaYActrices
def peliculaConMasActrices(L):
    maximo = peliculaYActrices(None, 0)
    return peliculaConMasActrices_aux(L, maximo)


assert peliculaConMasActrices(relaciones) == peliculaYActrices(pelicula=pelicula(nombre='The Devil Wears Prada', fecha=2006, rating=6.8), nActrices=2)

##################################################################################

# actorYRating: actor(actor),
estructura.crear("actorYRating", "actor rating")

# largo: lista(any) -> int
def largo(L):
    if vacia(L):
        return 0
    else:
        return 1 + largo(cola(L))

# actorEstaEn: lista(pelicula) actor ->
def actorEstaEn(L, a):
    if vacia(L):
        return False
    else:
        if cabeza(L).actor == a:
            return True
        else:
            return actorEstaEn(cola(L), a)

# sumaRatings: lista(peliculas) -> float
def sumaRatings(L):
    if vacia(L):
        return 0
    else:
        return cabeza(L).rating + sumaRatings(cola(L))

# promedioRatingActor_aux: lista(actuaEn) lista(actorYRating) -> lista(actorYRating)
def promedioRatingActor_aux(L, actoresVistos):
    if vacia(L):
        return actoresVistos
    else:
        actorActual = cabeza(L).actor
        if actorEstaEn(actoresVistos, actorActual):
            return promedioRatingActor_aux(cola(L), actoresVistos)
        else:
            f = filmografia(L, actorActual.nombre)
            nPeliculas = largo(f)
            sRatings = sumaRatings(f)
            nuevo = actorYRating(actorActual, 1.0*sRatings/nPeliculas)
            return promedioRatingActor_aux(cola(L), \
                                           lista(nuevo, actoresVistos))

# promedioRatingActor_aux: lista(actuaEn) -> lista(actorYRating)
def promedioRatingActor(L):
    return promedioRatingActor_aux(L, listaVacia)


assert promedioRatingActor(relaciones) == lista(valor=actorYRating(actor=actor(nombre='Ed Harris', sexo='H', edad=66), rating=8.1), siguiente=lista(valor=actorYRating(actor=actor(nombre='Jim Carrey', sexo='H', edad=54), rating=8.2), siguiente=lista(valor=actorYRating(actor=actor(nombre='Anne Hathaway', sexo='M', edad=34), rating=6.8), siguiente=lista(valor=actorYRating(actor=actor(nombre='Meryl Streep', sexo='M', edad=67), rating=6.8), siguiente=lista(valor=actorYRating(actor=actor(nombre='Mark Hamill', sexo='H', edad=65), rating=8.7), siguiente=lista(valor=actorYRating(actor=actor(nombre='Harrison Ford', sexo='H', edad=74), rating=8.7), siguiente=lista(valor=actorYRating(actor=actor(nombre='Kate Winslet', sexo='M', edad=41), rating=7.766666666666667), siguiente=lista(valor=actorYRating(actor=actor(nombre='Leonardo DiCaprio', sexo='H', edad=42), rating=7.5), siguiente=lista(valor=actorYRating(actor=actor(nombre='Carrie Fisher', sexo='M', edad=60), rating=8.7), siguiente=None)))))))))









