# -*- coding: utf-8 -*-
import estructura

# tiempo: int int
estructura.crear("tiempo", "horas minutos")

# crearTiempo: int int -> tiempo
# Dada una cantidad de horas y minutos, entrega un tiempo "correcto"
# Ejemplo: crearTiempo(0, 75) entrega tiempo(1,15)
def crearTiempo(horas, minutos):
    horas += minutos / 60
    minutos = minutos % 60
    return tiempo(horas, minutos)

assert crearTiempo(0, 75) == tiempo(1, 15)
assert crearTiempo(2, 150) == tiempo(4, 30)

# completarString: int -> str
# Función auxiliar, que dado un n, entrega ese n como un string de, al menos, largo dos (si es
# que el largo es menor a 2, se antepone un 0)
# Ejemplo: completarString(2) entrega "02"
def completarString(n):
    if n < 10:
        return "0" + str(n)
    else:
        return str(n)
assert completarString(2) == "02"
assert completarString(12) == "12"

# instancias de la estructura tiempo, nos servirán para realizar pruebas
t1 = tiempo(4,30)
t2 = tiempo(6,45)
t3 = tiempo(20,15)
t4 = tiempo(20,15)


# aString: tiempo -> str
# Retorna el tiempo en formato HH:MM
# Ej: tiempo(1, 15) entrega "01:15"
def aString(tiempo):
    return completarString(tiempo.horas) + ":" + completarString(tiempo.minutos)

assert aString(t1) == "04:30"
assert aString(t3) == "20:15"


# aMinutos: tiempo -> int
# Obtiene los minutos totales de una instancia de tiempo
# Ejemplo: aMinutos(t3) entrega 1215
def aMinutos(t):
    return t.horas * 60 + t.minutos
assert aMinutos(t1) == 270
assert aMinutos(t2) == 405
assert aMinutos(t3) == 1215

# comparar: tiempo tiempo -> int
# Compara dos tiempos, y entrega 1 si el primero es el mayor, 0 si son iguales y -1
# si el segundo es el mayor
# Ejemplo: comparar(tiempo(4,30), tiempo(2,15)) entrega 1
def comparar(t1, t2):
    minutosT1 = aMinutos(t1)
    minutosT2 = aMinutos(t2)
    if minutosT1 > minutosT2:
        return 1
    elif minutosT1 == minutosT2:
        return 0
    else:
        return -1

assert comparar(t1, t2) == -1
assert comparar(t2, t1) == 1
assert comparar(t3, t4) == 0

# suma: tiempo tiempo -> tiempo
# Entrega la suma de dos tiempos
# Ejemplo: suma(t1, t2) entregará tiempo(11, 15)
def suma(t1, t2):
    minutosTotal = aMinutos(t1) + aMinutos(t2)
    return crearTiempo(0, minutosTotal)

assert suma(t1, t2) == tiempo(11, 15)
assert suma(t2, t3) == tiempo(27, 0)


