# -*- coding: utf-8 -*-
from lista import *

polinomio1 = lista(1, lista(4, lista(5, None)))
polinomio2 = lista(2, lista(3, None))
polinomio3 = lista(3, lista(4, lista(5, lista(6, None))))

# largoLista: lista -> int
# Retorna el largo de una lista
# Ejemplo: largoLista(polinomio1) entrega 3
def largoLista(l):
    assert esLista(l)
    if l == None:
        return 0
    return 1 + largoLista(cola(l))

assert largoLista(polinomio1) == 3
assert largoLista(polinomio2) == 2
assert largoLista(polinomio3) == 4

# polinomioAString: lista int -> str
# Imprime el polinomio en formato a_0*x^0 + a_1*x^1 + ... a_n*x^n, donde los a_i
# son los coeficientes almacenados en la lista
# Ejemplo: polinomioAString(polinomio1) entrega "1*x^0 + 4*x^1 + 5*x^2"
def polinomioAString(coeficientes, grado = 0):
    assert esLista(coeficientes)
    if coeficientes == None:
        return ""
    elif cola(coeficientes) == None:
        actual = cabeza(coeficientes)
        return str(actual) + "*x^" + str(grado)
    else:
        actual = cabeza(coeficientes)
        return str(actual) + "*x^" + str(grado) + " + " + \
                polinomioAString(cola(coeficientes), grado + 1)

assert polinomioAString(polinomio1) == "1*x^0 + 4*x^1 + 5*x^2"
assert polinomioAString(polinomio2) == "2*x^0 + 3*x^1"
assert polinomioAString(polinomio3) == "3*x^0 + 4*x^1 + 5*x^2 + 6*x^3"

# imprimirPolinomio: lista -> none
# Imprime en pantalla la representación del polinomio
# Ejemplo: imprimirPolinomio(polinomio1) imprime en pantalla "1*x^0 + 4*x^1 + 5*x^2",
# pero no retorna nada
def imprimirPolinomio(coeficientes):
    print polinomioAString(coeficientes, 0)


# polinomio: lista num -> num
# Evalúa el polinomio en x
# Ejemplo: polinomio(polinomio1, 1.5) entrega 18.25
def polinomio(coeficientes, x, grado = 0):
    assert esLista(coeficientes)
    if coeficientes == None:
        return 0
    actual = cabeza(coeficientes)
    return actual * (x**grado) + polinomio(cola(coeficientes), x, grado + 1)

assert polinomio(polinomio1, 1.5) == 18.25
assert polinomio(polinomio2, 2) == 8
assert polinomio(polinomio3, 0) == 3

# polinomio: lista num -> num
# Evalúa el polinomio en x (versión alternativa)
# Ejemplo: polinomio_alt(polinomio1, 1.5) entrega 18.25
def polinomio_alt(lista,x):
    if lista == None:
        return 0
    else:
        return cabeza(lista) + x*polinomio(cola(lista), x)

assert polinomio_alt(polinomio1, 1.5) == 18.25
assert polinomio_alt(polinomio2, 2) == 8
assert polinomio_alt(polinomio3, 0) == 3

# sumaPolinomios: lista lista num -> num
# Evalua x en la suma de ambos polinomios
# Ejemplo: sumaPolinomios(polinomio1, polinomio2, 2) entrega 37
def sumaPolinomios(polinomio1, polinomio2, x):
    if polinomio1 == None and polinomio2 == None:
        return 0
    elif polinomio1 == None:
        return cabeza(polinomio2) +  x*sumaPolinomios(polinomio1, cola(polinomio2), x)
    elif polinomio2 == None:
        return cabeza(polinomio1) +  x*sumaPolinomios(cola(polinomio1), polinomio2, x)
    else:
        return cabeza(polinomio1) + cabeza(polinomio2) + \
                x * sumaPolinomios(cola(polinomio1), cola(polinomio2), x)


assert sumaPolinomios(polinomio1, polinomio2, 2) == 37
assert sumaPolinomios(polinomio3, polinomio2, 3) == 233

# sumaPolinomios_alt: lista lista num -> num
# Evalua x en la suma de ambos polinomios (versión alternativa)
# Ejemplo: sumaPolinomios_alt(polinomio1, polinomio2, 2) entrega 37
def sumaPolinomios_alt(polinomio1, polinomio2, x):
    return polinomio(polinomio1, x) + polinomio(polinomio2, x)


assert sumaPolinomios_alt(polinomio1, polinomio2, 2) == 37
assert sumaPolinomios_alt(polinomio3, polinomio2, 3) == 233

