# -*- coding: utf-8 -*-

# mayor: int -> int
# Dada un entero representando a una serie de números de dos dígitos, retorna el mayor de
# aquellos números
# Ejemplo: mayor(456327) entrega 63
def mayor(n):
    if n < 100:
        return n
    actual = n % 100
    resto = n / 100
    return max(actual, mayor(resto))

assert mayor(456327) == 63
assert mayor(101) == 1
assert mayor(102030) == 30
assert mayor(35) == 35

##################################### VERSIÓN ALTERNATIVA #####################################

# mayor_aux: int, int -> int
# Dada un entero representando a una serie de números de dos dígitos y un mayor_actual, retorna
# el mayor de aquellos números (o el mayor actual)
def mayor_aux(n, maximo_actual):
    if n < 100:
        return max(n, maximo_actual)
    actual = n % 100
    resto = n / 100
    if actual > maximo_actual:
        maximo_actual = actual
    return mayor_aux(resto, maximo_actual)

assert mayor_aux(456327, 0) == 63
assert mayor_aux(4563, 27) == 63
assert mayor_aux(45, 63) == 63

# mayor2: int -> int
# Dada un entero representando a una serie de números de dos dígitos, retorna el mayor de
# aquellos números
# Ejemplo: mayor(456327) entrega 63
def mayor2(n):
    return mayor_aux(n, 0)
assert mayor2(456327) == 63
assert mayor2(101) == 1
assert mayor2(102030) == 30
assert mayor2(35) == 35

# temblores: int, int -> none
# Genera un diálogo con el usuario para todos los días entre diaInicial y diaFinal, ambos
# inclusive, pidiendo los temblores del día e imprimiendo en pantalla el temblor de mayor
# intensidad
def temblores(diaInicial, diaFinal):
    if diaInicial > diaFinal:
        return
    n = input("dia " + str(diaInicial) + ": Intensidades de los temblores? ")
    print "mayor fue " + mayor(n)
    temblores(diaInicial + 1, diaFinal)

temblores(25, 27)



