# -*- coding: utf-8 -*-

import math

# cerca: num num num -> boolean
# Retorna True si es que |x - y| es menor o igual a epsilon (es decir, si están cerca)
# Ejemplo: cerca(0.33, 0.34, 0.01) retorna True
def cerca(x, y, epsilon):
    diff = abs(x - y)
    return diff <= epsilon
assert cerca(0.33, 0.34, 0.02)
assert not cerca(0.33, 0.34, 0.001)
assert cerca(0, 1, 1)


# factorial: int -> int
# Retorna el factorial de k
# Ejemplo: factorial(5) entrega 120
def factorial(k):
    if k <= 1:
        return 1
    return k*factorial(k-1)
assert factorial(0) == 1
assert factorial(3) == 6
assert factorial(5) == 120


# taylor_kesimo: num int -> num
# Retorna el ḱ-ésimo término de la expansión de Taylor para seno
# Ejemplo: taylor_kesimo(1, 0) entrega 1
def taylor_kesimo(x, k):
    n = 2*k + 1
    return ((-1.0)**k / factorial(n)) * (x**n)
assert cerca(taylor_kesimo(1, 0), 1, 0.001)
assert cerca(taylor_kesimo(1, 1), -1.0/6, 0.001)
assert cerca(taylor_kesimo(1, 2), 1.0/120, 0.001)

# seno_epsilon: num int num num -> num
# Retorna sin(x), calculando recursivamente hasta que el valor k y el valor k + 1 están a
# una distancia menor a epsilon
def seno_epsilon(x, k, suma_kesima, epsilon):
    valorK_mas_1 = taylor_kesimo(x, k+1)
    if cerca(suma_kesima, suma_kesima + valorK_mas_1, epsilon):
        return suma_kesima + valorK_mas_1
    else:
        return seno_epsilon(x, k+1, suma_kesima + valorK_mas_1, epsilon)

epsilon = 0.00001
assert cerca(seno_epsilon(math.pi, 0, math.pi, epsilon), 0, epsilon)
assert cerca(seno_epsilon(math.pi/2, 0, math.pi/2, epsilon), 1, epsilon)
assert cerca(seno_epsilon(math.pi/3, 0, math.pi/3, epsilon), math.sqrt(3) / 2, epsilon)
assert cerca(seno_epsilon(math.pi/4, 0, math.pi/4, epsilon), math.sqrt(2) / 2, epsilon)

# seno: num num -> num
# Retorna sin(x) con cierta precisión
# Ejemplo: seno(math.pi/2, 0.0001) es cercano a 1
def seno(x, epsilon):
    return seno_epsilon(x = x, k = 0, suma_kesima = x, epsilon = epsilon)

epsilon = 0.00001
assert cerca(seno(math.pi, epsilon), 0, epsilon)
assert cerca(seno(math.pi/2, epsilon), 1, epsilon)
assert cerca(seno(math.pi/3, epsilon), math.sqrt(3) / 2, epsilon)
assert cerca(seno(math.pi/4, epsilon), math.sqrt(2) / 2, epsilon)
