# -*- coding: utf-8 -*-

# multiplicacion: int, int -> int
# Retorna la multiplicación de dos enteros
# Ejemplo: multiplicacion(3,4) entrega 12

def multiplicacion(a,b):
    assert b >= 0
    if b == 0:
        return 0
    return a + multiplicacion(a, b - 1)

assert multiplicacion(3, 4) == 12
assert multiplicacion(1, 1) == 1
assert multiplicacion(100, 0) == 0
assert multiplicacion(4, 3) == 12
assert multiplicacion(0, 0) == 0
assert multiplicacion(20, 15) == 300

# division: int, int -> int
# Dados a y b, retorna el resultado de a/b (división entera)
# Ejemplo: division(18,5) entrega 3
def division(a,b):
    assert b > 0
    if a < b:
        return 0
    return 1 + division(a - b, b)

assert division(18, 5) == 3
assert division(18, 6) == 3
assert division(10, 2) == 5
assert division(345, 1) == 345
assert division(1, 1) == 1
assert division(40, 41) == 0

# esPalindromo: string -> boolean
# Retorna True si una palabra es palíndromo (i.e., se lee igual de izquierda a derecha que de derecha
# izquierda), False en caso contrario
# Ejemplo: esPalindromo("oso") entrega True, esPalindromo("casa") entrega False
def esPalindromo(s):
    if s == "":
        return True
    first = s[0]
    last = s[-1]
    if first != last:
        return False
    return esPalindromo(s[1:-1])

assert esPalindromo("a")
assert esPalindromo("gg")
assert esPalindromo("oso")
assert esPalindromo("reconocer")
assert esPalindromo("adannocallaconnada")
assert not esPalindromo("casa")
assert not esPalindromo("guitarra")
assert not esPalindromo("universidad")
