using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;

namespace VacationService
{
	/// <summary>
	/// Services information of vacations
	/// </summary>
	[WebService(Namespace="http://localhost/VacationService/",
		 Description="Services information of vacations.")]
	public class Vacations : System.Web.Services.WebService
	{
		private const int _min = 0;
		private const int _max = 30;
		
		public Vacations()
		{			
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion
			
		/// <summary>
		/// Returns number of vacations days
		/// </summary>
		/// <param name="id">User Id</param>
		/// <returns>Number of day</returns>
		[WebMethod]		
		public int GetDaysOfVacations(string id)
		{
			if (id != null && id != string.Empty) 
			{
				return GetRandomNumber();
			}
			else 
				return -1;
		}

		/// <summary>
		/// Return a random number
		/// </summary>
		/// <returns>random number</returns>
		private int GetRandomNumber()
		{
			Random random = new Random();
			return random.Next(_min, _max); 
		}
	}
}
